/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated  12 05 2011 06:26:35 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x18,0x00,0x6a,0x55,0x5e,0x2a,0x26,0x4f,0x26,0x2d, /* MPFS....jU^.&O&- */ \
	0x0a,0xa3,0xff,0xff,0x6a,0x83,0xff,0xff,0xea,0x72,0xff,0xff,0x4a,0xe3,0xff,0xff, /* ....j....r..J... */ \
	0x6a,0xe3,0xff,0xff,0xea,0x92,0xff,0xff,0x0a,0x4f,0xff,0xff,0x26,0xb6,0xff,0xff, /* j........O..&... */ \
	0x8a,0xb6,0xff,0xff,0xca,0xb4,0xff,0xff,0x48,0x02,0x00,0x00,0x35,0x03,0x00,0x00, /* ........H...5... */ \
	0x9e,0x03,0x00,0x00,0xd0,0xee,0xca,0x4e,0x00,0x00,0x00,0x00,0x01,0x00,0x53,0x02, /* .......N......S. */ \
	0x00,0x00,0xd3,0x06,0x00,0x00,0xc2,0x05,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* .............N.. */ \
	0x00,0x00,0x01,0x00,0x5d,0x02,0x00,0x00,0x95,0x0c,0x00,0x00,0xa0,0x00,0x00,0x00, /* ....]........... */ \
	0xc3,0x42,0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x68,0x02,0x00,0x00,0x35,0x0d, /* .B.N......h...5. */ \
	0x00,0x00,0xf0,0x03,0x00,0x00,0x50,0xe5,0xdb,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* ......P..N...... */ \
	0x73,0x02,0x00,0x00,0x25,0x11,0x00,0x00,0x1b,0x04,0x00,0x00,0x27,0x7c,0xab,0x4e, /* s...%.......'|.N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x7d,0x02,0x00,0x00,0x40,0x15,0x00,0x00,0x68,0x00, /* ......}...@...h. */ \
	0x00,0x00,0x27,0x7c,0xab,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x02,0x00,0x00, /* ..'|.N......~... */ \
	0xa8,0x15,0x00,0x00,0xcf,0x02,0x00,0x00,0x4a,0xb7,0xa4,0x4e,0x00,0x00,0x00,0x00, /* ........J..N.... */ \
	0x02,0x00,0x89,0x02,0x00,0x00,0x77,0x18,0x00,0x00,0x48,0x00,0x00,0x00,0x4a,0xb7, /* ......w...H...J. */ \
	0xa4,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x8a,0x02,0x00,0x00,0xbf,0x18,0x00,0x00, /* .N.............. */ \
	0xf8,0x08,0x00,0x00,0xe9,0x38,0xaf,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xa1,0x02, /* .....8.N........ */ \
	0x00,0x00,0xb7,0x21,0x00,0x00,0x80,0x00,0x00,0x00,0xe9,0x38,0xaf,0x4e,0x00,0x00, /* ...!.......8.N.. */ \
	0x00,0x00,0x00,0x00,0xa2,0x02,0x00,0x00,0x37,0x22,0x00,0x00,0x03,0x02,0x00,0x00, /* ........7"...... */ \
	0x86,0x22,0xac,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xba,0x02,0x00,0x00,0x3a,0x24, /* .".N..........:$ */ \
	0x00,0x00,0x20,0x00,0x00,0x00,0x86,0x22,0xac,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .. ....".N...... */ \
	0xbb,0x02,0x00,0x00,0x5a,0x24,0x00,0x00,0x9f,0x0a,0x00,0x00,0xd7,0x33,0xb5,0x4e, /* ....Z$.......3.N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xd3,0x02,0x00,0x00,0xf9,0x2e,0x00,0x00,0xb0,0x00, /* ................ */ \
	0x00,0x00,0xd7,0x33,0xb5,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xd4,0x02,0x00,0x00, /* ...3.N.......... */ \
	0xa9,0x2f,0x00,0x00,0xf8,0x0b,0x00,0x00,0xd1,0xeb,0xca,0x4e,0x00,0x00,0x00,0x00, /* ./.........N.... */ \
	0x02,0x00,0xe7,0x02,0x00,0x00,0xa1,0x3b,0x00,0x00,0xa0,0x00,0x00,0x00,0xd1,0xeb, /* .......;........ */ \
	0xca,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xe8,0x02,0x00,0x00,0x41,0x3c,0x00,0x00, /* .N..........A<.. */ \
	0xc6,0x03,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xfa,0x02, /* .......N........ */ \
	0x00,0x00,0x07,0x40,0x00,0x00,0x18,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* ...@.........N.. */ \
	0x00,0x00,0x00,0x00,0xfb,0x02,0x00,0x00,0x1f,0x40,0x00,0x00,0x08,0x00,0x00,0x00, /* .........@...... */ \
	0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x0e,0x03,0x00,0x00,0x27,0x40, /* ...N..........'@ */ \
	0x00,0x00,0x08,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0x0f,0x03,0x00,0x00,0x2f,0x40,0x00,0x00,0x06,0x02,0x00,0x00,0xcb,0x00,0xb7,0x4e, /* ..../@.........N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x22,0x03,0x00,0x00,0x35,0x42,0x00,0x00,0x20,0x00, /* ......"...5B.. . */ \
	0x00,0x00,0xcb,0x00,0xb7,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x23,0x03,0x00,0x00, /* .....N......#... */ \
	0x55,0x42,0x00,0x00,0x6c,0x03,0x00,0x00,0xc3,0xf2,0xad,0x4e,0x00,0x00,0x00,0x00, /* UB..l......N.... */ \
	0x02,0x00,0x34,0x03,0x00,0x00,0xc1,0x45,0x00,0x00,0x30,0x00,0x00,0x00,0xc3,0xf2, /* ..4....E..0..... */ \
	0xad,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63, /* .N......7m3tjz.c */ \
	0x73,0x73,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x00,0x66,0x6f,0x6f, /* ss.7m3tjz.js.foo */ \
	0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ter.inc.header.i */ \
	0x6e,0x63,0x00,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x73,0x74, /* nc.index.htm..st */ \
	0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64, /* atus.htm..nodead */ \
	0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d, /* apter/config.htm */ \
	0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f, /* ..nodeadapter/co */ \
	0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65,0x61, /* nfig2.htm..nodea */ \
	0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33,0x2e,0x68, /* dapter/config3.h */ \
	0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66, /* tm..protect/conf */ \
	0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f, /* ig.htm..protect/ */ \
	0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65, /* index.htm..prote */ \
	0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x00,0x00,0x70, /* ct/reboot.cgi..p */ \
	0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74, /* rotect/reboot.ht */ \
	0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e, /* m..protect/user. */ \
	0x68,0x74,0x6d,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xad, /* htm............. */ \
	0x56,0x4d,0x6f,0xa3,0x30,0x10,0x3d,0x37,0x52,0xfe,0x03,0x52,0xaf,0x01,0x41,0x08, /* VMo.0.=7R..R..A. */ \
	0x69,0x4b,0x4f,0xab,0xbd,0xef,0x71,0xef,0x06,0x8f,0x83,0x55,0x07,0x23,0x63,0x9a, /* iKO...q....U.#c. */ \
	0x74,0xab,0xfe,0xf7,0xb5,0x8d,0x01,0x03,0x4e,0xaa,0x95,0xb6,0x48,0x6d,0x31,0x9e, /* t.......N...Hm1. */ \
	0xf7,0xc6,0xf3,0xe6,0xc3,0x05,0xc7,0x1f,0xc1,0xe7,0x76,0xf3,0x40,0x78,0x2d,0x43, /* ..........v.@x-C */ \
	0x82,0xce,0x94,0x7d,0xe4,0xc1,0x6f,0x10,0x18,0xd5,0x68,0x17,0xfc,0x10,0x14,0xb1, /* ...}..o...h..... */ \
	0x5d,0xd0,0xa2,0xba,0x0d,0x5b,0x10,0x94,0xbc,0xaa,0xad,0x05,0x2a,0xdf,0x4e,0x82, /* ]....[........N. */ \
	0x77,0x35,0xce,0x83,0xc7,0xac,0xd0,0x8f,0x5e,0x3e,0x23,0x71,0xa2,0x75,0x1e,0xc4, /* w5......^>#q.u.. */ \
	0xcd,0x35,0x40,0x9d,0xe4,0x7a,0xad,0x41,0x18,0xd3,0xfa,0xa4,0x16,0xd5,0xb3,0xd7, /* .5@..z.A........ */ \
	0x5f,0x62,0xb5,0xfc,0xb5,0xdd,0x6c,0x37,0x8f,0x6d,0x85,0x30,0xbf,0x84,0xbc,0x06, /* _b....l7.m.0.... */ \
	0xe3,0xc0,0x85,0x62,0x59,0xe5,0xc1,0xd3,0x51,0xed,0x32,0x2c,0x5c,0x60,0x10,0x79, /* ...bY...Q.2,\`.y */ \
	0x90,0x28,0xa3,0x96,0x33,0x8a,0x15,0x57,0x96,0x4d,0x5f,0x42,0xc9,0x9b,0xdc,0xc0, /* .(..3..W.M_B.... */ \
	0xf9,0x98,0xbf,0x26,0x02,0x79,0xe1,0x86,0xc0,0x03,0x78,0x28,0xf4,0xe3,0xc3,0x74  /* ...&.y....x(...t */
#define DATACHUNK000001 \
	0xed,0x2b,0x01,0x70,0x13,0xe1,0x70,0xf8,0xc6,0x9c,0xf0,0x4e,0xdc,0xb2,0x4e,0x91, /* .+.p..p....N..N. */ \
	0x7e,0x6e,0x00,0x28,0x88,0x06,0x9d,0x6e,0x32,0xa7,0x69,0xba,0x12,0x83,0x10,0xe2, /* ~n.(...n2.i..... */ \
	0x0d,0xd0,0x28,0xc3,0xde,0x06,0xd7,0xa8,0xdd,0xd2,0x3f,0xa0,0x20,0xe3,0x46,0xce, /* ..(.......?. .F. */ \
	0x09,0x25,0x9e,0x32,0xc2,0xb3,0x47,0x52,0xc9,0xac,0x57,0x2e,0x77,0xac,0x7e,0x7a, /* .%.2..GR..W.w.~z */ \
	0xfa,0x91,0xed,0xe0,0x90,0x5d,0x80,0x9e,0x2a,0x99,0x07,0x05,0x67,0x58,0x2f,0x96, /* .....]......gX/. */ \
	0x9c,0x71,0x31,0xb9,0xdc,0x4b,0x18,0x16,0x5c,0x4a,0x7e,0x56,0x84,0x59,0x6f,0x5a, /* .q1..K..\J~V.YoZ */ \
	0x59,0xab,0xe4,0x68,0xde,0x5d,0x07,0x22,0xa1,0x3f,0xf5,0x9e,0x32,0x8e,0xd4,0x26, /* Y..h.].".?..2..& */ \
	0xb3,0xf0,0x3a,0xa5,0x52,0x1a,0xdb,0xd3,0x4a,0xb8,0xca,0x10,0x31,0x7a,0xaa,0xa7, /* ..:.R...J...1z.. */ \
	0x4d,0x3d,0xd4,0x19,0xea,0xce,0x85,0x60,0x40,0x5c,0x84,0x24,0xb3,0x08,0xf6,0x48, /* M=.....`@\.$...H */ \
	0xa1,0xe8,0xdd,0xb1,0x61,0x74,0x30,0x90,0x9b,0xc3,0xc9,0xc1,0x9a,0x61,0xda,0x36, /* ....at0......a.6 */ \
	0x0c,0xa9,0x82,0x2a,0x18,0x2f,0xdf,0x56,0x72,0x4d,0x21,0xb3,0xd1,0xb8,0x54,0x54, /* ...../.VrM!...TT */ \
	0xc2,0x2c,0x84,0xcf,0x77,0x42,0x68,0x65,0x1e,0x63,0x36,0xe5,0x86,0x0d,0xaa,0x39, /* .,..wBhe.c6....9 */ \
	0x37,0x86,0x92,0x0b,0x24,0x29,0x57,0x87,0xaf,0x55,0xb1,0x2d,0xfc,0xce,0x2b,0xfe, /* 7...$)W..U.-..+. */ \
	0x0e,0x62,0x2d,0x27,0x36,0xe9,0xd5,0xef,0x2c,0x15,0x3b,0xd4,0xd2,0x3d,0x62,0xb6, /* .b-'6...,.;..=b. */ \
	0xb7,0x0a,0x2d,0x63,0xbf,0x88,0x54,0xe2,0x46,0x6a,0xc0,0xe9,0x83,0x35,0x64,0x40, /* ..-c..T.Fj...5d@ */ \
	0x19,0xc7,0xdf,0x3b,0x3b,0x9a,0x3a,0xfe,0x0e,0x00,0xbd,0xab,0x6b,0x00,0x75,0x10, /* ...;;.:.....k.u. */ \
	0x10,0x8c,0x7a,0x50,0xaa,0xc4,0x00,0xd8,0xa4,0xeb,0xeb,0x64,0xf2,0x33,0x6a,0x1b, /* ..zP.......d.3j. */ \
	0x54,0x0e,0x1c,0x0c,0x90,0xd0,0x21,0x97,0xd5,0x88,0x42,0x38,0x97,0xf6,0xb3,0x53, /* T.....!...B8...S */ \
	0x23,0x71,0xf4,0x0c,0x67,0x37,0xb3,0x8f,0xc7,0xe3,0x32,0xf9,0x4a,0x45,0x0e,0xc2, /* #q..g7....2.JE.. */ \
	0x6d,0x59,0x3a,0x3e,0x41,0x66,0x1a,0x63,0xb0,0x4c,0x36,0xe3,0x57,0x32,0x6b,0x87, /* mY:>Af.c.L6.W2k. */ \
	0x76,0x4d,0x6d,0xc7,0x4a,0x75,0xc0,0x03,0x8b,0xed,0xa8,0x12,0xc9,0xae,0x9d,0x65, /* vMm.Ju.........e */ \
	0xe2,0xd3,0x7d,0x99,0x26,0x7c,0xd7,0xa1,0x65,0xfb,0x9d,0x73,0x79,0x93,0x71,0xe6, /* ..}.&|..e..sy.q. */ \
	0x40,0x63,0x5c,0x18,0x29,0xb2,0xfe,0x74,0xea,0x77,0xe2,0x16,0x24,0x55,0xf2,0xd4, /* @c\.)..t.w..$U.. */ \
	0x0a,0x21,0x5c,0xba,0x30,0xf6,0xbf,0x08,0xae,0xe8,0xdc,0x30,0x28,0xf8,0xd5,0xd1, /* .!\.0......0(... */ \
	0x2b,0x37,0x31,0xd3,0x25,0x16,0x8c,0xff,0xf9,0x6a,0xc6,0x77,0x82,0xd4,0x49,0x95, /* +71.%....j.w..I. */ \
	0x5e,0x93,0x49,0x12,0x27,0xfd,0x1f,0x31,0x1e,0x0f,0x15,0x95,0x1c,0xc3,0x7a,0x44, /* ^.I.'..1......zD */ \
	0xfe,0x54,0x6d,0x9d,0xaa,0x2c,0xf8,0x05,0x97,0xdd,0xf0,0xb2,0x0b,0x08,0xbd,0x02, /* .Tm..,.......... */ \
	0x0e,0x4d,0xf0,0xed,0x8b,0x73,0x16,0x10,0x25,0x6d,0x3d,0x9d,0x93,0xc0,0xcb,0xeb, /* .M...s..%m=..... */ \
	0x22,0x5e,0x4e,0x4b,0xd4,0x2d,0x69,0x95,0x06,0xfd,0xe2,0x7e,0xaa,0x78,0x28,0xd2, /* "^NK.-i....~.x(. */ \
	0x89,0x49,0x08,0x2e,0xdc,0x04,0x9f,0x43,0xac,0xa4,0x9f,0x3b,0x83,0xf1,0x3d,0x9e, /* .I.....C...;..=. */ \
	0x97,0x78,0x9a,0x4e,0x63,0x35,0x1d,0x9d,0x19,0xe5,0x64,0x28,0x6a,0x2b,0x27,0xe6, /* .x.Nc5....d(j+'. */ \
	0x63,0x82,0x65,0x0b,0x37,0xe2,0x45,0xab,0x77,0x0a,0xd1,0xd1,0xdf,0x0e,0x25,0x47, /* c.e.7.E.w.....%G */ \
	0xb9,0xa1,0x57,0x2f,0x3b,0x4e,0x36,0x01,0x10,0x0a,0x0c,0xb7,0x20,0xff,0x6f,0xf6, /* ..W/;N6..... .o. */ \
	0xdc,0x48,0x94,0x91,0x0c,0xd3,0xf7,0x79,0x01,0xe8,0xf8,0x69,0x2e,0xfd,0x77,0x18, /* .H.....y...i..w. */ \
	0x29,0x6b,0x13,0x86,0x0a,0x60,0x6b,0xd9,0xc2,0xe4,0xe0,0xeb,0x0b,0xfb,0x7e,0x6d, /* )k...`k.......~m */ \
	0xa8,0xf3,0x63,0x7c,0x67,0x50,0x34,0xbc,0xa5,0x7d,0x4b,0x44,0x85,0xd2,0xb1,0x93, /* ..c|gP4..}KD.... */ \
	0xb0,0x72,0x80,0xd6,0x4d,0x27,0xd7,0xe4,0x43,0x4b,0x1a,0x68,0xf6,0x3e,0xe7,0x8d, /* .r..M'..CK.h.>.. */ \
	0x6d,0xd4,0x9e,0xdd,0xc6,0x33,0x5d,0xc3,0x56,0x1b,0x11,0x4e,0x3c,0x3b,0x67,0x7d, /* m....3].V..N<;g} */ \
	0xd2,0x4a,0x3b,0xb7,0x2e,0x3a,0x35,0xe7,0x6a,0x6d,0x5e,0x7c,0x67,0x3f,0x1b,0xf2, /* .J;..:5.jm^|g?.. */ \
	0x23,0x80,0xde,0x81,0x04,0xcc,0x46,0xf5,0xde,0x2b,0xc7,0xe0,0x68,0xea,0x23,0x72, /* #.....F..+..h.#r */ \
	0x6e,0x9b,0x77,0x79,0x23,0x01,0x6d,0xc7,0xe4,0x76,0xf3,0xb9,0x5d,0xf4,0xfb,0x7f, /* n.wy#.m..v..]... */ \
	0xcb,0xbe,0xf9,0x7d,0xcf,0x3f,0x4e,0xfc,0xf7,0x03,0xb7,0xae,0x01,0x46,0xd1,0x1f, /* ...}.?N......F.. */ \
	0x22,0xfe,0x66,0x0e,0x36,0x94,0xec,0x38,0xb1,0x0a,0xd3,0xdf,0x17,0x86,0xc4,0xdc, /* ".f.6..8........ */ \
	0x48,0x94,0xe5,0x83,0x36,0x25,0x88,0x32,0xaf,0x71,0x71,0xf4,0x18,0x13,0x98,0x19, /* H...6%.2.qq..... */ \
	0x77,0xb5,0x9f,0xb8,0x2c,0x7d,0xb6,0x04,0x5b,0xdb,0xbf,0xbc,0xb1,0x55,0x26,0xa5, /* w...,}..[....U&. */ \
	0x0c,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd5,0x57,0x5d, /* ..............W] */ \
	0x6f,0xdb,0x36,0x14,0x7d,0x56,0x80,0xfc,0x87,0x3b,0x3f,0x2c,0x32,0xe0,0x38,0x4e, /* o.6.}V...;?,2.8N */ \
	0xb1,0xee,0xa1,0x81,0x3b,0xa4,0x49,0xb1,0x66,0x48,0x97,0x20,0x71,0x87,0x02,0xdb, /* ....;.I.fH. q... */ \
	0x1e,0x68,0x89,0x8e,0xd9,0xc8,0xa2,0x4a,0x52,0x76,0x8d,0x22,0x3f,0x68,0xff,0x72, /* .h.....JRv."?h.r */ \
	0xe7,0x92,0x94,0x2c,0xbb,0x69,0x51,0xac,0x7d,0x59,0x02,0x58,0x1f,0xbc,0xf7,0xf0, /* ...,.iQ.}Y.X.... */ \
	0xf2,0xdc,0x4f,0x1d,0x1d,0xd1,0x99,0xae,0xd6,0x46,0xdd,0xcd,0x1d,0xfd,0x43,0x4f, /* ..O......F....CO */ \
	0x46,0xa3,0x27,0x87,0x4f,0x46,0xc7,0x23,0x7a,0xad,0x32,0xa3,0xb3,0xb9,0xaa,0x68, /* F.'.OF.#z.2....h */ \
	0x22,0xb3,0x79,0xa9,0x0b,0x7d,0xb7,0xa6,0x8b,0x32,0x1b,0x12,0x9d,0x16,0x05,0x79, /* ".y..}...2.....y */ \
	0x05,0x4b,0x46,0x5a,0x69,0x96,0x32,0x1f,0xee,0xef,0x1d,0x1d,0xd1,0xad,0x94,0x5d, /* .KFZi.2........] */ \
	0xbd,0xb3,0xeb,0xa3,0x8b,0x6b,0xba,0x75,0x22,0xbb,0xa7,0x5c,0x67,0xf5,0x42,0x96, /* .....k.u"..\g.B. */ \
	0x4e,0x38,0xa5,0x4b,0x9a,0x69,0x43,0x85,0xca,0x64,0x69,0x25,0xa9,0x12,0x4f,0x0b, /* N8.K.iC..di%..O. */ \
	0xff,0x1e,0x28,0xfc,0x0f,0xa4,0x73,0xe9,0xa4,0x59,0xa8,0x52,0x5a,0x5a,0xcd,0x65, /* ..(...s..Y.RZZ.e */ \
	0x49,0x02,0x3b,0xbd,0xaf,0xa5,0x75,0xa4,0x2c,0x65,0xba,0xb4,0x2a,0x97,0x46,0xe6, /* I.;...u.,e....F. */ \
	0xd4,0x73,0x6a,0x81,0x8b,0xae,0x5d,0x6f,0x7f,0x6f,0x29,0x0c,0xf1,0xf3,0x55,0xed, /* .sj...]o.o)...U. */ \
	0x5e,0xdf,0xd2,0x98,0x9e,0x8e,0x46,0xa3,0x13,0x3a,0x3a,0x5a,0xd8,0xfd,0x3d,0x0a, /* ^.....F..::Z..=. */ \
	0x06,0x3a,0x0d,0x8b,0x81,0x06,0xac,0x5a,0x92,0x9e,0xd1,0xe9,0x6f,0xa7,0x6f,0x49, /* .:.....Z....o.oI */ \
	0x2e,0x61,0x99,0x25,0xa7,0xa9,0x82,0xed,0xd2,0xda,0x80,0x25,0xde,0x89,0x0f,0x97, /* .a.%.......%.... */ \
	0x0a,0x7b,0x8e,0xa9,0x94,0x2b,0x3a,0x35,0x46,0xac,0xd3,0xfe,0x49,0x34,0xf1,0xa2, /* .{...+:5F...I4.. */ \
	0x54,0x4e,0x09,0xe7,0xe1,0xfc,0x32,0x23,0x65,0x7a,0xb1,0x10,0x65,0xce,0x02,0x49  /* TN....2#ez..e..I */
#define DATACHUNK000002 \
	0x6d,0x8a,0x67,0xe4,0xe6,0x92,0x70,0xc3,0xd8,0x22,0x0b,0xd0,0x58,0xc2,0x09,0x9c, /* m.g...p.."..X... */ \
	0xc0,0xe9,0x4c,0x10,0x68,0xc8,0xa1,0x8b,0x73,0x16,0x9c,0xa9,0xa2,0x18,0x10,0x28, /* ..L.h...s......( */ \
	0x12,0x34,0xab,0xcb,0xcc,0x33,0x86,0xd7,0x99,0x00,0xef,0x2b,0xe5,0xe6,0xcc,0x7a, /* .4...3.....+...z */ \
	0xa5,0x99,0xbb,0xb7,0xaf,0x2f,0x29,0xd5,0x15,0x4b,0x88,0xa2,0xef,0xa1,0x8d,0xac, /* ...../)..K...... */ \
	0xa4,0x70,0xc0,0x35,0x38,0x20,0xb4,0xc2,0x33,0xb6,0x61,0xe2,0x18,0x41,0x95,0xb9, /* .p.58 ..3.a..A.. */ \
	0x9c,0x29,0x18,0x2f,0x8b,0xf5,0xae,0x72,0x2e,0x9c,0x78,0x46,0xa2,0xa4,0x37,0x37, /* .)./...r..xF..77 */ \
	0x97,0x24,0xcb,0x4c,0xe7,0x20,0xd7,0x3a,0xa3,0xca,0x3b,0xc6,0x9a,0x4a,0xb2,0xf5, /* .$.L. .:..;..J.. */ \
	0x74,0xa1,0x9c,0xc3,0x6b,0x61,0xe9,0xfa,0xea,0x76,0x42,0xac,0xb3,0x85,0xd3,0xda, /* t...ka...vB..... */ \
	0x0c,0x56,0x98,0x94,0xb3,0xc0,0x49,0x0a,0x1a,0x06,0xd4,0x9e,0x7c,0x10,0x2d,0x1b, /* .V....I.....|.-. */ \
	0x78,0x00,0xa8,0x7d,0xdc,0xdf,0x4b,0x7c,0x0c,0x39,0xaa,0x2b,0x78,0xd4,0x90,0x9e, /* x..}..K|.9.+x... */ \
	0xbe,0x93,0x99,0xc3,0x6b,0x76,0x06,0x83,0xc1,0x1f,0xd1,0x17,0x57,0x7e,0xc9,0x3b, /* ....kv......W~.; */ \
	0xc3,0xaf,0x82,0xc5,0x09,0x3c,0x6f,0xe2,0xf2,0x39,0xfc,0x12,0x16,0xa3,0xda,0x90, /* .....<o..9...... */ \
	0x7d,0x30,0x66,0x4f,0x74,0x5f,0xb6,0xc6,0x60,0xa9,0xbd,0xef,0x0a,0x44,0xf2,0xc6, /* }0fOt_..`....D.. */ \
	0xd1,0xd6,0xee,0x12,0x07,0xc7,0x8d,0x7c,0xcf,0x1b,0xd6,0x85,0x47,0x0d,0xf6,0x9f, /* .......|....G... */ \
	0x19,0x08,0x4a,0x70,0x08,0xe2,0x24,0x7e,0xd8,0xbf,0x31,0x76,0x21,0xa0,0x66,0xe9, /* ..Jp..$~..1v!.f. */ \
	0x0a,0x0e,0xd0,0xab,0x21,0x5c,0xf7,0xca,0xb9,0xea,0x26,0x2c,0xf5,0x09,0xc7,0xa7, /* ....!\....&,.... */ \
	0xf8,0xf7,0xc8,0x16,0x38,0xd3,0xb6,0x82,0x3f,0xdd,0x67,0x14,0x86,0xba,0x92,0x65, /* ....8...?.g....e */ \
	0x9a,0x32,0xaf,0xe3,0x31,0x5b,0xd7,0xff,0xa5,0xf7,0xeb,0xcb,0x49,0xef,0x59,0x8f, /* .2..1[......I.Y. */ \
	0x1d,0xd6,0x1b,0x50,0x87,0x94,0x81,0x0f,0x94,0x2f,0x81,0xf1,0x29,0x3c,0x56,0x23, /* ...P...../..)<V# */ \
	0xc4,0xb1,0x3f,0xa3,0x95,0x3c,0x30,0x08,0x6d,0xcb,0xa1,0x71,0xf1,0xf2,0x67,0x44, /* ..?..<0.m..q..gD */ \
	0xc9,0xba,0x90,0x94,0x2e,0xc4,0x1a,0x51,0xf2,0x74,0xf8,0x94,0x53,0xa1,0x42,0x56, /* .......Q.t..S.BV */ \
	0x4f,0x0b,0x0e,0x43,0xdd,0x0f,0xba,0x0f,0x24,0x0b,0xce,0xf9,0x96,0x86,0x53,0x84, /* O..C....$.....S. */ \
	0xca,0x52,0xbe,0x0d,0xfe,0xfc,0x0a,0x16,0xb6,0xe4,0xd3,0x9e,0xaf,0x36,0x56,0xcf, /* .R...........6V. */ \
	0x9c,0xe7,0x73,0x32,0xb9,0xee,0x75,0x8f,0x82,0x6d,0x76,0x50,0xb6,0x76,0xf8,0xee, /* ..s2..u..mvP.v.. */ \
	0xd4,0x7d,0x15,0x7d,0x9e,0x86,0xc8,0x46,0xb8,0x84,0xdf,0x46,0xb1,0x10,0xd6,0x9d, /* .}.}...F...F.... */ \
	0x21,0x51,0x91,0x62,0xe3,0x36,0xae,0x87,0x77,0xd2,0xf1,0x4d,0xeb,0xf6,0xd6,0x15, /* !Q.b.6..w..M.... */ \
	0xbe,0xa4,0x21,0xa9,0x7d,0xc6,0x08,0x2e,0x51,0x61,0xa9,0x29,0x5e,0xc3,0xaa,0xb6, /* ..!.}...Qa.)^... */ \
	0xf3,0x86,0x06,0xd6,0x7e,0x88,0xf5,0xeb,0x52,0xeb,0xca,0x92,0x5e,0x22,0xfa,0xb9, /* ....~...R...^".. */ \
	0x2c,0xe0,0xdc,0x39,0xfb,0x72,0xa7,0x20,0xe6,0x4d,0x21,0x06,0x99,0x08,0xea,0x35, /* ,..9.r. .M!....5 */ \
	0xaa,0x98,0xcf,0x6d,0x65,0x7d,0x54,0x2b,0x14,0xe1,0x4e,0xc6,0x57,0xba,0x28,0x18, /* ...me}T+..N.W.(. */ \
	0x20,0x05,0xcf,0x49,0x4c,0xcd,0xac,0x36,0xff,0x25,0x71,0x79,0x51,0x16,0xa2,0xb2, /*  ..IL..6.%qyQ... */ \
	0x32,0xdf,0x24,0xd7,0x8d,0x14,0x28,0xf6,0xb3,0x99,0xcf,0xaa,0xb6,0x3c,0x87,0x3a, /* 2.$...(......<.: */ \
	0x81,0xb3,0xc0,0xca,0xe9,0x9a,0x2f,0x90,0x46,0x53,0x49,0x15,0x50,0x5b,0x1e,0x0a, /* ....../.FSI.P[.. */ \
	0x59,0xde,0xb9,0xf9,0x09,0x29,0x7a,0x4e,0x68,0x0b,0xea,0xf0,0x10,0x31,0x99,0x70, /* Y....)zNh....1.p */ \
	0xd5,0x49,0x36,0x26,0xb6,0xd2,0x76,0xae,0x66,0xd1,0x4c,0x4e,0xda,0x1f,0xa2,0x08, /* .I6&..v.f.LN.... */ \
	0xab,0x24,0xbe,0x7c,0xab,0xb2,0x96,0x7e,0x35,0x1a,0xf9,0xa8,0xb3,0xe8,0xb0,0x39, /* .$.|...~5......9 */ \
	0x7e,0xc7,0xad,0x5e,0x2b,0xe1,0x13,0x25,0x4d,0x2a,0xa1,0xac,0x66,0x52,0xe6,0xcc, /* ~..^+..%M...fR.. */ \
	0xa5,0xdf,0xae,0x51,0x6a,0x82,0x08,0x35,0x25,0x5f,0xa3,0x91,0xa2,0xb0,0x8c,0xc7, /* ...Qj..5%_...... */ \
	0xf4,0x13,0xfd,0xf8,0x23,0xed,0x8a,0x58,0xac,0xd6,0x96,0x97,0xd1,0xc3,0x7d,0x98, /* ....#..X......}. */ \
	0x27,0x0d,0xbe,0x72,0x34,0x17,0xdc,0xa6,0x3a,0xc5,0x77,0x65,0xd0,0x00,0x62,0x71, /* '..r4...:.we..bq */ \
	0xb2,0x75,0xe1,0xbc,0x38,0x76,0x76,0xeb,0x4a,0xea,0x8d,0x01,0xad,0x46,0x9f,0x91, /* .u..8vv.J....F.. */ \
	0x0f,0x1a,0x47,0x1f,0xf4,0x03,0x7e,0xf2,0x89,0xdc,0x23,0xa6,0x87,0x5e,0x85,0xfc, /* ..G...~...#..^.. */ \
	0x1c,0x36,0x7d,0xee,0x65,0x21,0xf9,0x12,0xd8,0x4d,0x36,0x35,0xe1,0xcb,0x9b,0x87, /* .6}.e!...M65.... */ \
	0x3e,0x74,0xd0,0x9c,0x2d,0x69,0xd0,0x98,0xee,0x88,0xf8,0x62,0x7d,0x91,0x3f,0xa2, /* >t..-i.....b}.?. */ \
	0x3e,0x54,0x25,0x2e,0xaf,0x26,0xe8,0x96,0xe3,0x4f,0x88,0x6b,0x0c,0x9c,0xc8,0x0f, /* >T%..&...O.k.... */ \
	0xae,0x31,0x08,0xbc,0xa5,0x1a,0xe4,0x98,0x95,0xb2,0xdc,0x9e,0xa9,0xc4,0x13,0x67, /* .1.............g */ \
	0x07,0x0f,0x2e,0x5c,0x16,0x68,0x29,0x0a,0x94,0xe1,0x10,0x0e,0xf8,0xe1,0x8c,0x4b, /* ...\.h)........K */ \
	0x76,0x91,0xc5,0x54,0x9b,0x18,0x43,0x8f,0xad,0x6f,0x5a,0xc7,0x96,0xaf,0x0e,0xac, /* v..T..C..oZ..... */ \
	0x9f,0x76,0xb8,0xdf,0x08,0x2e,0x9e,0xb1,0x79,0x0c,0xd8,0x59,0x25,0xdb,0x62,0x75, /* .v......y..Y%.bu */ \
	0xe3,0xac,0x06,0x30,0x48,0x07,0x63,0x92,0x9d,0xae,0xdb,0xc8,0x84,0xee,0xbb,0x4b, /* ...0H.c........K */ \
	0xcd,0xe6,0x55,0xc4,0x38,0xf9,0x34,0xc0,0x1f,0xf8,0xa7,0x1b,0xad,0x07,0x4b,0x49, /* ..U.8.4.......KI */ \
	0x2b,0xa1,0x78,0x08,0xf0,0xe5,0xe3,0x18,0x9d,0x0e,0x1a,0x79,0x34,0x11,0xe1,0xdc, /* +.x........y4... */ \
	0x4e,0x65,0x31,0x9e,0x9b,0x1c,0x79,0xbe,0x99,0xcf,0xba,0x21,0x5a,0x2e,0xf5,0x7d, /* Ne1...y....!Z..} */ \
	0x08,0xc6,0x1a,0xe3,0xe4,0x66,0xe8,0xf1,0xc3,0x8e,0xa7,0x5b,0x95,0x55,0xfd,0xfd, /* .....f.....[.U.. */ \
	0x62,0xd4,0x17,0xf6,0xad,0xe0,0x8b,0xa2,0x30,0xe6,0xb4,0x90,0xc6,0xb5,0xb6,0x84, /* b.......0....... */ \
	0xd7,0x82,0xdf,0xa5,0xbd,0x48,0x29,0xcd,0x84,0x42,0x1a,0x0f,0xff,0x2a,0xcf,0x34, /* .....H)..B.....4 */ \
	0xe2,0xaa,0x9d,0xcf,0x72,0x54,0xcd,0x42,0x57,0x7e,0x90,0x9b,0x6a,0x61,0x72,0x90, /* ....rT.BW~..jar. */ \
	0x64,0xa9,0xd0,0xa8,0x26,0xbd,0x66,0x37,0xef,0xeb,0x6f,0x0b,0x96,0x58,0x3a,0xfe, /* d...&.f7..o..X:. */ \
	0x1f,0xf1,0x72,0xd5,0x24,0xd1,0x80,0xde,0xd5,0x28,0xd5,0xf7,0x52,0x56,0x3e,0x76, /* ..r.$....(..RV>v */ \
	0x90,0x4c,0x2c,0xb2,0xdd,0xa5,0x9a,0x22,0xcb,0x30,0x0f,0x9b,0x89,0x8a,0xdb,0x13, /* .L,....".0...... */ \
	0xba,0x9b,0x95,0xc5,0x92,0xa7,0xed,0x3b,0x58,0xc2,0x0d,0xef,0x78,0xc4,0x83,0x7d, /* .......;X...x..} */ \
	0x62,0x43,0xb1,0x45,0xb0,0xa5,0xbd,0x4d,0xff,0xe9,0x0d,0x8e,0x47,0xfd,0xd0,0x38, /* bC.E...M....G..8 */ \
	0x1e,0x22,0x67,0x80,0xba,0x16,0x40,0xb1,0xde,0xbb,0x1f,0x16,0xc5,0x4d,0x33,0x46, /* ."g...@......M3F */ \
	0x1b,0xe9,0x6a,0x53,0x22,0x3e,0xd1,0x3d,0x30,0xfc,0xc6,0x51,0x22,0x4e,0x5a,0xed  /* ..jS">.=0..Q"NZ. */
#define DATACHUNK000003 \
	0x18,0x8a,0xf9,0x18,0x4a,0xe7,0x7e,0x44,0x8e,0x08,0xfc,0xd0,0x6a,0xfb,0x1d,0x30, /* ....J.~D....j..0 */ \
	0xbc,0xcb,0x22,0x0f,0x02,0xfe,0x96,0x23,0xc3,0x4a,0x61,0xb2,0x39,0x17,0x8f,0x4e, /* .."....#.Ja.9..N */ \
	0xaf,0x44,0xd5,0xc2,0x46,0x7f,0x70,0x1d,0x49,0x23,0xd4,0x20,0xa8,0x84,0xd4,0x70, /* .D..F.p.I#. ...p */ \
	0x66,0x1d,0xc2,0x12,0x8e,0x8b,0xeb,0x9d,0x4a,0x67,0x5f,0xac,0x27,0xe2,0xee,0x77, /* f.......Jg_.'..w */ \
	0x81,0x2e,0x13,0x74,0xfe,0x1c,0xfd,0x3d,0x9c,0x29,0x83,0x26,0x33,0x57,0x45,0x3e, /* ...t...=.).&3WE> */ \
	0x2c,0x31,0xba,0x7b,0xec,0xe0,0xe5,0x60,0x23,0x7d,0x03,0x4e,0xec,0x75,0x56,0x76, /* ,1.{...`#}.N.uVv */ \
	0xf1,0x9a,0x90,0x7c,0xc0,0xa7,0x85,0xcb,0xe6,0xa9,0x34,0x48,0xc2,0x8f,0xd4,0x5d, /* ...|......4H...] */ \
	0xe5,0x21,0x27,0x8e,0x1c,0xf7,0x0a,0x1f,0x82,0x4d,0xf7,0xf6,0x73,0xc6,0x9b,0x0a, /* .!'......M..s... */ \
	0x93,0x11,0x67,0xd9,0xe7,0x9c,0x88,0x4f,0xb8,0xf0,0xc1,0xf5,0x2f,0xde,0xe8,0x9b, /* ..g....O..../... */ \
	0x2d,0xa8,0x0e,0x00,0x00,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* -....<div class= */ \
	0x22,0x73,0x70,0x61,0x63,0x65,0x72,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* "spacer">&nbsp;< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* /div>..<div id=" */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x22,0x3e,0x43,0x6f,0x70,0x79,0x72,0x69,0x67,0x68, /* footer">Copyrigh */ \
	0x74,0x20,0x26,0x63,0x6f,0x70,0x79,0x3b,0x20,0x32,0x30,0x31,0x31,0x20,0x53,0x61, /* t &copy; 2011 Sa */ \
	0x74,0x6f,0x73,0x68,0x69,0x20,0x59,0x61,0x73,0x75,0x64,0x61,0x20,0x37,0x6d,0x33, /* toshi Yasuda 7m3 */ \
	0x74,0x6a,0x7a,0x2f,0x61,0x64,0x36,0x67,0x7a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* tjz/ad6gz</div>. */ \
	0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c, /* ...</div></div>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* /div></div></div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x2f, /* >....</body>..</ */ \
	0x68,0x74,0x6d,0x6c,0x3e,0x3c,0x21,0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68, /* html><!DOCTYPE h */ \
	0x74,0x6d,0x6c,0x20,0x50,0x55,0x42,0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57, /* tml PUBLIC "-//W */ \
	0x33,0x43,0x2f,0x2f,0x44,0x54,0x44,0x20,0x58,0x48,0x54,0x4d,0x4c,0x20,0x31,0x2e, /* 3C//DTD XHTML 1. */ \
	0x30,0x20,0x53,0x74,0x72,0x69,0x63,0x74,0x2f,0x2f,0x45,0x4e,0x22,0x0d,0x0a,0x20, /* 0 Strict//EN"..  */ \
	0x20,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e, /*  "http://www.w3. */ \
	0x6f,0x72,0x67,0x2f,0x54,0x52,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2f,0x44,0x54, /* org/TR/xhtml1/DT */ \
	0x44,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2d,0x73,0x74,0x72,0x69,0x63,0x74,0x2e, /* D/xhtml1-strict. */ \
	0x64,0x74,0x64,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x74,0x6d,0x6c,0x20,0x78,0x6d,0x6c, /* dtd">..<html xml */ \
	0x6e,0x73,0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77, /* ns="http://www.w */ \
	0x33,0x2e,0x6f,0x72,0x67,0x2f,0x31,0x39,0x39,0x39,0x2f,0x78,0x68,0x74,0x6d,0x6c, /* 3.org/1999/xhtml */ \
	0x22,0x20,0x78,0x6d,0x6c,0x3a,0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x20, /* " xml:lang="en"  */ \
	0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x65,0x61, /* lang="en">..<hea */ \
	0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x69,0x74,0x6c,0x65,0x3e,0x44,0x2d,0x53,0x54,0x41, /* d>..<title>D-STA */ \
	0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20, /* R dSqure Client  */ \
	0x50,0x72,0x6f,0x67,0x72,0x61,0x6d,0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,0x0d, /* Program</title>. */ \
	0x0a,0x3c,0x6c,0x69,0x6e,0x6b,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x37,0x6d, /* .<link href="/7m */ \
	0x33,0x74,0x6a,0x7a,0x2e,0x63,0x73,0x73,0x22,0x20,0x72,0x65,0x6c,0x3d,0x22,0x73, /* 3tjz.css" rel="s */ \
	0x74,0x79,0x6c,0x65,0x73,0x68,0x65,0x65,0x74,0x22,0x20,0x74,0x79,0x70,0x65,0x3d, /* tylesheet" type= */ \
	0x22,0x74,0x65,0x78,0x74,0x2f,0x63,0x73,0x73,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c, /* "text/css" />..< */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x73,0x72,0x63,0x3d,0x22,0x2f,0x37,0x6d,0x33, /* script src="/7m3 */ \
	0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* tjz.js" type="te */ \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x3c, /* xt/javascript">< */ \
	0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x65,0x61,0x64, /* /script>..</head */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* >....<body>..<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x6f,0x6e,0x65, /* v id="shadow-one */ \
	0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f, /* "><div id="shado */ \
	0x77,0x2d,0x74,0x77,0x6f,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* w-two"><div id=" */ \
	0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x68,0x72,0x65,0x65,0x22,0x3e,0x3c,0x64, /* shadow-three"><d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x66,0x6f, /* iv id="shadow-fo */ \
	0x75,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x70, /* ur">..<div id="p */ \
	0x61,0x67,0x65,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* age">....<div id */ \
	0x3d,0x22,0x74,0x69,0x74,0x6c,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c, /* ="title"><div cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x72,0x69,0x67,0x68,0x74,0x22,0x3e,0x44,0x2d,0x53,0x54, /* ass="right">D-ST */ \
	0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74, /* AR dSqure Client */ \
	0x20,0x56,0x30,0x30,0x2e,0x32,0x30,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x73,0x70, /*  V00.20</div><sp */ \
	0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x68,0x65,0x6c,0x6c,0x6f,0x22,0x3e,0x26,0x6e, /* an id="hello">&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* bsp;</span></div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x6d,0x65, /* >....<div id="me */ \
	0x6e,0x75,0x22,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f, /* nu">..<a href="/ */ \
	0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4f,0x76,0x65,0x72,0x76, /* index.htm">Overv */ \
	0x69,0x65,0x77,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66, /* iew</a>..<a href */ \
	0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69, /* ="/protect/confi */ \
	0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43, /* g.htm">Network C */ \
	0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e, /* onfiguration</a> */ \
	0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65  /* ..<a href="/node */
#define DATACHUNK000004 \
	0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68, /* adapter/config.h */ \
	0x74,0x6d,0x22,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72, /* tm">Node Adapter */ \
	0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f, /*  Configuration</ */ \
	0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f, /* a>..<a href="/no */ \
	0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67, /* deadapter/config */ \
	0x32,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x43,0x6f, /* 2.htm">Beacon Co */ \
	0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d, /* nfiguration</a>. */ \
	0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61, /* .<a href="/nodea */ \
	0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33,0x2e,0x68, /* dapter/config3.h */ \
	0x74,0x6d,0x22,0x3e,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x52,0x65, /* tm">TX Header Re */ \
	0x70,0x6c,0x61,0x63,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74, /* place Configurat */ \
	0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66, /* ion</a>..<a href */ \
	0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e, /* ="/protect/user. */ \
	0x68,0x74,0x6d,0x22,0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x20,0x26,0x20,0x50, /* htm">User ID & P */ \
	0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c, /* assword setting< */ \
	0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x73, /* /a>..<a href="/s */ \
	0x74,0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x43,0x75,0x72,0x72,0x65, /* tatus.htm">Curre */ \
	0x6e,0x74,0x20,0x53,0x74,0x61,0x74,0x75,0x73,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c, /* nt Status</a>..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72, /* /div>~inc:header */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* .inc~..<div id=" */ \
	0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31, /* content">....<h1 */ \
	0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43, /* >D-STAR dSqure C */ \
	0x6c,0x69,0x65,0x6e,0x74,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x74, /* lient</h1>....<t */ \
	0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64, /* able style="padd */ \
	0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22, /* ing-left: 10px;" */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x64,0x53, /* >..<tr><td><b>dS */ \
	0x71,0x75,0x72,0x65,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d,0x61, /* qure Server Doma */ \
	0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* in Name :</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e,0x61,0x6d, /* ><td>~server_nam */ \
	0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74, /* e~</td></tr>..<t */ \
	0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4f,0x75,0x74,0x20,0x62,0x6f,0x75, /* r><td><b>Out bou */ \
	0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* nd Port :</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x3c, /* ><td>~out_port~< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c, /* /td></tr>..<tr>< */ \
	0x74,0x64,0x3e,0x3c,0x62,0x3e,0x49,0x6e,0x20,0x62,0x6f,0x75,0x6e,0x64,0x20,0x50, /* td><b>In bound P */ \
	0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* ort :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d>&nbsp;</td><td */ \
	0x3e,0x7e,0x69,0x6e,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* >~in_port~</td>< */ \
	0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62, /* /tr>..<tr><td><b */ \
	0x3e,0x43,0x6f,0x6e,0x66,0x65,0x72,0x65,0x6e,0x63,0x65,0x20,0x52,0x6f,0x6f,0x6d, /* >Conference Room */ \
	0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e, /*  Name :</b></td> */ \
	0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* <td>&nbsp;</td>< */ \
	0x74,0x64,0x3e,0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74, /* td>~RoomName~</t */ \
	0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64, /* d></tr>..<tr><td */ \
	0x3e,0x3c,0x62,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67, /* ><b>Node Callsig */ \
	0x6e,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* n :</b></td><td> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e, /* &nbsp;</td><td>~ */ \
	0x4e,0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* NodeName~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46, /* Access Control F */ \
	0x69,0x6c,0x65,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f, /* ile Name :</b></ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74, /* td><td>&nbsp;</t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x41,0x63,0x63,0x43,0x74,0x72,0x6c,0x7e,0x3c, /* d><td>~AccCtrl~< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c, /* /td></tr>..<tr>< */ \
	0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72, /* td><b>NTP Server */ \
	0x20,0x44,0x6f,0x6d,0x61,0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f, /*  Domain Name :</ */ \
	0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70, /* b></td><td>&nbsp */ \
	0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x74,0x70,0x4e,0x61, /* ;</td><td>~NtpNa */ \
	0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c, /* me~</td></tr>..< */ \
	0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65,0x20,0x5a, /* tr><td><b>Time Z */ \
	0x6f,0x6e,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* one :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64  /* d>&nbsp;</td><td */
#define DATACHUNK000005 \
	0x3e,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x20,0x26,0x6e,0x62,0x73, /* >~TimeZone~ &nbs */ \
	0x70,0x3b,0x68,0x6f,0x75,0x72,0x73,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x54,0x69, /* p;hours&nbsp;~Ti */ \
	0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x7e,0x26,0x6e, /* meZoneMinutes~&n */ \
	0x62,0x73,0x70,0x3b,0x6d,0x69,0x6e,0x75,0x74,0x65,0x73,0x3c,0x2f,0x74,0x64,0x3e, /* bsp;minutes</td> */ \
	0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c, /* </tr>..<tr><td>< */ \
	0x62,0x3e,0x4a,0x69,0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20, /* b>Jitter Buffer  */ \
	0x57,0x61,0x69,0x74,0x20,0x50,0x61,0x63,0x6b,0x65,0x74,0x73,0x3a,0x3c,0x2f,0x62, /* Wait Packets:</b */ \
	0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ></td><td>&nbsp; */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4a,0x69,0x74,0x74,0x65,0x72, /* </td><td>~Jitter */ \
	0x53,0x69,0x7a,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* Size~</td></tr>. */ \
	0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64, /* .</table>....</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74, /* iv>....<script t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63, /* ype="text/javasc */ \
	0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f, /* ript">..<!--..do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e, /* cument.getElemen */ \
	0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69, /* tById('hello').i */ \
	0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c, /* nnerHTML = "~hel */ \
	0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d, /* lomsg~";..//-->. */ \
	0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69, /* .</script>....~i */ \
	0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a, /* nc:footer.inc~.. */ \
	0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xb0,0x00,0x00,0x00,0x4a,0x00,0x00,0x00, /* ....3.......J... */ \
	0x00,0x01,0x00,0x00,0x4b,0x00,0x00,0x00,0x4c,0x01,0x00,0x00,0x4c,0x00,0x00,0x00, /* ....K...L...L... */ \
	0x9e,0x01,0x00,0x00,0x4d,0x00,0x00,0x00,0xea,0x01,0x00,0x00,0x4e,0x00,0x00,0x00, /* ....M.......N... */ \
	0x41,0x02,0x00,0x00,0x5f,0x00,0x00,0x00,0x95,0x02,0x00,0x00,0x60,0x00,0x00,0x00, /* A..._.......`... */ \
	0xdc,0x02,0x00,0x00,0x61,0x00,0x00,0x00,0xf8,0x02,0x00,0x00,0x6d,0x00,0x00,0x00, /* ....a.......m... */ \
	0x64,0x03,0x00,0x00,0x6e,0x00,0x00,0x00,0xe7,0x03,0x00,0x00,0x01,0x00,0x00,0x00, /* d...n........... */ \
	0x09,0x04,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61, /* ........~inc:hea */ \
	0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69, /* der.inc~..<div i */ \
	0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a, /* d="content">.... */ \
	0x3c,0x68,0x31,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72, /* <h1>D-STAR dSqur */ \
	0x65,0x20,0x53,0x74,0x61,0x74,0x75,0x73,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d, /* e Status</h1>... */ \
	0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70, /* .<table style="p */ \
	0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70, /* adding-left: 10p */ \
	0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62, /* x;">..<tr><td><b */ \
	0x3e,0x44,0x61,0x74,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e, /* >Date :</b></td> */ \
	0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* <td>&nbsp;</td>< */ \
	0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x44,0x61,0x74,0x65,0x7e,0x3c,0x2f,0x74,0x64, /* td>~CurDate~</td */ \
	0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e, /* ></tr>..<tr><td> */ \
	0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* <b>Time :</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x54,0x69,0x6d,0x65,0x7e,0x3c,0x2f, /* ><td>~CurTime~</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74, /* td></tr>..<tr><t */ \
	0x64,0x3e,0x3c,0x62,0x3e,0x50,0x54,0x54,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f, /* d><b>PTT :</b></ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74, /* td><td>&nbsp;</t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x50,0x54,0x54,0x7e,0x3c,0x2f, /* d><td>~CurPTT~</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74, /* td></tr>..<tr><t */ \
	0x64,0x3e,0x3c,0x62,0x3e,0x43,0x4f,0x53,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f, /* d><b>COS :</b></ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74, /* td><td>&nbsp;</t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x43,0x4f,0x53,0x7e,0x3c,0x2f, /* d><td>~CurCOS~</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74, /* td></tr>..<tr><t */ \
	0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x55,0x73,0x65,0x72,0x20,0x3a, /* d><b>Node User : */ \
	0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62, /* </b></td><td>&nb */ \
	0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72, /* sp;</td><td>~Cur */ \
	0x55,0x73,0x65,0x72,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* User~</td></tr>. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x53,0x53,0x4e,0x20, /* .<tr><td><b>SSN  */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e, /* :</b></td><td>&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75, /* bsp;</td><td>~Cu */ \
	0x72,0x53,0x53,0x4e,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* rSSN~</td></tr>. */ \
	0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64, /* .</table>....</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x6d, /* iv>..</body>..<m */ \
	0x65,0x74,0x61,0x20,0x68,0x74,0x74,0x70,0x2d,0x65,0x71,0x75,0x69,0x76,0x3d,0x22, /* eta http-equiv=" */ \
	0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74, /* refresh" content */ \
	0x3d,0x22,0x31,0x30,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a, /* ="10">..<body>.. */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65  /* <script type="te */
#define DATACHUNK000006 \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* xt/javascript">. */ \
	0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* .<!--..document. */ \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d, /* hello').innerHTM */ \
	0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22, /* L = "~hellomsg~" */ \
	0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* ;..//-->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* pt>..~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x9b, /* .inc~......3.... */ \
	0x00,0x00,0x00,0x63,0x00,0x00,0x00,0xdd,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x1e, /* ...c.......d.... */ \
	0x01,0x00,0x00,0x66,0x00,0x00,0x00,0x5e,0x01,0x00,0x00,0x67,0x00,0x00,0x00,0xa4, /* ...f...^...g.... */ \
	0x01,0x00,0x00,0x69,0x00,0x00,0x00,0xe5,0x01,0x00,0x00,0x68,0x00,0x00,0x00,0x9d, /* ...i.......h.... */ \
	0x02,0x00,0x00,0x01,0x00,0x00,0x00,0xbd,0x02,0x00,0x00,0x02,0x00,0x00,0x00,0x7e, /* ...............~ */ \
	0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d, /* inc:header.inc~. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e, /* .<div id="conten */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x6f,0x64,0x65,0x20, /* t">....<h1>Node  */ \
	0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72, /* Adapter Configur */ \
	0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66, /* ation</h1>....<f */ \
	0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74, /* orm method="post */ \
	0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61, /* " action="/nodea */ \
	0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74, /* dapter/config.ht */ \
	0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x6f,0x64,0x65,0x63,0x66,0x67, /* m" name="nodecfg */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a, /* ">..<fieldset>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x44, /* <div><label>TX D */ \
	0x65,0x6c,0x61,0x79,0x20,0x54,0x69,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* elay Time:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x65,0x6c, /* "text" name="del */ \
	0x79,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x65,0x6c,0x61,0x79, /* y" value="~delay */ \
	0x5f,0x74,0x69,0x6d,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22, /* _time~" size="4" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x26, /*  class="ad1" />& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* nbsp;mSec.</div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58, /* ..<div><label>TX */ \
	0x20,0x54,0x69,0x6d,0x65,0x20,0x6f,0x75,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /*  Time out:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x6f,0x75, /* "text" name="tou */ \
	0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x74,0x69,0x6d,0x65,0x5f, /* t" value="~time_ */ \
	0x6f,0x75,0x74,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63, /* out~" size="4" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73, /* lass="ad1"/>&nbs */ \
	0x70,0x3b,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* p;Sec.</div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x4b,0x65,0x65, /* iv><label>RX Kee */ \
	0x70,0x20,0x41,0x6c,0x69,0x76,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* p Alive:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* ..<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6b,0x65,0x65,0x70,0x22, /* ext" name="keep" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6b,0x65,0x65,0x70,0x5f,0x61,0x6c, /*  value="~keep_al */ \
	0x69,0x76,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63, /* ive~" size="4" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73, /* lass="ad1"/>&nbs */ \
	0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* p;mSec.</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4a,0x69,0x74,0x74,0x65, /* div><label>Jitte */ \
	0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x73,0x69,0x7a,0x65,0x3a,0x3c,0x2f, /* r Buffer size:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x6a,0x69,0x74,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6a, /* "jitt" value="~j */ \
	0x69,0x74,0x74,0x74,0x65,0x72,0x5f,0x73,0x69,0x7a,0x65,0x7e,0x22,0x20,0x73,0x69, /* ittter_size~" si */ \
	0x7a,0x65,0x3d,0x22,0x33,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* ze="3" class="ad */ \
	0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e,0x6f,0x74, /* 1"/>&nbsp;0: not */ \
	0x20,0x65,0x66,0x66,0x65,0x63,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /*  effect</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x41,0x75, /* div><label>RX Au */ \
	0x74,0x6f,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61, /* to Polarity:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x72,0x78,0x70,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="rxpl" value=" */ \
	0x22,0x20,0x7e,0x52,0x58,0x5f,0x41,0x75,0x74,0x6f,0x50,0x6f,0x6c,0x61,0x72,0x69, /* " ~RX_AutoPolari */ \
	0x74,0x79,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f, /* ty~ class="ad1"/ */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79  /* abel>RX Polarity */
#define DATACHUNK000007 \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x78,0x70,0x6f,0x22,0x20,0x76,0x61, /* " name="rxpo" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x52,0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72, /* lue="" ~RX_Polar */ \
	0x69,0x74,0x79,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* ity~  class="ad1 */ \
	0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* "/></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69, /* <label>TX Polari */ \
	0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64, /* ty:</label>..<td */ \
	0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68, /* ><input type="ch */ \
	0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x78, /* eckbox" name="tx */ \
	0x70,0x6f,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x54,0x58, /* po" value="" ~TX */ \
	0x5f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73, /* _Polarity~ class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ="ad1" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x4f,0x53, /* .<div><label>COS */ \
	0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /*  Check:</label>. */ \
	0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* .<td><input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x63,0x6f,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20, /* ="cos" value=""  */ \
	0x7e,0x43,0x4f,0x53,0x5f,0x43,0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61,0x73, /* ~COS_Check~ clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* s="ad1" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x2f, /* ..<div><label>S/ */ \
	0x4e,0x20,0x53,0x71,0x75,0x65,0x6c,0x63,0x68,0x20,0x56,0x61,0x6c,0x75,0x65,0x3a, /* N Squelch Value: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69, /* </label>..<td><i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /*  name="sn" value */ \
	0x3d,0x22,0x7e,0x53,0x4e,0x5f,0x53,0x71,0x75,0x65,0x6c,0x63,0x68,0x7e,0x22,0x20, /* ="~SN_Squelch~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* size="5" class=" */ \
	0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e, /* ad1"/>&nbsp;0: n */ \
	0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ot effect</div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x52,0x43, /* .<div><label>CRC */ \
	0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /*  Check:</label>. */ \
	0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* .<td><input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x63,0x72,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20, /* ="crc" value=""  */ \
	0x7e,0x43,0x52,0x43,0x5f,0x43,0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61,0x73, /* ~CRC_Check~ clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* s="ad1"/></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c,0x61,0x73, /* .<div><label>Las */ \
	0x74,0x20,0x46,0x72,0x61,0x6d,0x65,0x20,0x53,0x65,0x6e,0x64,0x3a,0x3c,0x2f,0x6c, /* t Frame Send:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* abel>..<td><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x61,0x73,0x74,0x22,0x20,0x76,0x61, /* " name="last" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x4c,0x61,0x73,0x74,0x46,0x72,0x61,0x6d, /* lue="" ~LastFram */ \
	0x65,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f, /* e~ class="ad1" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65,0x6e,0x65, /* abel>Header Gene */ \
	0x72,0x61,0x74,0x69,0x6f,0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* ration:</label>. */ \
	0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* .<td><input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x68,0x64,0x72,0x67,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22, /* ="hdrg" value="" */ \
	0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x47,0x65,0x6e,0x7e,0x20,0x63,0x6c,0x61, /*  ~HeaderGen~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* ss="ad1" /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48, /* >..<div><label>H */ \
	0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65,0x6e,0x2e,0x20,0x54,0x79,0x70,0x65,0x3a, /* eader Gen. Type: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69, /* </label>..<td><i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x74,0x22, /* box" name="hdrt" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65, /*  value="" ~Heade */ \
	0x72,0x47,0x65,0x6e,0x54,0x79,0x70,0x65,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73, /* rGenType~  class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x43,0x68, /* ="ad1"/>&nbsp;Ch */ \
	0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x53,0x70,0x61,0x63,0x65,0x3c,0x2f,0x64,0x69, /* ecked: Space</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* v>..<div>&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ;&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26  /* sp;&nbsp;&nbsp;& */
#define DATACHUNK000008 \
	0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* nbsp;.&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65,0x63,0x6b, /* p;&nbsp;.Uncheck */ \
	0x65,0x64,0x3a,0x20,0x4c,0x61,0x73,0x74,0x20,0x52,0x46,0x20,0x48,0x65,0x61,0x64, /* ed: Last RF Head */ \
	0x65,0x72,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* er</div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x61,0x6c,0x66,0x2f,0x46,0x75,0x6c,0x6c,0x20, /* label>Half/Full  */ \
	0x44,0x75,0x70,0x6c,0x65,0x78,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* Duplex:</label>. */ \
	0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* .<td><input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x68,0x5f,0x66,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20, /* ="h_f" value=""  */ \
	0x7e,0x48,0x61,0x6c,0x66,0x46,0x75,0x6c,0x6c,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73, /* ~HalfFull~  clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x43, /* s="ad1"/>&nbsp;C */ \
	0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x48,0x61,0x6c, /* hecked:&nbsp;Hal */ \
	0x66,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e, /* f</div>..<div>&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62,0x73,0x70, /* bsp;&nbsp;.&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x55,0x6e, /* ;&nbsp;&nbsp;.Un */ \
	0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x46,0x75,0x6c,0x6c,0x20,0x44,0x75, /* checked: Full Du */ \
	0x70,0x6c,0x65,0x78,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a, /* plex</div>...... */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* <div><input type */ \
	0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* ="submit" class= */ \
	0x22,0x61,0x70,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76, /* "ap1" value="Sav */ \
	0x65,0x20,0x42,0x61,0x73,0x69,0x63,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f, /* e Basic Info." / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64, /* ></div>..</field */ \
	0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c, /* set>..</form>..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74, /* /div>..~inc:foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xeb, /* er.inc~....3.... */ \
	0x00,0x00,0x00,0x51,0x00,0x00,0x00,0x6b,0x01,0x00,0x00,0x52,0x00,0x00,0x00,0xe9, /* ...Q...k...R.... */ \
	0x01,0x00,0x00,0x53,0x00,0x00,0x00,0x6f,0x02,0x00,0x00,0x54,0x00,0x00,0x00,0x03, /* ...S...o...T.... */ \
	0x03,0x00,0x00,0x55,0x00,0x00,0x00,0x78,0x03,0x00,0x00,0x5e,0x00,0x00,0x00,0xee, /* ...U...x...^.... */ \
	0x03,0x00,0x00,0x56,0x00,0x00,0x00,0x61,0x04,0x00,0x00,0x57,0x00,0x00,0x00,0xd3, /* ...V...a...W.... */ \
	0x04,0x00,0x00,0x58,0x00,0x00,0x00,0x61,0x05,0x00,0x00,0x59,0x00,0x00,0x00,0xd8, /* ...X...a...Y.... */ \
	0x05,0x00,0x00,0x5a,0x00,0x00,0x00,0x52,0x06,0x00,0x00,0x5b,0x00,0x00,0x00,0xcb, /* ...Z...R...[.... */ \
	0x06,0x00,0x00,0x5c,0x00,0x00,0x00,0xd1,0x07,0x00,0x00,0x5d,0x00,0x00,0x00,0xe8, /* ...\.......].... */ \
	0x08,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64, /* .......~inc:head */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* er.inc~..<div id */ \
	0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ="content">....< */ \
	0x68,0x31,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67, /* h1>Beacon Config */ \
	0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a, /* uration</h1>.... */ \
	0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f, /* <form method="po */ \
	0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64, /* st" action="/nod */ \
	0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x32, /* eadapter/config2 */ \
	0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x65,0x61,0x63, /* .htm" name="beac */ \
	0x6f,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e, /* on">..<fieldset> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x42,0x65, /* ..<div><label>Be */ \
	0x61,0x63,0x6f,0x6e,0x20,0x4d,0x65,0x73,0x73,0x61,0x67,0x65,0x3a,0x3c,0x2f,0x6c, /* acon Message:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* abel>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x62,0x65,0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x42,0x65, /* beac" value="~Be */ \
	0x61,0x63,0x6f,0x6e,0x4d,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x30, /* aconM~" size="20 */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x2f,0x3e,0x3c,0x2f, /* " class="sm"/></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x49,0x6e,0x65,0x72,0x76,0x61,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* l>Inerval:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x6e,0x74, /* "text" name="int */ \
	0x76,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x42,0x65,0x61,0x63,0x6f, /* v" value="~Beaco */ \
	0x6e,0x49,0x6e,0x74,0x76,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22, /* nIntv~" size="3" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e, /*  class="ad1"/>&n */ \
	0x62,0x73,0x70,0x3b,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* bsp;Sec.</div>.. */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* ..<div><input ty */ \
	0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73, /* pe="submit" clas */ \
	0x73,0x3d,0x22,0x61,0x70,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53, /* s="ap1" value="S */ \
	0x61,0x76,0x65,0x20,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x49,0x6e,0x66,0x6f,0x2e  /* ave Beacon Info. */
#define DATACHUNK000009 \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69, /* " /></div>..</fi */ \
	0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e, /* eldset>..</form> */ \
	0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66, /* ..</div>..~inc:f */ \
	0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00, /* ooter.inc~....3. */ \
	0x00,0x00,0xe6,0x00,0x00,0x00,0x71,0x00,0x00,0x00,0x53,0x01,0x00,0x00,0x72,0x00, /* ......q...S...r. */ \
	0x00,0x00,0xf3,0x01,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68, /* ..........~inc:h */ \
	0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* eader.inc~..<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a, /*  id="content">.. */ \
	0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20, /* ..<h1>TX Header  */ \
	0x52,0x65,0x70,0x6c,0x61,0x63,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72, /* Replace Configur */ \
	0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66, /* ation</h1>....<f */ \
	0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74, /* orm method="post */ \
	0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61, /* " action="/nodea */ \
	0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33,0x2e,0x68, /* dapter/config3.h */ \
	0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x65,0x61,0x64,0x65,0x72, /* tm" name="header */ \
	0x63,0x66,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74, /* cfg">..<fieldset */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54, /* >..<div><label>T */ \
	0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x52,0x65,0x70,0x6c,0x61,0x63,0x65, /* X Header Replace */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x78,0x68,0x72,0x22,0x20,0x76,0x61, /* " name="txhr" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x52,0x65, /* lue="" ~HeaderRe */ \
	0x70,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x6f, /* p~ class="ad1" o */ \
	0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x48,0x65, /* nclick="configHe */ \
	0x61,0x64,0x65,0x72,0x28,0x29,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ader()"/></div>. */ \
	0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* .<br>..<div><lab */ \
	0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72,0x20,0x4d,0x79,0x43,0x61,0x6c,0x6c,0x3a, /* el>Alter MyCall: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x6d,0x79,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* e="myc" value="~ */ \
	0x61,0x6c,0x74,0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a, /* alt_mycall~" siz */ \
	0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* e="8" class="ad1 */ \
	0x22,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* "/>..<input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x61,0x6d,0x79,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22, /* ="amyc" value="" */ \
	0x20,0x7e,0x61,0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73, /*  ~a_mycall~ clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69, /* s="ad3" />..</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x41,0x6c,0x74,0x65,0x72,0x20,0x4d,0x79,0x43,0x61,0x6c,0x6c,0x32,0x3a,0x3c,0x2f, /* Alter MyCall2:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x6d,0x79,0x63,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61, /* "myc2" value="~a */ \
	0x6c,0x74,0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c,0x32,0x7e,0x22,0x20,0x73,0x69,0x7a, /* lt_mycall2~" siz */ \
	0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* e="4" class="ad1 */ \
	0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* "/>&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e, /* nbsp;&nbsp;..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x6d,0x79,0x32,0x22,0x20, /* ox" name="amy2"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x6d,0x79,0x63,0x61, /* value="" ~a_myca */ \
	0x6c,0x6c,0x32,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22, /* ll2~ class="ad3" */ \
	0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /*  />..</div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72,0x20,0x59, /* v><label>Alter Y */ \
	0x6f,0x75,0x72,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* ourCall:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* ..<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x79,0x72,0x63,0x22,0x20, /* ext" name="yrc"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x79,0x6f,0x75,0x72, /* value="~alt_your */ \
	0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20, /* call~" size="8"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x3c, /* class="ad1"/>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x79,0x72,0x63, /* kbox" name="ayrc */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x79,0x6f, /* " value="" ~a_yo */ \
	0x75,0x72,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* urcall~ class="a */ \
	0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* d3" />..</div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65  /* <div><label>Alte */
#define DATACHUNK00000a \
	0x72,0x20,0x52,0x50,0x54,0x31,0x20,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61, /* r RPT1 Call:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72, /* e="text" name="r */ \
	0x70,0x74,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74, /* pt1" value="~alt */ \
	0x5f,0x72,0x70,0x74,0x31,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65, /* _rpt1call~" size */ \
	0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ="8" class="ad1" */ \
	0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* />..<input type= */ \
	0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* "checkbox" name= */ \
	0x22,0x61,0x72,0x74,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20, /* "art1" value=""  */ \
	0x7e,0x61,0x5f,0x72,0x70,0x74,0x31,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61, /* ~a_rpt1call~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* ss="ad3" />..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x41,0x6c,0x74,0x65,0x72,0x20,0x52,0x50,0x54,0x32,0x20,0x43,0x61,0x6c,0x6c, /* >Alter RPT2 Call */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x72,0x70,0x74,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="rpt2" value= */ \
	0x22,0x7e,0x61,0x6c,0x74,0x5f,0x72,0x70,0x74,0x32,0x63,0x61,0x6c,0x6c,0x7e,0x22, /* "~alt_rpt2call~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="8" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* "ad1"/>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x72,0x74,0x32,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="art2" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x72,0x70,0x74,0x32,0x63,0x61,0x6c,0x6c, /* e="" ~a_rpt2call */ \
	0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e, /* ~ class="ad3" /> */ \
	0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* ..</div>....<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x2e,0x20,0x54,0x58,0x20, /* ><label>Alt. TX  */ \
	0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x46,0x6c,0x61,0x67,0x73,0x3a,0x3c,0x2f,0x6c, /* Header Flags:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* abel>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x37,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="flg7" value= */ \
	0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x37,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73, /* "" ~flag7~ class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x2f, /* ="ad1" disabled/ */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* checkbox" name=" */ \
	0x66,0x6c,0x67,0x36,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e, /* flg6" value="" ~ */ \
	0x66,0x6c,0x61,0x67,0x36,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* flag6~ class="ad */ \
	0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* 3" />..<input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x35,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="flg5" value= */ \
	0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x35,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73, /* "" ~flag5~ class */ \
	0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* ="ad3" />..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x34,0x22,0x20,0x76,0x61, /* " name="flg4" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x34,0x7e,0x20,0x63, /* lue="" ~flag4~ c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c, /* lass="ad3" />..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x33, /* kbox" name="flg3 */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67, /* " value="" ~flag */ \
	0x33,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f, /* 3~ class="ad3" / */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* checkbox" name=" */ \
	0x66,0x6c,0x67,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e, /* flg2" value="" ~ */ \
	0x66,0x6c,0x61,0x67,0x32,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* flag2~ class="ad */ \
	0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* 3" />..<input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="flg1" value= */ \
	0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x31,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73, /* "" ~flag1~ class */ \
	0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* ="ad3" />..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x30,0x22,0x20,0x76,0x61, /* " name="flg0" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x30,0x7e,0x20,0x63, /* lue="" ~flag0~ c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x26,0x6e,0x62, /* lass="ad3" />&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* sp;&nbsp;..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x66,0x6c,0x67,0x22,0x20,0x76,0x61  /* " name="aflg" va */
#define DATACHUNK00000b \
	0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x41,0x66,0x6c,0x61,0x67,0x7e,0x20,0x63, /* lue="" ~Aflag~ c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c, /* lass="ad3" />..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69, /* /div>........<di */ \
	0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73, /* v><input type="s */ \
	0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70, /* ubmit" class="ap */ \
	0x31,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x73,0x22,0x20,0x76, /* 1" name="hdrs" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x48,0x65,0x61,0x64,0x65, /* alue="Save Heade */ \
	0x72,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* r Info." /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a, /* >..</fieldset>.. */ \
	0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* </form>..</div>. */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67, /* .<script languag */ \
	0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* e="javascript">. */ \
	0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67, /* .function config */ \
	0x48,0x65,0x61,0x64,0x65,0x72,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20,0x3d, /* Header() {...e = */ \
	0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e, /*  document.forms. */ \
	0x68,0x65,0x61,0x64,0x65,0x72,0x63,0x66,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20, /* headercfg;...st  */ \
	0x3d,0x20,0x21,0x28,0x65,0x2e,0x74,0x78,0x68,0x72,0x2e,0x63,0x68,0x65,0x63,0x6b, /* = !(e.txhr.check */ \
	0x65,0x64,0x29,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x6d,0x79,0x63,0x2e,0x64,0x69,0x73, /* ed);...e.myc.dis */ \
	0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e, /* abled = st;...e. */ \
	0x6d,0x79,0x63,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20, /* myc2.disabled =  */ \
	0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x79,0x72,0x63,0x2e,0x64,0x69,0x73,0x61, /* st;...e.yrc.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x72, /* bled = st;...e.r */ \
	0x70,0x74,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* pt1.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x72,0x70,0x74,0x32,0x2e,0x64,0x69,0x73,0x61, /* t;...e.rpt2.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66, /* bled = st;...e.f */ \
	0x6c,0x67,0x36,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* lg6.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x35,0x2e,0x64,0x69,0x73,0x61, /* t;...e.flg5.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66, /* bled = st;...e.f */ \
	0x6c,0x67,0x34,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* lg4.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x33,0x2e,0x64,0x69,0x73,0x61, /* t;...e.flg3.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66, /* bled = st;...e.f */ \
	0x6c,0x67,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* lg2.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x31,0x2e,0x64,0x69,0x73,0x61, /* t;...e.flg1.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66, /* bled = st;...e.f */ \
	0x6c,0x67,0x30,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* lg0.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61,0x66,0x6c,0x67,0x2e,0x64,0x69,0x73,0x61, /* t;...e.aflg.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61, /* bled = st;...e.a */ \
	0x6d,0x79,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* myc.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61,0x6d,0x79,0x32,0x2e,0x64,0x69,0x73,0x61, /* t;...e.amy2.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61, /* bled = st;...e.a */ \
	0x79,0x72,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* yrc.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61,0x72,0x74,0x31,0x2e,0x64,0x69,0x73,0x61, /* t;...e.art1.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61, /* bled = st;...e.a */ \
	0x72,0x74,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* rt2.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x48, /* t;..}....configH */ \
	0x65,0x61,0x64,0x65,0x72,0x28,0x29,0x3b,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x73,0x63, /* eader();....</sc */ \
	0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f, /* ript>....~inc:fo */ \
	0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00, /* oter.inc~....3.. */ \
	0x00,0xfd,0x00,0x00,0x00,0x73,0x00,0x00,0x00,0x85,0x01,0x00,0x00,0x74,0x00,0x00, /* .....s.......t.. */ \
	0x00,0xd7,0x01,0x00,0x00,0x81,0x00,0x00,0x00,0x44,0x02,0x00,0x00,0x75,0x00,0x00, /* .........D...u.. */ \
	0x00,0xaf,0x02,0x00,0x00,0x82,0x00,0x00,0x00,0x1d,0x03,0x00,0x00,0x76,0x00,0x00, /* .............v.. */ \
	0x00,0x71,0x03,0x00,0x00,0x83,0x00,0x00,0x00,0xe2,0x03,0x00,0x00,0x77,0x00,0x00, /* .q...........w.. */ \
	0x00,0x36,0x04,0x00,0x00,0x84,0x00,0x00,0x00,0xa7,0x04,0x00,0x00,0x78,0x00,0x00, /* .6...........x.. */ \
	0x00,0xfb,0x04,0x00,0x00,0x85,0x00,0x00,0x00,0x79,0x05,0x00,0x00,0x79,0x00,0x00, /* .........y...y.. */ \
	0x00,0xc5,0x05,0x00,0x00,0x7a,0x00,0x00,0x00,0x09,0x06,0x00,0x00,0x7b,0x00,0x00, /* .....z.......{.. */ \
	0x00,0x4d,0x06,0x00,0x00,0x7c,0x00,0x00,0x00,0x91,0x06,0x00,0x00,0x7d,0x00,0x00, /* .M...|.......}.. */ \
	0x00,0xd5,0x06,0x00,0x00,0x7e,0x00,0x00,0x00,0x19,0x07,0x00,0x00,0x7f,0x00,0x00, /* .....~.......... */ \
	0x00,0x5d,0x07,0x00,0x00,0x80,0x00,0x00,0x00,0xad,0x07,0x00,0x00,0x88,0x00,0x00, /* .].............. */ \
	0x00,0x8f,0x0a,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65, /* .........~inc:he */ \
	0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ader.inc~..<div  */ \
	0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d, /* id="content">... */ \
	0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e, /* .<h1>Network Con */ \
	0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d, /* figuration</h1>. */ \
	0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d  /* ...<form method= */
#define DATACHUNK00000c \
	0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f, /* "post" action="/ */ \
	0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68, /* protect/config.h */ \
	0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67, /* tm" name="config */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a, /* ">..<fieldset>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x41,0x43,0x20, /* <div><label>MAC  */ \
	0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* Address:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* ..<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61,0x63,0x22,0x20, /* ext" name="mac"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x6d, /* value="~config_m */ \
	0x61,0x63,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* ac~" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x72,0x76,0x65, /* div><label>Serve */ \
	0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* r Name:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x6f,0x73,0x74,0x22,0x20, /* xt" name="host"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e, /* value="~server_n */ \
	0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ame~" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4f,0x75,0x74,0x20, /* <div><label>Out  */ \
	0x42,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* Bound Port:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6f,0x70, /* ="text" name="op */ \
	0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6f,0x75,0x74,0x5f, /* rt" value="~out_ */ \
	0x70,0x6f,0x72,0x74,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* port~" class="ad */ \
	0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e,0x3c,0x2f,0x64, /* 1" size="5"/></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x49,0x6e,0x20,0x42,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c, /* >In Bound Port:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x69,0x70,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="iprt" value="~ */ \
	0x69,0x6e,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* in_port~" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e, /* "ad1" size="5"/> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f, /* bel>Room Name:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x52,0x6d,0x4e,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x52, /* "RmNm" value="~R */ \
	0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* oomName~" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x2f, /* "ad1" size="8" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69, /* abel>Node Callsi */ \
	0x67,0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* gn:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x4e,0x64,0x4e,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="NdNm" valu */ \
	0x65,0x3d,0x22,0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x63, /* e="~NodeName~" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d, /* lass="ad1" size= */ \
	0x22,0x38,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* "8" /></div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4a,0x69,0x74,0x74,0x65,0x72, /* iv><label>Jitter */ \
	0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x57,0x61,0x69,0x74,0x3a,0x3c,0x2f,0x6c, /*  Buffer Wait:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* abel>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x6a,0x69,0x74,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x4a,0x69, /* jitt" value="~Ji */ \
	0x74,0x74,0x65,0x72,0x53,0x69,0x7a,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d, /* tterSize~" size= */ \
	0x22,0x32,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f, /* "2" class="ad1"/ */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20, /* abel>NTP Server  */ \
	0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x26,0x6e,0x62, /* Name:</label>&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* sp;&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ;&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d, /* sp;..<select nam */ \
	0x65,0x3d,0x22,0x6e,0x74,0x70,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f, /* e="ntp">..<optio */ \
	0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* n value="pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e, /* p.org">pool.ntp. */ \
	0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* org..<option val */ \
	0x75,0x65,0x3d,0x22,0x65,0x75,0x72,0x6f,0x70,0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e  /* ue="europe.pool. */
#define DATACHUNK00000d \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x65,0x75,0x72,0x6f,0x70,0x65,0x2e, /* ntp.org">europe. */ \
	0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f, /* pool.ntp.org..<o */ \
	0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x61,0x73,0x69, /* ption value="asi */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e, /* a.pool.ntp.org"> */ \
	0x61,0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72, /* asia.pool.ntp.or */ \
	0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65, /* g..<option value */ \
	0x3d,0x22,0x6f,0x63,0x65,0x61,0x6e,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e, /* ="oceania.pool.n */ \
	0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x6f,0x63,0x65,0x61,0x6e,0x69,0x61,0x2e, /* tp.org">oceania. */ \
	0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f, /* pool.ntp.org..<o */ \
	0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x6e,0x6f,0x72, /* ption value="nor */ \
	0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e, /* th-america.pool. */ \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x6e,0x6f,0x72,0x74,0x68,0x2d,0x61, /* ntp.org">north-a */ \
	0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e, /* merica.pool.ntp. */ \
	0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* org..<option val */ \
	0x75,0x65,0x3d,0x22,0x73,0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63, /* ue="south-americ */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e, /* a.pool.ntp.org"> */ \
	0x73,0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f, /* south-america.po */ \
	0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74, /* ol.ntp.org..<opt */ \
	0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x61,0x66,0x72,0x69,0x63, /* ion value="afric */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e, /* a.pool.ntp.org"> */ \
	0x61,0x66,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e, /* africa.pool.ntp. */ \
	0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a, /* org..</select>.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x54,0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x3a,0x3c,0x2f, /* bel>Time Zone:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x7a,0x6f,0x6e,0x65,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x54, /* "zone" value="~T */ \
	0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* imeZone~" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x2f,0x3e, /* "ad1" size="3"/> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f,0x75,0x72,0x73,0x26,0x6e,0x62,0x73,0x70, /* &nbsp;hours&nbsp */ \
	0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* ;..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x7a,0x6e,0x65,0x4d, /* text" name="zneM */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f, /* " value="~TimeZo */ \
	0x6e,0x65,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73, /* neMinutes~" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x22, /* s="ad3" size="2" */ \
	0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x69,0x6e,0x75,0x74,0x65,0x73,0x3c, /* />&nbsp;minutes< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x52,0x46,0x20,0x52,0x65,0x70,0x65,0x74,0x65,0x72,0x20,0x43,0x6f, /* el>RF Repeter Co */ \
	0x6e,0x6e,0x65,0x63,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* nnect:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* ckbox" class="ad */ \
	0x31,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x65,0x70,0x74,0x22,0x20,0x76, /* 1" name="rept" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x20,0x7e,0x72,0x65,0x70,0x65,0x61, /* alue="1"  ~repea */ \
	0x74,0x65,0x72,0x5f,0x6f,0x6e,0x7e,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ter_on~ /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x63, /* ..<div><label>Ac */ \
	0x63,0x65,0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c, /* cess Control Fil */ \
	0x65,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* e Name:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x63,0x74,0x6c,0x22,0x20, /* xt" name="actl"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x41,0x63,0x63,0x43,0x74,0x72,0x6c,0x7e, /* value="~AccCtrl~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64, /* >&nbsp;&nbsp;</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* iv>..<div>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61, /* x" class="sm" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x68,0x63,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dhcp" value= */ \
	0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e, /* "1" onclick="con */ \
	0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x22,0x20,0x7e,0x63, /* figIPBoxes()" ~c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x68,0x63,0x70,0x63,0x68,0x65,0x63,0x6b,0x65, /* onfig_dhcpchecke */ \
	0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62,0x6c,0x65,0x20,0x44,0x48,0x43, /* d~ /> Enable DHC */ \
	0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* P</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x49,0x50,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a, /* abel>IP Address: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69, /* </label>..<td><i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22  /* nput type="text" */
#define DATACHUNK00000e \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /*  name="ip" value */ \
	0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x69,0x70,0x7e,0x22,0x20,0x2f, /* ="~config_ip~" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x47,0x61,0x74,0x65,0x77,0x61,0x79,0x3a,0x3c,0x2f,0x6c, /* abel>Gateway:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* abel>..<td><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x67,0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* me="gw" value="~ */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x67,0x77,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* config_gw~" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x53,0x75,0x62,0x6e,0x65,0x74,0x20,0x4d,0x61,0x73,0x6b,0x3a,0x3c,0x2f, /* l>Subnet Mask:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70, /* label>..<td><inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x73,0x75,0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ame="sub" value= */ \
	0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x73,0x75,0x62,0x6e,0x65,0x74,0x7e, /* "~config_subnet~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x72,0x69,0x6d,0x61,0x72,0x79,0x20, /* ><label>Primary  */ \
	0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* DNS:</label>..<t */ \
	0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* d><input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x31,0x22, /* ext" name="dns1" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f, /*  value="~config_ */ \
	0x64,0x6e,0x73,0x31,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* dns1~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x63, /* .<div><label>Sec */ \
	0x6f,0x6e,0x64,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* ondary DNS:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e, /* ="text" name="dn */ \
	0x73,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66, /* s2" value="~conf */ \
	0x69,0x67,0x5f,0x64,0x6e,0x73,0x32,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* ig_dns2~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* v>..<div><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c, /* type="submit" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* ass="sm" value=" */ \
	0x53,0x61,0x76,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x22,0x20,0x2f,0x3e,0x3c, /* Save Config" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* /div>..</fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* t>..</form>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c, /* iv>....<script l */ \
	0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72, /* anguage="javascr */ \
	0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e, /* ipt">..<!--..fun */ \
	0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f, /* ction configIPBo */ \
	0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20,0x3d,0x20,0x64,0x6f, /* xes() {...e = do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e, /* cument.forms.con */ \
	0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20,0x3d,0x20,0x65,0x2e,0x64,0x68, /* fig;...st = e.dh */ \
	0x63,0x70,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3b,0x0d,0x0a,0x09,0x65,0x2e, /* cp.checked;...e. */ \
	0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74, /* ip.disabled = st */ \
	0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x67,0x77,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ;...e.gw.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x73,0x75,0x62,0x2e, /* d = st;...e.sub. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x64,0x6e,0x73,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.dns1.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x32,0x2e, /*  = st;...e.dns2. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d, /* }..document.form */ \
	0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x6d,0x61,0x63,0x2e,0x64,0x69,0x73, /* s.config.mac.dis */ \
	0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x0d, /* abled = true;... */ \
	0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29, /* .configIPBoxes() */ \
	0x3b,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45, /* ;..document.getE */ \
	0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c, /* lementById('hell */ \
	0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20, /* o').innerHTML =  */ \
	0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f, /* "~hellomsg~";../ */ \
	0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d, /* /-->..</script>. */ \
	0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:footer.inc */ \
	0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xde,0x00,0x00,0x00,0x25,0x00,0x00, /* ~....3.......%.. */ \
	0x00,0x3e,0x01,0x00,0x00,0x4a,0x00,0x00,0x00,0xa2,0x01,0x00,0x00,0x4b,0x00,0x00, /* .>...J.......K.. */ \
	0x00,0x16,0x02,0x00,0x00,0x4c,0x00,0x00,0x00,0x85,0x02,0x00,0x00,0x4d,0x00,0x00, /* .....L.......M.. */ \
	0x00,0xfa,0x02,0x00,0x00,0x4e,0x00,0x00,0x00,0x74,0x03,0x00,0x00,0x6e,0x00,0x00, /* .....N...t...n.. */ \
	0x00,0x05,0x06,0x00,0x00,0x61,0x00,0x00,0x00,0x60,0x06,0x00,0x00,0x6d,0x00,0x00, /* .....a...`...m.. */ \
	0x00,0x01,0x07,0x00,0x00,0x87,0x00,0x00,0x00,0x6e,0x07,0x00,0x00,0x5f,0x00,0x00  /* .........n..._.. */
#define DATACHUNK00000f \
	0x00,0xf5,0x07,0x00,0x00,0x27,0x00,0x00,0x00,0x69,0x08,0x00,0x00,0x28,0x00,0x00, /* .....'...i...(.. */ \
	0x00,0xc6,0x08,0x00,0x00,0x29,0x00,0x00,0x00,0x28,0x09,0x00,0x00,0x2a,0x00,0x00, /* .....)...(...... */ \
	0x00,0x8f,0x09,0x00,0x00,0x2b,0x00,0x00,0x00,0xf2,0x09,0x00,0x00,0x2c,0x00,0x00, /* .....+.......,.. */ \
	0x00,0xc8,0x0b,0x00,0x00,0x01,0x00,0x00,0x00,0xe8,0x0b,0x00,0x00,0x02,0x00,0x00, /* ................ */ \
	0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:header.inc */ \
	0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74, /* ~..<div id="cont */ \
	0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4c,0x6f,0x67, /* ent">....<h1>Log */ \
	0x69,0x6e,0x20,0x53,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x3c,0x2f,0x68, /* in Successful</h */ \
	0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x20,0x68,0x61,0x76, /* 1>....<p>You hav */ \
	0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x6c, /* e successfully l */ \
	0x6f,0x67,0x67,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20, /* ogged in to the  */ \
	0x77,0x65,0x62,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2e,0x20,0x20,0x54,0x68,0x69, /* web server.  Thi */ \
	0x73,0x20,0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e, /* s authentication */ \
	0x20,0x0d,0x0a,0x69,0x73,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x75,0x6e,0x74,0x69, /*  ..is valid unti */ \
	0x6c,0x20,0x79,0x6f,0x75,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20,0x79,0x6f,0x75,0x72, /* l you close your */ \
	0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d, /*  browser.</p>... */ \
	0x0a,0x3c,0x70,0x3e,0x43,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20, /* .<p>Credentials  */ \
	0x61,0x72,0x65,0x20,0x76,0x65,0x72,0x69,0x66,0x69,0x65,0x64,0x20,0x69,0x6e,0x20, /* are verified in  */ \
	0x79,0x6f,0x75,0x72,0x20,0x6f,0x77,0x6e,0x20,0x63,0x75,0x73,0x74,0x6f,0x6d,0x20, /* your own custom  */ \
	0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f, /* callback functio */ \
	0x6e,0x20,0x63,0x61,0x6c,0x6c,0x65,0x64,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65, /* n called ..<code */ \
	0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74, /* >HTTPAuthenticat */ \
	0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x49,0x6e,0x20,0x68,0x65, /* e</code>.  In he */ \
	0x72,0x65,0x2c,0x20,0x79,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x64,0x65,0x74,0x65, /* re, you can dete */ \
	0x72,0x6d,0x69,0x6e,0x65,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70, /* rmine if the sup */ \
	0x70,0x6c,0x69,0x65,0x64,0x0d,0x0a,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65, /* plied..user name */ \
	0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x61,0x72, /*  and password ar */ \
	0x65,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x66,0x6f,0x72,0x20,0x61,0x63,0x63,0x65, /* e valid for acce */ \
	0x73,0x73,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73, /* ss to the reques */ \
	0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x20,0x63, /* ted page.  You c */ \
	0x61,0x6e,0x20,0x0d,0x0a,0x61,0x64,0x64,0x20,0x6d,0x75,0x6c,0x74,0x69,0x70,0x6c, /* an ..add multipl */ \
	0x65,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x73,0x74, /* e users and rest */ \
	0x72,0x69,0x63,0x74,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x75, /* rict different u */ \
	0x73,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e, /* sers to differen */ \
	0x74,0x20,0x70,0x61,0x67,0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a, /* t pages.</p>.... */ \
	0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69, /* <p class="exerci */ \
	0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a, /* se"><b>Exercise: */ \
	0x3c,0x2f,0x62,0x3e,0x20,0x43,0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65,0x20, /* </b> Change the  */ \
	0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61, /* user name and pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x69,0x6e,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65, /* ssword in..<code */ \
	0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74, /* >HTTPAuthenticat */ \
	0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x6f,0x6e,0x65,0x20, /* e</code> to one  */ \
	0x6f,0x66,0x20,0x79,0x6f,0x75,0x72,0x20,0x63,0x68,0x6f,0x6f,0x73,0x69,0x6e,0x67, /* of your choosing */ \
	0x2e,0x20,0x20,0x28,0x54,0x68,0x65,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b, /* .  (The callback */ \
	0x20,0x69,0x73,0x20,0x0d,0x0a,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e, /*  is ..located in */ \
	0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48,0x54,0x54, /*  <code>CustomHTT */ \
	0x50,0x41,0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x29,0x3c, /* PApp.c</code>.)< */ \
	0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73, /* /p>....<div clas */ \
	0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d, /* s="examplebox">. */ \
	0x0a,0x57,0x68,0x65,0x6e,0x20,0x79,0x6f,0x75,0x20,0x66,0x69,0x6e,0x69,0x73,0x68, /* .When you finish */ \
	0x2c,0x20,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x20,0x74,0x68,0x69,0x73,0x20,0x70, /* , refresh this p */ \
	0x61,0x67,0x65,0x20,0x74,0x6f,0x20,0x74,0x65,0x73,0x74,0x20,0x79,0x6f,0x75,0x72, /* age to test your */ \
	0x20,0x6e,0x65,0x77,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61, /*  new user name a */ \
	0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x0d,0x0a,0x63,0x6f, /* nd password ..co */ \
	0x6d,0x62,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69, /* mbination...</di */ \
	0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* v>....</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* <script type="te */ \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* xt/javascript">. */ \
	0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* .<!--..document. */ \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d, /* hello').innerHTM */ \
	0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22, /* L = "~hellomsg~" */ \
	0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* ;..//-->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74  /* pt>....~inc:foot */
#define DATACHUNK000010 \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x94, /* er.inc~....3.... */ \
	0x03,0x00,0x00,0x01,0x00,0x00,0x00,0xb6,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e, /* ...............~ */ \
	0x72,0x65,0x62,0x6f,0x6f,0x74,0x7e,0x00,0x00,0x00,0x00,0x2d,0x00,0x00,0x00,0x7e, /* reboot~....-...~ */ \
	0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d, /* inc:header.inc~. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e, /* .<div id="conten */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x52,0x65,0x62,0x6f,0x6f, /* t">....<h1>Reboo */ \
	0x74,0x20,0x49,0x6e,0x20,0x50,0x72,0x6f,0x67,0x72,0x65,0x73,0x73,0x2e,0x2e,0x2e, /* t In Progress... */ \
	0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x72, /* </h1>....<p>Your */ \
	0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x77,0x65,0x72,0x65,0x20,0x73, /*  settings were s */ \
	0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x73,0x61,0x76,0x65, /* uccessfully save */ \
	0x64,0x2c,0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64, /* d, and the board */ \
	0x20,0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x69,0x6e, /*  is now rebootin */ \
	0x67,0x20,0x0d,0x0a,0x74,0x6f,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x65, /* g ..to configure */ \
	0x20,0x69,0x74,0x73,0x65,0x6c,0x66,0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65, /*  itself with the */ \
	0x20,0x6e,0x65,0x77,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x2e,0x3c,0x2f, /*  new settings.</ */ \
	0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d,0x22, /* p>....<p align=" */ \
	0x63,0x65,0x6e,0x74,0x65,0x72,0x22,0x3e,0x3c,0x62,0x3e,0x59,0x6f,0x75,0x72,0x20, /* center"><b>Your  */ \
	0x62,0x6f,0x61,0x72,0x64,0x20,0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x6c,0x6f,0x63, /* board is now loc */ \
	0x61,0x74,0x65,0x64,0x20,0x61,0x74,0x3a,0x20,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72, /* ated at: ..<a hr */ \
	0x65,0x66,0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e,0x72,0x65,0x62,0x6f, /* ef="http://~rebo */ \
	0x6f,0x74,0x61,0x64,0x64,0x72,0x7e,0x2f,0x22,0x3e,0x68,0x74,0x74,0x70,0x3a,0x2f, /* otaddr~/">http:/ */ \
	0x2f,0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x61,0x64,0x64,0x72,0x7e,0x2f,0x3c,0x2f, /* /~rebootaddr~/</ */ \
	0x61,0x3e,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68, /* a></b></p>....<h */ \
	0x36,0x3e,0x3c,0x2f,0x68,0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* 6></h6>....</div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e, /* >....<script lan */ \
	0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70, /* guage="javascrip */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74, /* t">..<!--..funct */ \
	0x69,0x6f,0x6e,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x28, /* ion rebootDummy( */ \
	0x78,0x29,0x7b,0x7d,0x0d,0x0a,0x73,0x65,0x74,0x54,0x69,0x6d,0x65,0x6f,0x75,0x74, /* x){}..setTimeout */ \
	0x28,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64, /* ("newAJAXCommand */ \
	0x28,0x27,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f, /* ('/protect/reboo */ \
	0x74,0x2e,0x63,0x67,0x69,0x27,0x2c,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d, /* t.cgi',rebootDum */ \
	0x6d,0x79,0x2c,0x66,0x61,0x6c,0x73,0x65,0x29,0x3b,0x22,0x2c,0x35,0x30,0x30,0x29, /* my,false);",500) */ \
	0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* ;..//-->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* pt>..~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x0c,0x01,0x00, /* .inc~....3...... */ \
	0x00,0x2e,0x00,0x00,0x00,0x22,0x01,0x00,0x00,0x2e,0x00,0x00,0x00,0xf6,0x01,0x00, /* .....".......... */ \
	0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72, /* .....~inc:header */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* .inc~..<div id=" */ \
	0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31, /* content">....<h1 */ \
	0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x20,0x61,0x6e,0x64,0x20,0x50,0x61,0x73, /* >User ID and Pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x20,0x53,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x68, /* sword Setting</h */ \
	0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68, /* 1>....<form meth */ \
	0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e, /* od="post" action */ \
	0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e, /* ="/protect/user. */ \
	0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22, /* htm" name="user" */ \
	0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c, /* >..<fieldset>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x55,0x73,0x65,0x72,0x20, /* div><label>User  */ \
	0x49,0x44,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ID:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="user" valu */ \
	0x65,0x3d,0x22,0x7e,0x75,0x73,0x65,0x72,0x5f,0x69,0x64,0x7e,0x22,0x20,0x2f,0x3e, /* e="~user_id~" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c, /* bel>Password:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* abel>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61, /* pe="password" na */ \
	0x6d,0x65,0x3d,0x22,0x70,0x77,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* me="pwd" value=" */ \
	0x7e,0x75,0x73,0x65,0x72,0x5f,0x70,0x61,0x73,0x73,0x7e,0x22,0x20,0x2f,0x3e,0x3c, /* ~user_pass~" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61, /* el>Password:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d, /* e="password" nam */ \
	0x65,0x3d,0x22,0x70,0x77,0x64,0x43,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="pwdC" value=" */ \
	0x7e,0x75,0x73,0x65,0x72,0x5f,0x70,0x61,0x73,0x73,0x43,0x7e,0x22,0x20,0x2f,0x3e  /* ~user_passC~" /> */
#define DATACHUNK000011 \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e, /* </div>..<div><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e, /* put type="button */ \
	0x22,0x20,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x70,0x61,0x73,0x73, /* "  onClick="pass */ \
	0x77,0x6f,0x72,0x64,0x43,0x68,0x65,0x63,0x6b,0x28,0x29,0x22,0x20,0x63,0x6c,0x61, /* wordCheck()" cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ss="ad1b" value= */ \
	0x22,0x53,0x61,0x76,0x65,0x20,0x49,0x44,0x20,0x26,0x20,0x50,0x61,0x73,0x73,0x77, /* "Save ID & Passw */ \
	0x6f,0x72,0x64,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f, /* ord"/></div>..</ */ \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72, /* fieldset>..</for */ \
	0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73, /* m>..</div>....<s */ \
	0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* cript type="text */ \
	0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c, /* /javascript">..< */ \
	0x21,0x2d,0x2d,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x64,0x6f,0x63,0x75, /* !--..//-->..docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42, /* ment.getElementB */ \
	0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e, /* yId('hello').inn */ \
	0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f, /* erHTML = "~hello */ \
	0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e, /* msg~";..function */ \
	0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x43,0x68,0x65,0x63,0x6b,0x28,0x29, /*  passwordCheck() */ \
	0x0d,0x0a,0x7b,0x0d,0x0a,0x09,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65, /* ..{...if (docume */ \
	0x6e,0x74,0x2e,0x75,0x73,0x65,0x72,0x2e,0x70,0x77,0x64,0x2e,0x76,0x61,0x6c,0x75, /* nt.user.pwd.valu */ \
	0x65,0x20,0x21,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73, /* e != document.us */ \
	0x65,0x72,0x2e,0x70,0x77,0x64,0x43,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x0d,0x0a, /* er.pwdC.value).. */ \
	0x09,0x7b,0x0d,0x0a,0x09,0x09,0x61,0x6c,0x65,0x72,0x74,0x20,0x28,0x22,0x50,0x61, /* .{....alert ("Pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x6d,0x69,0x73,0x73,0x6d,0x61,0x74,0x63,0x68, /* ssword missmatch */ \
	0x21,0x22,0x29,0x3b,0x0d,0x0a,0x09,0x09,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d, /* !");....return;. */ \
	0x0a,0x09,0x7d,0x0d,0x0a,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75, /* ..}...document.u */ \
	0x73,0x65,0x72,0x2e,0x73,0x75,0x62,0x6d,0x69,0x74,0x28,0x29,0x3b,0x0d,0x0a,0x0d, /* ser.submit();... */ \
	0x0a,0x7d,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d, /* .}..</script>... */ \
	0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:footer.inc */ \
	0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xde,0x00,0x00,0x00,0x6a,0x00,0x00, /* ~....3.......j.. */ \
	0x00,0x3b,0x01,0x00,0x00,0x6b,0x00,0x00,0x00,0x9b,0x01,0x00,0x00,0x6c,0x00,0x00, /* .;...k.......l.. */ \
	0x00,0x95,0x02,0x00,0x00,0x01,0x00,0x00,0x00,0x5c,0x03,0x00,0x00,0x02,0x00,0x00, /* .........\...... */ \
	0x00                                                                             /* .                */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
	ROM BYTE MPFS_00000f[] = {DATACHUNK00000f};
	ROM BYTE MPFS_000010[] = {DATACHUNK000010};
	ROM BYTE MPFS_000011[] = {DATACHUNK000011};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e, DATACHUNK00000f, DATACHUNK000010, DATACHUNK000011};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
