package jp.oarts.pirka.core.ajax;

import java.util.HashMap;
import java.util.Set;

import jp.oarts.pirka.core.analyzer.html.HtmlTools;

/**
 * X|X}bv Ajaxs̃X|Xf[^ƂĎgp܂
 * 
 */
public class ResponseData {

	/** f[^ۑp}bv */
	private HashMap<String, String> map;

	/**
	 * RXgN^
	 */
	public ResponseData() {
		map = new HashMap<String, String>();
	}

	/**
	 * f[^i[܂B<BR>
	 * f[^̓ZLeB̂HTML̓ꕶi<>&j͈Sȕɕϊ܂B<BR>
	 * ܂AJavascript̃̕ZLeB̂"sR[h\"\rɕϊ܂B<BR>
	 *  put(keyName, value, true, true); ƓłB
	 * 
	 * @param keyName
	 *            f[^
	 * @param value
	 *            f[^l
	 */
	public void put(String keyName, String value) {
		put(keyName, value, true, true);
	}

	/**
	 * f[^i[܂B<BR>
	 * f[^l̓ZLeBSȕɕϊ܂2̃tOsafeHTMLAsafeStringɂ萧\łB<BR>
	 * etOfalseɂ邱Ƃ͈ӂ̂郆[U[ZLeBz[Ƃėp邩ꂸϊ댯łB<BR>
	 * etOfalseɂ鎞̓X|Xf[^Mɓ삷Javascript̓쌋ʂ̉elĂB<BR>
	 * 
	 * @param keyName
	 *            f[^
	 * @param value
	 *            f[^l
	 * @param safeHTML
	 *            true=HTML̓ꕶi<>&j͈Sȕɕϊ܂B
	 * @param safeString
	 *            true=Javascript̃̕ZLeB̂"sR[h\"\rɕϊ܂B
	 */
	public void put(String keyName, String value, boolean safeHTML, boolean safeString) {
		if (safeHTML) {
			value = HtmlTools.webString(value);
		}
		value = HtmlTools.javaScriptString(value);
		if (safeString) {
			value = HtmlTools.javaScriptString(value);
		}
		map.put(keyName, value);
	}

	/**
	 * f[^擾
	 * 
	 * @param keyName
	 *            f[^
	 * @return f[^l
	 */
	public String get(String keyName) {
		return map.get(keyName);
	}

	/**
	 * L[Zbg擾
	 * 
	 * @return L[Zbg
	 */
	public Set<String> keySet() {
		return map.keySet();
	}

}
