package jp.oarts.pirka.core.app;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.oarts.pirka.core.ajax.ResponseData;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaImage;
import jp.oarts.pirka.core.kernel.PirkaInfoPool;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.kernel.PirkaUploadManager;
import jp.oarts.pirka.core.res.PirkaFileDownloader;
import jp.oarts.pirka.core.res.PirkaFileDownloaderFromBytes;
import jp.oarts.pirka.core.res.PirkaImageDownloader;
import jp.oarts.pirka.core.res.PirkaRespons;
import jp.oarts.pirka.core.util.check.AutoCheckRuntimeException;
import jp.oarts.pirka.core.util.converter.StringConverter;
import jp.oarts.pirka.core.util.field.FieldItem;
import jp.oarts.pirka.core.win.FatalErrorDefaultWindow;
import jp.oarts.pirka.core.win.PirkaFatalErrorWindow;
import jp.oarts.pirka.core.win.PirkaWindow;
import jp.oarts.pirka.core.win.SessionTimeoutDefaultWindow;

/**
 * ServletGg[|Cg
 * 
 * @author ito
 * 
 */
public abstract class EntryPoint extends HttpServlet implements Serializable, EntryPointIF {

	// URL̓NGXgɊi[L[ //////////////////////////////////////////////////////////////

	/** sJ}[N uEU[߂郊NGXgiVKȊOjɂ͕K̕i[Ă */
	public static final String REQ_PIRKA_MARK = "__PIRKA__";

	/** NGXg */
	public static final String REQ_LINK = REQ_PIRKA_MARK + "LINK__";

	/** tH[GXg */
	public static final String REQ_FORM = REQ_PIRKA_MARK + "FORM__";

	/** C[WNGXg */
	public static final String REQ_IMAGE = REQ_PIRKA_MARK + "IMG__";

	/** AjaxNGXg */
	public static final String REQ_AJAX = REQ_PIRKA_MARK + "AJAX__";

	/** CX^Xԍ */
	public static final String REQ_INSTANCE = REQ_PIRKA_MARK + "INS__";

	/** VAԍ */
	public static final String REQ_SERIALNO = REQ_PIRKA_MARK + "SNO__";

	/** A^Oł̃Tu~bg */
	public static final String REQ_A_SUBMIT = REQ_PIRKA_MARK + "A_SUBMIT__";

	// ZbVɊi[L[ //////////////////////////////////////////////////////////////
	/** ZbṼsJ}[N */
	private static final String SESSION_PIRKA_MARK = "__PIRKA__";

	/** CX^Xi[p */
	private static final String SESSION_INSTANCE = SESSION_PIRKA_MARK + "INSTANCE__";

	/** őCX^Xԍ */
	// private static final String SESSION_MAX_INSTANCE_NO = SESSION_PIRKA_MARK + "MAX_INSTANCE_NO__";
	/** ZbVԍi[p */
	private static final String SESSION_SERIALNO = SESSION_PIRKA_MARK + "SERIAL_NO__";

	/** G[tO */
	private static final String SESSION_ERROR_FLAG = SESSION_PIRKA_MARK + "ERROR_FLAG__";

	// ̑ //////////////////////////////////////////////////////////////////////////////////////

	/**
	 * T[ubg̃T[rX󂯎p̃\hłB t[[Ngp܂Biʏ͎gp܂j
	 */
	@Deprecated
	public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		serviceMain(req, res);
	}

	/**
	 * T[ubg̃T[rX󂯎p̃\hłB t[[Ngp܂Biʏ͎gp܂j
	 */
	@Deprecated
	public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		serviceMain(req, res);
	}

	/**
	 * T[ubg̃T[rX󂯎p̃\hłB t[[Ngp܂Biʏ͎gp܂j
	 */
	@Deprecated
	public void serviceMain(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {

		try {
			// ZV`FbN
			boolean newSessionFlag = false;
			HttpSession session = req.getSession(false);
			if (session == null) {
				newSessionFlag = true;
				session = req.getSession(true);
			}

			PirkaThreadMap.setEntryPointObject(this);
			PirkaThreadMap.setServletPartam(req, res, session);

			PirkaRespons pirkaRespons = null;

			try {

				// ł̓sȂ키lɕύX 2009/05/31
				synchronized (session) {

					// NGXg}bv
					Map<String, String[]> reqMap = new HashMap<String, String[]>();

					// Abv[ht@CXg
					List<Long> uploadFileList = new ArrayList<Long>();

					// NGXg
					ReqParser.parser(req, reqMap, uploadFileList);

					try {
						if (reqMap.containsKey(REQ_AJAX)) {// AjaxvH
							pirkaRespons = serviceMainAjaxProc(newSessionFlag, session, req, res, reqMap, uploadFileList);
						} else if (reqMap.containsKey(REQ_IMAGE)) {// C[WvH
							pirkaRespons = serviceMainImageProc(newSessionFlag, session, req, res, reqMap, uploadFileList);
						} else {
							inputDataConvert(reqMap);
							if (isOldServletMode()) {
								pirkaRespons = serviceMainOldServletProc(newSessionFlag, session, req, res, reqMap, uploadFileList);
							} else {
								pirkaRespons = serviceMainProc(newSessionFlag, session, req, res, reqMap, uploadFileList);
							}
						}

					} finally {
						// uploadFile delete
						PirkaUploadManager.deleteFile(uploadFileList);
					}

				}
				// if (pirkaRespons == null) {
				// throw new RuntimeException("X|X݂܂");
				// }

			} catch (Throwable e) {
				// e.printStackTrace();
				pirkaRespons = getFatalErrorWindow();// tF[^G[
				if (pirkaRespons instanceof PirkaFatalErrorWindow) {
					((PirkaFatalErrorWindow) pirkaRespons).setError(e);
				}
				setErrorFlag(PirkaThreadMap.getSession(), true);
			}

			// X|XԂ
			if (pirkaRespons != null) {
				pirkaRespons.remakeHeader(res);
				OutputStream out = null;
				try {
					out = res.getOutputStream();
					if (pirkaRespons != null) {
						pirkaRespons.writeRespons(out);
						out.flush();
					}
				} finally {
					if (out != null) {
						out.close();
					}
				}
			}
		} finally {
			PirkaThreadMap.removeEntryPointObject();
			PirkaThreadMap.removeServletParam();
		}

	}

	private void inputDataConvert(Map<String, String[]> reqMap) {
		StringConverter converter = getInputStringConverter();
		for (String key : reqMap.keySet()) {
			String[] values = reqMap.get(key);
			if (values != null) {
				for (int i = 0; i < values.length; i++) {
					values[i] = converter.convert(values[i]);
				}
			}
		}
	}

	/**
	 * Ajax<BR>
	 * t[[Ngp܂Biʏ͎gp܂j
	 * 
	 * @param newSessionFlag
	 *            VKɃZbV쐬ꂽƂtrue
	 * @param session
	 *            ZbV
	 * @param req
	 *            NGXg
	 * @param res
	 *            X|X
	 * @param reqMap
	 *            NGXg}bv
	 * @param uploadFileList
	 *            Abv[ht@CXg
	 * @return X|XIuWFNg
	 * @throws ServletException
	 * @throws IOException
	 */
	@Deprecated
	protected PirkaRespons serviceMainAjaxProc(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap, List<Long> uploadFileList)
			throws ServletException, IOException {

		HashMap<String, String[]> params = new HashMap<String, String[]>();
		for (String key : reqMap.keySet()) {
			String[] values = reqMap.get(key);
			if (values == null) {
				params.put(decodeUnicodeEscp(key), new String[0]);
			} else {
				for (int i = 0; i < values.length; i++) {
					values[i] = decodeUnicodeEscp(values[i]);
				}
				params.put(decodeUnicodeEscp(key), values);
			}
		}
		inputDataConvert(params);

		PirkaRespons respons = new PirkaFileDownloaderFromBytes("", new byte[0]); // ftHg͋

		if (session != null) {
			// C[WACX^Xԍ擾
			String ajaxName = getSingleReqParam(params, REQ_AJAX);
			String instanceNo = getSingleReqParam(params, REQ_INSTANCE);

			if (ajaxName != null && instanceNo != null) {
				// ZVyуNGXgVAԍ擾
				String sessionSerialNo = getSerialNoFromSession(session, instanceNo);
				String reqSerialNo = getSingleReqParam(reqMap, REQ_SERIALNO);

				// VAԍ`FbN
				if (sessionSerialNo != null && reqSerialNo != null && reqSerialNo.equals(sessionSerialNo)) {
					// OʃIuWFNg̎擾
					PirkaWindow window = getWindowObjectFromSession(session, instanceNo);
					if (window != null) {
						// `FbNiVAԍNXoA͑OʂƓ̃`FbNj
						String className = getClassNameFromSerialNo(reqSerialNo);
						if (className != null && className.equals(window.getClass().getName())) {

							FieldItem fieldItem = window.getRootFieldItem(ajaxName);
							if (fieldItem != null && fieldItem.getCtrl() != null && fieldItem.getCtrl().getAjaxScript() != null) {
								boolean firstFlag = true;
								ResponseData resMap = fieldItem.getCtrl().getAjaxScript().run(params);
								StringBuilder sb = new StringBuilder();
								sb.append("{\n");
								if (resMap != null) {
									for (String key : resMap.keySet()) {
										String value = resMap.get(key);
										if (value == null) {
											value = "";
										}
										if (!firstFlag) {
											sb.append(",\n");
										} else {
											firstFlag = false;
										}
										sb.append('\"');
										sb.append(key);
										sb.append("\": \"");
										sb.append(getOutputStringConverter().convert(value));
										sb.append('\"');
									}
								}
								sb.append("\n}\n");
								byte[] buffer = sb.toString().getBytes("UTF-8");
								if (buffer != null) {
									respons = new PirkaFileDownloaderFromBytes("", "text/plain", buffer);
								}
							}
						}
					}
				}
			}
		}
		return respons;
	}

	private String decodeUnicodeEscp(String str) {

		StringBuilder sb = new StringBuilder();
		int i = 0;
		while (i < str.length()) {
			char c = str.charAt(i);
			if (c != '\\') {
				sb.append(c);
				i++;
			} else {
				if (i <= (str.length() - 6) && str.charAt(i + 1) == 'u') {
					char hex = '.';
					String hexStr = str.substring(i + 2, i + 6);
					try {
						hex = (char) Integer.parseInt(hexStr, 16);
						sb.append(hex);
						i += 6;
					} catch (NumberFormatException e) {
						sb.append(c);
						i++;
					}
				} else {
					sb.append(c);
					i++;
				}
			}

		}
		return sb.toString();

	}

	/**
	 * C[W<BR>
	 * t[[Ngp܂Biʏ͎gp܂j
	 * 
	 * @param newSessionFlag
	 *            VKɃZbV쐬ꂽƂtrue
	 * @param session
	 *            ZbV
	 * @param req
	 *            NGXg
	 * @param res
	 *            X|X
	 * @param reqMap
	 *            NGXg}bv
	 * @param uploadFileList
	 *            Abv[ht@CXg
	 * @return X|XIuWFNg
	 * @throws ServletException
	 * @throws IOException
	 */
	@Deprecated
	protected PirkaRespons serviceMainImageProc(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap, List<Long> uploadFileList)
			throws ServletException, IOException {

		PirkaRespons respons = new PirkaFileDownloaderFromBytes("", new byte[0]); // ftHg͋

		if (session != null) {
			// C[WACX^Xԍ擾
			String imageName = getSingleReqParam(reqMap, REQ_IMAGE);
			String instanceNo = getSingleReqParam(reqMap, REQ_INSTANCE);

			if (imageName != null && instanceNo != null) {
				// ZVyуNGXgVAԍ擾
				String sessionSerialNo = getSerialNoFromSession(session, instanceNo);
				String reqSerialNo = getSingleReqParam(reqMap, REQ_SERIALNO);

				// VAԍ`FbN
				if (sessionSerialNo != null && reqSerialNo != null && reqSerialNo.equals(sessionSerialNo)) {
					// OʃIuWFNg̎擾
					PirkaWindow window = getWindowObjectFromSession(session, instanceNo);
					if (window != null) {
						// `FbNiVAԍNXoA͑OʂƓ̃`FbNj
						String className = getClassNameFromSerialNo(reqSerialNo);
						if (className != null && className.equals(window.getClass().getName())) {

							FieldItem fieldItem = window.getRootFieldItem(imageName);
							if (fieldItem != null && fieldItem.getCtrl() != null && fieldItem.getCtrl().getImage() != null) {

								PirkaImage image = fieldItem.getCtrl().getImage();
								byte[] buffer = image.getImage();
								if (buffer != null) {
									respons = new PirkaImageDownloader(image.getMimeType(), buffer);
								}
							}
						}
					}
				}
			}
		}
		return respons;
	}

	/**
	 * ʏ탊NGXg<BR>
	 * t[[Ngp܂Biʏ͎gp܂j
	 * 
	 * @param newSessionFlag
	 *            VKɃZbV쐬ꂽƂtrue
	 * @param session
	 *            ZbV
	 * @param req
	 *            NGXg
	 * @param res
	 *            X|X
	 * @param reqMap
	 *            NGXg}bv
	 * @param uploadFileList
	 *            Abv[ht@CXg
	 * @return X|XIuWFNg
	 * @throws ServletException
	 * @throws IOException
	 */
	@Deprecated
	protected PirkaRespons serviceMainProc(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap, List<Long> uploadFileList)
			throws ServletException, IOException {

		// ̃\bh̏œ߁Ał͍̓sȂȂlɕύX 2009/05/31
		//synchronized (session) {	
			return serviceMainProcAsync(newSessionFlag, session, req, res, reqMap, uploadFileList);
		//}
	}

	/**
	 * ʏ탊NGXg(ZVœ̈̒)<BR>
	 * t[[Ngp܂Biʏ͎gp܂j
	 * 
	 * @param newSessionFlag
	 *            VKɃZbV쐬ꂽƂtrue
	 * @param session
	 *            ZbV
	 * @param req
	 *            NGXg
	 * @param res
	 *            X|X
	 * @param reqMap
	 *            NGXg}bv
	 * @param uploadFileList
	 *            Abv[ht@CXg
	 * @return X|XIuWFNg
	 * @throws ServletException
	 * @throws IOException
	 */
	@Deprecated
	protected PirkaRespons serviceMainProcAsync(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap, List<Long> uploadFileList)
			throws ServletException, IOException {

		PirkaRespons nextWindow = null;
		String instanceNo = "";
		boolean actionMethodNoCallFlag = false;

		do {

			// ʊmF
			boolean initWindowFlag = false;
			// ZbV`FbNo
			if (newSessionFlag) {
				if (isErrorFlag(session)) {
					initWindowFlag = true;
				} else {
					if (reqMap.containsKey(REQ_PIRKA_MARK)) {
						nextWindow = getSessionTimeoutWindow();// ZbV^CI[o[
						setErrorFlag(session, true);
						break;
					} else {
						initWindowFlag = true;
					}
				}
			} else {
				if (isErrorFlag(session)) {
					initWindowFlag = true;
				} else {
					if (!reqMap.containsKey(REQ_PIRKA_MARK)) {
						initWindowFlag = true;
					}
				}
			}

			// CX^Xԍ擾
			instanceNo = getSingleReqParam(reqMap, REQ_INSTANCE);
			if (initWindowFlag) { // sJ}[N邩H͐VKANZXƂ
				if (instanceNo == null || instanceNo.length() <= 0) {
					// ʂgpƂ̓ZbVxč쐬(ZbVnCWbNh~)
					if (isClearSessionAtInitScreen()) {
						session.invalidate();
						session = req.getSession(true);
					}
					PirkaThreadMap.setServletPartam(req, res, session);

					instanceNo = "";
					setErrorFlag(session, false);
					nextWindow = getInitWindow(reqMap);
					break;
				} else {
					nextWindow = getSubWindow(reqMap);
					break;
				}
			}

			// ZVyуNGXgVAԍ擾
			String sessionSerialNo = getSerialNoFromSession(session, instanceNo);
			String reqSerialNo = getSingleReqParam(reqMap, REQ_SERIALNO);

			// VAԍ`FbN
			if (sessionSerialNo == null || reqSerialNo == null) {
				nextWindow = getSessionTimeoutWindow(); // ZbV^CI[o[
				setErrorFlag(session, true);
				break;
				// VAԍ`FbN
			} else if (!reqSerialNo.equals(sessionSerialNo)) {
				// OʃIuWFNg̎擾
				nextWindow = getWindowObjectFromSession(session, instanceNo);
				if (nextWindow == null) {
					throw new RuntimeException("ZVɑÕEBhENX܂ ");
				}
				return nextWindow;
			} else {
				// OʃIuWFNg̎擾
				nextWindow = getWindowObjectFromSession(session, instanceNo);
				if (nextWindow == null) {
					throw new RuntimeException("ZVɑÕEBhENX܂ ");
				}

				// `FbNiVAԍNXoA͑OʂƓ̃`FbNj
				String className = getClassNameFromSerialNo(reqSerialNo);
				if (className == null || !className.equals(nextWindow.getClass().getName())) {
					throw new RuntimeException("ZbṼEBhEƃNGXgEBhEႢ܂ CX^Xԍ=" + instanceNo);
				}
			}

			clearErrorFlag(((PirkaWindow) nextWindow).getRootFieldMap()); // G[
			((PirkaWindow) nextWindow).getErrorMessageStocker().clear();

			String actionName = getActionName((PirkaWindow) nextWindow, reqMap); // ANV擾
			FieldItem actionFieldItem = null;
			if (actionName != null) {
				actionFieldItem = ((PirkaWindow) nextWindow).getRootFieldItem(actionName);
			}
			if (actionFieldItem != null) {
				setActionLoopIndex((PirkaWindow) nextWindow, actionName, actionFieldItem.getLoopDeepLevel());
			} else {
				((PirkaWindow) nextWindow).setActionLoopIndex(new int[0]);
			}

			String mark = getSingleReqParam(reqMap, REQ_PIRKA_MARK);

			PirkaWindow oldWindow = (PirkaWindow) nextWindow;

			if (REQ_FORM.equals(mark)) { // FORM^OsubmitiA^Oł͂ȂjH

				// f[^otB[h}bvɃZbg
				getReqValue(((PirkaWindow) nextWindow).getFieldMap(), reqMap);

				// vsȂ
				nextWindow = callAction((PirkaWindow) nextWindow, PRE_ACTION_METHOD_NAME);

				if (actionFieldItem != null && actionFieldItem.getCtrl().isAutoCheck()) {
					// `FbN
					try {
						((PirkaWindow) nextWindow).check();
					} catch (AutoCheckRuntimeException e) {
						actionMethodNoCallFlag = true;
					}
				}
			} else {
				// vsȂ
				nextWindow = callAction((PirkaWindow) nextWindow, PRE_ACTION_METHOD_NAME);
			}

			// ANVĂяo
			if (!actionMethodNoCallFlag && nextWindow == oldWindow) {
				try {
					if (actionFieldItem != null) {
						nextWindow = callEventAction((PirkaWindow) nextWindow, actionName);
					} else {
						// elseĂяo
						nextWindow = callAction((PirkaWindow) nextWindow, ELSE_ACTION_METHOD_NAME);
					}
				} catch (AutoCheckRuntimeException e) {
					// `FbNŃG[EȂɂȂ
				}
			}

			// t@C_E[h
			if (nextWindow == null) {
				// Ỏ
				PirkaWindow returnWindow = oldWindow.getReturnWindow();
				if (returnWindow != null) {
					nextWindow = returnWindow;
				} else {
					nextWindow = oldWindow;
				}
			} else if (nextWindow instanceof PirkaFileDownloader) {
				// t@C_E[h
				// Ȃ
			} else {
				if (nextWindow != oldWindow) { // IuWFNgm̔riʂςȂj
					// JڃNɓNX邩H
					boolean hitFlag = false;
					Class nextWindowClass = nextWindow.getClass();
					PirkaWindow tempWindow = (PirkaWindow) oldWindow;
					while (true) {
						Class tempWindowClass = tempWindow.getClass();
						if (tempWindowClass == nextWindowClass) {// NXIuWFNgm̔r
							((PirkaWindow) nextWindow).setReturnWindow(tempWindow.getReturnWindow());
							hitFlag = true;
							break;
						}
						tempWindow = tempWindow.getReturnWindow();
						if (tempWindow == null) {
							break;
						}
					}
					if (!hitFlag) {
						((PirkaWindow) nextWindow).setReturnWindow(oldWindow); // ߂Zbg
					}
				}
			}

		} while (false);

		if (nextWindow instanceof PirkaWindow) {
			// `OsȂ
			callAction((PirkaWindow) nextWindow, PRE_DRAW_METHOD_NAME);
			changeLabelErrorFlag(((PirkaWindow) nextWindow).getFieldMap()); // x̃G[tO

			((PirkaWindow) nextWindow).fixField();

			// VAԍ쐬ݒiʁAZbVj
			String newSerialNo = createSerialNo((PirkaWindow) nextWindow);
			setSerialNoToSession(session, instanceNo, newSerialNo);

			WindowBaseData windowBaseData = new WindowBaseData();
			windowBaseData.setSerialNo(newSerialNo);
			windowBaseData.setInstanceNo(instanceNo);
			((PirkaWindow) nextWindow).setWindowBaseData(windowBaseData);

			// CX^Xɂ̉ʂ̃IuWFNgi[
			setWindowObjectToSession(session, instanceNo, (PirkaWindow) nextWindow);
		}
		// Object wait = new Object();
		// synchronized (wait) {
		// try {
		// wait.wait(5000);
		// } catch (InterruptedException e) {
		// }
		// }
		return nextWindow;
	}

	/**
	 * ʏ탊NGXg(T[ubg[h)<BR>
	 * t[[Ngp܂Biʏ͎gp܂j
	 * 
	 * @param newSessionFlag
	 *            VKɃZbV쐬ꂽƂtrue
	 * @param session
	 *            ZbV
	 * @param req
	 *            NGXg
	 * @param res
	 *            X|X
	 * @param reqMap
	 *            NGXg}bv
	 * @param uploadFileList
	 *            Abv[ht@CXg
	 * @return X|XIuWFNg
	 * @throws ServletException
	 * @throws IOException
	 */
	@Deprecated
	protected PirkaRespons serviceMainOldServletProc(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap,
			List<Long> uploadFileList) throws ServletException, IOException {

		PirkaRespons nextWindow = null;
		String instanceNo = "";
		boolean actionMethodNoCallFlag = false;

		do {

			// ʊmF
			// boolean initWindowFlag = false;
			// // ZbV`FbNo
			// if (newSessionFlag) {
			// initWindowFlag = true;
			// }

			// ʊmF
			boolean initWindowFlag = false;
			// ZbV`FbNo
			if (newSessionFlag) {
				initWindowFlag = true;
			} else {
				if (isErrorFlag(session)) {
					initWindowFlag = true;
				} else {
					if (!reqMap.containsKey(REQ_PIRKA_MARK)) {
						initWindowFlag = true;
					}
				}
			}

			// if (initWindowFlag) { // sJ}[N邩H͐VKANZXƂ
			// // ʂgpƂ̓ZbVxč쐬(ZbVnCWbNh~)
			// session.invalidate();
			// session = req.getSession(true);
			// PirkaThreadMap.setServletPartam(req, res, session);
			//
			// // instanceNo = "1";
			// instanceNo = "";
			// // session.setAttribute(SESSION_MAX_INSTANCE_NO, 1);
			// nextWindow = getInitWindow(reqMap);
			// sendRedirect(req, res, (PirkaWindow) nextWindow, instanceNo);
			// return null;
			// // break;
			// }
			//
			// // CX^Xԍ擾
			// instanceNo = getSingleReqParam(reqMap, REQ_INSTANCE);
			// if (instanceNo == null) {
			// // CX^Xԍ΃TuʂƂ݂Ȃ
			// // Integer newInstanceNo = (Integer) session.getAttribute(SESSION_MAX_INSTANCE_NO);
			// // if (newInstanceNo == null || !(newInstanceNo instanceof Integer)) {
			// // throw new RuntimeException("ZbV̍őCX^Xԍ̎擾Ɏs܂");
			// // }
			// // newInstanceNo++;
			// // session.setAttribute(SESSION_MAX_INSTANCE_NO, newInstanceNo);
			// // instanceNo = newInstanceNo.toString();
			// nextWindow = getSubWindow(reqMap);
			// break;
			// }

			// CX^Xԍ擾
			instanceNo = getSingleReqParam(reqMap, REQ_INSTANCE);
			if (initWindowFlag) { // sJ}[N邩H͐VKANZXƂ
				if (instanceNo == null || instanceNo.length() <= 0) {
					// ʂgpƂ̓ZbVxč쐬(ZbVnCWbNh~)
					if (isClearSessionAtInitScreen()) {
						session.invalidate();
						session = req.getSession(true);
					}
					PirkaThreadMap.setServletPartam(req, res, session);

					instanceNo = "";
					setErrorFlag(session, false);
					nextWindow = getInitWindow(reqMap);
					break;
				} else {
					nextWindow = getSubWindow(reqMap);
					break;
				}
			}

			// NGXgVAԍ擾
			String sessionSerialNo = getSerialNoFromSession(session, instanceNo);
			String reqSerialNo = getSingleReqParam(reqMap, REQ_SERIALNO);

			if (reqSerialNo == null) {
				nextWindow = getSessionTimeoutWindow(); // ZbV^CI[o[
				setErrorFlag(session, true);
				// sendRedirect(req, res, session, (PirkaWindow) nextWindow);
				break;
			}

			if (sessionSerialNo != null && sessionSerialNo.equals(reqSerialNo)) {
				// OʃIuWFNg̎擾
				nextWindow = getWindowObjectFromSession(session, instanceNo);
				if (nextWindow == null) {
					throw new RuntimeException("ZVɑÕEBhENX܂ CX^Xԍ=" + instanceNo);
				}

				// `FbNiVAԍNXoA͑OʂƓ̃`FbNj
				String className = getClassNameFromSerialNo(reqSerialNo);
				if (className == null || !className.equals(nextWindow.getClass().getName())) {
					throw new RuntimeException("ZbṼEBhEƃNGXgEBhEႢ܂ CX^Xԍ=" + instanceNo);
				}
			} else {
				String className = getClassNameFromSerialNo(reqSerialNo);
				nextWindow = cleateWindowObject(className);
				if (nextWindow == null) {
					throw new RuntimeException("EBhENX܂ " + className);
				}
				break;
			}

			clearErrorFlag(((PirkaWindow) nextWindow).getRootFieldMap()); // G[
			((PirkaWindow) nextWindow).getErrorMessageStocker().clear();

			String actionName = getActionName((PirkaWindow) nextWindow, reqMap); // ANV擾
			FieldItem actionFieldItem = null;
			if (actionName != null) {
				actionFieldItem = ((PirkaWindow) nextWindow).getRootFieldItem(actionName);
			}
			if (actionFieldItem != null) {
				setActionLoopIndex((PirkaWindow) nextWindow, actionName, actionFieldItem.getLoopDeepLevel());
			} else {
				((PirkaWindow) nextWindow).setActionLoopIndex(new int[0]);
			}

			String mark = getSingleReqParam(reqMap, REQ_PIRKA_MARK);

			PirkaWindow oldWindow = (PirkaWindow) nextWindow;

			if (REQ_FORM.equals(mark)) { // FORM^OsubmitiA^Oł͂ȂjH

				// f[^otB[h}bvɃZbg
				getReqValue(((PirkaWindow) nextWindow).getFieldMap(), reqMap);

				// vsȂ
				nextWindow = callAction((PirkaWindow) nextWindow, PRE_ACTION_METHOD_NAME);

				if (actionFieldItem != null && actionFieldItem.getCtrl().isAutoCheck()) {
					// `FbN
					try {
						((PirkaWindow) nextWindow).check();
					} catch (AutoCheckRuntimeException e) {
						actionMethodNoCallFlag = true;
					}
				}
			} else {
				// vsȂ
				nextWindow = callAction((PirkaWindow) nextWindow, PRE_ACTION_METHOD_NAME);
			}

			// ANVĂяo
			if (!actionMethodNoCallFlag && nextWindow == oldWindow) {
				try {
					if (actionFieldItem != null) {
						nextWindow = callEventAction((PirkaWindow) nextWindow, actionName);
					} else {
						// elseĂяo
						nextWindow = callAction((PirkaWindow) nextWindow, ELSE_ACTION_METHOD_NAME);
					}
				} catch (AutoCheckRuntimeException e) {
					// System.out.println("error!!");
				}
			}

			// t@C_E[h
			if (nextWindow == oldWindow) {
				// ȂɂȂ
			} else if (nextWindow == null) {
				nextWindow = oldWindow;
			} else if (nextWindow instanceof PirkaFileDownloader) {
				// t@C_E[h
				// Ȃ
			} else {
				// VAԍ쐬ݒiʁj
				sendRedirect(req, res, (PirkaWindow) nextWindow, instanceNo);
				return null;
			}

		} while (false);

		if (nextWindow instanceof PirkaWindow) {
			// `OsȂ
			callAction((PirkaWindow) nextWindow, PRE_DRAW_METHOD_NAME);
			changeLabelErrorFlag(((PirkaWindow) nextWindow).getFieldMap()); // x̃G[tO

			((PirkaWindow) nextWindow).fixField();

			// VAԍ쐬ݒiʁAZbVj
			String newSerialNo = createSerialNo((PirkaWindow) nextWindow);
			setSerialNoToSession(session, instanceNo, newSerialNo);

			WindowBaseData windowBaseData = new WindowBaseData();
			windowBaseData.setSerialNo(newSerialNo);
			windowBaseData.setInstanceNo(instanceNo);
			((PirkaWindow) nextWindow).setWindowBaseData(windowBaseData);

			// CX^Xɂ̉ʂ̃IuWFNgi[
			setWindowObjectToSession(session, instanceNo, (PirkaWindow) nextWindow);
		}

		return nextWindow;
	}

	private boolean isErrorFlag(HttpSession session) {
		Boolean ret = (Boolean) session.getAttribute(SESSION_ERROR_FLAG);
		if (ret == null) {
			return false;
		}
		return ret;
	}

	private void setErrorFlag(HttpSession session, boolean errorFlag) {
		session.setAttribute(SESSION_ERROR_FLAG, errorFlag);
	}

	private void sendRedirect(HttpServletRequest req, HttpServletResponse res, PirkaWindow nextWindow, String instanceNo) throws IOException {
		String newSerialNo = createSerialNo(nextWindow);

		StringBuilder sb = new StringBuilder();
		sb.append(req.getRequestURL());
		sb.append('?');
		sb.append(EntryPoint.REQ_PIRKA_MARK);
		sb.append('=');
		sb.append('&');
		sb.append(EntryPoint.REQ_INSTANCE);
		sb.append('=');
		sb.append(instanceNo);
		sb.append('&');
		sb.append(EntryPoint.REQ_SERIALNO);
		sb.append('=');
		sb.append(newSerialNo);

		// System.out.println(sb.toString());
		res.sendRedirect(sb.toString());

	}

	/**
	 * SẴtB[h̃G[<BR>
	 * t[[Ngp܂Biʏ͎gp܂j
	 * 
	 * @param rootFieldMap
	 *            [gtB[h}bv
	 */
	private void clearErrorFlag(Map<String, FieldItem> rootFieldMap) {
		for (String fieldName : rootFieldMap.keySet()) {
			rootFieldMap.get(fieldName).setErrorFlag(false);
		}
	}

	/**
	 * EChEփANV[vCfbNXݒ肷
	 * 
	 * @param window
	 *            EChE
	 * @param actionName
	 *            ANV
	 * @param loopDeepLevel
	 *            [vKwx
	 */
	private void setActionLoopIndex(PirkaWindow window, String actionName, int loopDeepLevel) {
		int[] index = null;
		if (loopDeepLevel == 0) {
			index = new int[0];
		} else {
			String[] deeps = actionName.split("\\$");
			index = new int[loopDeepLevel];

			for (int i = 0; i < index.length; i++) {
				int ix = i + 1;
				if (ix <= deeps.length) {
					try {
						index[i] = Integer.parseInt(deeps[ix]);
					} catch (NumberFormatException e) {
						// Ȃ
					}
				} else {
					index[i] = 0;
				}
			}
		}
		window.setActionLoopIndex(index);
	}

	/**
	 * ANV\bh̎擾
	 * 
	 * @param window
	 *            EBhE
	 * @param reqMap
	 *            NGXg}bv
	 * @return ANV\bh(TbtBbNXt)
	 */
	private String getActionName(PirkaWindow window, Map<String, String[]> reqMap) {

		for (String name : reqMap.keySet()) {
			int index = name.indexOf('.');
			if (index >= 0) {
				name = name.substring(0, index);
			}

			FieldItem fieldItem = window.getRootFieldItem(name);
			if (fieldItem != null) {
				HtmlCtrlParts ctrlParts = fieldItem.getCtrl();

				if (ctrlParts != null) {
					CtrlProcesser ctrlProcesser = ctrlParts.getCtrlProcesser();
					if (ctrlProcesser != null && ctrlProcesser.isActionCtrl()) {
						return name;
					}
				}
			}
		}

		// Ver1.02
		String[] aSubmitName = reqMap.get(REQ_A_SUBMIT);
		if (aSubmitName != null && aSubmitName.length >= 1 && aSubmitName[0] != null && aSubmitName[0].length() > 0) {
			return aSubmitName[0];
		}

		return null;
	}

	/**
	 * ANV\bȟĂяo
	 * 
	 * @param window
	 *            EBhE
	 * @param name
	 *            ANVtB[h
	 * @return ɃuEU֑M郌X|XIuWFNg
	 */
	private PirkaRespons callEventAction(PirkaWindow window, String name) {

		FieldItem fieldItem = window.getRootFieldItem(name);
		if (fieldItem != null) {
			HtmlCtrlParts ctrlParts = fieldItem.getCtrl();

			if (ctrlParts != null) {
				CtrlProcesser ctrlProcesser = ctrlParts.getCtrlProcesser();
				if (ctrlProcesser != null && ctrlProcesser.isActionCtrl()) {
					Method method = PirkaInfoPool.getMethod(window, ctrlParts.getBaseName());
					if (method == null) {
						return window;
					}
					try {
						if (method.getReturnType() == null || method.getReturnType() == void.class) {
							method.invoke(window);
							return window;
						}
						return (PirkaRespons) method.invoke(window);
					} catch (IllegalArgumentException e) {
						throw new RuntimeException("ANV\bȟĂяoɎs܂ " + name, e);
					} catch (IllegalAccessException e) {
						throw new RuntimeException("ANV\bȟĂяoɎs܂ " + name, e);
					} catch (InvocationTargetException e) {
						if (e.getCause() instanceof AutoCheckRuntimeException) {
							throw (AutoCheckRuntimeException) e.getCause();
						} else {
							throw new RuntimeException("ANV\bȟĂяoɎs܂ " + name, e);
						}
					}
				}
			}
		}
		return window;
	}

	/**
	 * ̑̃ANV\bȟĂяo
	 * 
	 * @param window
	 *            EBhE
	 * @param name
	 *            ANVtB[h
	 * @return ɃuEU֑M郌X|XIuWFNg
	 */
	private PirkaRespons callAction(PirkaWindow window, String name) {

		Method method = PirkaInfoPool.getMethod(window, name);
		if (method == null) {
			return window;
		}
		try {
			if (method.getReturnType() == null || method.getReturnType() == void.class) {
				method.invoke(window);
				return window;
			}
			return (PirkaRespons) method.invoke(window);
		} catch (IllegalArgumentException e) {
			throw new RuntimeException("ANV\bȟĂяoɎs܂ " + name, e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException("ANV\bȟĂяoɎs܂ " + name, e);
		} catch (InvocationTargetException e) {
			if (e.getCause() instanceof AutoCheckRuntimeException) {
				throw (AutoCheckRuntimeException) e.getCause();
			} else {
				throw new RuntimeException("ANV\bȟĂяoɎs܂ " + name, e);
			}
		}
	}

	/**
	 * NGXgɊi[Ăf[^tB[h}bv֊i[
	 * 
	 * @param fieldMap
	 *            tB[h}bv
	 * @param reqMap
	 *            NGXgf[^i[Ă}bv
	 */
	private void getReqValue(FieldMap fieldMap, Map<String, String[]> reqMap) {
		getReqValueMain(fieldMap, reqMap, "");
	}

	/**
	 * NGXgɊi[Ăf[^tB[h}bv֊i[̎又
	 * 
	 * @param fieldMap
	 *            tB[h}bv
	 * @param reqMap
	 *            NGXgf[^i[Ă}bv
	 * @param suffix
	 *            [vTtBNX
	 */
	private void getReqValueMain(FieldMap fieldMap, Map<String, String[]> reqMap, String suffix) {
		String[] fieldNames = fieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
			if (fieldItem.getCtrl().getCtrlProcesser().isInputCtrl()) {

				String reqFieldName = null;
				if (fieldItem.getCtrl().getCtrlProcesser().isGroupItem()) {
					reqFieldName = fieldItem.getCtrl().getBaseName() + changeSuffix(suffix, fieldItem.getCtrl().getGroupLevel());
				} else {
					reqFieldName = fieldItem.getCtrl().getBaseName() + suffix + fieldItem.getCtrl().getSuffixName();
				}

				// String value = getSingleReqParam(reqMap, reqFieldName);
				String[] values = reqMap.get(reqFieldName);
				fieldItem.getCtrl().getCtrlProcesser().setReq(reqMap, reqFieldName, fieldItem, values);

			} else if (fieldItem.getCtrl().getCtrlProcesser().isLoop()) {
				Object loop = fieldItem.getValue();
				if (loop != null && loop instanceof List) {
					List<FieldMap> list = (List<FieldMap>) loop;
					for (int index = 0; index < list.size(); index++) {
						getReqValueMain(list.get(index), reqMap, suffix + '$' + index);
					}
				}
			}
		}
	}

	/**
	 * O[vxɂTtBbNXύX
	 * 
	 * @param suffix
	 *            TtBbNX
	 * @param groupLevel
	 *            O[vx
	 * @return ύXꂽTtbNX
	 */
	private String changeSuffix(String suffix, int groupLevel) {
		if (groupLevel <= 0) {
			return suffix;
		}
		int index = suffix.length();
		for (int i = 0; i < groupLevel; i++) {
			index = suffix.lastIndexOf('$', index - 1);
			if (index <= 0) {
				return "";
			}
		}
		return suffix.substring(0, index);

	}

	/**
	 * ZbVCX^XԍŎw肳ꂽEChEIuWFNg擾
	 * 
	 * @param session
	 *            ZbV
	 * @param InstanceNo
	 *            CX^Xԍ
	 * @return EChEIuWFNg
	 */
	private PirkaWindow getWindowObjectFromSession(HttpSession session, String InstanceNo) {
		return (PirkaWindow) session.getAttribute(SESSION_INSTANCE + InstanceNo);
	}

	/**
	 * ZbV֎w肳ꂽCX^XԍŃEChEIuWFNgi[
	 * 
	 * @param session
	 *            ZbV
	 * @param InstanceNo
	 *            CX^Xԍ
	 * @param windowObject
	 *            EBhEIuWFNg
	 */
	private void setWindowObjectToSession(HttpSession session, String InstanceNo, PirkaWindow windowObject) {
		session.setAttribute(SESSION_INSTANCE + InstanceNo, windowObject);
	}

	/**
	 * 1̃L[ɑ΂ĕ镶f[^̂ŏ̈iCfbNX0Ԗځj擾
	 * 
	 * @param map
	 *            }bv
	 * @param key
	 *            L[
	 * @return l
	 */
	private String getSingleReqParam(Map<String, String[]> map, String key) {
		String[] strings = map.get(key);
		if (strings == null || strings.length <= 0) {
			return null;
		}
		return strings[0];

	}

	/**
	 * VAԍ쐬
	 * 
	 * @param windowObject
	 *            EChEIuWFNg
	 * @return VAԍ
	 */
	private String createSerialNo(PirkaWindow windowObject) {
		return Tools.encodePsw((windowObject.getClass().getName() + "$" + System.currentTimeMillis()));
	}

	/**
	 * VAԍNX擾
	 * 
	 * @param serialNo
	 *            VAԍ
	 * @return NX
	 */
	private String getClassNameFromSerialNo(String serialNo) {
		if (serialNo == null) {
			return null;
		}

		String decodeSerialNo = Tools.decodePsw(serialNo);
		int index = decodeSerialNo.indexOf('$');
		if (index <= 0) {
			return null;
		}

		return decodeSerialNo.substring(0, index);
	}

	/**
	 * ZbVɃCX^Xԍ̃VAԍi[
	 * 
	 * @param session
	 *            ZbV
	 * @param instanceNo
	 *            CX^Xԍ
	 * @param serialNo
	 *            VAԍ
	 */
	private void setSerialNoToSession(HttpSession session, String instanceNo, String serialNo) {
		Map<String, String> instanceMap = (Map<String, String>) session.getAttribute(SESSION_SERIALNO);
		if (instanceMap == null) {
			instanceMap = new HashMap<String, String>();
			session.setAttribute(SESSION_SERIALNO, instanceMap);
		}
		instanceMap.put(instanceNo, serialNo);
	}

	/**
	 * ZbVVAԍ擾
	 * 
	 * @param session
	 *            ZbV
	 * @param instanceNo
	 *            CX^Xԍ
	 * @return VAԍ
	 */
	private String getSerialNoFromSession(HttpSession session, String instanceNo) {
		Map<String, String> instanceMap = (Map<String, String>) session.getAttribute(SESSION_SERIALNO);
		if (instanceMap == null) {
			return null;
		}
		return instanceMap.get(instanceNo);
	}

	/**
	 * ^ꂽNX̂̃EBtHEIuWFNg쐬
	 * 
	 * @param className
	 *            NX
	 * @return EChEIuWFNg
	 */
	private PirkaWindow cleateWindowObject(String className) {
		PirkaWindow windowObject = null;
		try {
			Class classObject = Class.forName(className);
			Object newObject = classObject.newInstance();
			if (newObject instanceof PirkaWindow) {
				windowObject = (PirkaWindow) newObject;
			}
		} catch (Exception e) {
			// Ȃ
		}
		return windowObject;
	}

	/**
	 * x̃G[tOXV
	 * 
	 * @param fieldMap
	 *            tB[h}bv
	 */
	private void changeLabelErrorFlag(FieldMap fieldMap) {
		changeLabelErrorFlagMain(fieldMap, fieldMap, "");
	}

	/**
	 * x̃G[tOXVC
	 * 
	 * @param baseFieldMap
	 *            x[X̃tB[h}bv
	 * @param fieldMap
	 *            tB[h}bv
	 * @param suffix
	 *            TbtBNX
	 */
	private void changeLabelErrorFlagMain(FieldMap baseFieldMap, FieldMap fieldMap, String suffix) {

		String[] fieldNames = fieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
			String forId = fieldItem.getCtrl().getOptionMap().get("for");
			if (forId != null) {
				if (fieldItem.getCtrl().isSuffix()) {
					forId = forId + suffix;
				}
				boolean errorFlag = isErrorId(baseFieldMap, forId);
				fieldItem.setErrorFlag(errorFlag);
			}
			if (fieldItem.getCtrl().getCtrlProcesser().isLoop() && fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
				List<FieldMap> list = (List<FieldMap>) fieldItem.getValue();
				int index = 0;
				for (FieldMap childMap : list) {
					changeLabelErrorFlagMain(baseFieldMap, childMap, suffix + '$' + index);
					index++;
				}

			}
		}

	}

	/**
	 * G[IDmF
	 * 
	 * @param baseFieldMap
	 *            x[XtB[h}bv
	 * @param id
	 *            ID
	 * @return true=G[
	 */
	private boolean isErrorId(FieldMap baseFieldMap, String id) {

		return isErrorIdMain(baseFieldMap, id, "");

	}

	/**
	 * G[IDmFC
	 * 
	 * @param baseFieldMap
	 *            x[XtB[h}bv
	 * @param id
	 *            ID
	 * @param suffix
	 *            TtBbNX
	 * @return true=G[
	 */
	private boolean isErrorIdMain(FieldMap baseFieldMap, String id, String suffix) {

		String[] fieldNames = baseFieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			FieldItem fieldItem = baseFieldMap.getFieldItem(fieldName);
			String targetId = fieldItem.getCtrl().getOptionMap().get("id");
			if (targetId != null) {
				if (fieldItem.getCtrl().isSuffix()) {
					targetId = targetId + suffix;
				}
				if (id.equals(targetId)) {
					if (fieldItem.isErrorFlag()) {
						return true;
					}
				}
			}
			if (fieldItem.getCtrl().getCtrlProcesser().isLoop() && fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
				List<FieldMap> list = (List<FieldMap>) fieldItem.getValue();
				int index = 0;
				for (FieldMap childMap : list) {
					if (isErrorIdMain(childMap, id, suffix + '$' + index)) {
						return true;
					}
					index++;
				}

			}
		}
		return false;
	}

	/**
	 * ZbVɔCӂ̃IuWFNgo^܂B<BR>
	 * 炩̗RɂT[ubgReiɃZbV݂ȂƂiZbV^CAEgj͓o^܂B
	 * 
	 * @param keyName
	 *            ۑIuWFNg擾ƂɎgp閼O
	 * @param object
	 *            ۑIuWFNg
	 */
	public void putSession(String keyName, Object object) {
		HttpSession session = PirkaThreadMap.getSession();
		if (session != null) {
			session.putValue(keyName, object);
		}
	}

	/**
	 * ZVwꂽIuWFNg擾܂B<BR>
	 * T[ubgŝݎ擾\łB<BR>
	 * sȊOnull߂܂B
	 * 
	 * @param keyName
	 *            IuWFNgʂ閼O
	 * @return IuWFNg
	 */
	public Object getSession(String keyName) {
		HttpSession session = PirkaThreadMap.getSession();
		if (session == null) {
			return null;
		}
		return session.getAttribute(keyName);
	}

	// łΎgpȂق\bh ///////////////////////////////////////////////////////////////////////////////

	/**
	 * T[ubgNGXg擾܂B<BR>
	 * T[ubgŝݎ擾\łB<BR>
	 * sȊOnull߂܂B
	 * 
	 * @return T[ubgNGXg
	 */
	protected HttpServletRequest getHttpServletRequest() {
		return PirkaThreadMap.getServletReq();
	}

	/**
	 * T[ubgX|X擾܂B <BR>
	 * T[ubgŝݎ擾\łB<BR>
	 * sȊOnull߂܂B
	 * 
	 * @return T[ubgX|X
	 */
	protected HttpServletResponse getHttpServletResponse() {
		return PirkaThreadMap.getServletRes();
	}

	/**
	 * URL̕ʖ擾܂B <BR>
	 * ̕ʖURL2ڈȍ~̉ʕ\̃uEU[URL\ɎgpB <BR>
	 * ftHg͌ĂяoꂽURL
	 * 
	 * @return ʖURL
	 */
	public String getUrlAlias() {
		HttpServletRequest req = getHttpServletRequest();
		if (req != null) {
			return req.getRequestURI();
		}
		return this.getClass().getName();
	}

	// ̓I[o[ChKvȃ\bh /////////////////////////////////////////////////////////

	/**
	 * ʂ擾܂B<BR>
	 * 
	 * @param reqMap
	 *            p[^}bv
	 */
	protected abstract PirkaWindow getInitWindow(Map<String, String[]> reqMap);

	/**
	 * Tuʂ擾܂B
	 * 
	 * @param reqMap
	 *            p[^}bv
	 */
	protected PirkaWindow getSubWindow(Map<String, String[]> reqMap) {
		return null;
	}

	/**
	 * ZbV^CAEgʂ擾܂B
	 * 
	 * @return ftHg̃ZbV^CAEg
	 */
	protected PirkaWindow getSessionTimeoutWindow() {
		return new SessionTimeoutDefaultWindow();
	}

	/**
	 * tF[^G[ʂ擾܂B
	 * 
	 * @return ftHg̃tF[^G[
	 */
	protected PirkaWindow getFatalErrorWindow() {
		return new FatalErrorDefaultWindow();
	}

	/**
	 * T[ubg[hmF܂B<BR>
	 * ̒l͏펞lƂrŕύXĂ͂܂B
	 * 
	 * @return true=T[ubg[h
	 */
	public boolean isOldServletMode() {
		return false;
	}

	/**
	 * Gg[|Cg̓Ǝ̃Rg[vZbT[}bv߂܂B<BR>
	 * ̒l͏펞lƂrŕύXĂ͂܂B
	 * 
	 * @return Ǝ̃Rg[vZbT[}bviƎ̃Rg[[vZbT[nullj
	 */
	public Map<String, CtrlProcesser> getCtrlProcesserMap() {
		return null;
	}

	/**
	 * PirkaMessageCvgEnumNXԂ܂B<BR>
	 * nullԂƃG[bZ[WƂStringp邱Ƃł܂B<BR>
	 * PirkaMessageCvgEnumNXԂƃG[bZ[WƂĂEnumNX̂ݎgp\ƂȂA<BR>
	 * String̃G[bZ[W̓^CG[ƂȂ܂B<BR>
	 * 
	 * @return PirkaMessageCvgEnumNX
	 */
	public Class getPirkaMessageEnumClass() {
		return null;
	}

	/**
	 * \[XHTMLt@C̃LN^[Zbg擾܂B<BR>
	 * ftHgMS932Ԃ܂B<BR>
	 * ̃LN^ZbggpƂ͂̃\bhI[o[Ch<BR>
	 * ̃LN^Zbg߂ĂB
	 * 
	 * @return LN^[Zbg
	 */
	public String getResourceHtmlFileCharset() {
		return "MS932";
	}

	/**
	 * uEU[ɑMHTMLC[W̃LN^[Zbg擾܂B<BR>
	 * ftHgMS932Ԃ܂B<BR>
	 * ̃LN^ZbggpƂ͂̃\bhI[o[Ch<BR>
	 * ̃LN^Zbg߂ĂB
	 * 
	 * @return LN^[Zbg
	 */
	public String getHtmlStringCharset() {
		return "MS932";
	}

	/**
	 * uEU[ɑM郌X|Xwb_̃LN^Zbg擾܂B<BR>
	 * ftHgShift-jisԂ܂B ̃LN^ZbggpƂ͂̃\bhI[o[Ch<BR>
	 * ̃LN^Zbg߂ĂB
	 * 
	 * @return LN^[Zbg
	 */
	public String getResponsHeaderCharset() {
		return "Shift-jis";
	}

	/**
	 * uEU[͕Ro[^[擾<BR>
	 * uEU[œ͂ꂽɑSʋʂȕϊKvȎɃI[o[Ch<BR>
	 * Ǝ̕Ro[^[߂ĂB<BR>
	 * ftHgł͖ϊłB
	 * 
	 * @return Ro[^
	 */
	public StringConverter getInputStringConverter() {
		return DefaultStringConverter.getInstance();
	}

	/**
	 * uEU[o͕Ro[^[擾<BR>
	 * uEU[֏o͂镶ɑSʋʂȕϊKvȎɃI[o[Ch<BR>
	 * Ǝ̕Ro[^[߂ĂB<BR>
	 * ftHgł͖ϊłB
	 * 
	 * @return Ro[^
	 */
	public StringConverter getOutputStringConverter() {
		return DefaultStringConverter.getInstance();
	}

	/**
	 * ʕ\̂Ƃ̓ZbVNA邩̊mF<br>
	 * ʕ\ɃZVpƂ͂̃\bhI[o[Ch false߂ĂB<br>
	 * ftHgture߂܂B
	 * 
	 * @return true=NAAfalse=NAȂ
	 */
	public boolean isClearSessionAtInitScreen() {
		return true;
	}

}
