package jp.oarts.pirka.core.app;

import java.util.Map;

import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.util.converter.StringConverter;

public interface EntryPointIF {

	/** HTML`i쐬j̑OɌĂяo郁\bh */
	public static final String PRE_DRAW_METHOD_NAME = "preDraw";

	/** SẴANV\bhĂ΂OɌĂяo郁\bh */
	public static final String PRE_ACTION_METHOD_NAME = "onPre";

	/** `SUBMITsꂽ̃ANV\bh */
	public static final String ELSE_ACTION_METHOD_NAME = "onElse";

	/**
	 * Gg[|Cg̓Ǝ̃Rg[vZbT[}bv߂܂B<BR>
	 * ̒l͏펞lƂrŕύXĂ͂܂B
	 * 
	 * @return Ǝ̃Rg[vZbT[}bv
	 */
	public Map<String, CtrlProcesser> getCtrlProcesserMap();

	/**
	 * URL̕ʖ擾܂B <BR>
	 * ̕ʖURL2ڈȍ~̉ʕ\̃uEU[URL\Ɏgp܂B <BR>
	 * ftHg̓pbP[W{NX ̒l͏펞lƂrŕύXĂ͂܂B
	 * 
	 * @return ʖURL
	 */
	public String getUrlAlias();

	/**
	 * PirkaMessageCvgEnumNXԂ܂B<BR>
	 * nullԂƃG[bZ[WƂStringp邱Ƃł܂B<BR>
	 * PirkaMessageCvgEnumNXԂƃG[bZ[WƂĂEnumNX̂ݎgp\ƂȂA<BR>
	 * String̃G[bZ[W̓^CG[ƂȂ܂B<BR>
	 * 
	 * @return PirkaMessageCvgEnumNX
	 */
	public Class getPirkaMessageEnumClass();

	/**
	 * T[ubg[hmF܂B<BR>
	 * ̒l͏펞lƂrŕύXĂ͂܂B
	 * 
	 * @return true=T[ubg[h
	 */
	public boolean isOldServletMode();

	/**
	 * ZVɕۑ
	 * 
	 * @param keyName
	 *            L[
	 * @param object
	 *            ۑIWFNg
	 */
	public void putSession(String keyName, Object object);

	/**
	 * ZV擾
	 * 
	 * @param keyName
	 *            L[
	 * @return ۑĂIWFNg
	 */
	public Object getSession(String keyName);

	/**
	 * \[XHTMLt@C̃LN^[Zbg擾܂B<BR>
	 * 
	 * @return LN^[Zbg
	 */
	public String getResourceHtmlFileCharset();

	/**
	 * uEU[ɑMHTMLC[W̃LN^[Zbg擾܂B
	 * 
	 * @return LN^[Zbg
	 */
	public String getHtmlStringCharset();

	/**
	 * uEU[ɑM郌X|Xwb_̃LN^Zbg擾܂B
	 * 
	 * @return LN^[Zbg
	 */
	public String getResponsHeaderCharset();

	/**
	 * uEU[͕Ro[^[擾<BR>
	 * uEU[œ͂ꂽɑSʋʂȕϊKvȎɃI[o[Ch<BR>
	 * Ǝ̕Ro[^[߂ĂB<BR>
	 * ftHgł͖ϊłB
	 * 
	 * @return Ro[^
	 */
	public StringConverter getInputStringConverter();

	/**
	 * uEU[o͕Ro[^[擾<BR>
	 * uEU[֏o͂镶ɑSʋʂȕϊKvȎɃI[o[Ch<BR>
	 * Ǝ̕Ro[^[߂ĂB<BR>
	 * ftHgł͖ϊłB
	 * 
	 * @return Ro[^
	 */
	public StringConverter getOutputStringConverter();

	/**
	 * ʕ\̂Ƃ̓ZbVNA邩̊mF
	 * 
	 * @return true=NAAfalse=NAȂ
	 */
	public boolean isClearSessionAtInitScreen();
}
