package jp.oarts.pirka.core.app;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * AvP[c[
 * 
 * @author ito
 * 
 */
class Tools implements Serializable {

	/** VAԍp̈Í1 */
	private static final String pswBase1 = "0123456789.abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";

	/** VAԍp̈Í2 */
	private static final String pswBase2 = "iMEtuv45zA3OPmnCjcdFGHI9.aJKLpqrsQDTUB2V78bXwYZ_01oNRS6efghxyWkl";

	/** GR[h}bv */
	private static final HashMap<Character, Character> pswMapEmc = new HashMap<Character, Character>();

	/** fR[h}bv */
	private static final HashMap<Character, Character> pswMapDec = new HashMap<Character, Character>();

	static {
		// }bv쐬
		for (int index = 0; index < pswBase1.length(); index++) {
			Character c = pswBase1.charAt(index);
			pswMapEmc.put(c, pswBase2.charAt(index));
			pswMapDec.put(pswBase2.charAt(index), c);
		}
	}

	/**
	 * GR[h
	 * 
	 * @param str
	 *            GR[h镶
	 * @return GR[hꂽ
	 */
	public static String encodePsw(String str) {
		return convert(str, pswMapEmc);
	}

	/**
	 * fR[h
	 * 
	 * @param str
	 *            fR[h镶
	 * @return fR[hꂽ
	 */
	public static String decodePsw(String str) {
		return convert(str, pswMapDec);
	}

	/**
	 * ϊ
	 * 
	 * @param str
	 *            ϊ镶
	 * @return ϊꂽ
	 */
	public static String convert(String str, Map<Character, Character> convertMap) {
		StringBuilder sb = new StringBuilder();
		for (char c : str.toCharArray()) {
			Character cc = convertMap.get(c);
			if (cc == null) {
				sb.append(c);
			} else {
				sb.append(cc);
			}
		}
		return sb.toString();
	}
}
