package jp.oarts.pirka.core.util.format;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

import jp.oarts.pirka.core.util.check.PirkaChecker;

public class PirkaFormatUtil  implements Serializable{

	/**
	 * intIntegerIuWFNgɕϊB<BR>
	 * 
	 * @param value
	 *            i+-.,\$%@#ō\j
	 * @return IntegerIuWFNg IntegerƂĉ߂łȂnull
	 */
	public static Integer parseInteger(String value) {

		if (value == null) {
			return null;
		}

		value = value.trim();
		if (!PirkaChecker.checkString(value, "+-0123456789,\\$%@#")) {
			return null;
		}
		value = cutNonNumChar(value);
		if (value == null || value.length() <= 0) {
			return null;
		}

		try {
			return Integer.parseInt(value);
		} catch (NumberFormatException e) {
			return null;
		}
	}

	/**
	 * longLongIuWFNgɕϊB<BR>
	 * 
	 * @param value
	 *            i+-.,\$%@#ō\j
	 * @return IntegerIuWFNg LongƂĉ߂łȂnull
	 */
	public static Long parseLong(String value) {

		if (value == null) {
			return null;
		}
		value = value.trim();
		if (!PirkaChecker.checkString(value, "+-0123456789,\\$%@#")) {
			return null;
		}
		value = cutNonNumChar(value);
		if (value == null || value.length() <= 0) {
			return null;
		}

		try {
			return Long.parseLong(value);
		} catch (NumberFormatException e) {
			return null;
		}
	}

	/**
	 * lBigDecimalIuWFNgɕϊB<BR>
	 * 
	 * @param value
	 *            i+-.,\$%@#ō\j
	 * @return BigDecimalIuWFNg BigDecimalƂĉ߂łȂnull
	 */
	public static BigDecimal parseBigDecimal(String value) {

		if (value == null) {
			return null;
		}
		value = value.trim();
		if (!PirkaChecker.checkString(value, "+-0123456789.,\\$%@#")) {
			return null;
		}
		value = cutNonNumChar(value);
		if (value == null || value.length() <= 0) {
			return null;
		}

		try {
			return new BigDecimal(value);
		} catch (NumberFormatException e) {
			return null;
		}
	}

	/**
	 * l\ȊO̕폜߂
	 * 
	 * @param string
	 *            
	 * @return l\ȊO̕폜
	 */
	private static String cutNonNumChar(String string) {
		StringBuilder sb = new StringBuilder();
		for (char c : string.toCharArray()) {
			if ("+-1234567890.".indexOf(c) >= 0) {
				sb.append(c);
			}
		}
		return sb.toString();
	}

	/**
	 * tjava.sql.TimestampIuWFNgɕϊB<BR>
	 * ȉformatL<BR>
	 * &nbsp;&nbsp;wN bx́wNx NparseDate\bhŗLȏAbparseTime\bhŗLȏ
	 * 
	 * @param value
	 *            
	 * @return tIuWFNg 񂪓tƂĉ߂łȂnull
	 */
	public static Timestamp parseTimestamp(String value) {

		if (value == null) {
			return null;
		}
		value = value.trim();
		if (value == null || value.length() <= 0) {
			return null;
		}

		String[] item = value.split(" ");
		if (item.length == 1) {
			Date date = parseDate(item[0]);
			if (date == null) {
				return null;
			}
			return new Timestamp(date.getTime());
		} else if (item.length == 2) {
			Date date = parseDate(item[0]);
			Time time = parseTime(item[1]);
			if (date == null || time == null) {
				return null;
			}
			Calendar calDate = Calendar.getInstance();
			Calendar calTime = Calendar.getInstance();
			Calendar cal = Calendar.getInstance();
			calDate.setTime(date);
			calTime.setTime(time);
			cal.clear();
			cal.set(calDate.get(Calendar.YEAR), calDate.get(Calendar.MONTH), calDate.get(Calendar.DAY_OF_MONTH), calTime.get(Calendar.HOUR_OF_DAY), calTime.get(Calendar.MINUTE), calTime
					.get(Calendar.SECOND));
			return new Timestamp(cal.getTimeInMillis());
		}

		return null;

	}

	/**
	 * java.sql.TimeIuWFNgɕϊB<BR>
	 * ȉformatL<BR>
	 * &nbsp;&nbsp;235959A2359A23A23:59:59A23:1:6A23:05A23:5A235959bA235959A2359A2359A23 &nbsp;&nbsp;L͈͂00:00:00`23:59:59
	 * 
	 * @param value
	 *            
	 * @return tIuWFNg 񂪓tƂĉ߂łȂnull
	 */
	public static Time parseTime(String value) {
		final String[] splitChars = { "\\:", "\\." };

		if (value == null) {
			return null;
		}

		value = value.trim();
		if (value == null || value.length() <= 0) {
			return null;
		}

		String hh = null;
		String mm = null;
		String ss = null;
		boolean splitFlag = false;

		if (PirkaChecker.isNumber(value)) {
			if (value.length() == 6) { // 6̐
				hh = value.substring(0, 2);
				mm = value.substring(2, 4);
				ss = value.substring(4, 6);
				splitFlag = true;
			} else if (value.length() == 4) { // 4̐
				hh = value.substring(0, 2);
				mm = value.substring(2, 4);
				ss = "0";
				splitFlag = true;
			} else if (value.length() <= 2) { // 2ȉ̐
				hh = value;
				mm = "0";
				ss = "0";
				splitFlag = true;
			}

		}
		if (!splitFlag) {
			// pLŋ؂Ă
			for (String splitChar : splitChars) {
				String[] item = value.split(splitChar);
				if (item.length == 3) {
					if (item[0].length() > 0 && item[0].length() <= 2 && item[1].length() > 0 && item[1].length() <= 2 && item[2].length() > 0 && item[2].length() <= 2) {
						hh = item[0];
						mm = item[1];
						ss = item[2];
						splitFlag = true;
						break;
					}
				} else if (item.length == 2) {
					if (item[0].length() > 0 && item[0].length() <= 2 && item[1].length() > 0 && item[1].length() <= 2) {
						hh = item[0];
						mm = item[1];
						ss = "0";
						splitFlag = true;
						break;
					}

				}
			}
		}

		if (!splitFlag) {
			int hhIndex = value.indexOf("");
			int mmIndex = value.indexOf("");
			int ssIndex = value.indexOf("b");
			if (hhIndex >= 0 && mmIndex >= 0) {
				if (ssIndex >= 0) {
					if (hhIndex < mmIndex && mmIndex < ssIndex) {
						hh = value.substring(0, hhIndex);
						mm = value.substring(hhIndex + 1, mmIndex);
						ss = value.substring(mmIndex + 1, ssIndex);
						splitFlag = true;
					}
				} else {
					if (hhIndex < mmIndex) {
						if (value.length() > (mmIndex + 1)) {
							hh = value.substring(0, hhIndex);
							mm = value.substring(hhIndex + 1, mmIndex);
							ss = value.substring(mmIndex + 1);
							splitFlag = true;
						} else {
							hh = value.substring(0, hhIndex);
							mm = value.substring(hhIndex + 1, mmIndex);
							ss = "0";
							splitFlag = true;
						}
					}

				}
			} else if (hhIndex >= 0) {
				if (value.length() > (hhIndex + 1)) {
					hh = value.substring(0, hhIndex);
					mm = value.substring(hhIndex + 1);
					ss = "0";
					splitFlag = true;
				} else {
					hh = value.substring(0, hhIndex);
					mm = "0";
					ss = "0";
					splitFlag = true;
				}
			}
		}

		if (!splitFlag) {
			return null;
		}

		if (hh.length() <= 0 || mm.length() <= 0 || ss.length() <= 0 || !PirkaChecker.isNumber(hh) || !PirkaChecker.isNumber(mm) || !PirkaChecker.isNumber(ss)) {
			return null;
		}

		try {
			Calendar cal = Calendar.getInstance();
			cal.clear();
			cal.setLenient(false); // 
			cal.set(1970, 1, 1, Integer.parseInt(hh), Integer.parseInt(mm), Integer.parseInt(ss));
			return new Time(cal.getTimeInMillis());

		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * tjava.sql.DateIuWFNgɕϊB<BR>
	 * ȉformatL<BR>
	 * &nbsp;&nbsp;20060506A2006/5/6A2006/05/06A2006.5.6A2006.05.06A2006-5-6A2006-05-06A2006N56A2006N0506A2006N56A2006N0506
	 * 
	 * @param value
	 *            
	 * @return tIuWFNg 񂪓tƂĉ߂łȂnull
	 */
	public static Date parseDate(String value) {

		if (value == null) {
			return null;
		}

		value = value.trim();
		final String[] splitChars = { "/", "\\.", "-" };
		if (value == null || value.length() <= 0) {
			return null;
		}

		String yyyy = null;
		String mm = null;
		String dd = null;
		boolean splitFlag = false;

		if (value.length() == 8 && PirkaChecker.isNumber(value)) { // 8̐
			yyyy = value.substring(0, 4);
			mm = value.substring(4, 6);
			dd = value.substring(6, 8);
			splitFlag = true;
		}

		if (!splitFlag) {
			// pLŋ؂Ă
			for (String splitChar : splitChars) {
				String[] item = value.split(splitChar);
				if (item.length != 3) {
					continue;
				}
				if (item[0].length() >= 3 && item[1].length() > 0 && item[1].length() <= 2 && item[2].length() > 0 && item[2].length() <= 2) {
					yyyy = item[0];
					mm = item[1];
					dd = item[2];
					splitFlag = true;
					break;
				} else if (item[0].length() > 0 && item[0].length() <= 2 && item[1].length() > 0 && item[1].length() <= 2 && item[2].length() >= 3) {
					yyyy = item[2];
					mm = item[0];
					dd = item[1];
					splitFlag = true;
					break;
				}
			}
		}
		if (!splitFlag) {
			int yyyyIndex = value.indexOf("N");
			int mmIndex = value.indexOf("");
			int ddIndex = value.indexOf("");
			if (yyyyIndex >= 0 && mmIndex >= 0) {
				if (ddIndex >= 0) {
					if (yyyyIndex < mmIndex && mmIndex < ddIndex) {
						yyyy = value.substring(0, yyyyIndex);
						mm = value.substring(yyyyIndex + 1, mmIndex);
						dd = value.substring(mmIndex + 1, ddIndex);
						splitFlag = true;
					}
				} else {
					if (yyyyIndex < mmIndex) {
						yyyy = value.substring(0, yyyyIndex);
						mm = value.substring(yyyyIndex + 1, mmIndex);
						dd = value.substring(mmIndex + 1);
						splitFlag = true;
					}
				}
			}
		}

		if (!splitFlag) {
			return null;
		}

		try {
			Calendar cal = Calendar.getInstance();
			cal.clear();
			cal.setLenient(false); // 
			cal.set(Integer.parseInt(yyyy), Integer.parseInt(mm) - 1, Integer.parseInt(dd), 0, 0, 0);
			return new Date(cal.getTimeInMillis());

		} catch (Exception e) {
			return null;
		}

	}

}
