/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.app;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.app.DefaultReqCharacterConverter;
import jp.oarts.pirka.core.app.DefaultStringConverter;
import jp.oarts.pirka.core.app.DefaultTempFileManager;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaInfoPool;
import jp.oarts.pirka.core.kernel.TempFileManager;
import jp.oarts.pirka.core.res.PirkaFileDownloader;
import jp.oarts.pirka.core.res.PirkaRespons;
import jp.oarts.pirka.core.util.check.AutoCheckRuntimeException;
import jp.oarts.pirka.core.util.converter.ReqCharacterConverter;
import jp.oarts.pirka.core.util.converter.StringConverter;
import jp.oarts.pirka.core.util.field.FieldItem;
import jp.oarts.pirka.core.win.PirkaWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflineEntryPoint
implements EntryPointIF,
Serializable {
    private static final String DEBUG_BROWSER_COMMAND = "C:\\Program Files\\Internet Explorer\\iexplore.exe";
    private static OfflineEntryPoint instance = null;
    private boolean oldServletMode = false;
    private Map<String, CtrlProcesser> ctrlProcesserMap = null;
    private Class pirkaMessageEnumClass = null;
    private String debugBrowserCommand = "C:\\Program Files\\Internet Explorer\\iexplore.exe";
    private File tempHtmlFile;
    private Map<String, Object> sessionMap;
    private String resourceHtmlFileCharset;
    private String outHtmlFileCharset;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private OfflineEntryPoint() {
        String tempDirName = System.getProperty("java.io.tmpdir");
        this.tempHtmlFile = new File(tempDirName, "$$pirka.html");
        this.sessionMap = new HashMap<String, Object>();
        this.resourceHtmlFileCharset = "MS932";
        this.outHtmlFileCharset = "MS932";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OfflineEntryPoint getInstance() {
        if (instance != null) return instance;
        Class<OfflineEntryPoint> clazz = OfflineEntryPoint.class;
        synchronized (OfflineEntryPoint.class) {
            if (instance != null) return instance;
            instance = new OfflineEntryPoint();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void startSession() {
        this.sessionMap.clear();
    }

    public void setDebugBrowserCommand(String debugBrowserCommand) {
        this.debugBrowserCommand = debugBrowserCommand;
    }

    public void setTempHtmlFile(File tempHtmlFile) {
        this.tempHtmlFile = tempHtmlFile;
    }

    public void setOldServletMode(boolean oldServletMode) {
        this.oldServletMode = oldServletMode;
    }

    public void getCtrlProcesserMap(Map<String, CtrlProcesser> ctrlProcesserMap) {
        this.ctrlProcesserMap = ctrlProcesserMap;
    }

    public void getPirkaMessageEnumClass(Class pirkaMessageEnumClass) {
        this.pirkaMessageEnumClass = pirkaMessageEnumClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(PirkaRespons window, int displaySec) {
        block19: {
            if (window == null || !(window instanceof PirkaWindow)) {
                return;
            }
            WindowBaseData windowBaseData = new WindowBaseData();
            windowBaseData.setInstanceNo("1");
            windowBaseData.setSerialNo("");
            ((PirkaWindow)window).setWindowBaseData(windowBaseData);
            try {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(OfflineEntryPoint.getInstance().tempHtmlFile);
                    window.writeRespons(fos);
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                }
                InputStream stream = null;
                try {
                    int c;
                    ProcessBuilder builder = new ProcessBuilder(OfflineEntryPoint.getInstance().debugBrowserCommand, OfflineEntryPoint.getInstance().tempHtmlFile.getCanonicalPath());
                    Process process = builder.start();
                    if (displaySec > 0) {
                        Object waitObject;
                        Object object = waitObject = new Object();
                        synchronized (object) {
                            try {
                                waitObject.wait((long)displaySec * 1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        process.destroy();
                        break block19;
                    }
                    stream = process.getErrorStream();
                    while ((c = stream.read()) >= 0) {
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
            }
        }
    }

    public PirkaRespons action(PirkaRespons window, String actionName, int ... index) {
        try {
            if (window == null || !(window instanceof PirkaWindow)) {
                throw new RuntimeException("window\u304cPirkaWindow\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3067\u306f\u6709\u308a\u307e\u305b\u3093");
            }
            if (this.isOldServletMode()) {
                return this.serviceMainOldServletProc(window, actionName, index);
            }
            return this.serviceMainProc(window, actionName, index);
        }
        catch (Throwable e) {
            throw new RuntimeException("\u4e88\u671f\u3057\u306a\u3044\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }

    private PirkaRespons serviceMainProc(PirkaRespons nextWindow, String actionName, int[] actionLoopIndex) throws IOException {
        boolean actionMethodNoCallFlag = false;
        this.clearErrorFlag(((PirkaWindow)nextWindow).getRootFieldMap());
        ((PirkaWindow)nextWindow).getErrorMessageStocker().clear();
        FieldItem actionFieldItem = null;
        if (actionName != null) {
            actionFieldItem = ((PirkaWindow)nextWindow).getRootFieldItem(actionName);
        }
        if (actionFieldItem != null) {
            ((PirkaWindow)nextWindow).setActionLoopIndex(actionLoopIndex);
        } else {
            ((PirkaWindow)nextWindow).setActionLoopIndex(new int[0]);
        }
        PirkaWindow oldWindow = (PirkaWindow)nextWindow;
        if (actionFieldItem != null && (!actionFieldItem.getCtrl().getTagName().equalsIgnoreCase("a") || actionFieldItem.getCtrl().isSubmitFlag())) {
            nextWindow = this.callAction((PirkaWindow)nextWindow, "onPre");
            if (actionFieldItem != null && actionFieldItem.getCtrl().isAutoCheck()) {
                try {
                    ((PirkaWindow)nextWindow).check();
                }
                catch (AutoCheckRuntimeException e) {
                    actionMethodNoCallFlag = true;
                }
            }
        } else {
            nextWindow = this.callAction((PirkaWindow)nextWindow, "onPre");
        }
        if (!actionMethodNoCallFlag && nextWindow == oldWindow) {
            try {
                nextWindow = actionFieldItem != null ? this.callEventAction((PirkaWindow)nextWindow, actionName) : this.callAction((PirkaWindow)nextWindow, "onElse");
            }
            catch (AutoCheckRuntimeException e) {
                // empty catch block
            }
        }
        if (nextWindow == null) {
            PirkaWindow returnWindow = oldWindow.getReturnWindow();
            nextWindow = returnWindow != null ? returnWindow : oldWindow;
        } else if (!(nextWindow instanceof PirkaFileDownloader) && nextWindow != oldWindow) {
            boolean hitFlag = false;
            Class<?> nextWindowClass = nextWindow.getClass();
            PirkaWindow tempWindow = oldWindow;
            do {
                Class<?> tempWindowClass;
                if ((tempWindowClass = tempWindow.getClass()) != nextWindowClass) continue;
                ((PirkaWindow)nextWindow).setReturnWindow(tempWindow.getReturnWindow());
                hitFlag = true;
                break;
            } while ((tempWindow = tempWindow.getReturnWindow()) != null);
            if (!hitFlag) {
                ((PirkaWindow)nextWindow).setReturnWindow(oldWindow);
            }
        }
        if (nextWindow instanceof PirkaWindow) {
            this.callAction((PirkaWindow)nextWindow, "preDraw");
            this.changeLabelErrorFlag(((PirkaWindow)nextWindow).getFieldMap());
            ((PirkaWindow)nextWindow).fixField();
            String newSerialNo = "";
            WindowBaseData windowBaseData = new WindowBaseData();
            windowBaseData.setSerialNo(newSerialNo);
            windowBaseData.setInstanceNo("1");
            ((PirkaWindow)nextWindow).setWindowBaseData(windowBaseData);
        }
        return nextWindow;
    }

    private PirkaRespons serviceMainOldServletProc(PirkaRespons nextWindow, String actionName, int[] actionLoopIndex) throws IOException {
        boolean actionMethodNoCallFlag = false;
        this.clearErrorFlag(((PirkaWindow)nextWindow).getRootFieldMap());
        ((PirkaWindow)nextWindow).getErrorMessageStocker().clear();
        FieldItem actionFieldItem = null;
        if (actionName != null) {
            actionFieldItem = ((PirkaWindow)nextWindow).getRootFieldItem(actionName);
        }
        if (actionFieldItem != null) {
            ((PirkaWindow)nextWindow).setActionLoopIndex(actionLoopIndex);
        } else {
            ((PirkaWindow)nextWindow).setActionLoopIndex(new int[0]);
        }
        PirkaWindow oldWindow = (PirkaWindow)nextWindow;
        if (actionFieldItem != null && !actionFieldItem.getCtrl().getTagName().equalsIgnoreCase("a")) {
            nextWindow = this.callAction((PirkaWindow)nextWindow, "onPre");
            if (actionFieldItem != null && actionFieldItem.getCtrl().isAutoCheck()) {
                try {
                    ((PirkaWindow)nextWindow).check();
                }
                catch (AutoCheckRuntimeException e) {
                    actionMethodNoCallFlag = true;
                }
            }
        } else {
            nextWindow = this.callAction((PirkaWindow)nextWindow, "onPre");
        }
        if (!actionMethodNoCallFlag && nextWindow == oldWindow) {
            try {
                nextWindow = actionFieldItem != null ? this.callEventAction((PirkaWindow)nextWindow, actionName) : this.callAction((PirkaWindow)nextWindow, "onElse");
            }
            catch (AutoCheckRuntimeException autoCheckRuntimeException) {
                // empty catch block
            }
        }
        if (nextWindow != oldWindow) {
            if (nextWindow == null) {
                nextWindow = oldWindow;
            } else if (!(nextWindow instanceof PirkaFileDownloader)) {
                try {
                    nextWindow = (PirkaWindow)nextWindow.getClass().newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        if (nextWindow instanceof PirkaWindow) {
            this.callAction((PirkaWindow)nextWindow, "preDraw");
            this.changeLabelErrorFlag(((PirkaWindow)nextWindow).getFieldMap());
            ((PirkaWindow)nextWindow).fixField();
            String newSerialNo = "";
            WindowBaseData windowBaseData = new WindowBaseData();
            windowBaseData.setSerialNo(newSerialNo);
            windowBaseData.setInstanceNo("1");
            ((PirkaWindow)nextWindow).setWindowBaseData(windowBaseData);
        }
        return nextWindow;
    }

    private void clearErrorFlag(Map<String, FieldItem> rootFieldMap) {
        for (String fieldName : rootFieldMap.keySet()) {
            rootFieldMap.get(fieldName).setErrorFlag(false);
        }
    }

    private PirkaRespons callEventAction(PirkaWindow window, String name) {
        CtrlProcesser ctrlProcesser;
        HtmlCtrlParts ctrlParts;
        FieldItem fieldItem = window.getRootFieldItem(name);
        if (fieldItem != null && (ctrlParts = fieldItem.getCtrl()) != null && (ctrlProcesser = ctrlParts.getCtrlProcesser()) != null && ctrlProcesser.isActionCtrl()) {
            Method method = PirkaInfoPool.getMethod(window, ctrlParts.getBaseName());
            if (method == null) {
                return window;
            }
            try {
                if (method.getReturnType() == null || method.getReturnType() == Void.TYPE) {
                    method.invoke((Object)window, new Object[0]);
                    return window;
                }
                return (PirkaRespons)method.invoke((Object)window, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof AutoCheckRuntimeException) {
                    throw (AutoCheckRuntimeException)e.getCause();
                }
                throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
            }
        }
        return window;
    }

    private PirkaRespons callAction(PirkaWindow window, String name) {
        Method method = PirkaInfoPool.getMethod(window, name);
        if (method == null) {
            return window;
        }
        try {
            if (method.getReturnType() == null || method.getReturnType() == Void.TYPE) {
                method.invoke((Object)window, new Object[0]);
                return window;
            }
            return (PirkaRespons)method.invoke((Object)window, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof AutoCheckRuntimeException) {
                throw (AutoCheckRuntimeException)e.getCause();
            }
            throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
        }
    }

    private void changeLabelErrorFlag(FieldMap fieldMap) {
        this.changeLabelErrorFlagMain(fieldMap, fieldMap, "");
    }

    private void changeLabelErrorFlagMain(FieldMap baseFieldMap, FieldMap fieldMap, String suffix) {
        String[] fieldNames;
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String fieldName = stringArray[n];
            FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
            String forId = fieldItem.getCtrl().getOptionMap().get("for");
            if (forId != null) {
                if (fieldItem.getCtrl().isSuffix()) {
                    forId = String.valueOf(forId) + suffix;
                }
                boolean errorFlag = this.isErrorId(baseFieldMap, forId);
                fieldItem.setErrorFlag(errorFlag);
            }
            if (fieldItem.getCtrl().getCtrlProcesser().isLoop() && fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
                List list = (List)fieldItem.getValue();
                int index = 0;
                for (FieldMap childMap : list) {
                    this.changeLabelErrorFlagMain(baseFieldMap, childMap, String.valueOf(suffix) + '$' + index);
                    ++index;
                }
            }
            ++n;
        }
    }

    private boolean isErrorId(FieldMap baseFieldMap, String id) {
        return this.isErrorIdMain(baseFieldMap, id, "");
    }

    private boolean isErrorIdMain(FieldMap baseFieldMap, String id, String suffix) {
        String[] fieldNames;
        String[] stringArray = fieldNames = baseFieldMap.getFieldNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String fieldName = stringArray[n];
            FieldItem fieldItem = baseFieldMap.getFieldItem(fieldName);
            String targetId = fieldItem.getCtrl().getOptionMap().get("id");
            if (targetId != null) {
                if (fieldItem.getCtrl().isSuffix()) {
                    targetId = String.valueOf(targetId) + suffix;
                }
                if (id.equals(targetId) && fieldItem.isErrorFlag()) {
                    return true;
                }
            }
            if (fieldItem.getCtrl().getCtrlProcesser().isLoop() && fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
                List list = (List)fieldItem.getValue();
                int index = 0;
                for (FieldMap childMap : list) {
                    if (this.isErrorIdMain(childMap, id, String.valueOf(suffix) + '$' + index)) {
                        return true;
                    }
                    ++index;
                }
            }
            ++n;
        }
        return false;
    }

    @Override
    public Map<String, CtrlProcesser> getCtrlProcesserMap() {
        return this.ctrlProcesserMap;
    }

    @Override
    public String getUrlAlias() {
        return "offline";
    }

    @Override
    public Class getPirkaMessageEnumClass() {
        return this.pirkaMessageEnumClass;
    }

    @Override
    public boolean isOldServletMode() {
        return this.oldServletMode;
    }

    @Override
    public void putSession(String keyName, Object object) {
        this.sessionMap.put(keyName, object);
    }

    @Override
    public Object getSession(String keyName) {
        return this.sessionMap.get(keyName);
    }

    public void setResourceHtmlFileCharset(String resourceHtmlFileCharset) {
        this.resourceHtmlFileCharset = resourceHtmlFileCharset;
    }

    public void setHtmlStringCharset(String outHtmlFileCharset) {
        this.outHtmlFileCharset = outHtmlFileCharset;
    }

    @Override
    @Deprecated
    public String getResourceHtmlFileCharset() {
        return this.resourceHtmlFileCharset;
    }

    @Override
    @Deprecated
    public String getHtmlStringCharset() {
        return this.outHtmlFileCharset;
    }

    @Override
    @Deprecated
    public String getResponsHeaderCharset() {
        return "Shift-jis";
    }

    @Override
    public StringConverter getInputStringConverter() {
        return DefaultStringConverter.getInstance();
    }

    @Override
    public StringConverter getOutputStringConverter() {
        return DefaultStringConverter.getInstance();
    }

    @Override
    public boolean isClearSessionAtInitScreen() {
        return true;
    }

    @Override
    public ReqCharacterConverter getReqCharacterConverter() {
        return DefaultReqCharacterConverter.getInstance();
    }

    @Override
    public TempFileManager getTempFileManager() {
        return DefaultTempFileManager.getInstance();
    }
}

