// NotifyIcon class - Copyright(C) 2003 minamina
//
// ^XNgCACR⏕NX
// Initialize  Set nŕKvȏZbg
// Add, Delete, Modify ֐Ń^XNgCACR𑀍
// ACR\[X͎ō폜
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include <assert.h>
#include <commctrl.h>
#include "NotifyIcon.h"

#define NOTIFYICON_ID (0)

CNotifyIcon* CNotifyIcon::s_pNotifyIcon;

CNotifyIcon::CNotifyIcon()
{
	::ZeroMemory(&m_notifyIconData, sizeof(NOTIFYICONDATA));

	m_notifyIconData.cbSize = sizeof(NOTIFYICONDATA);
	m_notifyIconData.hWnd = NULL;
	m_notifyIconData.uID = NOTIFYICON_ID;
	m_notifyIconData.uFlags = NIF_ICON | NIF_MESSAGE | NIF_TIP;
	m_notifyIconData.uCallbackMessage = NULL;
	m_notifyIconData.hIcon = NULL;
	m_notifyIconData.szTip[0] = _T('\0');

	m_uTaskbarCreated = ::RegisterWindowMessage(_T("TaskbarCreated"));
	m_hInstance = NULL;
	m_bActive = false;
	m_bAutoDestroyIcon = true;

	m_hAnimationIconList = NULL;
	m_dwAnimationInterval = 10;
	m_dwAnimationCount = 0;
	m_dwAnimationIndex = 0;
	m_bAnimationLoop = false;
	m_uiAnimationTimerEventID = DEFAULT_ANIMATION_TIMER_EVENT_ID;
}

// ACR͎IɃ^XNgC폜ACR\[X폜
CNotifyIcon::~CNotifyIcon()
{
	Delete();
	DestroyIcon();
	DestroyAnimationIcon();
}

// 
// hInstance : \[XǂݍނƂK{
// hWnd : bZ[W𑗂EBhE
// uCallbackMessage : R[obNbZ[WB ) #define WM_USER_NOTIFYICON (WIN_APP + 100)
void CNotifyIcon::Initialize(HINSTANCE hInstance, HWND hWnd, UINT uCallbackMessage)
{
	SetHInstance(hInstance);
	SetWindow(hWnd);
	m_notifyIconData.uCallbackMessage = uCallbackMessage;
}

// ACR^XNgCɒǉ (݂̐ݒ)
bool CNotifyIcon::Add()
{
	assert(m_notifyIconData.hWnd != NULL);
	assert(m_notifyIconData.hIcon != NULL);

	::Shell_NotifyIcon(NIM_ADD, &m_notifyIconData);
	m_bActive = true;
	return (m_bActive);
}

// ACR^XNgCɒǉ (\[X)
bool CNotifyIcon::AddIcon(WORD wResourceID)
{
	SetIcon(wResourceID);
	return Add();
}

// ACR^XNgCɒǉ (t@C)
bool CNotifyIcon::AddIcon(LPCTSTR lpszFilename)
{
	SetIcon(lpszFilename);
	return Add();
}

// ACR^XNgCɒǉ (nh)
// bAutoDestroyIcon
//   true  : KvȂȂƂ CNotifyIcon Ńnh폜
//   false : CNotifyIcon ̓nh̊ǗBō폜Kv
bool CNotifyIcon::AddIcon(HICON hIcon, bool bAutoDestroyIcon)
{
	SetIcon(hIcon, bAutoDestroyIcon);
	return Add();
}

// ACR^XNgC폜 (݂̐ݒ)
bool CNotifyIcon::Delete()
{
	assert(m_notifyIconData.hWnd != NULL);
	assert(m_notifyIconData.hIcon != NULL);

	m_bActive = false;
	return (::Shell_NotifyIcon(NIM_DELETE, &m_notifyIconData) != FALSE);
}

// ^XNgCACRύX (݂̐ݒ)
bool CNotifyIcon::Modify()
{
	assert(m_notifyIconData.hWnd != NULL);
	assert(m_notifyIconData.hIcon != NULL);

	bool bResult = false;
	if (IsActive())
	{
		bResult = ::Shell_NotifyIcon(NIM_MODIFY, &m_notifyIconData) != FALSE;
	}
	return bResult;
}

// ^XNgCACRύX (\[X)
bool CNotifyIcon::ModifyIcon(WORD wResourceID)
{
	assert(m_hInstance != NULL);

	SetIcon(wResourceID);
	return Modify();
}

// ^XNgCACRύX (t@C)
bool CNotifyIcon::ModifyIcon(LPCTSTR lpszFilename)
{
	SetIcon(lpszFilename);
	return Modify();
}

// ^XNgCACRύX (nh)
// bAutoDestroyIcon
//   true  : KvȂȂƂ CNotifyIcon Ńnh폜
//   false : CNotifyIcon ̓nh̊ǗBō폜Kv
bool CNotifyIcon::ModifyIcon(HICON hIcon, bool bAutoDestroyIcon)
{
	SetIcon(hIcon, bAutoDestroyIcon);
	return Modify();
}

// ^XNgCACR̃c[`bvύX (\[X)
bool CNotifyIcon::ModifyTip(WORD wResourceID)
{
	SetTip(wResourceID);
	return Modify();
}

// ^XNgCACR̃c[`bvύX (񂩂)
bool CNotifyIcon::ModifyTip(LPCTSTR lpszTip)
{
	SetTip(lpszTip);
	return Modify();
}

// ACR\[X폜
void CNotifyIcon::DestroyIcon()
{
	if (m_notifyIconData.hIcon != NULL)
	{
		if (m_bAutoDestroyIcon)
		{
			::DestroyIcon(m_notifyIconData.hIcon);
		}
		m_notifyIconData.hIcon = NULL;
	}
}

// bZ[WMEBhEw
void CNotifyIcon::SetWindow(HWND hWnd)
{
	assert(hWnd != NULL);

	m_notifyIconData.hWnd = hWnd;
}

// ACR ID w
// ɓo^ς݂̂Ƃ ID ςƍ폜łȂȂĂ܂̂
// ύXO Delete Ăł
void CNotifyIcon::SetID(UINT uID)
{
	if (IsActive())
	{
		Delete();
	}
	m_notifyIconData.uID = uID;
}

// ACR ID 擾
UINT CNotifyIcon::GetID()
{
	return m_notifyIconData.uID;
}

// \[X擾郂W[ HINSTANCE w
void CNotifyIcon::SetHInstance(HINSTANCE hInstance)
{
	m_hInstance = hInstance;
}

// ACRݒ (\[X)
bool CNotifyIcon::SetIcon(WORD wResourceID, UINT fuLoad)
{
	assert(m_hInstance != NULL);

	return SetIcon(MAKEINTRESOURCE(wResourceID), fuLoad);
}

// ACRݒ (t@C)
bool CNotifyIcon::SetIcon(LPCTSTR lpszFilename, UINT fuLoad)
{
	DestroyIcon();

	m_notifyIconData.hIcon = (HICON)::LoadImage(m_hInstance, lpszFilename, IMAGE_ICON, 16, 16, fuLoad);
	m_bAutoDestroyIcon = true;

	return (m_notifyIconData.hIcon != NULL);
}

// ACRݒ (nh)
// bAutoDestroyIcon
//   true  : KvȂȂƂ CNotifyIcon Ńnh폜
//   false : CNotifyIcon ̓nh̊ǗBō폜Kv
bool CNotifyIcon::SetIcon(HICON hIcon, bool bAutoDestroyIcon)
{
	DestroyIcon();

	m_notifyIconData.hIcon = hIcon;
	m_bAutoDestroyIcon = bAutoDestroyIcon;

	return (m_notifyIconData.hIcon != NULL);
}

// c[`bvݒ (\[X)
void CNotifyIcon::SetTip(WORD wResourceID)
{
	assert(m_hInstance != NULL);

	TCHAR tcBuffer[64];
	if (::LoadString(m_hInstance, wResourceID, tcBuffer, 64) > 0)
	{
		SetTip(tcBuffer);
	}
}

// c[`bvݒ (񂩂)
void CNotifyIcon::SetTip(LPCTSTR lpszTip)
{
	_tcsncpy(m_notifyIconData.szTip, lpszTip, 63);
	m_notifyIconData.szTip[63] = _T('\n');
}

// ^XNgCɃACR邩?
bool CNotifyIcon::IsActive()
{
	return m_bActive;
}

// Aj[Vݒ
// rbg}bvACRnh (t@C)
bool CNotifyIcon::SetAnimation(LPCTSTR lpszFilename, DWORD dwInterval, bool bLoop, COLORREF crMask, UINT uiEventID, UINT fuLoad)
{
	bool bResult = false;

	EndAnimation();
	DestroyAnimationIcon();

	HIMAGELIST hImage = ::ImageList_Create(16, 16, ILC_COLOR8 | ILC_MASK, 0, 0);
	if (hImage != NULL)
	{
		HBITMAP hBitmap = (HBITMAP)::LoadImage(m_hInstance, lpszFilename, IMAGE_BITMAP, 0, 0, fuLoad);
		if (hBitmap != NULL)
		{
			int nIndex = ImageList_AddMasked(hImage, hBitmap, crMask);
			if (nIndex != -1)
			{
				int nCount = ::ImageList_GetImageCount(hImage);
				m_dwAnimationCount = nCount;
				m_dwAnimationInterval = dwInterval;
				m_bAnimationLoop = bLoop;
				m_uiAnimationTimerEventID = uiEventID;
				m_dwAnimationIndex = 0;
				m_hAnimationIconList = new HICON[m_dwAnimationCount];
				DWORD i;
				for (i = 0; i < m_dwAnimationCount; i++)
				{
					m_hAnimationIconList[i] = ::ImageList_GetIcon(hImage, i, ILD_TRANSPARENT);
				}
				bResult = true;
			}
			::DeleteObject(hBitmap);
		}
		::ImageList_Destroy(hImage);
	}

	return bResult;
}

// Aj[Vݒ
// rbg}bvACRnh (\[X)
bool CNotifyIcon::SetAnimation(WORD wResourceID, DWORD dwInterval, bool bLoop, COLORREF crMask, UINT uiEventID, UINT fuLoad)
{
	return SetAnimation(MAKEINTRESOURCE(wResourceID), dwInterval, bLoop, uiEventID, crMask, fuLoad);
}

// Aj[VŎgACR폜
void CNotifyIcon::DestroyAnimationIcon()
{
	if (m_hAnimationIconList != NULL)
	{
		DWORD i;
		for (i = 0; i < m_dwAnimationCount; i++)
		{
			::DestroyIcon(m_hAnimationIconList[i]);
		}
		delete[] m_hAnimationIconList;
		m_hAnimationIconList = NULL;
		m_dwAnimationCount = 0;
	}
}

// ݂̐ݒŃAj[VJn
bool CNotifyIcon::StartAnimation()
{
	bool bResult = false;

	EndAnimation();

	if (m_hAnimationIconList != NULL)
	{
		s_pNotifyIcon = this;
		m_dwAnimationIndex = 0;
		::SetTimer(m_notifyIconData.hWnd, m_uiAnimationTimerEventID, m_dwAnimationInterval, TimerProc);
	}

	return bResult;
}

// Aj[VJn㎩ŌĂ΂R[obN
VOID CALLBACK CNotifyIcon::TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
	if (s_pNotifyIcon != NULL)
	{
		// Aj[Vł͂ȂZbgĂACR͂̂܂ܕۑĂ
		HICON hOrigIcon = s_pNotifyIcon->m_notifyIconData.hIcon;
		s_pNotifyIcon->m_notifyIconData.hIcon = s_pNotifyIcon->m_hAnimationIconList[s_pNotifyIcon->m_dwAnimationIndex];
		s_pNotifyIcon->Modify();
		s_pNotifyIcon->m_notifyIconData.hIcon = hOrigIcon;

		s_pNotifyIcon->m_dwAnimationIndex++;
		if (s_pNotifyIcon->m_dwAnimationIndex >= s_pNotifyIcon->m_dwAnimationCount)
		{
			if (s_pNotifyIcon->m_bAnimationLoop)
			{
				s_pNotifyIcon->m_dwAnimationIndex = 0;
			}
			else
			{
				// ̃ACRɕA
				s_pNotifyIcon->Modify();
				s_pNotifyIcon->EndAnimation();
			}
		}
	}
}

// Aj[VI
void CNotifyIcon::EndAnimation()
{
	if (m_hAnimationIconList != NULL)
	{
		s_pNotifyIcon = NULL;
		::KillTimer(m_notifyIconData.hWnd, m_uiAnimationTimerEventID);
	}
}
