// Skin.cpp : Cve[V t@C
//

#include "stdafx.h"
#include <iomanip>
#include "pochy.h"
#include "Skin.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSkin


CSkin::CSkin()
{
	m_skinIniFile = "";

	m_tasktrayIcon = "";
	m_tasktrayAnimeIcon = "";
	m_summarryViewIcons = "";
	m_summarryViewBackBmp = "";
	m_folderViewBackBmp = "";
	m_textViewBackBmp = "";
	m_mailEditViewBackBmp = "";
	m_headerViewBackBmp = "";
	m_toolbarDraftIcons = "";
	m_toolbarMainIcons = "";
	m_treeViewIcons = "";
	m_successEffectSound = "";
}

//skin.inĩ[h
BOOL CSkin::LoadSkinProfile(char *skinIniFile)
{
	CString buf;
	CString fileName = skinIniFile;
	std::fstream cFStrm( fileName, std::ios::in);
    if( cFStrm.fail() ) {
		CString message;
		message.Format("cannot open file: %s", fileName.GetBuffer(0));
		AfxMessageBox(message.GetBuffer(0));
		return FALSE;
	}

	m_skinIniFile = fileName;

	while(!cFStrm.eof())
    {
		char skinfilename[1024];
        cFStrm.getline(buf.GetBuffer(0), 1024);
        if(!cFStrm.fail()) {
			if(buf.Find("[TaskTrayIcon]") != -1) {
				cFStrm >> std::setw(1024)
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw(1024)
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw(1024)
					   >> skinfilename;
				m_tasktrayIcon = skinfilename;
			}
			else if(buf.Find("[TaskTrayAnimeIcon]") != -1) {
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> skinfilename;
				m_tasktrayAnimeIcon = skinfilename;
			}
			else if(buf.Find("[SummaryViewIcons]") != -1) {
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> skinfilename;
				m_summarryViewIcons = skinfilename;
			}
			else if(buf.Find("[SummaryViewBackBmp]") != -1) {
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> skinfilename;
				m_summarryViewBackBmp = skinfilename;
			}
			else if(buf.Find("[FolderViewBackBmp]") != -1) {
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> skinfilename;
				m_folderViewBackBmp = skinfilename;
			}
			else if(buf.Find("[TextViewBackBmp]") != -1) {
				// TextViewBk.bmp
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> skinfilename;
				m_textViewBackBmp = skinfilename;
			}
			else if(buf.Find("[MailEditViewBackBmp]") != -1) {
				// MailEditViewBk.bmp
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> skinfilename;
				m_mailEditViewBackBmp = skinfilename;
			}
			else if(buf.Find("[HeaderViewBackBmp]") != -1) {
				// HeaderViewBk.bmp
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> skinfilename;
				m_headerViewBackBmp = skinfilename;
			}
			else if(buf.Find("[ToolbarDraftIcons]") != -1) {
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> skinfilename;
				m_toolbarDraftIcons = skinfilename;
			}
			else if(buf.Find("[ToolbarMainIcons]") != -1) {
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> skinfilename;
				m_toolbarMainIcons = skinfilename;
			}
			else if(buf.Find("[TreeViewIcons]") != -1) {
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> skinfilename;
				m_treeViewIcons = skinfilename;
			}
			else if(buf.Find("[SuccessEffectSound]") != -1) {
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> buf.GetBuffer(0);
				cFStrm >> std::setw( 1024 )
					   >> skinfilename;
				m_successEffectSound = skinfilename;
			}
		}
    }

	return TRUE;
}

CSkin::~CSkin()
{
}

//lget֐
CString CSkin::getSkinIniFile() {
	return m_skinIniFile;
}
CString CSkin::getSkinIniPath() {
	return m_skinIniFile.Left(m_skinIniFile.ReverseFind('\\'));
}
CString CSkin::getTasktrayIcon() {
	return m_tasktrayIcon;
}
CString CSkin::getTasktrayAnimeIcon() {
	return m_tasktrayAnimeIcon;
}
CString CSkin::getSummarryViewIcons() {
	return m_summarryViewIcons;
}
CString CSkin::getSummarryViewBackBmp() {
	return m_summarryViewBackBmp;
}
CString CSkin::getFolderViewBackBmp() {
	return m_folderViewBackBmp;
}
CString CSkin::getTextViewBackBmp() {
	return m_textViewBackBmp;
}
CString CSkin::getMailEditViewBackBmp() {
	return m_mailEditViewBackBmp;
}
CString CSkin::getHeaderViewBackBmp() {
	return m_headerViewBackBmp;
}
CString CSkin::getToolbarDraftIcons() {
	return m_toolbarDraftIcons;
}
CString CSkin::getToolbarMainIcons() {
	return m_toolbarMainIcons;
}
CString CSkin::getTreeViewIcons() {
	return m_treeViewIcons;
}
CString CSkin::getSuccessEffectSound() {
	return m_successEffectSound;
}


/////////////////////////////////////////////////////////////////////////////
// CSkin bZ[W nh
