/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * For license terms, see the file COPYING in this directory.
 */

#include "stdafx.h"
#include "Pochy.h"
#include "MainFrm.h"
#include "SummaryView.h"
#include "HeaderInfo.h"
#include "CodeConvert.h"
#include "direct.h"
#include "lib.h"
#include "_regex.h" // K\֐
#include "process.h" // getpid()

void g_log(CString path, CString log)
{
	CPochyApp *app = (CPochyApp*)AfxGetApp();
	FILE* file;
	if((file = fopen(app->m_app_path+"\\"+path, "ab"))==NULL){
		AfxMessageBox("fopen: error at g_log");
		return;
	}
	fwrite(log, sizeof(char), log.GetLength(), file);
	fclose(file);
}

// cdr֐
BOOL g_cstr_compare(LPCTSTR c, LPCTSTR d)
{
	regex_t reg; // K\i[p
	regmatch_t pmatch[2]; // regexečʂi[

	CString regex;
	regex.Format("^%s$", c);
	regcomp(&reg, regex.GetBuffer(0), REG_EXTENDED | REG_NEWLINE | REG_ICASE |REG_NOSUB );
	if(0 == regexec(&reg, d, 2, pmatch, 0)){
		regfree(&reg);
		return TRUE;
	}
	regfree(&reg);
	return FALSE;
}

BOOL g_rm_recursive(CString path)
{
	CFileFind ff;
	BOOL b_Find;
	CString cPath = path + "\\*.*";

	b_Find = ff.FindFile(cPath);
	while(b_Find){
		b_Find = ff.FindNextFile();
		if(ff.IsDots())
			continue;
		if(ff.IsDirectory()){
			if(!g_rm_recursive(path + "\\" + ff.GetFileName()))
				return FALSE;
		}else{
			if(!DeleteFile(path + "\\" +ff.GetFileName()))
				return FALSE;
		}
	}
	ff.FindFile(cPath + "\\.."); // JgfBNgύXĂȂrmdirłȂ
	if(_rmdir(path))
		return FALSE;
	return TRUE;
}

// CStringt@CփeLXgo֐
BOOL g_cstring2file(/*CString& buf*/LPCTSTR buf, LPCTSTR file_name)
{
/*	HANDLE hTmp;
	DWORD len;
	hTmp = CreateFile(filename,GENERIC_WRITE,0,NULL,OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
*/
//	WriteFile(hTmp, buf, /*buf.GetLength()*/strlen(buf), &len, 0);
/*	if(!CloseHandle(hTmp)){
		AfxMessageBox("CloseHandle");
		return FALSE;
	}
	return TRUE;*/

	FILE *fp;

	fp = fopen(file_name, "wb");
	if(0 > fwrite(buf, sizeof(char), strlen(buf), fp)){
		AfxMessageBox("g_cstring2file error");
		fclose(fp);
		return FALSE;
	}

	fclose(fp);
	return TRUE;
}

// t@CCStringɃeLXgo֐
BOOL g_file2cstring(LPCTSTR filename,CString& buf)
{
	CFile file;
	if(!file.Open(filename,CFile::modeRead)){
		return FALSE;
	}
	LPSTR pbuf;
	pbuf = buf.GetBuffer(file.GetLength()+1);
	file.Read(pbuf,file.GetLength());
	pbuf[file.GetLength()]=0;
	buf.ReleaseBuffer();
	file.Close();
	return TRUE;
}

// t@C쐬֐
BOOL g_fcreate(LPCTSTR path)
{
	HANDLE h = CreateFile(
		path,
		GENERIC_WRITE,
		FILE_SHARE_READ,
		0,	// NT2000Ƒ߁AvC
		OPEN_ALWAYS,
		FILE_ATTRIBUTE_NORMAL,
		NULL);	
	if(h == NULL){
		CloseHandle(h);
		return FALSE;
	}	
	CloseHandle(h);
	return TRUE;
}

// vZX֐ڑ֐
BOOL g_connect_process(CStringArray &comline, CString &out1, CString &out2)
{
	HANDLE hOutputReadTmp,hOutputRead,hOutputWrite;
	HANDLE hInputWriteTmp,hInputRead,hInputWrite;
	HANDLE hErrorReadTmp,hErrorRead,hErrorWrite;
	SECURITY_ATTRIBUTES sa;
	sa.nLength = sizeof(SECURITY_ATTRIBUTES);
	sa.lpSecurityDescriptor = NULL;
	sa.bInheritHandle = TRUE;

	// Create the child output pipe.
	if (!CreatePipe(&hOutputReadTmp,&hOutputWrite,&sa,0))
		AfxMessageBox("CreatePipe");
	if (!CreatePipe(&hErrorReadTmp,&hErrorWrite,&sa,0))
		AfxMessageBox("CreatePipe");
	if (!CreatePipe(&hInputRead,&hInputWriteTmp,&sa,0))
		AfxMessageBox("CreatePipe");

	if (!DuplicateHandle(GetCurrentProcess(),hErrorReadTmp,
		GetCurrentProcess(),&hErrorRead,0,TRUE,DUPLICATE_SAME_ACCESS))
		AfxMessageBox("DuplicateHandle");
	if (!DuplicateHandle(GetCurrentProcess(),hOutputReadTmp,
		GetCurrentProcess(),&hOutputRead,0,FALSE,DUPLICATE_SAME_ACCESS))
		AfxMessageBox("DuplicateHandle");
	if (!DuplicateHandle(GetCurrentProcess(),hInputWriteTmp,
		GetCurrentProcess(),&hInputWrite,0,FALSE,DUPLICATE_SAME_ACCESS))
		AfxMessageBox("DuplicateHandle");

	// Close inheritable copies of the handles you do not want to be 
	// inherited.
	if (!CloseHandle(hOutputReadTmp)) AfxMessageBox("CloseHandle");
	if (!CloseHandle(hInputWriteTmp)) AfxMessageBox("CloseHandle");
	if (!CloseHandle(hErrorReadTmp)) AfxMessageBox("CloseHandle");

	// vZXN
	STARTUPINFO siStartInfo;
	PROCESS_INFORMATION pi;
	ZeroMemory( &siStartInfo, sizeof(STARTUPINFO) );
	siStartInfo.hStdError = hErrorWrite;
	siStartInfo.hStdOutput = hOutputWrite;
	siStartInfo.hStdInput = hInputRead;
	siStartInfo.dwFlags = STARTF_USESHOWWINDOW | STARTF_USESTDHANDLES;
	siStartInfo.wShowWindow = SW_HIDE;
	siStartInfo.cb = sizeof(STARTUPINFO);
	LPSTR lps = comline[0].GetBuffer(0);
	if(!CreateProcess(NULL,lps,
		NULL,NULL,TRUE,CREATE_NEW_CONSOLE/*NORMAL_PRIORITY_CLASS|DETACHED_PROCESS*/,NULL,NULL,&siStartInfo,&pi)){ //CREATE_NEW_CONSOLE
		if(!CloseHandle(hInputWrite)) AfxMessageBox("CloseHandle");
		if(!CloseHandle(hOutputRead)) AfxMessageBox("CloseHandle");
		if(!CloseHandle(hErrorRead)) AfxMessageBox("CloseHandle");
		return FALSE;
	}

	// ͂
	for(int i=1;i<comline.GetSize();i++){
		DWORD len;
		WaitForInputIdle(pi.hProcess,INFINITE);
		WriteFile(hInputWrite,comline[i],comline[i].GetLength(),&len,NULL);
	}

	DWORD BytesAvail;
	DWORD ret;
	out1.Empty();
	out2.Empty();
	CString buf;
    // vZXÑpCve󂯎菈
	while((ret = WaitForSingleObject(pi.hProcess,0)) != WAIT_ABANDONED){
		PeekNamedPipe(hOutputRead,NULL,0,NULL,&BytesAvail,NULL);
		if(BytesAvail>0){
			LPSTR pout1;
			DWORD len;
			pout1 = buf.GetBuffer(65536);
			ReadFile(hOutputRead,pout1,65536,&len,NULL);
			pout1[len]=0;
			buf.ReleaseBuffer();
			out1 += buf;
			buf.Empty();
		}
		PeekNamedPipe(hErrorRead,NULL,0,NULL,&BytesAvail,NULL);
		if(BytesAvail>0){
			LPSTR pout2;
			DWORD len;
			pout2 = buf.GetBuffer(65536);
			ReadFile(hErrorRead,pout2,65536,&len,NULL);
			pout2[len]=0;
			buf.ReleaseBuffer();
			out2 += buf;
			buf.Empty();
		}
		// bZ[WL[擾A݂΁A𑣂
/*		MSG msg;
		if(::PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)){
			::TranslateMessage(&msg);
			::DispatchMessage(&msg);
		}*/
		// vZXIȂA[v𔲂
		if(ret == WAIT_OBJECT_0)
			break;
		Sleep(10);
	}
    GetExitCodeProcess(pi.hProcess, &ret);
	if(!CloseHandle(hInputWrite)) AfxMessageBox("CloseHandle");
	if(!CloseHandle(hOutputRead)) AfxMessageBox("CloseHandle");
	if(!CloseHandle(hErrorRead)) AfxMessageBox("CloseHandle");

	return TRUE;
}

/*
int g_get_icon_index(const CString& csFileName)
{
	SHFILEINFO sfi;

	SHGetFileInfo(
		(LPCTSTR)csFileName, 
		0,
		&sfi, 
		sizeof(SHFILEINFO), 
		SHGFI_USEFILEATTRIBUTES | SHGFI_SYSICONINDEX | SHGFI_SMALLICON);

	return sfi.iIcon;
}
*/

// CStringesCStringArrayɊi[isep܂߂j
void g_cstr2cstra(CString& cstr, CStringArray& cstra, LPCTSTR sep)
{
	int a;
	cstra.RemoveAll();
	a = cstr.Find(sep);
	while(a!=-1){
		cstra.Add(cstr.Left(a+strlen(sep)));
		cstr = cstr.Mid(a+strlen(sep));
		a = cstr.Find(sep);
	}
	cstra.Add(cstr);
}

// CStringesCStringArrayɊi[isep͊܂߂Ȃj
void g_cstr2cstra_ex(CString& cstr, CStringArray& cstra, LPCTSTR sep)
{
	CString buf;
	int a;
	cstra.RemoveAll();
	a = cstr.Find(sep);
	while(a!=-1){
		buf = cstr.Left(a);
		cstra.Add(buf);
		cstr = cstr.Mid(a+strlen(sep));
		a = cstr.Find(sep);
	}
	cstra.Add(cstr);
}

// CStringArrayɊesi[̂CStringɏo
void g_cstra2cstr(CStringArray& cstra, CString& cstr, int size)
{
	int i;
	cstr.Empty();

	char *p = cstr.GetBuffer(size);
	for(i=0;i<cstra.GetSize();i++){
		strcpy(p, cstra.GetAt(i).GetBuffer(0));
		p += cstra.GetAt(i).GetLength();
	}
	cstr.ReleaseBuffer();
}

// CStringArrayɊi[ꂽCStringS̃TCY
int g_cstra_getsize(CStringArray& cstra)
{
	int i;
	int n;

	i = n = 0;
	while(i < cstra.GetSize()){
		n += cstra.GetAt(i).GetLength();
		i++;
	}
	return n;
}

// eLXgt@C̊esCStringArrayɓǂݍ
BOOL g_file2cstra(LPCTSTR path, CStringArray &cstra)
{
	CString buf;
	CStdioFile file;

	if(!file.Open(path, CFile::modeRead | CFile::typeText))
		return FALSE;
	while(file.ReadString(buf)){
		buf += "\r\n";
		cstra.Add(buf);
	}
	buf.Empty();
	file.Close();
	return TRUE;
}

// CStringArrayɊesi[ꂽeLXgt@C֏o
BOOL g_cstra2file(LPCTSTR path, CStringArray &cstra)
{
	int n = 0;
	FILE *file;

	file = fopen(path, "wb");
	if(file == NULL){
		AfxMessageBox("fopen: error");
		return FALSE;
	}
	while(n < cstra.GetSize()){
		fwrite(cstra.GetAt(n), sizeof(char), cstra.GetAt(n).GetLength(), file);
		n++;
	}
	fclose(file);

	return TRUE;
}

// t@C̑傫Ԃ
long g_getfs(LPCTSTR path)
{
	FILE *file;
	long size = 0;

	if((file = fopen(path, "rt"))){
		fseek(file, 0, SEEK_END);
		size = ftell(file);
		fclose(file);
		return size;
	}

	return -1;
}

// t@CԍƂČƂA
// (num)ȏł܂݂Ȃŏ̔ԍԂ֐
int g_get_min_num(CString path)
{
/*	CString cNum;
	CString tmp;
	HANDLE hFile;
	WIN32_FIND_DATA wfd;

	while(1){
		tmp = path;
		cNum.Format("\\%d", num);
		tmp += cNum;
		cNum.Empty();
		hFile = FindFirstFile(tmp.GetBuffer(0), &wfd);
		tmp.Empty();
		if(hFile == INVALID_HANDLE_VALUE) break;
		num++;
	}
	FindClose(hFile);

	cNum.Format("%d", num);
	return num;*/

	int i=0;
	CFileFind ff;
	BOOL b = ff.FindFile(path+"\\*.*");
	while(b){
		b = ff.FindNextFile();
		if(	!ff.IsDirectory() &&
			!ff.IsDots() &&
			ff.GetFileName().SpanExcluding("0123456789").IsEmpty())
		{
			if(i<atoi(ff.GetFileName()))
				i=atoi(ff.GetFileName());
		}
	}
	ff.Close();
	return ++i;
}

// CStringAray̕o֐
void g_cstra_getpart(CStringArray &org, CStringArray &dst, int start, int end)
{
	dst.RemoveAll();

	while(/*start < org.GetSize() || */start < end+1){
		dst.Add(org.GetAt(start));
		start++;
	}
}

// t@C݂Ă邩ǂԂ֐
BOOL g_is_there(LPCTSTR path)
{
	WIN32_FIND_DATA wfd;

	HANDLE handle = FindFirstFile(path, &wfd);
	if(handle == INVALID_HANDLE_VALUE){
		FindClose(handle);
		return FALSE;
	}else{
		FindClose(handle);
		return TRUE;
	}
}

// <>̒̕Ԃ֐
CString g_ma(CString& to)
{
	CString res;
	int p,p2,q,q2;
	p = to.Find("<")+1;
	q = to.Find(">")+1;
	p2 = to.Find("<",p)+1;
	q2 = to.Find(">",q)+1;

	if(p && q && !p2 && !q2)
		return to.Mid(p,q-p-1);
	if(p || q || p2 || q2)
		AfxMessageBox(to+"\r\n͕ςȃAhXłB");
	return to;
}

CString g_getfield(CString& body,LPCTSTR name)
{
	CString res;
	int a,b;
	a = body.Find(name);
	if(a==-1){
		res.Empty();
		return res;
	}
	if(a==0 || body[a-1]==10){
		b = body.Find("\r\n",a);
		if(b == -1)
			b = body.GetLength();
		a += strlen(name);
		res = body.Mid(a,b-a);
	}
	res.TrimLeft();
	res.TrimRight();
	return res;
}

// Message-ID𐶐֐
CString g_gen_msgid(CString from)
{
	CString message_id;
	CTime t = CTime::GetCurrentTime();
	message_id.Format("<%d%02d%02d.%02d%02d%02d.%d.%s>",
			t.GetYear(),
			t.GetMonth(),
			t.GetDay(),
			t.GetHour(),
			t.GetMinute(),
			t.GetSecond(),
			getpid(),
			g_ma(from)); // from͂ƃ[AhX|Kv
	return message_id;
}

void g_cstr_chop(CString &buf)
{
	if(buf.IsEmpty()) return;
	buf.TrimRight("\r\n");
	buf.TrimLeft("\t ");
}

CString g_cstr_chop2(CString buf)
{
	if(buf.IsEmpty()) return buf;
	buf.TrimRight("\r\n");
	buf.TrimLeft("\t ");
	return buf;
}

int g_cstr_rvs_find(CString org, LPCTSTR key, int start)
{
	int i=start;

	if(i >= org.GetLength())
		return -1;

	while(i > 0){
		if(org.GetAt(i) == (TCHAR)key)
			return i;

		i--;
	}
	return -1;
}

// e|[t@C쐬Ãt@Cւ̃pXԂ
CString g_get_tmp_file()
{
	// e|[t@C̃fBNg擾
	TCHAR tmp_path[MAX_PATH];
	DWORD d_result = GetTempPath(MAX_PATH, tmp_path);
	ASSERT(d_result);
	// t@C̍쐬
	TCHAR tmp_file[MAX_PATH];
	UINT u_result = GetTempFileName(tmp_path, _T("~ex"), 0, tmp_file);
	ASSERT(u_result);

	return tmp_file;
}

// directory폜֐iɂt@CSāj
BOOL g_delete_directory(LPCTSTR dir_path)
{
	CFileFind ff;
	CString path = dir_path;
	path.TrimRight('\\');
	BOOL r;

	r = ff.FindFile(path+"\\*.*");
	while(r){
		r = ff.FindNextFile();
		if(ff.IsDots())
			continue;
		if(ff.IsDirectory())
			g_delete_directory(path+"\\"+ff.GetFileName());
		else
			DeleteFile(path+"\\"+ff.GetFileName());
	}
	ff.Close();

	return RemoveDirectory(dir_path);
}

// logfontRs[֐
void g_logfont_copy(LOGFONT *dst, LOGFONT *org)
{
	dst->lfCharSet				= org->lfCharSet;
	dst->lfClipPrecision				= org->lfClipPrecision;
	dst->lfEscapement				= org->lfEscapement;
	strcpy(dst->lfFaceName, org->lfFaceName);
	dst->lfHeight				= org->lfHeight;
	dst->lfItalic				= org->lfItalic;
	dst->lfOrientation			= org->lfOrientation;
	dst->lfOutPrecision			= org->lfOutPrecision;
	dst->lfPitchAndFamily		= org->lfPitchAndFamily;
	dst->lfQuality				= org->lfQuality;
	dst->lfStrikeOut			= org->lfStrikeOut;
	dst->lfUnderline			= org->lfUnderline;
	dst->lfWeight				= org->lfWeight;
	dst->lfWidth				= org->lfWidth;
}

// timezone name ^ƁAtimezone offsetԂ֐
CString g_get_tzoffset_from_tzname(CString name)
{

	name.MakeUpper();

	CMapStringToString map;

	map.SetAt("NZDT",	"+1300");	// New Zealand Daylight Time (j[W[hĎ)
	map.SetAt("IDLE",	"+1200");	// International Date Line, East (ۓtύXA)
	map.SetAt("NZST",	"+1200");	// New Zealand Std Time (j[W[hW)
	map.SetAt("NZT",	"+1200");	// New Zealand Time (j[W[h)
	map.SetAt("AESST",	"+1100");	// Australia Eastern Summer Std Time (I[XgAWĎ)
	map.SetAt("ACSST",	"+1030");	// Central Australia Summer Std Time (I[XgAWĎ)
	map.SetAt("CADT",	"+1030");	// Central Australia Daylight Savings Time (I[XgAĎ)
	map.SetAt("SADT",	"+1030");	// South Australian Daylight Time (I[XgA암Ď)
	map.SetAt("AEST",	"+1000");	// Australia Eastern Std Time (I[XgAW)
	map.SetAt("EAST",	"+1000");	// East Australian Std Time (I[XgAW)
	map.SetAt("GST",	"+1000");	// Guam Std Time, USSR Zone 9 (OAWԁA\rGg^C][ 9)
	map.SetAt("LIGT",	"+1000");	// Melbourne, Australia (I[XgAA{)
	map.SetAt("ACST",	"+0930");	// Central Australia Std Time (I[XgAW)
	map.SetAt("CAST",	"+0930");	// Central Australia Std Time (I[XgAW)
	map.SetAt("SAT",	"+0930");	// South Australian Std Time (I[XgA암W)
	map.SetAt("AWSST",	"+0900");	// Australia Western Summer Std Time (I[XgAW)
	map.SetAt("JST",	"+0900");	// Japan Std Time, USSR Zone 8 ({WԁA\rGg^C][ 8)
	map.SetAt("KST",	"+0900");	// Korea Standard Time (؍W)
	map.SetAt("WDT",	"+0900");	// West Australian Daylight Time (I[XgAĎ)
	map.SetAt("MT",		"+0830");	// Moluccas Time (bJ)
	map.SetAt("AWST",	"+0800");	// Australia Western Std Time (I[XgAW)
	map.SetAt("CCT",	"+0800");	// China Coastal Time (pݎ)
	map.SetAt("WADT",	"+0800");	// West Australian Daylight Time (A[XgAĎ)
	map.SetAt("WST",	"+0800");	// West Australian Std Time (I[XgAW)
	map.SetAt("JT",		"+0730");	// Java Time (Java )
	map.SetAt("WAST",	"+0700");	// West Australian Std Time (I[XgAW)
	map.SetAt("IT",		"+0330");	// Iran Time (C)
	map.SetAt("BT",		"+0300");	// Baghdad Time (oO_bh)
	map.SetAt("EETDST",	"+0300");	// Eastern Europe Daylight Savings Time ([bpĎ)
	map.SetAt("CETDST",	"+0200");	// Central European Daylight Savings Time ([bpĎ)
	map.SetAt("EET",	"+0200");	// Eastern Europe, USSR Zone 1 ([bpԁA\rGg^C][ 1)
	map.SetAt("FWT",	"+0200");	// French Winter Time (tX~)
	map.SetAt("IST",	"+0200");	// Israel Std Time (CXGW)
	map.SetAt("MEST",	"+0200");	// Middle Europe Summer Time ([bpĎ)
	map.SetAt("METDST",	"+0200");	// Middle Europe Daylight Time ([bpĎ)
	map.SetAt("SST",	"+0200");	// Swedish Summer Time (XEF[fĎ)
	map.SetAt("BST",	"+0100");	// British Summer Time (CMXĎ)
	map.SetAt("CET",	"+0100");	// Central European Time ([bp)
	map.SetAt("DNT",	"+0100");	// Dansk Normal Tid (f}[NW)
	map.SetAt("DST",	"+0100");	// Dansk Standard Time (?) (f}[NW (?))
	map.SetAt("FST",	"+0100");	// French Summer Time (tXĎ)
	map.SetAt("MET",	"+0100");	// Middle Europe Time ([bp)
	map.SetAt("MEWT",	"+0100");	// Middle Europe Winter Time ([bp~)
	map.SetAt("MEZ",	"+0100");	// Middle Europe Zone ([bp)
	map.SetAt("NOR",	"+0100");	// Norway Standard Time (mEF[W)
	map.SetAt("SET",	"+0100");	// Seychelles Time (ZCVF)
	map.SetAt("SWT",	"+0100");	// Swedish Winter Time (XEF[f~)
	map.SetAt("WETDST",	"+0100");	// Western Europe Daylight Savings Time ([bpĎ)
	map.SetAt("GMT",	"+0000");	// Greenwish Mean Time (OjbWW)
	map.SetAt("WET",	"+0000");	// Western Europe ([bp)
	map.SetAt("WAT",	"-0100");	// West Africa Time (AtJ)
	map.SetAt("NDT",	"-0230");	// Newfoundland Daylight Time (j[t@hhĎ)
	map.SetAt("ADT",	"-0300");	// Atlantic Daylight Time (吼mĎ)
	map.SetAt("NFT",	"-0330");	// Newfoundland Standard Time (j[t@hhW)
	map.SetAt("NST",	"-0330");	// Newfoundland Standard Time (j[t@hhW)
	map.SetAt("AST",	"-0400");	// Atlantic Std Time (Canada) (吼mW (Ji_))
	map.SetAt("EDT",	"-0400");	// Eastern Daylight Time (AJĎ)
	map.SetAt("ZP4",	"-0400");	// GMT +4 
	map.SetAt("CDT",	"-0500");	// Central Daylight Time (AJĎ)
	map.SetAt("EST",	"-0500");	// Eastern Standard Time (AJW)
	map.SetAt("ZP5",	"-0500");	// GMT +5 
	map.SetAt("CST",	"-0600");	// Central Std Time (AJW)
	map.SetAt("MDT",	"-0600");	// Mountain Daylight Time (AJRxĎ)
	map.SetAt("ZP6",	"-0600");	// GMT +6 hours (OjbWW +6 )
	map.SetAt("MST",	"-0700");	// Mountain Standard Time (AJRxW)
	map.SetAt("PDT",	"-0700");	// Pacific Daylight Time (AJmĎ)
	map.SetAt("PST",	"-0800");	// Pacific Std Time (AJmW)
	map.SetAt("YDT",	"-0800");	// Yukon Daylight Time ([RĎ)
	map.SetAt("HDT",	"-0900");	// Hawaii/Alaska Daylight Time (nC/AXJĎ)
	map.SetAt("YST",	"-0900");	// Yukon Standard Time ([RW)
	map.SetAt("AHST",	"-1000");	// Alaska-Hawaii Std Time (AXJ-nCW)
	map.SetAt("CAT",	"-1000");	// Central Alaska Time (AXJ)
	map.SetAt("NT",		"-1100");	// Nome Time (m[)
	map.SetAt("IDLW",	"-1200");	// International Date Line, West (ۓtύXA)

	CString value;
	map.Lookup(name, value);
	return value;
}

// cstringmarkň͂܂ꂽr
void g_strip_part(CString &buf, char *mark)
{
	int start = 0;
	int end;
	while((start = buf.Find(mark, start)) != -1){
		end = buf.Find(mark, start+1);
		buf = buf.Left(start)+buf.Mid(end+1);
		start = start+1;
	}
}

// ɔpJi܂܂Ă邩ǂm߂
BOOL g_is_hankana(unsigned char *buf)
{
	unsigned char c = *buf;
	while(c != NULL){
		// 0xa0 -> 0xdf 
		if(c >= 0xa0 && c <= 0xdf){
			return TRUE;
		}
		c = *(++buf);
	}
	return FALSE;
}

int g_richedit_count_char(CString buf)
{
	buf.Replace("\r", "");
	return _mbsnccnt((const unsigned char *)buf.GetBuffer(0), buf.GetLength());
}