<?php

/*
 * postLdapAdmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * ѥ桼
 *
 * $RCSfile: admin_user_mod.php,v $
 * $Revision: 1.29 $
 * $Date: 2007/08/23 05:27:35 $
 **********************************************************/

include_once("../../lib/libcommon");
include_once("../../lib/libpage");
include_once("../../lib/libsess");
include_once("../../lib/libldap");

/********************************************************
ƥڡ
*********************************************************/

/* ֤μ */
define("MY_TAB", TAB_USER);

/* ѥ󤯤ꥹ */
$topic[0]["name"] = TOPIC_USER_CONTROL;
$topic[0]["url"] = "admin_user_menu.php";
$topic[1]["name"] = TOPIC_USER_SEARCH_MOD;
$topic[1]["url"] = "admin_user_search.php";
$topic[2]["name"] = TOPIC_USER_EDIT;
$topic[2]["url"] = "";

define("OPERATION", "桼");
define("MODE_LDAPDATA", 0);
define("MODE_POSTDATA", 1);

/***********************************************************
 * 饹: ˥塼
 **********************************************************/
Class my_page extends page {

    /***********************************************************
     * ܥǥɽʥС饤ɡ
     **********************************************************/
    function display_body() {

        global $sesskey;
        global $user;
        global $dispusr;
        global $mail;
        global $mode;
        global $ldapdata;
        global $userdn;

        $userdn = base64_encode($userdn);
        $userdn = str_rot13($userdn);

        /* hiddenϤǡǼ */
        $hiddendata['dn'] = $userdn;
        $hiddendata['uid'] = $user;
        $hiddendata['mail'] = $mail;
        $hiddendata['sk'] = $sesskey;
        $hiddendata['page'] = $_POST["page"];
        $hiddendata['filter'] = $_POST["filter"];

        if ($mode == MOD_MODE) {

            $postdata['user'] = $user;
            if (isset($ldapdata[0]["quotaSize"][0])) {
                $postdata['quota'] = to_MB($ldapdata[0]["quotaSize"][0]);
            }
 
            /* ž襢ɥ쥹˼ʬΥɥ쥹С
            Ф˥᡼ĤꡢʤлĤʤ */
            if (isset ($ldapdata[0]['mailForwardingAddr'][1])) {
                 $postdata['save'] = ON;
                 if ($ldapdata[0]['mail'][0] == $ldapdata[0]['mailForwardingAddr'][0]) {
                     $postdata['trans'] = $ldapdata[0]['mailForwardingAddr'][1];
                 } else {
                     $postdata['trans'] = $ldapdata[0]['mailForwardingAddr'][0];
                 }
            } else if (isset ($ldapdata[0]['mailForwardingAddr'][0])) {
                 $postdata['save'] = OFF;
                 $postdata['trans'] = $ldapdata[0]['mailForwardingAddr'][0];
            } 

            /* ᡼륨ꥢʬ */
            if (isset($ldapdata[0]['mailAlias'][0])) {
                $ldapalias = htmlspecialchars($ldapdata[0]['mailAlias'][0]);
                $part = explode("@", $ldapalias, 2);
                $postdata['alias'] = $part[0];
            }
        } elseif ($mode == POST_MOD_MODE) {
            $postdata = $_POST;
        }

        print_admin_form($mode, $postdata, $hiddendata);

    }

};

/*********************************************************
 * check_mod_data
 *
 * ϥեηå
 *
 * []
 *          &$data     ϥǡ
 * [֤]
 *          TRUE       
 *          FALSE      顼
 *
 **********************************************************/
function check_mod_data(&$data)
{
    global $err_msg;
    global $domain;
    global $ldapdata;
    $transes = array();

    $mail = $data['mail'];

    if ((!isset($ldapdata[0]['userPassword'][0])) || $data["pass"] != "" 
                                               || $data["re_pass"] != "") {
        /* ѥɤꤵƤʤȥǤХѥɤɬ */
        if ($data["pass"] == "") {
            $err_msg = "ѥɤꤵƤޤ";
            return FALSE;
        }
        /* ѥɤΥå(ɬ) */
        if (check_passwd($data["pass"], MINPASSWD, MAXPASSWD) === FALSE) {
            return FALSE;
        }
        /* ѥɡѥ(ǧ)ΰץå */
        if ($data["pass"] != $data["re_pass"]) {
            $err_msg = "ѥɤפޤ";
            return FALSE;
        }
    }

    /* ᡼ܥå̤Υå(ɬ) */
    if ($data["quota"] != "") {
        if (check_diskquota($data["quota"]) === FALSE) {
            return FALSE;
        }
    }

    /* ᡼륨ꥢΥå */
    if ($data["alias"] != "") {
        if ($data["alias"] == $data["uid"]) {
            $err_msg = "᡼륨ꥢ桼̾ȽʣƤޤ";
            return FALSE;
        }
        if (check_name($data["alias"], MAXNAME) === FALSE) {
            $err_msg = "᡼륨ꥢηǤ";
            return FALSE;
        }
    }

    /* ᡼žɥ쥹Υå */
    if ($data["trans"] != "") {
        if (check_mail ($data["trans"]) === FALSE) {
            $err_msg = "᡼žɥ쥹ηǤ";
            return FALSE;
        }
        /* ᡼¸å */
        if (!isset($data["save"])) {
            $err_msg = "᡼Ĥ/Ĥʤ꤬Ƥޤ";
            return FALSE;
        } elseif (check_flg($data["save"]) === FALSE) {
            $err_msg = "᡼Ĥ/ĤʤͤǤ";
            return FALSE;
        }
    }
    /* ᡼륨ꥢνʣå */
    if ($data["alias"] != "") {
        $data["mailAlias"] = $data["alias"] . "@" . $domain;
        /* ꥢ񤭴ե饰ǥեȤON */
        $chflg = ON;

        if (isset($ldapdata[0]["mailAlias"][0])) {
            /* ꥢѹʤн񤭴ե饰:OFF */
            if ($data["mailAlias"] == $ldapdata[0]["mailAlias"][0]) {
                $chflg = OFF;
            }
        }

        /* ꥢѹСʣå */
        if ($chflg == ON) {
            $ret = check_duplicate($data["mailAlias"]);
            if ($ret == LDAP_FOUNDUSER) {
                $err_msg = "᡼륨ꥢϴ˻ȤƤޤ";
                return FALSE;
            } elseif ($ret == LDAP_ERRUSER) {
                return FALSE;
            }
        }
    }

    /* ᡼žɥ쥹Υå */
    if ($data['trans'] != "") {
        if ($data['trans'] == $mail) {
            $err_msg = "᡼žɥ쥹᡼륢ɥ쥹ȽʣƤޤ";
            return FALSE;
        }
        if (isset($data["mailAlias"]) && $data['trans'] == $data["mailAlias"]) {
            $err_msg = "᡼žɥ쥹᡼륨ꥢȽʣƤޤ";
            return FALSE;
        }
        if ($data["save"] == ON) {
            /* ᡼Ĥξžɥ쥹˼᡼륢ɥ쥹ɲ */
            array_push($transes, $mail);
        }
        if ($data["trans"] != "") {
            array_push($transes, $data["trans"]);
        }
    
        $data["transes"] = $transes;
    }
    return TRUE;
}


/*********************************************************
 * mod_user
 *
 * 桼ν
 *
 * []
 *          $data  桼γǼ줿Ϣ
 * [֤]
 *          TRUE   
 *          FALSE  顼
 *
 **********************************************************/
function mod_user($data)
{
    global $err_msg;
    global $domain;
    global $user;
    global $ldapdata;
    global $web_conf;
    global $userdn;

    if (isset($data["mailAlias"])) {
        $alias = $data["mailAlias"];
    } else {
        $alias = "";
    }
    if (isset($data["alias"])) {
        $alias_name = $data["alias"];
    } else {
        $alias_name = "";
    }
    if (isset($data["transes"])) {
        $transes = $data["transes"];
    } else {
        $transes = array();
    }

    if ($data["pass"] != "") {
        $attrs['userPassword'] = CRYPT . my_crypt($data["pass"]);
    }

    /* ǥ̤ѹʤк */
    if ($data["quota"] != "") {
        $attrs["quotaSize"] = $data["quota"] * 1024 * 1024;
    } else {
        $attrs["quotaSize"] = array();
    }

    /* Х᡼륨ꥢѹʤк */
    if ($alias != "") {
        $attrs["mailAlias"] = $alias;
    } else {
        $attrs["mailAlias"] = array();
    } 

    /* ᡼žɥ쥹γǼ */
    if (count($transes) != 0) {
        $attrs["mailForwardingAddr"] = $transes;
    } else {
        $attrs["mailForwardingAddr"] = array();
    }

    /* ᡼ǥ쥯ȥ°ʤк */
    if (!isset($ldapdata[0]["mailDirectory"][0])) {
        $attrs["mailDirectory"] = $web_conf["basemaildir"] . "/" . $user . "/";
    }

    /* LDAPǡι */
    $ret = LDAP_mod_entry($userdn, $attrs);
    if ($ret !== LDAP_OK && $ret != LDAP_ERR_NOATTR) {
        return FALSE;
    }

    return TRUE;
}

/*********************************************************
 * del_user
 *
 * 桼
 *
 * []
 *         $user    оݥ桼
 * [֤]
 *         TRUE     
 *         FALSE    顼
 *
 **********************************************************/
function del_user($user)
{
    global $err_msg;
    global $web_conf; 
    global $domain; 
    global $userdn;
    global $ldapdata;

    $maildir = "";

    $delmail = $user . "@" . $domain;

    /* LDAPΥȥ */
    $ret = LDAP_del_entry($userdn);
    if ($ret == LDAP_ERR_NODATA) {
        /* ¸ߤʤ */
        $err_msg = "";
    } elseif ($ret != LDAP_OK) {
        return FALSE;
    }

    /* ᡼ǥ쥯ȥ¸ߥå */
    if (isset($ldapdata[0]['mailDirectory'][0])) {
        $maildir = $ldapdata[0]['mailDirectory'][0];
    }
    if ($maildir != "" && is_dir ($maildir)) {
        /* ᡼ǥ쥯ȥޥɤ¹ */
        $delcmd = $web_conf['maildelcommand'] . " " . $maildir . " > /dev/null 2>&1";
        system ($delcmd, $cmd_st);
        if ($cmd_st != 0) {
            $err_msg = "᡼ǥ쥯ȥޥɤμ¹Ԥ˼Ԥޤ";
            result_log (OPERATION . ":NG:ޥɡ" . $delcmd . "פμ¹Ԥ˼Ԥޤ");
            return FALSE;
        }
    }

    /* ᡼󥰥ꥹȥɥ쥹 */
    $dn = sprintf(SEARCH_DN, $web_conf['ldaplistsuffix'], $web_conf['ldapbasedn']);
    $filter = "(mailForwardingAddr=" . $delmail . ")";
    $attrs = array(); 

    $ret = main_get_entry($dn, $filter, $attrs, $web_conf['ldapscope'], $mldata);
    if ($ret == LDAP_ERR_NODATA) {
        /* ¸ߤʤϤʤˤ⤷ʤ */
        $err_msg = "";
    } elseif ($ret != LDAP_OK) {
        return FALSE;
    } else {
        /* ᡼륢ɥ쥹° */
        for ($i = 0; isset($mldata[$i]["mail"][0]); $i++) {
            $del_mldn = sprintf(ADD_DN, $mldata[$i]["mail"][0], 
                                $web_conf['ldaplistsuffix'], $web_conf['ldapbasedn']);
            $fwaddr = array();
            $modaddr = array();

            foreach ($mldata[$i]["mailForwardingAddr"] as $each) {
                if ($each != $delmail) {
                    array_push($fwaddr, $each);
                }
            }
            $modaddr["mailForwardingAddr"] = $fwaddr;
            $ret = LDAP_mod_entry($del_mldn, $modaddr);
            if ($ret !== LDAP_OK && $ret != LDAP_ERR_NOATTR) {
                return FALSE;
            }
            result_log(OPERATION . ":OK:" . "᡼󥰥ꥹȡ" . 
                      $mldata[$i]["mail"][0] . "פ桼ޤ");
        }
    }
    return TRUE; 
}

/***********************************************************
 * 
 **********************************************************/
/* 󥹥󥹺 */
$pg  = new my_page();
if (isset($_POST["sk"])) {
    $sesskey = $_POST["sk"];
} 

/* 桼Ǽ */
if (isset($_POST["dn"])) {
    $userdn = $_POST["dn"];
    $userdn = str_rot13($userdn);
    $userdn = base64_decode($userdn);
}
if (isset($_POST["page"])) {
    $page = $_POST["page"];
}
if (isset($_POST["filter"])) {
    $filter = $_POST["filter"];
}

/* ɥᥤ */
$domain = $_SERVER['DOMAIN'];

/* եɹ */
$ret = read_web_conf();
if ($ret === FALSE) {
    $sys_err = TRUE;
    $pg->display(null, null);
    exit (1);
}

/* Ź沽Υѥ򥻥å */
$admkey_file = BASEDIR . ETCDIR . $domain . "/" . ADMKEY;

/* å */
if (isset($sesskey) === FALSE) {
    header("Location: index.php?e=2");
    exit (1);
}

/* åå */
if (is_sysadm($sesskey) !== TRUE) {
   header("Location: index.php?e=1");
   exit (1);
}

/* 顼å */
$err_msg = "";

/***********************************************************
 * main
 **********************************************************/
/* ʬ */

/* 桼μ */
$ret = get_userdata($userdn);
if ($ret === FALSE) {
    if (isset ($_POST['delete'])) {
        $err_msg = "ꤵ줿桼ϤǤ˺Ƥޤ";
    }
    result_log(OPERATION . ":NG:" . $err_msg);
    $sys_err = TRUE;
    $pg->display(null, null);
    exit (1);
}

$user = $ldapdata[0]["uid"][0];

$dispattr = $web_conf['displayuser'];
$dispusr = $ldapdata[0][$dispattr][0];

/* ᡼륢ɥ쥹Ǽ */
$mail = $ldapdata[0]["mail"][0];

if (isset($_POST['modify'])) {

    /* ⡼ */
    $mode = POST_MOD_MODE;

    /* ϥǡΥå */
    if (check_mod_data($_POST) === FALSE ||
        mod_user($_POST) === FALSE) {
        result_log(OPERATION . ":NG:" . $err_msg);
    } else {
        $err_msg = "桼򹹿ޤ(" . $dispusr . ")";
        result_log(OPERATION . ":OK:" . $err_msg);

        /* ̤ */
        dgp_location_search("admin_user_search.php", $err_msg);
        exit;
    }
} elseif (isset($_POST["delete"])) {

    $mode = POST_MOD_MODE;

    /* 桼 */
    if ($user != "" && del_user($user) === FALSE) {
        result_log(OPERATION . ":NG:" . $err_msg);
    } else {
        $err_msg = "桼ޤ(" . $dispusr . ")";
        result_log(OPERATION . ":OK:" . $err_msg);

        /* ̤ */
        dgp_location_search("admin_user_search.php", $err_msg);
        exit;
    }

} elseif (isset($_POST["cancel"])) {

    /* ̤ */
    dgp_location_search("admin_user_search.php", $err_msg);
    exit;

} else {

    /* LDAPǡ⡼ */
    $mode = MOD_MODE;
}



/***********************************************************
 * ɽ
 **********************************************************/

/* ڡν */
$pg->display($topic, MY_TAB);

?>
