<?php

/*
 * postLdapAdmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * ѥ桼
 *
 * $RCSfile: admin_user_search.php,v $
 * $Revision: 1.13 $
 * $Date: 2007/08/24 06:55:27 $
 **********************************************************/

include_once("../../lib/libcommon");
include_once("../../lib/libpage");
include_once("../../lib/libsess");
include_once("../../lib/libldap");

/********************************************************
ƥڡ
*********************************************************/

/* ֤μ */
define("MY_TAB", TAB_USER);

/* ѥ󤯤ꥹ */
$topic[0]["name"] = TOPIC_USER_CONTROL;
$topic[0]["url"] = "admin_user_menu.php";
$topic[1]["name"] = TOPIC_USER_SEARCH_MOD;
$topic[1]["url"] = "";

define("OPERATION", "桼");
define("STATUS_INPUT",  0);
define("STATUS_SEARCH", 1);

/***********************************************************
 * 饹: ˥塼
 **********************************************************/
Class my_page extends page {

    /***********************************************************
     * ܥǥɽʥС饤ɡ
     **********************************************************/
    function display_body() {
        print_form();
    }
};

/*********************************************************
 * print_form
 *
 * ϥե
 *
 * []
 *        ʤ
 *
 * [֤]
 *        ʤ
 *
 **********************************************************/
function print_form()
{
    global $web_conf;
    global $status;
    global $sesskey;

    if (isset($_POST['name'])) {
        $name = htmlspecialchars($_POST['name']);

        /* ޥå */
        if ($_POST["name_match"] == 0) {
            $name_inc_flg = "selected";
            $name_mat_flg = "";
        } elseif ($_POST["name_match"] == 1) {
            $name_mat_flg = "selected";
            $name_inc_flg = "";
        }
    } else {
        $name ="";
        $name_inc_flg = "selected";
        $name_mat_flg = "";
    }

    print <<<EOD

<form method="post" name="all" action="admin_user_search.php">
<b>桼θ</b><br><br>
<table class="normal">
    <tr>
        <td class="normal" style="text-align:right;">
          桼̾
        </td>
        <td class="normal">
          <input type="text" size="30" name="name" value="{$name}" maxlength="256">
          <select name="name_match">
              <option value="0" {$name_inc_flg}>ޤ</option>
              <option value="1" {$name_mat_flg}>Ȱפ</option>
          </select>
        </td>
    </tr>
</table>

<br>
<input type="hidden" name="sk" value="$sesskey">
<input type="submit" name="search" value="    ">
EOD;

    if ($status == STATUS_INPUT) {
        print_title(0, null);
    } else {
        print_result();
    }
        print <<<EOD
</table>
</form>
EOD;
}

/*********************************************************
 * print_title
 *
 * ̤Υȥ
 *
 * []
 *          $sum     ̤ι׿
 *          $filter  ѥե륿
 *
 * [֤]
 *          ʤ
 *
 **********************************************************/
function print_title($sum, $filter)
{
    global $web_conf;
    global $sesskey;
    global $page;
    global $filter_disp;

    /* ڡֹ0ϤޤäƤ */
    $all_page = (int) ceil(($sum / $web_conf["lineperpage"]));
    if ($all_page == 0) {
        $all_page = 1;
    }

    /* ɽƤǸΰ硢Υڡɽ */
    $ret = $sum % $all_page;
    if ($ret == 0 && $all_page < $page + 1) {
        $page = $page - 1;
    } 

    if ($page != 0) {
        $tmp = $page - 1;
        $pre = "<a href=\"#\" onClick=\"allSubmit('admin_user_search.php', '$tmp', '')\">ڡ</a>";
        $next = "";
    } else {
        $pre = "";
        $next = "";
    }

    if ($page != $all_page - 1) {
        $tmp = $page + 1;
        $next = "<a href=\"#\" onClick=\"allSubmit('admin_user_search.php', '$tmp', '')\">ڡ</a>";
    }

    $filter_disp = base64_encode($filter);
    $filter_disp = str_rot13($filter_disp);
    print <<<EOD

<script type="text/javascript">
<!--
function allSubmit(url, page, dn) {
    document.all.action = url;
    document.all.page.value = page;
    document.all.dn.value = dn;
    document.all.submit();
}
// -->
</script>

<br>
<br>
<input type="hidden" name="filter" value="{$filter_disp}">
<input type="hidden" name="page" value="{$page}">
<input type="hidden" name="sk" value="{$sesskey}">
<input type="hidden" name="sum" value="{$sum}">
<input type="hidden" name="dn">
<table class="table">
    <tr>
        <td class="search_sum">[ $sum ]</td>
        <td colspan="5" class="search_tmp" style="border:1px solid #000000;">
          <table class="guide" align="right">
            <tr>
              <td class="search_prev">$pre</td>
              <td class="search_next">$next</td>
            </tr>
          </table>  
        </td>
    </tr>
    <tr>
        <td class="search_name">桼̾</td>
        <td class="search_name">᡼륨ꥢ</td>
        <td class="search_trans">᡼žɥ쥹</td>
        <td class="search_quota">᡼</td>
        <td class="search_ref"></td>
    </tr>

EOD;

}

/*********************************************************
 * print_result
 *
 * ̽
 *
 * []
 *       ʤ
 *
 * [֤]
 *       ʤ
 **********************************************************/
function print_result()
{
    global $web_conf;
    global $ldap_result;
    global $dispusr;
    global $filter;
    global $page;
    global $limit_adm;

    /* ̤ɽ°̾ǥ */
    if (isset($ldap_result)) {
        usort($ldap_result, "user_sort");
        reset($ldap_result);
        $sum = count($ldap_result);
    } else {
        $sum = 0;
    }

    /* ơ֥Υȥɽ */
    print_title($sum, $filter);

    $i = $web_conf["lineperpage"] * $page;
    $tmp = $i + $web_conf["lineperpage"];

    /* ɽ */
    $max = ($tmp < $sum) ? $tmp : $sum;

    while ($i < $max) {

        /* dnǼ */
        $userdn = $ldap_result[$i]["dn"];
        $userdn = base64_encode($userdn);
        $userdn = str_rot13($userdn);
        $userdn = htmlspecialchars($userdn);

        /*  */
        $alias = "";
        $trans = "";
        $quota = "";

        /* 桼̾Ǽ */
        $name = htmlspecialchars($ldap_result[$i][$dispusr][0]);

        /* ꥢǼ */
        if (isset($ldap_result[$i]["mailAlias"])) {
            $mailalias = htmlspecialchars($ldap_result[$i]["mailAlias"][0]);
            $part = explode("@", $mailalias, 2);
            $alias = $part[0];
        }

        /* žɥ쥹Ǽ */
        if (isset($ldap_result[$i]['mailForwardingAddr'][0])) {
            if ($ldap_result[$i]['mailForwardingAddr'][0] != $ldap_result[$i]['mail'][0]) {
                $trans = $ldap_result[$i]['mailForwardingAddr'][0];
            } else {
                $trans = $ldap_result[$i]['mailForwardingAddr'][1];
            }
        }

        /* ᡼̤Ǽ */
        if (isset($ldap_result[$i]["quotaSize"][0])) {
            $quota = to_MB($ldap_result[$i]["quotaSize"][0]) . "M";
        }

    print <<<EOD

    <tr>
        <td class="value">{$name}</td>
        <td class="value_alias">{$alias}</td>
        <td class="value_trans">{$trans}</td>
        <td class="value_right">{$quota}</td>
        <td class="value_center"><a href="#" onClick="allSubmit('admin_user_mod.php', '$page', '$userdn')">Խ</a></td>
    </tr>

EOD;
        $i++;
    }

}

/*********************************************************
 * form_check
 *
 * ϥեηå
 *
 * []
 *           $data    åǡϢ
 *
 * [֤]
 *           TRUE     
 *           FALSE    顼
 *
 **********************************************************/
function form_check($data)
{
    global $err_msg;

    /* 桼̾ηå */
    $ret = check_search_name($data['name']);
    if ($ret === FALSE) {
        $err_msg = "桼̾ηǤ";
        return FALSE;
    }	

    /* 桼Υå */
    $ret = check_flg($data['name_match']);
    if ($ret === FALSE) {
        $err_msg = "桼̾θ郎Ǥ";
        return FALSE;
    }	

    return TRUE;
}


/***********************************************************
 * 
 **********************************************************/
/* 󥹥󥹺 */
$pg  = new my_page();
if (isset($_POST["sk"])) {
    $sesskey = $_POST["sk"];
}

/* ɥᥤ */
$domain = $_SERVER['DOMAIN'];

/* եɹ */
$ret = read_web_conf();
if ($ret === FALSE) {
    $sys_err = TRUE;
    $pg->display(null, null);
    exit (1);
}

/* Ź沽Υѥ򥻥å */
$admkey_file = BASEDIR . ETCDIR . $domain . "/" . ADMKEY;

/* ơ */
if (isset($_POST["search"]) || isset($_POST["filter"])) {
    $status = STATUS_SEARCH;
} else {
    $status = STATUS_INPUT;
}

/* å */
if (isset($sesskey) === FALSE) {
    header("Location: index.php?e=2");
    exit (1);
}

/* åå */
if (is_sysadm($sesskey) !== TRUE) {
    header("Location: index.php?e=1");
    exit (1);
}

/* 顼å */
if (isset($_POST["msg"])) {
    $err_msg = $_POST["msg"];
} else {
    $err_msg = "";
}

/***********************************************************
 * main
 **********************************************************/

$logstr = OPERATION;

/* ɽ° */
$dispusr = $web_conf['displayuser'];

/* ʬ */

if ($status == STATUS_SEARCH) {
    if (isset($_POST["search"]) && form_check($_POST) === FALSE) {
        /* ܥ󤬲졢ϤǤСϤʤ */
        $status = STATUS_INPUT;
        $logstr .= ":NG:" . $err_msg;
        result_log($logstr);
    } else {
        /* Υե륿 */
        if (!isset($_POST["search"]) && $_POST["filter"] != "") {
            $filter = str_rot13($_POST["filter"]);
            $filter = base64_decode($filter);
            $page = $_POST["page"];
        } else {
            /* ե륿 */
            $filter = mk_filter($_POST["name"], $_POST["name_match"]);
            /* Τϡɽ°ĥȥΤ */
            $filter = "(&($dispusr=*)$filter)";
            $page = 0;
        }
        $search_dn = sprintf(SEARCH_DN, $web_conf["ldapusersuffix"], 
                                        $web_conf["ldapbasedn"]);
        $ret = main_get_entry($search_dn, $filter, array(), $web_conf['ldapscope'], $ldap_result);
        if ($ret == LDAP_ERR_NODATA ) {
            $err_msg = "ꤵ줿桼ϸĤޤǤ";
        } elseif ($ret != LDAP_OK) {
            $status = STATUS_INPUT;
            $logstr .= ":NG:" . $err_msg;
            result_log($logstr);
        }

        /* ¾Υڡۤåɽ */
        if (isset($_POST["msg"])) {
            $err_msg = $_POST["msg"];
        }
    }
} 

/***********************************************************
 * ɽ
 **********************************************************/

/* ڡν */
$pg->display($topic, MY_TAB);

?>
