/*
 *  psychlops_devices_nidaqmxbase.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/07/30 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_DEVICES_UTIL
#define HEADER_PSYCHLOPS_DEVICES_UTIL

#include "../../core/devices/psychlops_io_analog.h"
#include "../../core/devices/psychlops_io_clock.h"

namespace Psychlops {

namespace Devices {

	class OscillationSimulator : public AnalogInput {
		public:
		double frequency, amplitude, internal_phase;
		double (*waveform)(double);

		OscillationSimulator();
		OscillationSimulator(double freq, double amp = 1, double phase = 0);
		double get();
	};


	class ClockOscillator : public AnalogInput {
		Clock clock;
		public:
		double frequency, amplitude, internal_phase;
		double (*waveform)(double);

		ClockOscillator();
		ClockOscillator(double freq, double amp = 1, double phase = 0);
		double get();
	};


	class MouseX : public AnalogInput {
		double factor;
		public:
		MouseX();
		MouseX(const double factor);
		virtual ~MouseX();
		virtual double get();
//		virtual double normalize(double);
	};

}

}	/*	<- namespace Psycholops 	*/



#endif
