/*
 *  psychlops_app_main_Win32.h
 *  Psychlops Standard Library (Win32)
 *
 *  Last Modified 2006/01/09 by Kenchi HOSOKAWA
 *  (C) 2006 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */


#ifndef HEADER_PSYCHLOPS_APP_MAIN_WIN32
#define HEADER_PSYCHLOPS_APP_MAIN_WIN32


#include <windows.h>
#include "../../psychlops_lib.h"
#include "../../core/ApplicationInterfaces/psychlops_app_init.h"
#include "psychlops_app_state_Win32.h"



//namespace Psychlops {

	void psychlops_main();

//}	/*	<- namespace Psycholops 	*/


extern "C" int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int iCmdShow) {

	MSG msg;
	msg.wParam = 0;
	Psychlops::APIApplicationProperties::startupinfo.set(hInstance, hPrevInstance, lpCmdLine, iCmdShow);

	try {

		//	giveio.sys
		//HANDLE h = CreateFile(CreateFile("\\\\.\\giveio", GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		//if(h == INVALID_HANDLE_VALUE) throw "INVALID_HANDLE_VALUE";
		//CloseHandle(h);

		HANDLE hProcess = GetCurrentProcess();
		SetPriorityClass(hProcess,NORMAL_PRIORITY_CLASS);

		Psychlops::initialize();
		psychlops_main();
		Psychlops::finalize();


	} catch(Psychlops::Exception e) {
//		if(e.ti_ == typeid(Psychlops::APIInputProperties)) {
//			if(Psychlops::Display::the_canvas!=NULL) Psychlops::Display::the_canvas->release();
//		}
		MessageBox( NULL, e.to_s().c_str(), "Psychlops Notification", MB_OK );
		//Psychlops::APIApplicationProperties::analyzeAPIError();
	} catch(Psychlops::Exception *e) {
		MessageBox( NULL, e->to_s().c_str(), "Psychlops Notification", MB_OK );
	} catch(std::exception e) {
		MessageBox( NULL, e.what(), "Psychlops Notification : std lib exception", MB_OK );
	} catch(char* str) {
		MessageBox( NULL, str, "Psychlops Notification", MB_OK );
		//Psychlops::APIApplicationProperties::analyzeAPIError();
	}

//	return 0;
	return msg.wParam;

}

//DWORD WINAPI entryMainThread(LPVOID vdParam);


#endif
