#include <psychlops.h>
using namespace Psychlops;	// Initially developed with Psychlops Win32 1.3.5 / 20091031



void RectLuminance() {
	double rect_size = 100;
	double rect_lum  = 0.5;
	double bg_lum    = 0.2;

	Psychlops::Rectangle rect(rect_size,rect_size);
	rect.centering();

	Range rng;
	Independent << rect_size | "Rect Size"      |   1< rng< 500 | 10.0 | 2.0 ;
	Independent << rect_lum  | "Rect Luminance" | 0.0<=rng<=1.0 |  0.1 | 0.05;
	Independent << bg_lum    | "BG Luminance"   | 0.0<=rng<=1.0 |  0.1 | 0.05;


	while(!Input::get(Keyboard::esc)) {
		Display::clear(Color(bg_lum));
		rect.resize(rect_size,rect_size);
		rect.draw(rect_lum);
		Display::flip();
	}

}


void psychlops_main() {

	Canvas display(Canvas::fullscreen);

	Procedure p;
	p.setDesign(Procedure::DEMO);
	p.setProcedure(RectLuminance);
	p.run();

}

