//
//  PT1.h
//

#import <Cocoa/Cocoa.h>
#import "UserKernelShared.h"


@interface PT1 : NSObject
{
    io_connect_t _connect;
    vm_address_t _buffer;
    vm_size_t    _bufsize;
    BufferInfo   _bufferInfo;
    BOOL         _open;
}

+ (NSArray *)scan;

- (id)init:(io_service_t)service;

- (void)dealloc;

- (BOOL)getDeviceInfo:(DeviceInfo *)info;

- (int)open;
- (int)close;
- (int)getPciClockCounter:(uint32_t *)counter;
- (int)setPciLatencyTimer:(uint8_t)latencyTimer;
- (int)getPciLatencyTimer:(uint8_t *)latencyTimer;
- (int)setLnbPower:(LnbPower)lnbPower;
- (int)getLnbPower:(LnbPower *)lnbPower;
- (int)setLnbPowerWhenClose:(LnbPower)lnbPower;
- (int)getLnbPowerWhenClose:(LnbPower *)lnbPower;
- (int)setTunerPowerReset:(TunerPowerReset)tunerPowerReset;
- (int)getTunerPowerReset:(TunerPowerReset *)tunerPowerReset;
- (int)initTuner:(uint32_t)tuner;
- (int)setTunerSleep:(uint32_t)tuner isdb:(ISDB)isdb sleep:(BOOL)sleep;
- (int)getTunerSleep:(uint32_t)tuner isdb:(ISDB)isdb sleep:(BOOL *)sleep;
- (int)setFrequency:(uint32_t)tuner isdb:(ISDB)isdb channel:(uint32_t)channel offset:(int32_t)offset;
- (int)getFrequency:(uint32_t)tuner isdb:(ISDB)isdb channel:(uint32_t *)channel offset:(int32_t *)offset;
- (int)getFrequencyOffset:(uint32_t)tuner isdb:(ISDB)isdb clock:(int32_t *)clock carrier:(int32_t *)carrier;
- (int)getCnAgc:(uint32_t)tuner isdb:(ISDB)isdb cn100:(uint32_t *)cn100 currentAgc:(uint32_t *)currentAgc maxAgc:(uint32_t *)maxAgc;
- (int)setIdS:(uint32_t)tuner tsid:(uint32_t)tsid;
- (int)getIdS:(uint32_t)tuner tsid:(uint32_t *)tsid;
- (int)getCorrectedErrorRate:(uint32_t)tuner isdb:(ISDB)isdb layerIndex:(LayerIndex)layerIndex errorRate:(ErrorRate *)errorRate;
- (int)resetCorrectedErrorCount:(uint32_t)tuner isdb:(ISDB)isdb;
- (int)getErrorCount:(uint32_t)tuner isdb:(ISDB)isdb count:(uint32_t *)count;
- (int)getTmccS:(uint32_t)tuner tmcc:(TmccS *)tmcc;
- (int)getLayerS:(uint32_t)tuner layer:(LayerS *)layer;
- (int)getTmccT:(uint32_t)tuner tmcc:(TmccT *)tmcc;
- (int)getLockedT:(uint32_t)tuner locked:(BOOL [LAYER_COUNT_T])locked;
- (int)setLayerEnable:(uint32_t)tuner isdb:(ISDB)isdb layerMask:(LayerMask)layerMask;
- (int)getLayerEnable:(uint32_t)tuner isdb:(ISDB)isdb layerMask:(LayerMask *)layerMask;
- (int)setBufferInfo:(const BufferInfo *)bufferInfo;
- (int)getBufferInfo:(BufferInfo *)bufferInfo;
- (int)getBufferPtr:(uint32_t)index ptr:(void **)ptr;
- (int)resetTransferCounter;
- (int)incrementTransferCounter;
- (int)setStreamEnable:(uint32_t)tuner isdb:(ISDB)isdb enable:(BOOL)enable;
- (int)getStreamEnable:(uint32_t)tuner isdb:(ISDB)isdb enable:(BOOL *)enable;
- (int)setStreamGray:(uint32_t)tuner isdb:(ISDB)isdb gray:(uint32_t)gray;
- (int)getStreamGray:(uint32_t)tuner isdb:(ISDB)isdb gray:(uint32_t *)gray;
- (int)setTransferEnable:(BOOL)enable;
- (int)getTransferEnable:(BOOL *)enable;
- (int)getTransferInfo:(TransferInfo *)transferInfo;

@end