//
//
//

#import <Cocoa/Cocoa.h>

#import "PT1.h"

#import "SampleStream.h"

#define kVirtualSize        4
#define kVirtualCount       16
#define kLockSize           4
#define kBufferPageCount    511
#define kPageSize           4096
#define kBlockCount         2
#define kBlockSize          (kPageSize * kBufferPageCount / kBlockCount)

@interface SampleBuffer : NSObject
{
    PT1 *_pt1;
    uint8_t _buffer[kBlockSize];
    SampleStream *_stream[4];

    NSLock *_transferLock;
    bool _transfer;
    bool _stop;
    uint _virtualIndex;
    uint _imageIndex;
    uint _blockIndex;
}

- (id)initWithPT1:(PT1 *)pt1;
- (bool)transfer:(bool)enable;

@end
