//
//  Stream.h
//

#import <Cocoa/Cocoa.h>

#include <stdio.h>

#import "PT1.h"

#define kPacketSize 188
#define kPageSize 4096
#define kPageCount 47

@interface SampleStream : NSObject
{
    uint8_t _buffer[kPageSize * kPageCount];
    FILE *_fp;
    int _fd;
    uint _count;
    uint _packetCount;
    uint _packetOffset;
}

- (id)initWithTuner:(uint)tuner isdb:(uint)isdb;
- (id)initWithTuner:(uint)tuner isdb:(uint)isdb fifo:(BOOL)fifo;
- (void)reset;
- (void)addPacket:(uint)packet;

@end
