######################################################################
# ck.inc.pl - This is PyukiWiki, yet another Wiki clone.
# $Id: ck.inc.pl,v 1.74 2011/10/19 22:07:03 papu Exp $
#
# "PyukiWiki" version 0.2.0-alpha16 $$
# Author: Nanami http://nanakochi.daiba.cx/
# Copyright (C) 2004-2011 by Nekyo.
# http://nekyo.qp.land.to/
# Copyright (C) 2005-2011 PyukiWiki Developers Team
# http://pyukiwiki.sourceforge.jp/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sourceforge.jp/
# License: GPL2 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:LF Code=UTF-8 1TAB=4Spaces
######################################################################
# for linktrack.inc.cgi
######################################################################

use strict;
require "plugin/counter.inc.pl";

sub plugin_ck_action {
	my $lk=$::form{lk};
	my $r=$::form{r};
	my $test=$lk;
	$test=~s/[0-9A-Z]?//g;
	if($test eq '') {
		my $url=&undbmname($lk);
		&plugin_counter_do("link\_$url","w");
		if($r eq "y") {
			print &http_header("Status: 204\n\n");
		} else {
			print &http_header("Status: 302","Location: $url\n\n");
		}
		exit;
	}
	print <<EOM;
Content-type: text/plain

Forbidden
EOM
exit;
}

1;
__END__
=head1 NAME

ck.inc.pl - PyukiWiki Plugin

=head1 SYNOPSIS

 ?cmd=ck&amp;lk=hex encoded url

=head1 DESCRIPTION

This plugin is explugin is count of tracking of linktrack.inc.cgi

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/Standard/ck

L<http://pyukiwiki.sourceforge.jp/PyukiWiki/Plugin/Standard/ck/>

=item PyukiWiki CVS

L<http://sourceforge.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/plugin/ck.inc.pl?view=log>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.sourceforge.jp/>

=back

=head1 LICENSE

Copyright (C) 2005-2011 by Nanami.

Copyright (C) 2005-2011 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 2 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
