#==============================================================================
#  Window_Menu
#------------------------------------------------------------------------------
# EBhEj[
# Copyright (C) 2005 fukuyama
#==============================================================================

class Window_Menu < Window_Base
  include Event_Handling_Module

  #--------------------------------------------------------------------------
  #  JCX^Xϐ
  #--------------------------------------------------------------------------
  attr_reader   :index                    # J[\ʒu
#  attr_reader   :help_window              # wvEBhE

  TITLE_HEIGHT = 1.2
  DEFAULT_ITEM_HEIGHT = 32

  #--------------------------------------------------------------------------
  # j[
  #--------------------------------------------------------------------------
  class Menu
    attr_accessor :name   # j[
    attr_accessor :handler # j[nh
    def initialize(name, handler)
      @name = name
      @handler = handler
    end
  end

  #---------------------------------------------------------------------------
  # 
  #---------------------------------------------------------------------------
  def initialize(*arg)
    @menus = [] if @menus.nil?
    super(0, 0, 0, 0)

    @item_max = 1 if @item_max.nil?

    @column_max = 1 if @column_max.nil?
    @row_max = -1 if @row_max.nil?
    @index = -1 if @index.nil?
    @cellspacing = Rect.new(4,0,4,0) if @cellspacing.nil?
    @item_height = DEFAULT_ITEM_HEIGHT if @item_height.nil?

    pack
  end
  #---------------------------------------------------------------------------
  # EBhEpbNiTCY𒲐j
  #---------------------------------------------------------------------------
  def pack
    make_contents
    self.width = self.contents.width + 32
    self.height= self.contents.height + 32
    refresh
  end
  #---------------------------------------------------------------------------
  # j[̒ǉ
  #---------------------------------------------------------------------------
  def add_menu(name, handler)
    @menus = [] if @menus.nil?
    case handler
    when Symbol
      handler = method handler
    when String
      handler = method handler
    end
    @menus.push Menu.new(name, handler)
    @item_max = @menus.size
  end
  #---------------------------------------------------------------------------
  # j[̑}
  #---------------------------------------------------------------------------
  def insert_menu(index, name, handler)
    @menus = [] if @menus.nil?
    case handler
    when Symbol
      handler = method handler
    when String
      handler = method handler
    end
    @menus.insert(index, Menu.new(name, handler))
    @item_max = @menus.size
  end
  #---------------------------------------------------------------------------
  # j[f[^擾
  #---------------------------------------------------------------------------
  def get_menu
    return nil if @menus[@index].nil?
    return @menus[@index].name
  end
  #---------------------------------------------------------------------------
  # j[f[^擾
  #---------------------------------------------------------------------------
  def get_last_menu
    return nil if @menus.empty?
    return @menus[@menus.size - 1].name
  end
  #---------------------------------------------------------------------------
  # j[̍폜
  #---------------------------------------------------------------------------
  def remove_menu(index = nil)
    return if @menus.empty?
    if index.nil?
      index = @menus.size - 1
    end
    @menus.delete_at @index
    @item_max = @menus.size
  end
  #---------------------------------------------------------------------------
  # j[NA
  #---------------------------------------------------------------------------
  def clear
    @menus = [] if @menus.nil?
    @menus.clear
    @item_max = @menus.size
  end
  #---------------------------------------------------------------------------
  # j[s
  #---------------------------------------------------------------------------
  def menu_call(index)
    return if @menus[index].nil?
    @menus[index].handler.call
  end
  #--------------------------------------------------------------------------
  #  J[\ʒu̐ݒ
  #     index : VJ[\ʒu
  #--------------------------------------------------------------------------
  def index=(index)
    @index = index
    # J[\̋`XV
    update_cursor_rect
  end
  #---------------------------------------------------------------------------
  # 
  #---------------------------------------------------------------------------
  def input_c
    if Input.trigger?(Input::C)
      decision_se
      menu_call(@index)
    end
  end
  #---------------------------------------------------------------------------
  # LZ
  #---------------------------------------------------------------------------
  def input_b
    if Input.trigger?(Input::B)
      cancel_se
      if not disposed?
        dispose
      end
    end
  end
  #---------------------------------------------------------------------------
  # J[\ړ
  #---------------------------------------------------------------------------
  def input_up
    # 񐔂 1  {^̏̉Ԃs[głȂꍇA
    # ܂̓J[\ʒu񐔂̏ꍇ
    if (@column_max == 1 and Input.trigger?(Input::UP)) or @index >= @column_max
      return if page_item_max == 0
      # J[\Ɉړ
      $game_system.se_play($data_system.cursor_se)
#      @index = (@index - @column_max + @item_max) % @item_max
      page,index = @index.divmod page_item_max
      index = (index - @column_max + page_item_max) % page_item_max
      @index = page * page_item_max + index
      if @index >= @item_max
        @index = @item_max - 1
      end
    end
  end
  def input_down
    # 񐔂 1  {^̉̉Ԃs[głȂꍇA
    # ܂̓J[\ʒu(ڐ - )Ȍꍇ
    if (@column_max == 1 and Input.trigger?(Input::DOWN)) or @index < @item_max - @column_max
      return if page_item_max == 0
      # J[\Ɉړ
      $game_system.se_play($data_system.cursor_se)
#      @index = (@index + @column_max) % @item_max
      page,index = @index.divmod page_item_max
      if @index == @item_max - 1
        index = 0
      else
        index = (index + @column_max) % page_item_max
      end
      @index = page * page_item_max + index
    end
  end
  def input_right
    # {^̉Eꂽꍇ
    if Input.repeat?(Input::RIGHT)
      # 񐔂 2 ȏŁAJ[\ʒu(ڐ - 1)Ȍꍇ
      if @column_max >= 2 and @index < @item_max - 1
        # J[\EɈړ
        $game_system.se_play($data_system.cursor_se)
        @index += 1
      end
      return if page_item_max == 0
      page,index = (@item_max - 1).divmod page_item_max
      if @index < page * page_item_max
        # J[\EɈړ
        $game_system.se_play($data_system.cursor_se)
        @index += page_item_max
        if @index >= @item_max
          @index = @item_max - 1
        end
      end
    end
  end
  def input_left
    # {^̍ꂽꍇ
    if Input.repeat?(Input::LEFT)
      # 񐔂 2 ȏŁAJ[\ʒu 0 ̏ꍇ
      if @column_max >= 2 and @index > 0
        # J[\Ɉړ
        $game_system.se_play($data_system.cursor_se)
        @index -= 1
      end
      return if page_item_max == 0
      if @index >= page_item_max
        # J[\Ɉړ
        $game_system.se_play($data_system.cursor_se)
        @index -= page_item_max
      end
    end
  end

  #--------------------------------------------------------------------------
  # tbV
  #--------------------------------------------------------------------------
  def refresh
    self.contents.clear

    # Rec蒼Kv邩mF
    page_max = 1
    if not @menus.empty?
      page_max = (@menus.size + page_item_max - 1)/ page_item_max
#p "#{@menus.size} #{page_item_max}"
    end
    w = _contents_width * page_max
    if w != self.contents.width
      h = _contents_height
      self.contents.dispose
      self.contents = Bitmap.new(w,h)
    end

    # ^Cg̕`
    if not @title.nil?
      draw_title(normal_color)
    end
    # j[̕`
    for index in 0...@menus.size
      draw_menu(index, normal_color)
    end
  end
  #--------------------------------------------------------------------------
  # ڂ̍W
  #--------------------------------------------------------------------------
  def menu_rect(index)
    w = _menu_width
    h = _menu_height
    page, index = index.divmod page_item_max
    x = index % @column_max * w + page * _contents_width
    y = index / @column_max * h + _title_height
    return Rect.new(x,y,w,h)
  end
  #--------------------------------------------------------------------------
  # ^Cg̕`
  #--------------------------------------------------------------------------
  def draw_title(color)
    # ڂ̍WvZ
    rect = Rect.new(0,0,_title_width,_menu_height)
    rect.width  -= @cellspacing.x + @cellspacing.width
    rect.height -= @cellspacing.y + @cellspacing.height
    rect.x += @cellspacing.x
    rect.y += @cellspacing.y
    if @title_align.nil?
      @title_align = 0
    end
    draw_title_item(color,rect,@title,@title_align)
  end
  #--------------------------------------------------------------------------
  # ^Cg̕`iftHgj
  #--------------------------------------------------------------------------
  def draw_title_item(color,rect,title,title_align)
    self.contents.font.color = color
    self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
    self.contents.draw_text(rect, title, title_align)
  end
  #--------------------------------------------------------------------------
  # ڂ̕`
  #--------------------------------------------------------------------------
  def draw_menu(index, color)
    # ڂ̍WvZ
    rect = menu_rect(index)
    rect.width  -= @cellspacing.x + @cellspacing.width
    rect.height -= @cellspacing.y + @cellspacing.height
    rect.x += @cellspacing.x
    rect.y += @cellspacing.y
    draw_menu_item(index,color,rect,@menus[index].name)
  end
  #--------------------------------------------------------------------------
  # ڂ̕`iftHgj
  #--------------------------------------------------------------------------
  def draw_menu_item(index,color,rect,name)
    self.contents.font.color = color
    self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
    self.contents.draw_text(rect, name)
  end
  #--------------------------------------------------------------------------
  # J[\̋`XV
  #--------------------------------------------------------------------------
  def update_cursor_rect
    return if self.contents.nil?
    # J[\ʒu 0 ̏ꍇ
    if @index < 0
      self.cursor_rect.empty
      return
    end
    return if page_item_max == 0
    # ڂ̍WvZ
    rect = menu_rect(@index)
    page, i = @index.divmod page_item_max
    self.ox = page * _contents_width

    # J[\̋`XV
    self.cursor_rect = rect
  end
  #--------------------------------------------------------------------------
  #  t[XV
  #--------------------------------------------------------------------------
  def update
    super
    # J[\̋`XV
    update_cursor_rect
  end

  #--------------------------------------------------------------------------
  #  1 y[Wɕ\łs̎擾
  #--------------------------------------------------------------------------
  def page_row_max
    if @row_max < 0
      return (@menus.size + @column_max - 1) / @column_max
    end
    return @row_max
  end

  #--------------------------------------------------------------------------
  #  1 y[Wɕ\ł鍀ڐ̎擾
  #--------------------------------------------------------------------------
  def page_item_max
    # s page_row_max   @column_max |
    return page_row_max * @column_max
  end

  #---------------------------------------------------------------------------
  # Recrbg}bv̍쐬
  def make_contents
    if not self.contents.nil?
      self.contents.dispose
      self.contents = nil
    end
    w = _contents_width
    h = _contents_height
    return if w == 0 or h == 0
    self.contents = Bitmap.new(w,h)
  end
  #---------------------------------------------------------------------------
  # Rec̍쐬
  def _contents_width
    name_test = Bitmap.new(640,@item_height)
    max_width = 0
    if not @title.nil?
      max_width = name_test.text_size(@title).width
    end
    @menus.each do |menu|
      max_width = [max_width,name_test.text_size(menu.name).width].max
    end
    name_test.dispose
    max_width += @cellspacing.x + @cellspacing.width
    return max_width * @column_max
  end
  #---------------------------------------------------------------------------
  # Rec̍쐬
  def _contents_height
    return _menu_height * page_row_max + _title_height
  end
  #---------------------------------------------------------------------------
  # j[̍쐬
  def _menu_height
    return @item_height + @cellspacing.y + @cellspacing.height
  end
  #---------------------------------------------------------------------------
  # j[̍쐬
  def _menu_width
    return self.contents.width / @column_max
  end
  #---------------------------------------------------------------------------
  # ^Cg̍쐬
  def _title_height
    if @title.nil?
      return 0
    end
    return _menu_height * TITLE_HEIGHT
  end
  #---------------------------------------------------------------------------
  # ^Cg̍쐬
  def _title_width
    if @title.nil?
      return 0
    end
    return self.contents.width
  end
end
