#==============================================================================
#  Item_Facade
#------------------------------------------------------------------------------
# ACep`oh
#==============================================================================

module Item_Facade
  @@last_result = nil

  module_function

  #--------------------------------------------------------------------------
  # ŌɎs`oh̕ԋpl
  #--------------------------------------------------------------------------
  def last_result
    return @@last_result
  end

  def get_use_item(item)
    # gp\W[CN[hĂꍇ
    if item.is_a?(Game_Item_Use_Module)
      return item.use_item
    end
    return item
  end
  #--------------------------------------------------------------------------
  # \
  #--------------------------------------------------------------------------
  def equippable?(item,actor)
    @@last_result = actor.equippable?(item.data_base)
    return @@last_result
  end
  #--------------------------------------------------------------------------
  # ACe̎擾
  #--------------------------------------------------------------------------
  def equip_items(actor)
    if actor.class.method_defined?('equip_items')
      @@last_result = actor.equip_items
    else
      @@last_result = []
    end
    return @@last_result
  end
  #--------------------------------------------------------------------------
  # ĂACeH
  #--------------------------------------------------------------------------
  def actor_equip?(item,actor)
    @@last_result = equip_items(actor).include?(item)
    return @@last_result
  end
  #--------------------------------------------------------------------------
  # ACe킽
  #--------------------------------------------------------------------------
  def trade_item(actor1,item1,actor2,item2=nil)
    @@last_result = false
    # ̏ꍇ́AO
    if Item_Facade.actor_equip?(item1,actor1)
      actor1.remove_equip_item(item1)
    end
    if item2.nil?
      # n
      lose(item1,actor1)
      gain(item1,actor2)
      @@last_result = true
    elsif item1 != item2
	    if Item_Facade.actor_equip?(item2,actor2)
	      actor2.remove_equip_item(item2)
	    end
      # 
      lose(item1,actor1)
      lose(item2,actor2)
      gain(item2,actor1)
      gain(item1,actor2)
      @@last_result = true
    end
    return @@last_result
  end
  #--------------------------------------------------------------------------
  # ACeĂ
  #--------------------------------------------------------------------------
  def throw_item(item,owner_actor = nil)
    @@last_result = false
    if item_can_throw?(item,owner_actor)
      # ̏ꍇ́AO
      if Item_Facade.actor_equip?(item,owner_actor)
        owner_actor.remove_equip_item(item)
      end
      lose(item,owner_actor)
      @@last_result = true
    end
    return @@last_result
  end
  #--------------------------------------------------------------------------
  # ACêĂ邩ǂmF
  #--------------------------------------------------------------------------
  def item_can_throw?(item,owner_actor = nil)
    # 傪܂Ăꍇ́A{ɏĂ邩mFBӂ̏ꍇH
    if not owner_actor.nil?
      if not owner_actor.backpack.include?(item)
        return false
      end
    end

    # iÓ̕uȂ́vibΏj
    if item.price == 0
      return false
    end
    return true
  end
  #--------------------------------------------------------------------------
  # ACegpł邩ǂmF
  #--------------------------------------------------------------------------
  def item_can_use?(use_item,owner_actor = nil,use_actor = nil)
    item = get_use_item(use_item)

    # gpACeł͂Ȃꍇ
    if item.nil?
      return false
    end

    # 傪܂Ăꍇ́A{ɏĂ邩mFBӂ̏ꍇH
    if not owner_actor.nil?
      if not owner_actor.backpack.include?(item)
        return false
      end
    end

    # ʔ͈ (P/S) ̊mF
    if item.scope_all? and (not use_actor.nil?)
      return false
    end
    if item.scope_unit? and use_actor.nil?
      return false
    end

    # gp\擾
    occasion = item.occasion

    # og̏ꍇ
    if $game_temp.in_battle
      # gp\ 0 (펞) ܂ 1 (oĝ) Ȃgp\
      return (occasion == 0 or occasion == 1)
    end

    # gp\ 0 (펞) ܂ 2 (j[̂) Ȃgp\
    return (occasion == 0 or occasion == 2)

  end
  #--------------------------------------------------------------------------
  # ACeg
  #--------------------------------------------------------------------------
  def use_item(use_item, owner_actor = nil, use_actors = [])
    @@last_result = false
    use_actors.each do |actor|
      @@last_result |= actor.item_effect use_item
    end
    # ACegpꂽꍇ
    if @@last_result
      # Օȉꍇ
      if use_item.consumable
        # gpACe 1 炷
        lose(use_item,owner_actor)
      end
      # ACe̎gp SE t
      $game_system.se_play(use_item.menu_se)
    end
    return @@last_result
  end
  #--------------------------------------------------------------------------
  # ACȇ
  #--------------------------------------------------------------------------
  def gain(item,actor=nil)
    if actor.nil?
      $game_party.actors.each do |a|
        @@last_result = a.backpack.add_item item
        break if @@last_result
      end
    else
      @@last_result = actor.backpack.add_item item
    end
    return @@last_result
  end
  #--------------------------------------------------------------------------
  # ACě
  #--------------------------------------------------------------------------
  def lose(item,actor=nil)
    if actor.nil?
      $game_party.actors.each do |a|
        @@last_result = a.backpack.remove_item item
        break if @@last_result
      end
    else
      @@last_result = actor.backpack.remove_item item
    end
    return @@last_result
  end
  #--------------------------------------------------------------------------
  #  ACȇ ()
  #     item_id : ACe ID
  #     n       : 
  #     actor   : ACe𑝌AN^[
  #--------------------------------------------------------------------------
  def gain_item(id, n, actor = nil)
    return _gain_item_base(Game_Item, id, n, actor)
  end
  def lose_item(id, n, actor = nil)
    return _gain_item_base(Game_Item, id, -n, actor)
  end
  def gain_weapon(id, n, actor = nil)
    return _gain_item_base(Game_Weapon, id, n, actor)
  end
  def lose_weapon(id, n, actor = nil)
    return _gain_item_base(Game_Weapon, id, -n, actor)
  end
  def gain_armor(id, n, actor = nil)
    return _gain_item_base(Game_Armor, id, n, actor)
  end
  def lose_armor(id, n, actor = nil)
    return _gain_item_base(Game_Armor, id, -n, actor)
  end
  #--------------------------------------------------------------------------
  # vCx[g\bh
  #--------------------------------------------------------------------------
  def _gain_item_base(type, id, n, actor = nil)
    for i in 1 .. n.abs
      if 0 < n
        _gain(type,id,actor)
      elsif n < 0
        _lose(type,id,actor)
      end
    end
    return last_result
  end
  def _find(klass,id,actor)
    find_proc = proc do |item|
      if item.is_a?(klass) and item.id == id
        return item
      end
    end
    if actor.nil?
      $game_party.actors.each do |a|
        a.backpack.each_item &find_proc
      end
    else
      actor.backpack.each_item &find_proc
    end
    return nil
  end
  def _gain(klass,id,actor)
    return gain(klass.new(id),actor)
  end
  def _lose(klass,id,actor)
    remove_item = _find(klass,id,actor)
    if not remove_item.nil?
      lose(remove_item,actor)
      @@last_result = true
    else
      @@last_result = false
    end
    return @@last_result
  end
end
