#==============================================================================
#  Window_Main_Menu
#------------------------------------------------------------------------------
# Cj[EBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_Main_Menu < Window_Menu
  include Window_Tree_Module

  def initialize
    add_menu('͂Ȃ',   :talk)
    add_menu('', :skill)
    add_menu('ǂ',   :item)
    add_menu('ׂ', :check)
    add_menu('悳',   :status)
    add_menu('', :operation)
    @index = 0
    @column_max = 2
    super(nil)
    self.x = 16
    self.y = 16

    @window_gold = Window_Gold.new
    add_child @window_gold
    @window_gold.x = 640 - @window_gold.width - 16
    @window_gold.y = 16
    @window_gold.z = self.z
    @window_gold.back_opacity = WINDOW_BACK_OPACITY

    @window_status = Window_Main_Menu_Status.new
    add_child @window_status
    @window_status.z = self.z
    @window_status.back_opacity = WINDOW_BACK_OPACITY
  end

  #----------------------------------------------------------------------------
  # ͂Ȃ
  #----------------------------------------------------------------------------
  def talk
    # ʃCxǧgK[Cxg`FbN
    if not $game_player.check_event_trigger_there([0,1,2])
      # Cxgꍇ́c
      # ԂƘb\

      # TODO Ƃ肠ARCxgőΉ

      # RCxg ID L̏ꍇ
      if PARTY_TALK_COMMON_EVENT_ID > 0
        # RCxgĂяo\
        $game_temp.common_event_id = PARTY_TALK_COMMON_EVENT_ID
        # }bvʂɐ؂ւ
        $scene = Scene_Map.new
        return
      end
    end
    dispose
  end
  #----------------------------------------------------------------------------
  # 
  #----------------------------------------------------------------------------
  def skill
    window = Window_Actor_Menu_Skill.new(self,'')
    add_child window
    set_active_window(window.class)
  end
  #----------------------------------------------------------------------------
  # ǂ
  #----------------------------------------------------------------------------
  def item
    window = Window_Actor_Menu_Item.new(self,'ǂ')
    add_child window
    set_active_window(window.class)
  end
  #----------------------------------------------------------------------------
  # ׂ
  #----------------------------------------------------------------------------
  def check
    # ʃCxǧgK[Cxg`FbN
    result = $game_player.check_event_trigger_there([0])
    # ʒuCxǧgK[Cxg`FbN
    result = $game_player.check_event_trigger_here([0]) if not result
    if not result
      msg = [
        "#{$game_party.actors[0].name}́@ƂׂB",
        "@Ȃɂ݂ȂB"
      ]
      Event_Facade.display_message(msg)
    end
    dispose
  end
  #----------------------------------------------------------------------------
  # 悳
  #----------------------------------------------------------------------------
  def status
    window = Window_Actor_Menu_Status.new(self,'悳')
    add_child window
    set_active_window(window.class)
  end
  #----------------------------------------------------------------------------
  # 
  #----------------------------------------------------------------------------
  def operation
    window = Window_Operation_Menu.new(self,'')
    add_child window
    set_active_window(window.class)
  end
end

end
