###########################################################
#                                                         #
# Look for low-level C headers, write defines to config.h #
#                                                         #
###########################################################

include( ${CMAKE_ROOT}/Modules/CheckIncludeFile.cmake )
include( ${CMAKE_ROOT}/Modules/CheckFunctionExists.cmake )

set( CONFIG_H ${PROJECT_BINARY_DIR}/config.h )

# Only write config.h once
if( WROTE_CONFIG_H_${PROJECT_NAME} )
  message( STATUS "Not writing config.h -- wrote it previously" )
else( WROTE_CONFIG_H_${PROJECT_NAME} )  
  message( STATUS "Writing config.h for ${PROJECT_NAME}" )
  set( WROTE_CONFIG_H_${PROJECT_NAME} TRUE CACHE INTERNAL "Wrote config.h for ${PROJECT_NAME}" )

  file( WRITE ${CONFIG_H} "/* config.h.  Generated by CMakeLists.txt */\n\n" )

  if( WIN32 )
    
    #
    # define some stuff to make MSVC look a bit more like gcc
    #

    # define 'uint' to 'unsigned int' for windows
    file( APPEND ${CONFIG_H} "#ifndef uint\n" )
    file( APPEND ${CONFIG_H} "#define uint unsigned int\n" )
    file( APPEND ${CONFIG_H} "#endif\n\n" )

    file( APPEND ${CONFIG_H} "// MSVC compiler requires this symbol before exposing the (apparently)\n" )
    file( APPEND ${CONFIG_H} "// non-standard symbols M_PI, etc...\n" )
    file( APPEND ${CONFIG_H} "#define _USE_MATH_DEFINES\n\n" )

    file( APPEND ${CONFIG_H} "// Just in case the above line didn't fix it...\n" )
    file( APPEND ${CONFIG_H} "#ifndef M_PI\n" )
    file( APPEND ${CONFIG_H} "#define M_PI 3.14159265358979323846\n" )
    file( APPEND ${CONFIG_H} "#endif\n\n" )

  else( WIN32 )

    #
    # AlexB: I think all these low-level guys are 'nix-specific.
    #        Don't write them for win32.
    #

    check_include_file( termio.h HAVE_TERMIO_H )
    if( HAVE_TERMIO_H )
      set( VAL 1 )
    else( HAVE_TERMIO_H )
      set( VAL 0 )
    endif( HAVE_TERMIO_H )
    file( APPEND ${CONFIG_H} "#define HAVE_TERMIO_H ${VAL}\n\n" )

    check_include_file( linux/input.h HAVE_LINUX_INPUT_H )
    if( HAVE_LINUX_INPUT_H )
      set( VAL 1 )
    else( HAVE_LINUX_INPUT_H )
      set( VAL 0 )
    endif( HAVE_LINUX_INPUT_H )
    file( APPEND ${CONFIG_H} "#define HAVE_LINUX_INPUT_H ${VAL}\n\n" )

    check_include_file( string.h HAVE_STRING_H )
    if( HAVE_STRING_H )
      set( VAL 1 )
    else( HAVE_STRING_H )
      set( VAL 0 )
    endif( HAVE_STRING_H )
    file( APPEND ${CONFIG_H} "#define HAVE_STRING_H ${VAL}\n\n" )

    check_include_file( stdlib.h HAVE_STDLIB_H )
    if( HAVE_STDLIB_H )
      set( VAL 1 )
    else( HAVE_STDLIB_H )
      set( VAL 0 )
    endif( HAVE_STDLIB_H )
    file( APPEND ${CONFIG_H} "#define HAVE_STDLIB_H ${VAL}\n\n" )

    check_include_file( unistd.h HAVE_UNISTD_H )
    if( HAVE_UNISTD_H )
      set( VAL 1 )
    else( HAVE_UNISTD_H )
      set( VAL 0 )
    endif( HAVE_UNISTD_H )
    file( APPEND ${CONFIG_H} "#define HAVE_UNISTD_H ${VAL}\n\n" )

    check_include_file( sys/types.h HAVE_SYS_TYPES_H )
    if( HAVE_SYS_TYPES_H )
      set( VAL 1 )
    else( HAVE_SYS_TYPES_H )
      set( VAL 0 )
    endif( HAVE_SYS_TYPES_H )
    file( APPEND ${CONFIG_H} "#define HAVE_SYS_TYPES_H ${VAL}\n\n" )

    check_include_file( sys/stat.h HAVE_SYS_STAT_H )
    if( HAVE_SYS_STAT_H )
      set( VAL 1 )
    else( HAVE_SYS_STAT_H )
      set( VAL 0 )
    endif( HAVE_SYS_STAT_H )
    file( APPEND ${CONFIG_H} "#define HAVE_SYS_STAT_H ${VAL}\n\n" )

    check_include_file( pthread.h HAVE_PTHREAD_H )
    if( HAVE_PTHREAD_H )
      set( VAL 1 )
    else( HAVE_PTHREAD_H )
      set( VAL 0 )
    endif( HAVE_PTHREAD_H )
    file( APPEND ${CONFIG_H} "#define HAVE_PTHREAD_H ${VAL}\n\n" )

    check_include_file( sys/ioctl.h HAVE_SYS_IOCTL_H )
    if( HAVE_SYS_IOCTL_H )
      set( VAL 1 )
    else( HAVE_SYS_IOCTL_H )
      set( VAL 0 )
    endif( HAVE_SYS_IOCTL_H )
    file( APPEND ${CONFIG_H} "#define HAVE_SYS_IOCTL_H ${VAL}\n\n" )

    check_include_file( fcntl.h HAVE_FCNTL_H )
    if( HAVE_FCNTL_H )
      set( VAL 1 )
    else( HAVE_FCNTL_H )
      set( VAL 0 )
    endif( HAVE_FCNTL_H )
    file( APPEND ${CONFIG_H} "#define HAVE_FCNTL_H ${VAL}\n\n" )

    check_include_file( time.h HAVE_TIME_H )
    if( HAVE_TIME_H )
      set( VAL 1 )
    else( HAVE_TIME_H )
      set( VAL 0 )
    endif( HAVE_TIME_H )
    file( APPEND ${CONFIG_H} "#define HAVE_TIME_H ${VAL}\n\n" )

    check_include_file( errno.h HAVE_ERRNO_H )
    if( HAVE_ERRNO_H )
      set( VAL 1 )
    else( HAVE_ERRNO_H )
      set( VAL 0 )
    endif( HAVE_ERRNO_H )
    file( APPEND ${CONFIG_H} "#define HAVE_ERRNO_H ${VAL}\n\n" )

    check_include_file( zlib.h HAVE_ZLIB_H )
    if( HAVE_ZLIB_H )
      set( VAL 1 )
    else( HAVE_ZLIB_H )
      set( VAL 0 )
    endif( HAVE_ZLIB_H )
    file( APPEND ${CONFIG_H} "#define HAVE_ZLIB_H ${VAL}\n\n" )

    check_include_file( sys/filio.h HAVE_FILIO_H )
    if( HAVE_FILIO_H )
      set( VAL 1 )
    else( HAVE_FILIO_H )
      set( VAL 0 )
    endif( HAVE_FILIO_H )
    file( APPEND ${CONFIG_H} "#define HAVE_FILIO_H ${VAL}\n\n" )

    check_function_exists( strnlen HAVE_STRNLEN )
    if( HAVE_STRNLEN )
      set( VAL 1 )
    else( HAVE_STRNLEN )
      set( VAL 0 )
    endif( HAVE_STRNLEN )
    file( APPEND ${CONFIG_H} "#define HAVE_STRNLEN ${VAL}\n\n" )

  endif( WIN32 )

endif( WROTE_CONFIG_H_${PROJECT_NAME} )  
