// -*- C -*-
/*!
 * @file  rtc_inifile.c
 * @brief Initial File Analyze
 * @date  $Date$
 *
 * $Id$
 */
#include "rtc_inifile.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <math.h>
#include <limits.h>

#define LINE_MAX_LENGTH 256

//եϾ
ANALYZE_DATA* createAnalyzeData(char* filename, char comment, char* separate)
{
	ANALYZE_DATA*	head = NULL;
	ANALYZE_DATA*	next = NULL;
	
	FILE			*fp = NULL ;
	char			buf[LINE_MAX_LENGTH];
	char			param[LINE_MAX_LENGTH];
	char			value[LINE_MAX_LENGTH];
	
	ANALYZE_DATA*	data = NULL;

	
	// եΥץ
	if( NULL == (fp = fopen(filename, "r")))
	{
		goto LBL_EXIT ;
	}
	
	//ե뤫1ɤ߹
	while(NULL != fgets(buf, LINE_MAX_LENGTH, fp))
	{
		// եϾΰ
		data = (ANALYZE_DATA*)malloc(sizeof(ANALYZE_DATA));
		if(data == NULL)
		{
			goto LBL_CLOSE_EXIT ;
		}
		data->comment = NULL ;
		data->param = NULL ;
		data->value = NULL ;
		data->next = NULL ;
		
		// ԤκǽʸȽ
		if(buf[0] == comment || buf[0] == '\r' || buf[0] == '\n')
		{
			// commentԤǻϤޤԤϥȤ
			data->comment = (char*)malloc(strlen(buf) + 1);
			if(data->comment == NULL)
			{
				goto LBL_CLOSE_EXIT ;
			}
			
			strcpy(data->comment, buf);
			
		}else{
			// 嵭ʳϥѥ᡼ѥ᡼ͤ
			
			// separateǥѥ᡼ȥѥ᡼ͤʬ
			memset(param, 0, sizeof(param));
			memset(value, 0, sizeof(value));
			if( 0 != separateToken(buf, (int)strlen(buf), param, value, separate))
			{
				continue ;
			}
			
			// ѥ᡼ȥѥ᡼ͤΰ
			data->param = (char *)malloc(strlen(param) + 1);
			data->value = (char *)malloc(strlen(value) + 1);
			if(data->param == NULL || data->value == NULL )
			{
				goto LBL_CLOSE_EXIT ;
			}
			
			// ѥ᡼ȥѥ᡼ͤ
			strcpy(data->param, param);
			strcpy(data->value, value);
		}
		
		// ꥹȤɲ
		if(head != NULL)
		{
			next->next = data;
			next = data ;
		}else{
			head = data;
			next = head ;
		}
	}
	
LBL_CLOSE_EXIT:
	// եΥ
	if( NULL != fp)
	{
		fclose(fp);
	}
	
LBL_EXIT:
	return head;
}

// եϾ
void deleteAnalyzeData(ANALYZE_DATA* data)
{
	ANALYZE_DATA* beforeLast;
	ANALYZE_DATA* last;
	
	// ꥹʬ롼
	while(data != NULL)
	{
		beforeLast = NULL ;
		last = data ;
		
		// ꥹȤκǸΥեϾ󸡺
		while(last->next != NULL)
		{
			beforeLast = last ;
			last = last->next ;
		}
		
		// Ȥȥѥ᡼ȥѥ᡼ͤΰ
		if(last->comment != NULL) free(last->comment);
		if(last->param != NULL) free(last->param);
		if(last->value != NULL) free(last->value);
		
		// ꥹȤκǸΥեϾ󤬤뤫Ƚ
		if(beforeLast != NULL)
		{
			// 硢ꥹȤκǸΰ
			if(beforeLast->next != NULL) free(beforeLast->next);
			beforeLast->next = NULL ;
		}else{
			// ʤ硢ꥹȤκǽΰ
			if(data != NULL) free(data);
			data = NULL ;
		}
	}
}

//եϾ󤫤ѥ᡼ͤ
int getAnalyzeData(ANALYZE_DATA* data, char* param, char* value)
{
	ANALYZE_DATA* current = data;
	
	// ꥹʬϥ롼
	while(current != NULL)
	{
		// ѥ᡼ȥѥ᡼ͤΥå
		if(current->param != NULL && current->value != NULL)
		{
			// ѥ᡼Ƚ
			if(0 == strcmp(current->param, param))
			{
				// פ硢ѥ᡼ͤ
				strcpy(value,current->value);
				return 0 ;
			}
		}
		//ΥեϾ
		current = current->next ;
	}
	
	return -1 ;
}

//ʸϤѥ᡼ȥѥ᡼ͤʬ
int separateToken(char* buf, int len, char* param, char* value, char* separate)
{
	char* pParam = NULL;
	char* pValue = NULL;
	
	// ʸڤʸʬ
	if(NULL != (pParam = strtok(buf, separate)))
	{
		// ѥ᡼ΥڡTABԤ
		pParam = deleteSpcHtCrLf(pParam);
		// ѥ᡼
		strcpy(param,pParam);
		
		// ʸڤʸʬ
		if(NULL != (pValue = strtok(NULL, separate)))
		{
			// ѥ᡼ͤΥڡTABԤ
			pValue = deleteSpcHtCrLf(pValue);
			// ѥ᡼ͤ
			strcpy(value,pValue);
		}else{
			return -1 ;
		}
	
	}else{
		return -1 ;
	}
	
	return 0 ;
}

// ʸ10ʿѴ
int changeStrToInt(char* buf, int* value)
{
	int er = 0;
	int tmp;
	
	// ʸȽ
	er = checkStrInt(buf);
	if( er != 0)
	{
		goto LBL_EXIT;
	}
	
	// ʸ10ʿѴ
	errno = 0;
	tmp = strtol((const char*)buf, NULL, 10);
	if((errno == ERANGE && (tmp == LONG_MAX || tmp == LONG_MIN))
		|| (errno != 0 && tmp == 0))
	{
		er = -1 ;
		goto LBL_EXIT;
	}
	*value = tmp ;
	
LBL_EXIT:
	return er;
}

// ʸư¿Ѵ
int changeStrToDouble(char* buf, double* value)
{
	int er = 0 ;
	double tmp;
	
	// ʸȽ
	er = checkStrDouble(buf);
	if( er != 0)
	{
		goto LBL_EXIT;
	}
	
	// ʸ10ʿѴ
	errno = 0;
	tmp = strtod(buf, NULL);
	if(errno == ERANGE && (tmp == HUGE_VAL || tmp == 0))
	{
		er = -1;
		goto LBL_EXIT ;
	}
	*value = tmp ;

LBL_EXIT:
	return er;
}

// ʸIntͤå
int checkStrInt(char* buf)
{
	char*	pBuf = buf;
	char	check = 0;	//åʸ
	
	// '-'ޤ'+'ξϼʸ
	if( *pBuf == '-' || *pBuf == '+')
	{
		pBuf++ ;
	}
	
	// ʸˤʤޤǥ롼
	while( *pBuf != 0)
	{
		check = *pBuf ;
		// ǤϤʤ票顼
		if( isdigit(check) == 0)
		{
			return -1;
		}
		// ʸ
		pBuf++;
	}
	
	return 0;
}

// ʸDoubleͤå
int checkStrDouble(char* buf)
{
	char*	pBuf = buf;
	char	check = 0;	//åʸ
	int		dotCnt = 0;	//ɥåѥ
	
	// '-'ޤ'+'ξϼʸ
	if( *pBuf == '-' || *pBuf == '+')
	{
		pBuf++ ;
	}
	
	// '.'ξϥ顼
	if( *pBuf == '.')
	{
		return -1;
	}
	
	// ʸˤʤޤǥ롼
	while( *pBuf != 0)
	{
		check = *pBuf ;
		// '.'ξ
		if( check == '.')
		{
			dotCnt++ ;
			// '.'2İʾξ票顼
			if(dotCnt > 1) return -1;
			// ʸ
			pBuf++;
			continue ;
		}
		
		//ǤϤʤ票顼
		if( isdigit(check) == 0 )
		{
			return -1;
		}
		// ʸ
		pBuf++;
	}
	
	return 0;
}

//Ϳ줿ʸΥڡTABԤ
char* deleteSpcHtCrLf(char* buf)
{
	char* sBuf = buf ;
	char* eBuf = buf + strlen(buf) -1 ;
	
	// ʸΥڡTABԤ
	while(*sBuf==' ' || *sBuf=='\t' || *sBuf=='\r' || *sBuf=='\n')
	{
		sBuf++ ;
	}
	// ʸθΥڡTABԤ
	while(*eBuf==' ' || *eBuf=='\t' || *eBuf=='\r' || *eBuf=='\n')
	{
		*eBuf = 0;
		eBuf-- ;
	}
	
	return sBuf;
}
