// -*- C -*-
/*!
 * @file  rtc_inifile.h
 * @brief Initial File Analyze
 * @date  $Date$
 *
 * $Id$
 */

#ifndef RTC_INIFILE_H
#define RTC_INIFILE_H

typedef enum
{
	DATA_TYPE_STR,
	DATA_TYPE_INT
} DATA_TYPE;

#ifdef __cplusplus
extern "C" {
#endif

	//եϾ¤
	typedef struct analyze_data_tag
	{
		char*				comment;		//
		char*				param;			//ѥ᡼
		char*				value;			//ѥ᡼
		struct analyze_data_tag*	next ;	//ΥեϾ
	} ANALYZE_DATA ;
	
	// ϰ
	typedef struct analyze_data_range_tag
	{
		int		minValue;		// Ǿ
		int		maxValue;		// 
	} ANALYZE_DATA_RANGE ;

	//եϾ
	ANALYZE_DATA* createAnalyzeData(char* filename, char comment, char* separate);
	//եϾ
	void deleteAnalyzeData(ANALYZE_DATA* data);
	//եϾ󤫤ѥ᡼ͤ
	int getAnalyzeData(ANALYZE_DATA* data, char* param, char* value);
	
	// ʸϤѥ᡼ȥѥ᡼ͤʬ
	int separateToken(char* buf, int len, char* param, char* value, char* separate);
	// ʸ10ʿѴ
	int changeStrToInt(char* buf, int* value);
	// ʸư¿Ѵ
	int changeStrToDouble(char* buf, double* value);
	// ʸIntѴǽå
	int checkStrInt(char* buf);
	// ʸDoubleѴǽå
	int checkStrDouble(char* buf);
	// Ϳ줿ʸΥڡTABԤ
	char* deleteSpcHtCrLf(char* buf);

#ifdef __cplusplus
};
#endif

#endif //RTC_INIFILE_H

