<?php
//---------------------------------------------------------------------------------------//
@set_time_limit(300);

//---------------------------------------------------------------------------------------//
// Grab all indexes ..we are gonna do em from scratch

// Only operate on these tables:
$tables_list = array(
			"bb_categories",
			"bb_forum_access",
			"bb_forum_mods",
			"bb_forums",
			"bb_posts",
			"bb_topics",
			"comments",
			"groups",
			"groups_blocks_link",
			"groups_modules_link",
			"groups_users_link",
			"headlines",
			"lastseen",
			"modules",
			"mydownloads_broken",
			"mydownloads_cat",
			"mydownloads_downloads",
			"mydownloads_mod",
			"mydownloads_votedata",
			"mylinks_broken",
			"mylinks_cat",
			"mylinks_links",
			"mylinks_mod",
			"mylinks_votedata",
			"newblocks",
			"nseccont",
			"nsections",
			"partners",
			"priv_msgs",
			"ranks",
			"session",
			"smiles",
			"stories",
			"topics",
			"users",
			"xoopsfaq_categories",
			"xoopsfaq_contents",
			"xoopspoll_desc",
			"xoopspoll_log",
			"xoopspoll_option",
			"xoopspollcomments"
			);

$tables = mysql_list_tables($xoopsConfig['dbname']);
while (list($table_name) = $db->fetch_array($tables)) {
	$indexes = $db->query("SHOW INDEX FROM $table_name");
	while ($index_name = $db->fetch_array($indexes)) {
		$key_comp = strtolower($index_name['Key_name']);
		$key_name = $index_name['Key_name'];
		if ( !empty($key_comp) && ($key_comp != "primary") && ($key_comp != "unique") ) {
			$org_name = str_replace($db->prefix.'_', '', $table_name);
			if (in_array($org_name, $tables_list)) {
				$sql[] = "ALTER TABLE $table_name DROP INDEX $key_name";
			}
		}
	}
}

//---------------------------------------------------------------------------------------//
// banner :: Beta 1.05
$sql[] = "DROP TABLE ".$db->prefix("banner")."";

//---------------------------------------------------------------------------------------//
// bannerclient :: Beta 1.05
$sql[] = "DROP TABLE ".$db->prefix("bannerclient")."";

//---------------------------------------------------------------------------------------//
// bannerfinish :: Beta 1.05
$sql[] = "DROP  TABLE ".$db->prefix("bannerfinish")."";

//---------------------------------------------------------------------------------------//
// bb_categories
$sql[] = "ALTER TABLE ".$db->prefix("bb_categories")." CHANGE cat_id cat_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("bb_categories")." CHANGE cat_title cat_title VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("bb_categories")." CHANGE cat_order cat_order SMALLINT(3) NOT NULL DEFAULT '0'";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("bb_categories")."";

//---------------------------------------------------------------------------------------//
// bb_forum_access
$sql[] = "ALTER TABLE ".$db->prefix("bb_forum_access")." DROP PRIMARY KEY";

$sql[] = "ALTER TABLE ".$db->prefix("bb_forum_access")." CHANGE forum_id forum_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forum_access")." CHANGE user_id user_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forum_access")." CHANGE can_post can_post TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("bb_forum_access")."";

//---------------------------------------------------------------------------------------//
// bb_forum_mods
$sql[] = "ALTER TABLE ".$db->prefix("bb_forum_mods")." DROP INDEX forum_user_id";

$sql[] = "ALTER TABLE ".$db->prefix("bb_forum_mods")." CHANGE forum_id forum_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forum_mods")." CHANGE user_id user_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("bb_forum_mods")."";

//---------------------------------------------------------------------------------------//
// bb_forums
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." DROP INDEX forum_last_post_id";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." DROP INDEX cat_id";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." DROP INDEX idx";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." DROP forum_moderator";

$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." CHANGE forum_id forum_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." CHANGE cat_id cat_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." CHANGE forum_last_post_id forum_last_post_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." CHANGE forum_type forum_type TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." CHANGE allow_html allow_html TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." CHANGE allow_sig allow_sig TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." CHANGE forum_topics forum_topics MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." CHANGE forum_posts forum_posts MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." CHANGE forum_name forum_name VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." CHANGE forum_desc forum_desc TEXT";
$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." CHANGE forum_access forum_access TINYINT(2) UNSIGNED DEFAULT '1' NOT NULL";

$sql[] = "ALTER TABLE ".$db->prefix("bb_forums")." ADD INDEX idx(cat_id)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("bb_forums")."";

//---------------------------------------------------------------------------------------//
// bb_posts
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." DROP INDEX uid";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." DROP INDEX pid";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." DROP INDEX subject";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." DROP INDEX forumid_uid";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." DROP INDEX topicid_uid";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." DROP INDEX topicid_postid_pid";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE icon icon VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE post_id post_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE forum_id forum_id MEDIUMINT(8) UNSIGNED  NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE topic_id topic_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE uid uid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE pid pid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE subject subject VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE poster_ip poster_ip VARCHAR(15) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE attachsig attachsig TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE post_time post_time INT(10) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE allow_html allow_html TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE allow_smileys allow_smileys TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE allow_bbcode allow_bbcode TINYINT(1) UNSIGNED NOT NULL DEFAULT '1'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE type type ENUM('admin', 'user') NOT NULL DEFAULT 'user'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." CHANGE post_text post_text TEXT NOT NULL ";

$sql[] = "ALTER TABLE ".$db->prefix("bb_posts")." ADD INDEX idx(topic_id)";

//$sql[] = "UPDATE ".$db->prefix("bb_posts")." SET allow_html=ABS(allow_html-1), allow_smileys=ABS(allow_smileys-1)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("bb_posts")."";

//---------------------------------------------------------------------------------------//
// bb_topics
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." DROP INDEX forum_id";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." DROP INDEX topic_last_post_id";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." DROP INDEX topic_poster";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." DROP INDEX topic_forum";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." DROP INDEX topic_sticky";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." CHANGE topic_id topic_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." CHANGE forum_id forum_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." CHANGE topic_poster topic_poster MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." CHANGE topic_views topic_views MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." CHANGE topic_last_post_id topic_last_post_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." CHANGE topic_replies topic_replies MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." CHANGE topic_title topic_title VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." CHANGE topic_time topic_time INT(10) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." CHANGE topic_status topic_status TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." CHANGE topic_notify topic_notify TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." CHANGE topic_sticky topic_sticky TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "ALTER TABLE ".$db->prefix("bb_topics")." ADD INDEX idx(forum_id)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("bb_topics")."";

//---------------------------------------------------------------------------------------//
// comments
$sql[] = "ALTER TABLE ".$db->prefix("comments")." DROP INDEX pid";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." DROP INDEX item_id";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." DROP INDEX user_id";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." DROP INDEX subject";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("comments")." CHANGE comment_id comment_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." CHANGE pid pid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." CHANGE item_id item_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." CHANGE user_id user_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." CHANGE icon icon VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." CHANGE subject subject VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." CHANGE allow_html allow_html TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." CHANGE allow_smileys allow_smileys TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." CHANGE allow_bbcode allow_bbcode TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." CHANGE date date INT(10) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "ALTER TABLE ".$db->prefix("comments")." CHANGE type type ENUM('admin', 'user') NOT NULL DEFAULT 'user'";
$sql[] = "ALTER TABLE ".$db->prefix("comments")." CHANGE attachsig attachsig TINYINT(1) UNSIGNED DEFAULT '0' NOT NULL";

$sql[] = "ALTER TABLE ".$db->prefix("comments")." ADD INDEX idx(item_id)";

//$sql[] = "UPDATE ".$db->prefix("comments")." SET allow_html=ABS(allow_html-1), allow_smileys=ABS(allow_smileys-1), allow_bbcode=ABS(allow_bbcode-1)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("comments")."";

//---------------------------------------------------------------------------------------//
// groups
$sql[] = "ALTER TABLE ".$db->prefix("groups")." DROP INDEX type";
$sql[] = "ALTER TABLE ".$db->prefix("groups")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("groups")." CHANGE groupid groupid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("groups")." CHANGE name name VARCHAR(30) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("groups")." CHANGE description description VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("groups")." CHANGE type type ENUM('Admin', 'User', 'Anonymous', 'Custom') NOT NULL DEFAULT 'Custom'";

$sql[] = "ALTER TABLE ".$db->prefix("groups")." ADD INDEX idx(type)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("groups")."";

//---------------------------------------------------------------------------------------//
// groups_blocks_link
$sql[] = "ALTER TABLE ".$db->prefix("groups_blocks_link")." CHANGE groupid groupid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("groups_blocks_link")." CHANGE block_id block_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("groups_blocks_link")."";
//---------------------------------------------------------------------------------------//
// groups_modules_link
$sql[] = "ALTER TABLE ".$db->prefix("groups_modules_link")." DROP INDEX groupid_type_mid";

$sql[] = "ALTER TABLE ".$db->prefix("groups_modules_link")." CHANGE groupid groupid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("groups_modules_link")." CHANGE mid mid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("groups_modules_link")."";

//---------------------------------------------------------------------------------------//
// groups_users_link
$sql[] = "ALTER TABLE ".$db->prefix("groups_users_link")." DROP INDEX groupid_uid";

$sql[] = "ALTER TABLE ".$db->prefix("groups_users_link")." CHANGE groupid groupid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("groups_users_link")." CHANGE uid uid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("groups_users_link")."";

//---------------------------------------------------------------------------------------//
// headlines
$sql[] = "ALTER TABLE ".$db->prefix("headlines")." DROP INDEX status";
$sql[] = "ALTER TABLE ".$db->prefix("headlines")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("headlines")." CHANGE id id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("headlines")." CHANGE items items TINYINT(2) UNSIGNED NOT NULL DEFAULT '5'";
$sql[] = "ALTER TABLE ".$db->prefix("headlines")." CHANGE weight weight SMALLINT(3) NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("headlines")." CHANGE url url VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("headlines")." CHANGE headlineurl headlineurl VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("headlines")." CHANGE template template VARCHAR(30) NOT NULL DEFAULT 'simple.txt'";
$sql[] = "ALTER TABLE ".$db->prefix("headlines")." CHANGE cache cache SMALLINT(3) UNSIGNED NOT NULL DEFAULT '60'";
$sql[] = "ALTER TABLE ".$db->prefix("headlines")." CHANGE status status TINYINT(1) UNSIGNED NOT NULL DEFAULT '1'";

$sql[] = "ALTER TABLE ".$db->prefix("headlines")." ADD INDEX idx(status)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("headlines")."";

//---------------------------------------------------------------------------------------//
// lastseen
$sql[] = "ALTER TABLE ".$db->prefix("lastseen")." DROP INDEX time";
$sql[] = "ALTER TABLE ".$db->prefix("lastseen")." DROP INDEX uid";
$sql[] = "ALTER TABLE ".$db->prefix("lastseen")." DROP INDEX username";
$sql[] = "ALTER TABLE ".$db->prefix("lastseen")." DROP INDEX ip";
$sql[] = "ALTER TABLE ".$db->prefix("lastseen")." DROP INDEX online";
$sql[] = "ALTER TABLE ".$db->prefix("lastseen")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("lastseen")." CHANGE uid uid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("lastseen")." CHANGE username username VARCHAR(30) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("lastseen")." CHANGE time time INT(10) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "ALTER TABLE ".$db->prefix("lastseen")." ADD INDEX idx(uid,online)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("lastseen")."";

//---------------------------------------------------------------------------------------//
// modules
$sql[] = "ALTER TABLE ".$db->prefix("modules")." DROP INDEX hasmain";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." DROP INDEX hasadmin";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." DROP INDEX hassearch";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." DROP INDEX dirname";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." DROP INDEX name";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("modules")." CHANGE mid mid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." CHANGE weight weight SMALLINT(3) NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." CHANGE name name VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." CHANGE dirname dirname VARCHAR(30) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." CHANGE version version FLOAT(3, 2) UNSIGNED NOT NULL DEFAULT '1.00'";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." CHANGE isactive isactive TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." CHANGE last_update last_update INT(10) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." CHANGE hassearch hassearch TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." CHANGE hasadmin hasadmin TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("modules")." CHANGE hasmain hasmain TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";

// Beta 1.05
$sql[] = "ALTER TABLE ".$db->prefix("modules")." CHANGE config config TEXT ";

// 1.06 CVS
$sql[] = "ALTER TABLE ".$db->prefix("modules")." CHANGE haswaiting haswaiting TINYINT(1) UNSIGNED DEFAULT '0' NOT NULL";
//$sql[] = "UPDATE ".$db->prefix("modules")." SET haswaiting=1 WHERE dirname='news' OR dirname='mylinks' OR dirname='mydownloads'";

$sql[] = "ALTER TABLE ".$db->prefix("modules")." ADD INDEX idx(dirname,isactive)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("modules")."";

//---------------------------------------------------------------------------------------//
// mydownloads_broken
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_broken")." DROP INDEX lid";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_broken")." DROP INDEX sender";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_broken")." DROP INDEX ip";

$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_broken")." CHANGE reportid reportid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_broken")." CHANGE lid lid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_broken")." CHANGE sender sender MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_broken")." CHANGE ip ip VARCHAR(15) NOT NULL DEFAULT ''";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("mydownloads_broken")."";

//---------------------------------------------------------------------------------------//
// mydownloads_cat
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_cat")." DROP INDEX pid";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_cat")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_cat")." CHANGE imgurl imgurl VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_cat")." CHANGE cid cid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_cat")." CHANGE pid pid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_cat")." CHANGE title title VARCHAR(60) NOT NULL DEFAULT '0'";

$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_cat")." CHANGE description description TEXT";

$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_cat")." ADD INDEX idx(pid)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("mydownloads_cat")."";

//---------------------------------------------------------------------------------------//
// mydownloads_downloads
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." DROP INDEX cid";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." DROP INDEX status";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." DROP INDEX title";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE lid lid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE url url VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE homepage homepage VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE logourl logourl VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE cid cid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE title title VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE votes votes SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE comments comments SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE submitter submitter MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE hits hits MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE platform platform VARCHAR(30) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE size size INT(10) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE version version VARCHAR(10) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE rating rating FLOAT(3, 2) UNSIGNED NOT NULL DEFAULT '0.00'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE status status TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE date date INT(10) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." CHANGE description description TEXT NOT NULL ";

$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_downloads")." ADD INDEX idx(status,cid)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("mydownloads_downloads")."";

//---------------------------------------------------------------------------------------//
// mydownloads_mod
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_mod")." CHANGE requestid requestid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_mod")." CHANGE url url VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_mod")." CHANGE homepage homepage VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_mod")." CHANGE logourl logourl VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_mod")." CHANGE lid lid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_mod")." CHANGE cid cid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_mod")." CHANGE title title VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_mod")." CHANGE modifysubmitter modifysubmitter MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_mod")." CHANGE version version VARCHAR(10) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_mod")." CHANGE size size INT(10) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_mod")." CHANGE platform platform VARCHAR(30) NOT NULL DEFAULT ''";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("mydownloads_mod")."";

//---------------------------------------------------------------------------------------//
// mydownloads_votedata
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_votedata")." DROP INDEX ratinguser";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_votedata")." DROP INDEX ratinghostname";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_votedata")." DROP INDEX lid";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_votedata")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_votedata")." CHANGE ratingid ratingid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_votedata")." CHANGE lid lid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_votedata")." CHANGE ratinguser ratinguser MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_votedata")." CHANGE ratinghostname ratinghostname VARCHAR(15) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_votedata")." CHANGE rating rating FLOAT(3, 2) UNSIGNED NOT NULL DEFAULT '0.00'";
$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_votedata")." CHANGE ratingtimestamp ratingtimestamp INT(10) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "ALTER TABLE ".$db->prefix("mydownloads_votedata")." ADD INDEX idx(lid)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("mydownloads_votedata")."";

//---------------------------------------------------------------------------------------//
// mylinks_broken OK
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_broken")." DROP INDEX lid";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_broken")." DROP INDEX sender";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_broken")." DROP INDEX ip";

$sql[] = "ALTER TABLE ".$db->prefix("mylinks_broken")." CHANGE reportid reportid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_broken")." CHANGE lid lid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_broken")." CHANGE sender sender MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_broken")." CHANGE ip ip VARCHAR(15) NOT NULL DEFAULT ''";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("mylinks_broken")."";

//---------------------------------------------------------------------------------------//
// mylinks_cat OK
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_cat")." DROP INDEX pid";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_cat")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("mylinks_cat")." CHANGE cid cid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_cat")." CHANGE imgurl imgurl VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_cat")." CHANGE pid pid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_cat")." CHANGE title title VARCHAR(60) NOT NULL DEFAULT ''";

$sql[] = "ALTER TABLE ".$db->prefix("mylinks_cat")." CHANGE description description TEXT";

$sql[] = "ALTER TABLE ".$db->prefix("mylinks_cat")." ADD INDEX idx(pid)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("mylinks_cat")."";

//---------------------------------------------------------------------------------------//
// mylinks_links OK
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." DROP INDEX cid";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." DROP INDEX status";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." DROP INDEX title";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE lid lid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE url url VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE email email VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE cid cid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE title title VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE submitter submitter MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE hits hits MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE comments comments SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE votes votes SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE logourl logourl VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE rating rating FLOAT(3, 2) UNSIGNED NOT NULL DEFAULT '0.00'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE date date INT(10) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE status status TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." CHANGE description description TEXT NOT NULL ";

$sql[] = "ALTER TABLE ".$db->prefix("mylinks_links")." ADD INDEX idx(status,cid)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("mylinks_links")."";

//---------------------------------------------------------------------------------------//
// mylinks_mod OK
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_mod")." CHANGE requestid requestid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_mod")." CHANGE url url VARCHAR(255) NOT NULL";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_mod")." CHANGE logourl logourl VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_mod")." CHANGE modifysubmitter modifysubmitter MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_mod")." CHANGE lid lid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_mod")." CHANGE title title VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_mod")." CHANGE cid cid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_mod")." CHANGE email email VARCHAR(60) NOT NULL DEFAULT ''";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("mylinks_mod")."";

//---------------------------------------------------------------------------------------//
// mylinks_votedata OK
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_votedata")." DROP INDEX ratinguser";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_votedata")." DROP INDEX ratinghostname";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_votedata")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("mylinks_votedata")." CHANGE ratingid ratingid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_votedata")." CHANGE ratinghostname ratinghostname VARCHAR(15) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_votedata")." CHANGE lid lid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_votedata")." CHANGE ratinguser ratinguser MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_votedata")." CHANGE ratingtimestamp ratingtimestamp INT(10) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("mylinks_votedata")." CHANGE rating rating FLOAT(3, 2) UNSIGNED NOT NULL DEFAULT '0.00'";

$sql[] = "ALTER TABLE ".$db->prefix("mylinks_votedata")." ADD INDEX idx(lid)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("mylinks_votedata")."";

//---------------------------------------------------------------------------------------//
// newblocks OK
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." DROP INDEX mid";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." DROP INDEX visible";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." DROP INDEX side_visible_mid";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." DROP INDEX mid_funcnum";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE bid bid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE mid mid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE title title VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE content content TEXT";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE weight weight SMALLINT(3) NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE dirname dirname VARCHAR(30) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE show_func show_func VARCHAR(30) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE edit_func edit_func VARCHAR(30) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE func_file func_file VARCHAR(30) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE name name VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE side side TINYINT(3) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE visible visible TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE isactive isactive TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE c_type c_type CHAR(1) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE options options VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE func_num func_num TINYINT(3) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE position position TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." CHANGE type type CHAR(1) NOT NULL DEFAULT 'C'";

$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." ADD iscopy tinyint(1) unsigned NOT NULL default '0' AFTER isactive";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." ADD show_mid varchar(30) NOT NULL default '0' AFTER show_func";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." ADD show_template varchar(40) NOT NULL default 'standard' AFTER show_mid";
$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." ADD page_style tinyint(2) unsigned NOT NULL default '3' AFTER show_template";


$sql[] = "ALTER TABLE ".$db->prefix("newblocks")." ADD INDEX idx(mid,isactive,side,visible)";

// Fixes a slip where some blocks where deactivated :: Beta 1.05
$sql[] = "UPDATE ".$db->prefix("newblocks")." SET iscopy=0";
$sql[] = "UPDATE ".$db->prefix("newblocks")." SET show_mid=0";
$sql[] = "UPDATE ".$db->prefix("newblocks")." SET page_style=3";


$sql[] = "OPTIMIZE TABLE ".$db->prefix("newblocks")."";

//---------------------------------------------------------------------------------------//
// nseccont OK
$sql[] = "ALTER TABLE ".$db->prefix("nseccont")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("nseccont")." CHANGE artid artid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("nseccont")." CHANGE secid secid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("nseccont")." CHANGE title title VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("nseccont")." CHANGE author author MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("nseccont")." CHANGE counter counter MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("nseccont")." CHANGE date date INT(10) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("nseccont")." CHANGE byline byline VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("nseccont")." CHANGE content content TEXT NOT NULL";

$sql[] = "ALTER TABLE ".$db->prefix("nseccont")." ADD INDEX idx(secid)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("nseccont")."";

//---------------------------------------------------------------------------------------//
// nsections OK
$sql[] = "ALTER TABLE ".$db->prefix("nsections")." CHANGE secid secid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("nsections")." CHANGE image image VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("nsections")." CHANGE secname secname VARCHAR(60) NOT NULL DEFAULT ''";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("nsections")."";

//---------------------------------------------------------------------------------------//
// partners OK
$sql[] = "ALTER TABLE ".$db->prefix("partners")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("partners")." CHANGE id id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("partners")." CHANGE url url VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("partners")." CHANGE image image VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("partners")." CHANGE weight weight SMALLINT(3) NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("partners")." CHANGE hits hits MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("partners")." CHANGE title title VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("partners")." CHANGE status status TINYINT(1) UNSIGNED NOT NULL DEFAULT '1'";
$sql[] = "ALTER TABLE ".$db->prefix("partners")." CHANGE description description VARCHAR(255) NOT NULL DEFAULT ''";

$sql[] = "ALTER TABLE ".$db->prefix("partners")." ADD INDEX idx(status)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("partners")."";

//---------------------------------------------------------------------------------------//
// priv_msgs OK
$sql[] = "ALTER TABLE ".$db->prefix("priv_msgs")." DROP INDEX to_userid";
$sql[] = "ALTER TABLE ".$db->prefix("priv_msgs")." DROP INDEX idxprivmsgstouseridreadmsg";
$sql[] = "ALTER TABLE ".$db->prefix("priv_msgs")." DROP INDEX idxprivmsgsmsgidfromuserid";
$sql[] = "ALTER TABLE ".$db->prefix("priv_msgs")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("priv_msgs")." CHANGE msg_id msg_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("priv_msgs")." CHANGE from_userid from_userid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("priv_msgs")." CHANGE to_userid to_userid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("priv_msgs")." CHANGE msg_image msg_image VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("priv_msgs")." CHANGE subject subject VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("priv_msgs")." CHANGE read_msg read_msg TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("priv_msgs")." CHANGE msg_time msg_time INT(10) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("priv_msgs")." CHANGE msg_text msg_text TEXT NOT NULL";

$sql[] = "ALTER TABLE ".$db->prefix("priv_msgs")." ADD INDEX idx(to_userid)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("priv_msgs")."";

//---------------------------------------------------------------------------------------//
// ranks OK
$sql[] = "ALTER TABLE ".$db->prefix("ranks")." DROP INDEX rank_min";
$sql[] = "ALTER TABLE ".$db->prefix("ranks")." DROP INDEX rank_max";
$sql[] = "ALTER TABLE ".$db->prefix("ranks")." DROP INDEX idxranksrankminrankmaxranspecial";
$sql[] = "ALTER TABLE ".$db->prefix("ranks")." DROP INDEX idxranksrankspecial";

$sql[] = "ALTER TABLE ".$db->prefix("ranks")." CHANGE rank_id rank_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("ranks")." CHANGE rank_special rank_special TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("ranks")." CHANGE rank_title rank_title VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("ranks")." CHANGE rank_image rank_image VARCHAR(255) NOT NULL DEFAULT ''";

//$sql[] = "UPDATE ".$db->prefix("ranks")." SET rank_image='rank1.gif' WHERE rank_id=3";
//$sql[] = "UPDATE ".$db->prefix("ranks")." SET rank_image='rank2.gif' WHERE rank_id=4";
//$sql[] = "UPDATE ".$db->prefix("ranks")." SET rank_image='rank3.gif' WHERE rank_id=5";
//$sql[] = "UPDATE ".$db->prefix("ranks")." SET rank_image='rank4.gif' WHERE rank_id=6";
//$sql[] = "UPDATE ".$db->prefix("ranks")." SET rank_image='webmaster.gif' WHERE rank_id=7";
//$sql[] = "UPDATE ".$db->prefix("ranks")." SET rank_image='moderator.gif' WHERE rank_id=8";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("ranks")."";

//---------------------------------------------------------------------------------------//
// session OK
$sql[] = "ALTER TABLE ".$db->prefix("session")." DROP INDEX uid";
$sql[] = "ALTER TABLE ".$db->prefix("session")." DROP INDEX time";
$sql[] = "ALTER TABLE ".$db->prefix("session")." DROP INDEX hash_ip";
$sql[] = "ALTER TABLE ".$db->prefix("session")." DROP INDEX uid_ip";

$sql[] = "ALTER TABLE ".$db->prefix("session")." CHANGE uid uid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("session")." CHANGE ip ip VARCHAR(15) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("session")." CHANGE time time INT(10) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "ALTER TABLE ".$db->prefix("session")." CHANGE uname uname VARCHAR(30) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("session")." CHANGE mid mid MEDIUMINT(8) UNSIGNED DEFAULT '0' NOT NULL";

$sql[] = "ALTER TABLE ".$db->prefix("session")." ADD INDEX idx(uid,hash)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("session")."";

//---------------------------------------------------------------------------------------//
// smiles OK
$sql[] = "ALTER TABLE ".$db->prefix("smiles")." CHANGE id id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("smiles")." CHANGE smile_url smile_url VARCHAR(255) NOT NULL";
$sql[] = "ALTER TABLE ".$db->prefix("smiles")." CHANGE code code VARCHAR(30) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("smiles")." CHANGE emotion emotion VARCHAR(60) NOT NULL DEFAULT ''";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("smiles")."";

//---------------------------------------------------------------------------------------//
// stories OK
$sql[] = "ALTER TABLE ".$db->prefix("stories")." DROP INDEX idxstoriestopic";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." DROP INDEX ihome";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." DROP INDEX uid";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." DROP INDEX published_ihome";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." DROP INDEX title";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." DROP INDEX created";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE storyid storyid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE title title VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE type type ENUM('admin', 'user') NOT NULL DEFAULT 'user'";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE uid uid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE hostname hostname VARCHAR(15) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE counter counter MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE topicid topicid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '1'";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE topicdisplay topicdisplay TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE notifypub notifypub TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE ihome ihome TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE allow_smileys  allow_smileys TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE allow_html allow_html TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE bodytext bodytext TEXT";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE published published INT(10) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE created created INT(10) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE topicalign topicalign ENUM('R', 'L', '0') NOT NULL DEFAULT '0'";

$sql[] = "ALTER TABLE ".$db->prefix("stories")." CHANGE allow_bbcode allow_bbcode TINYINT(1) UNSIGNED NOT NULL DEFAULT '1'";

$sql[] = "ALTER TABLE ".$db->prefix("stories")." ADD INDEX idx(topicid,published,ihome,created)";

//$sql[] = "UPDATE ".$db->prefix("stories")." SET allow_html=ABS(allow_html-1), allow_smileys=ABS(allow_smileys-1)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("stories")."";

//---------------------------------------------------------------------------------------//
// topics OK
$sql[] = "ALTER TABLE ".$db->prefix("topics")." DROP INDEX pid ";
$sql[] = "ALTER TABLE ".$db->prefix("topics")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("topics")." CHANGE topic_id topic_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("topics")." CHANGE topic_pid topic_pid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("topics")." CHANGE topic_imgurl topic_imgurl VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("topics")." CHANGE topic_title topic_title VARCHAR(60) NOT NULL DEFAULT ''";

$sql[] = "ALTER TABLE ".$db->prefix("topics")." ADD INDEX idx(topic_pid)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("topics")."";

//---------------------------------------------------------------------------------------//
// users OK
$sql[] = "ALTER TABLE ".$db->prefix("users")." DROP INDEX idxusersuname";
$sql[] = "ALTER TABLE ".$db->prefix("users")." DROP INDEX idxusersemail";
$sql[] = "ALTER TABLE ".$db->prefix("users")." DROP INDEX idxusersuiduname";
$sql[] = "ALTER TABLE ".$db->prefix("users")." DROP INDEX idxusersunamepass";
$sql[] = "ALTER TABLE ".$db->prefix("users")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE uid uid MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE user_avatar user_avatar VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE user_from user_from VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE theme theme VARCHAR(30) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE posts posts SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE user_intrest user_intrest VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE name name VARCHAR(30) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE uname uname VARCHAR(30) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE email email VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE pass pass VARCHAR(32) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE url url VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE user_sig user_sig VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE user_aim user_aim VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE user_yim user_yim VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE user_msnm user_msnm VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE user_icq user_icq VARCHAR(15) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE user_mailok user_mailok TINYINT(1) UNSIGNED NOT NULL DEFAULT '1'";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE user_occ user_occ VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE umode umode ENUM('flat', 'thread', '0') NOT NULL DEFAULT 'flat'";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE bio bio VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE user_regdate user_regdate INT(10) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE user_viewemail user_viewemail TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE attachsig attachsig TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE uorder uorder TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE last_login last_login INT(10) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE actkey actkey VARCHAR(8) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("users")." CHANGE timezone_offset timezone_offset TINYINT(2) NOT NULL DEFAULT '0'";

//$sql[] = "ALTER TABLE ".$db->prefix("users")." ADD UNIQUE (uname)";
//$sql[] = "ALTER TABLE ".$db->prefix("users")." ADD UNIQUE (email)";
$sql[] = "ALTER TABLE ".$db->prefix("users")." ADD INDEX idx(uname)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("users")."";

//---------------------------------------------------------------------------------------//
// xoopsfaq_categories OK
$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_categories")." CHANGE category_id category_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_categories")." CHANGE category_order category_order SMALLINT(3) NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_categories")." CHANGE category_title category_title VARCHAR(60) NOT NULL DEFAULT ''";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("xoopsfaq_categories")."";

//---------------------------------------------------------------------------------------//
// xoopsfaq_contents OK
$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_contents")." DROP INDEX contents_title";
$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_contents")." DROP INDEX contents_visible_category_id";
$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_contents")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_contents")." CHANGE contents_id contents_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_contents")." CHANGE contents_title contents_title VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_contents")." CHANGE contents_order contents_order SMALLINT(3) NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_contents")." CHANGE category_id category_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_contents")." CHANGE contents_noxcode allow_bbcode TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_contents")." CHANGE contents_nosmiley allow_smileys TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_contents")." CHANGE contents_nohtml allow_html TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_contents")." CHANGE contents_visible contents_visible TINYINT(1) UNSIGNED NOT NULL DEFAULT '1'";

$sql[] = "ALTER TABLE ".$db->prefix("xoopsfaq_contents")." ADD INDEX idx(category_id,contents_visible)";

//$sql[] = "UPDATE ".$db->prefix("xoopsfaq_contents")." SET allow_html=ABS(allow_html-1), allow_smileys=ABS(allow_smileys-1), allow_bbcode=ABS(allow_bbcode-1)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("xoopsfaq_contents")."";

//---------------------------------------------------------------------------------------//
// xoopspoll_desc OK
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_desc")." DROP INDEX end_time";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_desc")." DROP INDEX display";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_desc")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_desc")." CHANGE weight weight SMALLINT(3) NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_desc")." CHANGE description description VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_desc")." CHANGE user_id user_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_desc")." ADD INDEX idx(end_time,display)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("xoopspoll_desc")."";

//---------------------------------------------------------------------------------------//
// xoopspoll_log OK
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_log")." DROP INDEX poll_id_ip";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_log")." DROP INDEX poll_id_user_id";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_log")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_log")." CHANGE log_id log_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_log")." CHANGE user_id user_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_log")." CHANGE ip ip VARCHAR(15) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_log")." CHANGE option_id option_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_log")." ADD INDEX idx(poll_id,option_id)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("xoopspoll_log")."";

//---------------------------------------------------------------------------------------//
// xoopspoll_option OK
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_option")." DROP INDEX poll_id";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_option")." DROP INDEX idx";

$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_option")." CHANGE option_id option_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_option")." CHANGE poll_id poll_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_option")." CHANGE option_color option_color VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_option")." CHANGE option_count option_count SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_option")." CHANGE option_text option_text VARCHAR(60) NOT NULL DEFAULT ''";

$sql[] = "ALTER TABLE ".$db->prefix("xoopspoll_option")." ADD INDEX idx(poll_id)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("xoopspoll_option")."";

//---------------------------------------------------------------------------------------//
// xoopspollcomments OK
$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." DROP INDEX pid";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." DROP INDEX item_id";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." DROP INDEX user_id";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." DROP INDEX subject";

$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." CHANGE comment_id comment_id MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." CHANGE ip ip VARCHAR(15) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." CHANGE icon icon VARCHAR(255) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." CHANGE pid pid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." CHANGE item_id item_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." CHANGE user_id user_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." CHANGE subject subject VARCHAR(60) NOT NULL DEFAULT ''";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." CHANGE nohtml allow_html TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." CHANGE nosmiley allow_smileys TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";
$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." CHANGE noxcode allow_bbcode TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'";

$sql[] = "ALTER TABLE ".$db->prefix("xoopspollcomments")." ADD type ENUM('admin', 'user') NOT NULL DEFAULT 'user' AFTER allow_bbcode";

//$sql[] = "UPDATE ".$db->prefix("xoopspollcomments")." SET allow_html=ABS(allow_html-1), allow_smileys=ABS(allow_smileys-1), allow_bbcode=ABS(allow_bbcode-1)";

$sql[] = "OPTIMIZE TABLE ".$db->prefix("xoopspollcomments")."";

//---------------------------------------------------------------------------------------//
// Execute the above SQL
$count = count($sql);
for ($i=0; $i<$count; $i++) {
	$db->query($sql[$i]) or print("<li>".$db->error()."</li><br />");
}

//---------------------------------------------------------------------------------------//
// Change banner clients password to MD5 encryption
/*$query = $db->query("SELECT cid, passwd FROM ".$db->prefix("bannerclient")."") or print("<li>".$db->error()."</li><br />");
if ($query) {
	while (list($cid, $passwd) = $db->fetch_row($query)) {
		if (strlen($passwd) < 32) {
			$newpass = ($passwd != '') ? md5($passwd) : md5("password");
			$db->query("UPDATE ".$db->prefix("bannerclient")." SET passwd='$newpass' WHERE cid=$cid") or print("<li>".$db->error()."</li><br />");
		}
	}
}*/

//---------------------------------------------------------------------------------------//
// Transfer descriptions to new table :: bb_posts
/*$i=0;
$query = $db->query("SELECT post_id, post_text FROM ".$db->prefix("bb_posts_text")."") or print("<li>".$db->error()."</li><br />");
if ($query) {
	while (list($post_id, $post_text) = $db->fetch_row($query)) {
		$post_text = $myts->oopsAddSlashesRT($post_text);
		$db->query("UPDATE ".$db->prefix("bb_posts")." SET post_text='$post_text' WHERE post_id=$post_id") or print("<li>".$db->error()."</li><br />");
		$i++;
	}
	if ($i == $db->num_rows($query)) {
		$db->query("DROP TABLE ".$db->prefix("bb_posts_text")."") or print("<li>".$db->error()."</li><br />");
		$db->query("OPTIMIZE TABLE ".$db->prefix("bb_posts")."") or print("<li>".$db->error()."</li><br />");
	}
}*/

//---------------------------------------------------------------------------------------//
// Transfer descriptions to new table :: mydownloads_downloads
/*$i=0;
$query = $db->query("SELECT lid, description FROM ".$db->prefix("mydownloads_text")."") or print("<li>".$db->error()."</li><br />");
if ($query) {
	while (list($lid, $description) = $db->fetch_row($query)) {
		$description = $myts->oopsAddSlashesRT($description);
		$db->query("UPDATE ".$db->prefix("mydownloads_downloads")." SET description='$description' WHERE lid=$lid") or print("<li>".$db->error()."</li><br />");
		$i++;
	}
	if ($i == $db->num_rows($query)) {
		$db->query("DROP TABLE ".$db->prefix("mydownloads_text")."") or print("<li>".$db->error()."</li><br />");
		$db->query("OPTIMIZE TABLE ".$db->prefix("mydownloads_downloads")."") or print("<li>".$db->error()."</li><br />");
	}
}*/


//---------------------------------------------------------------------------------------//
// Transfer descriptions to new table :: mylinks_links
/*$i=0;
$query = $db->query("SELECT lid, description FROM ".$db->prefix("mylinks_text")."") or print("<li>".$db->error()."</li><br />");
if ($query) {
	while (list($lid, $description) = $db->fetch_row($query)) {
		$description = $myts->oopsAddSlashesRT($description);
		$db->query("UPDATE ".$db->prefix("mylinks_links")." SET description='$description' WHERE lid=$lid") or print("<li>".$db->error()."</li><br />");
		$i++;
	}
	if ($i == $db->num_rows($query)) {
		$db->query("DROP TABLE ".$db->prefix("mylinks_text")."") or print("<li>".$db->error()."</li><br />");
		$db->query("OPTIMIZE TABLE ".$db->prefix("mylinks_links")."") or print("<li>".$db->error()."</li><br />");
	}
}*/


//---------------------------------------------------------------------------------------//
include_once(XOOPS_ROOT_PATH."/class/xoopsmodule.php");
$modules =& XoopsModule::getInstalledModules();

foreach ($modules as $module) {
	switch($module->dirname) {
		case 'meta-generator':
			@$module->uninstall();
			break;
			
		case 'newbb_plus':
			include_once(XOOPS_ROOT_PATH."/modules/newbb_plus/xoops_version.php");
			include_once(XOOPS_ROOT_PATH."/modules/newbb_plus/config.php");
		
			function get_current_version()
			{
			        global $db;
			        $xoopsModule = XoopsModule::getByDirname('newbb_plus');
			 
			        $sql = 'select version from '.$db->prefix('modules').' WHERE mid='.$xoopsModule->mid();
			        if($result = $db->query($sql))
			        {
			                if($db->num_rows($result) == 1)
			                {
			                        $row = $db->fetch_object($result);
			                        return $row->version;
			                }
			        }
			        return '';
			}
 
			$cur_ver = get_current_version();
			$new_ver = '0.81';
			echo "<h3>Newbb Plus Updater</h3>";
			echo "<hr>";
			echo "Current Version: ".$cur_ver."<br>";
			echo "New Version: ".$new_ver."<br>";
			$updater = XOOPS_ROOT_PATH.'/modules/newbb_plus/_update/update_'.$cur_ver.'_'.$new_ver.'.php';
			if (file_exists($updater))
			{
			        include ($updater);
			        $xoopsModule = XoopsModule::getByDirname('newbb_plus');
			        $xoopsModule->update();
			}else{
			        echo "<h3>No updater available for these versions!</h3>";
			        die();
			}
			echo "<hr>";
			echo "<h3>Update Complete!</h3>";
			echo "<h3><font color='#ff0000'>The '_update' directory should now be removed.</font></h3>";
 
			break;
	

		default:
			@$module->update();
	}
}
//---------------------------------------------------------------------------------------//
?>
