<?php
// $Id: groupaccess.php,v 1.1 2004/07/11 10:27:17 Farsus Exp $
// -------------------------------------------------------------------------//
//			                 RUNCMS                                         //
//                                                                          //
//	 reliable - Unique - Nocost &  Simplicity & ease off use                //
//                       < http://www.runcms.org >                          //
// -------------------------------------------------------------------------//
// Original Author: Half-Dead
// Author Website : http://www.e-xoops.com
// License Type   : Proprietary: See /manual/LICENSES/E-Xoops.txt
// ------------------------------------------------------------------------- //

if (!defined("EXOOPS_GROUPACCESS_INCLUDED")) {
	define("EXOOPS_GROUPACCESS_INCLUDED", 1);

include_once(XOOPS_ROOT_PATH . '/class/xoopsgroup.php');

class groupAccess {

	var $table;
	var $field;
	var $item;

	var $groupname;

	var $groups      = array();
	var $user_groups = array();

	function groupAccess($groupname='groupid') {
	global $xoopsUser;

	$this->groupname = $groupname;

	$this->user_groups = XoopsGroup::getByType("Anonymous");
	if ($xoopsUser) {
		$this->user_groups = array_merge($this->user_groups, $xoopsUser->groups());
	}
	}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function loadGroups($id, $item, $table, $field='groupid') {
global $db;

$this->table = $db->prefix($table);
$this->field = $field;
$this->item  = $item;

if ($result = $db->query("SELECT ".$this->field." FROM ".$this->table." WHERE ".$this->item."='$id'")) {
	list($groups) = $db->fetch_row($result);
	unset($this->groups[$this->groupname]);
	$this->addGroups($groups, 1);
	return(TRUE);
}

return(FALSE);
}

//---------------------------------------------------------------------------------------//
/**
* Makes sure $groupid is a space delimited string and not an array, before saving to database.

* @return string A space delimited string of group ID's
*/
function saveGroups($id) {
global $db;

$groups = array();

foreach ($this->groups[$this->groupname] as $key => $value) {
	if ($value == 1) {
		$groups[$key] = $key;
	}
}

$groups = implode(" ", $groups);

if ($result = $db->query("UPDATE ".$this->table." SET ".$this->field."='$groups' WHERE ".$this->item."='$id'")) {
	return(TRUE);
}

return(FALSE);
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function addGroups($groups, $allow=1) {

if ( !is_array($groups) ) {
	$groups = explode(" ", $groups);
}

($allow == 1) ? $allow = 1 : $allow = 0;

foreach ($groups as $key) {
	$this->groups[$this->groupname][$key] = $allow;
}

}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function removeGroups($groups, $allow=1) {

if ( !is_array($groups) ) {
	$groups = explode(" ", $groups);
}

($allow == 1) ? $allow = 0 : $allow = 1;

foreach ($groups as $key) {
	$this->groups[$this->groupname][$key] = $allow;
}

}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function checkGroups($allow=1) {

($allow == 1) ? $allow = 1 : $allow = 0;

$group_size = count($this->groups);
$user_size  = count($this->user_groups);

$size = ($group_size > $user_size) ? $group_size : $user_size;

foreach ($this->groups[$this->groupname] as $key => $value) {
	if ($value == $allow) {
		if ( @in_array($key, $this->user_groups) ) {
			return(TRUE);
		}
	}
}

return(FALSE);
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function listGroups() {
global $db, $myts, $HTTP_POST_VARS;

if ( !empty($HTTP_POST_VARS[$this->groupname]) ) {
	unset($this->groups[$this->groupname]);
	$this->addGroups($HTTP_POST_VARS[$this->groupname], 1);
}

if ( $result = $db->query("SELECT groupid, name FROM ".$db->prefix('groups')." ORDER BY name ASC") ) {
	$i=0;
	while (list($gid, $name) = $db->fetch_row($result)) {
		if ($i == "4") {
			$grouplist .= "<br />";
			$i=0;
		}
		$grouplist .= "<input type='checkbox' class='checkbox' name='".$this->groupname."[$gid]' value='$gid'";
		if (empty($this->groups[$this->groupname]) || $this->groups[$this->groupname][$gid] == 1) {
			$grouplist .= " checked";
		}
		$grouplist .= " />".$myts->makeTboxData4Show($name);
		$i++;
	}
}

return $grouplist;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function groups($style=1, $type=1) {

($type == 1) ? $type = 1 : $type = 0;

if ($style == 1) {
	return array_keys($this->groups[$this->groupname], $type);
	} else {
		return implode(" ", array_keys($this->groups[$this->groupname], $type));
	}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function userGroups($style=1) {

if ($style == 1) {
	return $this->user_groups;
	} else {
		return implode(" ", $this->user_groups);
	}
}
//---------------------------------------------------------------------------------------//
} // END CLASS
//---------------------------------------------------------------------------------------//
} // END DEFINED
