<?php
// $Id: formselect.php,v 1.1 2004/07/11 10:27:19 Farsus Exp $
// -------------------------------------------------------------------------//
//			                 RUNCMS                                         //
//                                                                          //
//	 reliable - Unique - Nocost &  Simplicity & ease off use                //
//                       < http://www.runcms.org >                          //
// -------------------------------------------------------------------------//
// Original Author: Kazumi Ono
// Author Website : http://www.mywebaddons.com/ , http://www.myweb.ne.jp
// License Type   : GPL: See /manual/LICENSES/GPL.txt
// ------------------------------------------------------------------------- //

if (!defined("EXOOPS_XOOPSFORMSELECT_INCLUDED")) {
	define("EXOOPS_XOOPSFORMSELECT_INCLUDED", 1);

include_once(XOOPS_ROOT_PATH."/class/xoopsform/formelement.php");

class XoopsFormSelect extends XoopsFormElement {

	var $size;
	// pre-selected values in array
	var $value    = array();
	var $options  = array();
	var $multiple = false;

	function XoopsFormSelect($caption, $name, $value="", $size=1, $multiple=false) {
		$this->setCaption($caption);
		$this->setName($name);
		$this->multiple = $multiple;
		$this->size     = intval($size);
		$this->setValue($value);
	}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function isMultiple() {
	return $this->multiple;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function getSize() {
	return $this->size;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function getValue() {
	return $this->value;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function addOption($value, $name="") {

if ( $name != "" ) {
	$this->options[$value] = $name;
	} else {
		$this->options[$value] = $value;
	}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function setValue($value) {

if ( $value != "" ) {
	$this->value = '';
	if ( is_array($value) ) {
		foreach ( $value as $v ) {
			$this->value[] = $v;
		}
		} else {
			$this->value[] = $value;
		}
}

}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function addOptionArray($arr) {

if ( is_array($arr) ) {
	foreach ($arr as $k=>$v) {
		$this->addOption($k, $v);
	}
}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function getOptions() {
	return $this->options;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function render() {

$ret = "<select class='select' size='".$this->getSize()."'".$this->getExtra()."";

if ( $this->isMultiple() != false ) {
	$ret .= " name='".$this->getName()."[]' id='".$this->getName()."[]' multiple='multiple'>";
	} else {
		$ret .= " name='".$this->getName()."' id='".$this->getName()."'>";
	}

foreach ( $this->getOptions() as $value => $name ) {
	$ret .= "<option value='".htmlspecialchars($value, ENT_QUOTES)."'";
	$count = count($this->getValue());
	if ( $count > 0 && in_array($value, $this->getValue()) ) {
		$ret .= " selected='selected'";
	}
	$ret .= ">".$name."</option>";
}
$ret .= "</select>";

return $ret;
}

//---------------------------------------------------------------------------------------//
} // END CLASS
} // END DEFINED
?>
