<?php
// $Id: xoopspagenav.php,v 1.1 2004/07/11 10:27:18 Farsus Exp $
// -------------------------------------------------------------------------//
//			                 RUNCMS                                         //
//                                                                          //
//	 reliable - Unique - Nocost &  Simplicity & ease off use                //
//                       < http://www.runcms.org >                          //
// -------------------------------------------------------------------------//
// Original Author: Kazumi Ono
// Author Website : http://www.mywebaddons.com/ , http://www.myweb.ne.jp
// License Type   : GPL: See /manual/LICENSES/GPL.txt
// ------------------------------------------------------------------------- //

if (!defined("XOOPS_XOOPSPAGENAV_INCLUDED")) {
	define("XOOPS_XOOPSPAGENAV_INCLUDED", 1);

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
class XoopsPageNav {

	var $total;
	var $perpage;
	var $current;
	var $url;


	function XoopsPageNav($total_items, $items_perpage, $current_start, $start_name="start", $extra_arg=""){

	$this->total   = intval($total_items);
	$this->perpage = intval($items_perpage);
	$this->current = intval($current_start);
	if ( $extra_arg != '' && ( substr($extra_arg, -5) != '&amp;' || substr($extra_arg, -1) != '&' ) ) {
		$extra_arg .= '&amp;';
	}
	$this->url = _PHP_SELF.'?'.$extra_arg.trim($start_name).'=';
	}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function renderNav($offset=4, $renderstyle=1) {

if ($this->total < $this->perpage) {
	return;
}

$total_pages = ceil($this->total / $this->perpage);

if ($total_pages > 1) {
	$ret  = '';
	$prev = ($this->current - $this->perpage);

if ($renderstyle == 1) {
	if ($prev >= 0) {
		$ret .= '<a href="'.$this->url.$prev.'"><u>&laquo;</u></a> ';
	}
	} else {
		$ret .= '<table width="100%" class="prenext" border="0" cellpadding="7" cellspacing="0"><tr>';
		if ($prev >= 0) {
			$ret .= '<td align="left"><a href="'.$this->url.$prev.'"><b>&laquo; '._PREVIOUS.'</b></a></td>';
			} else {
				$ret .= '<td align="left">&laquo; <i>'._PREVIOUS.'</i></td>';
			}
		$ret .= '<td align="center">';
	}

	$counter      = 1;
	$current_page = intval(floor(($this->current + $this->perpage) / $this->perpage));
	while ($counter <= $total_pages) {
		if ($counter == $current_page) {
			$ret .= '<b>['.$counter.']</b> ';
			} elseif ( ($counter > $current_page-$offset && $counter < $current_page + $offset ) || $counter == 1 || $counter == $total_pages ) {
				if ( $counter == $total_pages && $current_page < $total_pages - $offset ) {
					$ret .= '... ';
				}
				$ret .= '<a href="'.$this->url.(($counter - 1) * $this->perpage).'">'.$counter.'</a> ';
				if ( ($counter == 1) && ($current_page > (1 + $offset) ) ) {
					$ret .= '... ';
				}
			}
			$counter++;
	}
	$next = ($this->current + $this->perpage);

if ($renderstyle == 1) {
	if ($this->total > $next) {
		$ret .= '<a href="'.$this->url.$next.'"><u>&raquo;</u></a> ';
	}
	} else {
		if ($this->total > $next) {
			$ret .= '<td align="right"><a href="'.$this->url.$next.'"><b>'._NEXT.' &raquo;</b></a></TD>';
			} else {
				$ret .= '<td align="right"><i>'._NEXT.'</i> &raquo;</td>';
			}
		$ret .= '</tr></table>';
	}
}

return $ret;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function renderSelect($showbutton=false) {

if ( $this->total < $this->perpage ) {
	return;
}

$total_pages = ceil($this->total / $this->perpage);
$ret = '';

if ($total_pages > 1) {
	$ret          = '<form name="pagenavform">';
	$ret         .= '<select class="select" name="pagenavselect" id="pagenavselect" onchange="location=this.options[this.options.selectedIndex].value;">';
	$counter      = 1;
	$current_page = intval(floor(($this->current + $this->perpage) / $this->perpage));
	while ($counter <= $total_pages) {
		if ($counter == $current_page) {
			$ret .= '<option value="'.$this->url.(($counter - 1) * $this->perpage).'" selected="selected">'.$counter.'</option>';
			} else {
				$ret .= '<option value="'.$this->url.(($counter - 1) * $this->perpage).'">'.$counter.'</option>';
			}
			$counter++;
		}
	$ret .= '</select>';
	if ($showbutton) {
		$ret .= '&nbsp;<input type="submit" class="button" vallue="'._GO.'" />';
	}
	$ret .= '</form>';
}

return $ret;
}

//---------------------------------------------------------------------------------------//
} // END PAGENAV

//---------------------------------------------------------------------------------------//
}
?>
