<?php
// $Id: edituser.php,v 1.1 2004/07/11 10:27:17 Farsus Exp $
// -------------------------------------------------------------------------//
//			       RUNCMS                                                   //
//                                                                          //
//	 reliable - Unique - Nocost &  Simplicity & ease off use                //
//                       < http://www.runcms.org >                          //
// -------------------------------------------------------------------------//
// Original Author: The Xoops Project
// Author Website : http://www.xoops.org
// Licence Type   : GPL: See /manual/LICENSES/GPL.txt
// ------------------------------------------------------------------------- //

$xoopsOption['pagetype']   = 'user';
$xoopsOption['page_style'] = 8;

include_once('./mainfile.php');
include_once(XOOPS_ROOT_PATH.'/class/xoopsformloader.php');

// If not a user, redirect
if ( !$xoopsUser ) {
	redirect_header('index.php', 3, _NOPERM);
	exit();
}

// initialize $op variable
$op = 'editprofile';

// if GET/POST is set, change $op
if ( isset($HTTP_POST_VARS['op']) ) {
	$op =  $HTTP_POST_VARS['op'];
	} elseif ( isset($HTTP_GET_VARS['op']) ) {
		$op =  $HTTP_GET_VARS['op'];
	}

if ( $op == 'editprofile' ) {
	include_once('header.php');
	OpenTable();
	echo "<a href='userinfo.php?uid=".$xoopsUser->getVar("uid")."'>". _US_PROFILE ."</a>&nbsp;<span style='font-weight:bold;'>&raquo;&raquo;</span>&nbsp;". _US_EDITPROFILE ."<br /><br />";
	$form        = new XoopsThemeForm(_US_EDITPROFILE, "userinfo", "edituser.php");
	$uname_label = new XoopsFormLabel(_US_NICKNAME, $xoopsUser->getVar("uname"));
	$form->addElement($uname_label);
	$name_text = new XoopsFormText(_US_REALNAME, "name", 30, 60, $xoopsUser->getVar("name", "E"));
	$form->addElement($name_text);
	$email_tray = new XoopsFormElementTray(_US_EMAIL, '<br />');
	$email_text = new XoopsFormText('', 'email', 30, 60, $xoopsUser->getVar('email', 'E'));
	$email_tray->addElement($email_text);
	$email_cbox_value = $xoopsUser->user_viewemail() ? 1 : 0;
	$email_cbox       = new XoopsFormCheckBox('', 'user_viewemail', $email_cbox_value);
	$email_cbox->addOption(1, _US_ALLOWVIEWEMAIL);
	$email_tray->addElement($email_cbox);
	$form->addElement($email_tray);
	$url_text = new XoopsFormText(_US_WEBSITE, 'url', 30, 100, $xoopsUser->getVar('url', 'E'));
	$form->addElement($url_text);
	$avatar_array  =& XoopsLists::getImgListAsArray(XOOPS_ROOT_PATH.'/images/avatar/');
	$avatar_select = new XoopsFormSelect('', 'user_avatar', $xoopsUser->getVar('user_avatar'));
	$avatar_select->addOptionArray($avatar_array);
	$a_dirlist      =& XoopsLists::getDirListAsArray(XOOPS_ROOT_PATH.'/images/avatar/');
	$a_dir_labels   = array();
	$a_count        = 0;
	$a_dir_link     = "<a href=\"javascript:openWithSelfMain('".XOOPS_URL."/misc.php?action=showpopups&amp;type=avatars&amp;start=".$a_count."','avatars',600,400);\">XOOPS</a>";
	$a_count        = $a_count + count($avatar_array);
	$a_dir_labels[] = new XoopsFormLabel('', $a_dir_link);

	foreach ($a_dirlist as $a_dir) {
		if ( $a_dir == 'users' ) {
			continue;
		}
		$avatars_array =& XoopsLists::getImgListAsArray(XOOPS_ROOT_PATH."/images/avatar/".$a_dir."/", $a_dir."/");
		$avatar_select->addOptionArray($avatars_array);
		$a_dir_link     = "<a href=\"javascript:openWithSelfMain('".XOOPS_URL."/misc.php?action=showpopups&amp;type=avatars&amp;subdir=".$a_dir."&amp;start=".$a_count."','avatars',600,400);\">".$a_dir."</a>";
		$a_dir_labels[] = new XoopsFormLabel("", $a_dir_link);
		$a_count        = $a_count + count($avatars_array);
	}

	if ( $xoopsConfig['avatar_allow_upload'] == 1 ) {
		$myavatar = avatarExists($xoopsUser->getVar("uid"));
		if ( $myavatar != false ) {
			$avatar_select->addOption($myavatar, _US_MYAVATAR);
		}
	}

	$avatar_select->setExtra("onchange='showImgSelected(\"avatar\", \"user_avatar\", \"images/avatar\")'");
	$avatar_label = new XoopsFormLabel("", "<img src='images/avatar/".$xoopsUser->getVar("user_avatar", "E")."' name='avatar' id='avatar' alt='' />");
	$avatar_tray  = new XoopsFormElementTray(_US_AVATAR, "&nbsp;");
	$avatar_tray->addElement($avatar_select);
	$avatar_tray->addElement($avatar_label);
	foreach ($a_dir_labels as $a_dir_label) {
		$avatar_tray->addElement($a_dir_label);
	}
	$form->addElement($avatar_tray);

	if ( $xoopsConfig['allow_theme'] == 1 ) {
		$temp         = $xoopsUser->getVar("theme");
		$usertheme    = empty($temp) ? $xoopsConfig['default_theme'] : $temp;
		$theme_select = new XoopsFormSelectTheme(_US_THEME, "theme", $usertheme);
		$form->addElement($theme_select);
	}

	$timezone_select = new XoopsFormSelectTimezone(_US_TIMEZONE, "timezone_offset", $xoopsUser->getVar("timezone_offset"));
	$icq_text        = new XoopsFormText(_US_ICQ, "user_icq", 30, 100, $xoopsUser->getVar("user_icq", "E"));
	$aim_text        = new XoopsFormText(_US_AIM, "user_aim", 30, 100, $xoopsUser->getVar("user_aim", "E"));
	$yim_text        = new XoopsFormText(_US_YIM, "user_yim", 30, 100, $xoopsUser->getVar("user_yim", "E"));
	$msnm_text       = new XoopsFormText(_US_MSNM, "user_msnm", 30, 100, $xoopsUser->getVar("user_msnm", "E"));
	$location_text   = new XoopsFormText(_US_LOCATION, "user_from", 30, 100, $xoopsUser->getVar("user_from", "E"));
	$occupation_text = new XoopsFormText(_US_OCCUPATION, "user_occ", 30, 100, $xoopsUser->getVar("user_occ", "E"));
	$interest_text   = new XoopsFormText(_US_INTEREST, "user_intrest", 30, 100, $xoopsUser->getVar("user_intrest", "E"));
	$sig_tray        = new XoopsFormElementTray(_US_SIGNATURE, "<br />");
	$sig_tarea       = new XoopsFormDhtmlTextArea('', 'user_sig', $xoopsUser->getVar('user_sig', 'E'));
	$sig_tray->addElement($sig_tarea);
	$sig_cbox_value = $xoopsUser->getVar("attachsig") ? 1 : 0;
	$sig_cbox       = new XoopsFormCheckBox("", "attachsig", $sig_cbox_value);
	$sig_cbox->addOption(1, _US_SHOWSIG);
	$sig_tray->addElement($sig_cbox);
	$umode_select = new XoopsFormSelect(_US_CDISPLAYMODE, "umode", $xoopsUser->getVar("umode"));
	$umode_select->addOptionArray(array("0"=>_NOCOMMENTS, "flat"=>_FLAT, "thread"=>_THREADED));
	$uorder_select = new XoopsFormSelect(_US_CSORTORDER, "uorder", $xoopsUser->getVar("uorder"));
	$uorder_select->addOptionArray(array("0"=>_OLDESTFIRST, "1"=>_NEWESTFIRST));
	$bio_tarea          = new XoopsFormTextArea(_US_EXTRAINFO, "bio", $xoopsUser->getVar("bio", "E"));
	$cookie_radio_value = empty($HTTP_COOKIE_VARS[$xoopsConfig['cookie_name']]) ? 0 : 1;
	$cookie_radio       = new XoopsFormRadioYN(_US_USECOOKIE, "usecookie", $cookie_radio_value, _YES, _NO);
	$pwd_text           = new XoopsFormPassword("", "upass", 10, 20);
	$pwd_text2          = new XoopsFormPassword("", "vpass", 10, 20);
	$pwd_tray           = new XoopsFormElementTray(_US_PASSWORD."<br />"._US_TYPEPASSTWICE);
	$pwd_tray->addElement($pwd_text);
	$pwd_tray->addElement($pwd_text2);
	$mailok_radio  = new XoopsFormRadioYN(_US_MAILOK, 'user_mailok', $xoopsUser->getVar('user_mailok'));
	$uid_hidden    = new XoopsFormHidden("uid", $xoopsUser->getVar("uid"));
	$op_hidden     = new XoopsFormHidden("op", "saveuser");
	$submit_button = new XoopsFormButton("", "submit", _SAVE, "submit");

	$form->addElement($timezone_select);
	$form->addElement($icq_text);
	$form->addElement($aim_text);
	$form->addElement($yim_text);
	$form->addElement($msnm_text);
	$form->addElement($location_text);
	$form->addElement($occupation_text);
	$form->addElement($interest_text);
	$form->addElement($sig_tray);
	$form->addElement($umode_select);
	$form->addElement($uorder_select);
	$form->addElement($bio_tarea);
	$form->addElement($pwd_tray);
	$form->addElement($cookie_radio);
	$form->addElement($mailok_radio);
	$form->addElement($uid_hidden);
	$form->addElement($op_hidden);
	$form->addElement($submit_button);
	$form->setRequired('email');
	$form->display();
	CloseTable();
	include_once('footer.php');
}

if ( $op == 'saveuser' ) {
	if ( $xoopsUser->getVar('uid') != $uid ) {
		redirect_header('index.php', 3, _NOACTION);
		exit();
	}

	$email = $myts->oopsStripSlashesGPC(trim($email));
	if ( (!$email) || ($email=='') || (!checkEmail($email)) ) {
		include_once('header.php');
		OpenTable();
		echo _US_INVALIDMAIL.'<br />';
		CloseTable();
		include_once('footer.php');
		exit();
	}

	if ( !empty($xoopsBadEmails) && hasMatch($xoopsBadEmails, $email) ) {
		include_once('header.php');
		OpenTable();
		echo _US_EMAILRESERVED;
		CloseTable();
		include_once('footer.php');
		exit();

	}

	if ( $user_avatar != '' ) {
		if (substr($user_avatar, 0, 6) == 'users/') {
			if ( $myts->oopsStripSlashesGPC(trim($user_avatar)) != avatarExists($xoopsUser->getVar("uid")) ) {
				$user_avatar = '';
			}
		}
	}

	if (isset($upass)) {
		$upass = trim($upass);
	}

	if (isset($vpass)) {
		$vpass = trim($vpass);
	}

	if ( (isset($upass)) && ($upass != $vpass) ) {
		include_once('header.php');
		OpenTable();
		echo _US_PASSNOTSAME;
		CloseTable();
		include_once('footer.php');
		} elseif ( ($upass != '') && (strlen($upass) < $xoopsConfig['minpass']) ) {
			include_once('header.php');
			OpenTable();
			printf(_US_PWDTOOSHORT, $xoopsConfig['minpass']);
			CloseTable();
			include_once('footer.php');
			} else {
				$edituser = new XoopsUser($uid);
				$edituser->setVar('name', $name);
				$edituser->setVar('email', $email);
				$edituser->setVar('url', formatURL($url));
				$edituser->setVar('user_avatar', $user_avatar);
				$edituser->setVar('user_icq', $user_icq);
				$edituser->setVar('user_from', $user_from);
				$edituser->setVar('user_sig', $user_sig);
				$edituser->setVar('user_viewemail', $user_viewemail);
				$edituser->setVar('user_aim', $user_aim);
				$edituser->setVar('user_yim', $user_yim);
				$edituser->setVar('user_msnm', $user_msnm);

				if ( isset($upass) && $upass != '') {
					$edituser->setVar('pass', md5($upass));
				}

				$edituser->setVar('attachsig', $attachsig);
				$edituser->setVar('timezone_offset', $timezone_offset);

				if ( !empty($theme) && $xoopsConfig['allow_theme'] == 1 ) {
					$edituser->setVar('theme', $theme);
				}

				$edituser->setVar('uorder', $uorder);
				$edituser->setVar('umode', $umode);
				$edituser->setVar('bio', $bio);
				$edituser->setVar('user_occ', $user_occ);
				$edituser->setVar('user_intrest', $user_intrest);
				$edituser->setVar('user_mailok', $user_mailok);

				if ( $usecookie ) {
					cookie($xoopsConfig['cookie_name'], $xoopsUser->getVar("uname"), 31536000);
					} else {
						cookie($xoopsConfig['cookie_name']);
					}

				if ( !$edituser->store() ) {
					include_once('header.php');
					echo $edituser->getErrors();
					include_once('footer.php');
					} else {
						redirect_header("userinfo.php?uid=".$uid."",1,_US_PROFUPDATED);
					}

				exit();
			}
}

if ( $op == 'avatarform' && $xoopsConfig['avatar_allow_upload'] == 1 ) {
	include_once('header.php');
	OpenTable();
	echo "<a href='userinfo.php?uid=".$xoopsUser->getVar("uid")."'>". _US_PROFILE ."</a>&nbsp;<span style='font-weight:bold;'>&raquo;&raquo;</span>&nbsp;". _US_UPLOADMYAVATAR ."<br /><br />";
	if ( $oldavatar = avatarExists($xoopsUser->getVar("uid")) ) {
		echo "<div style='text-align:center;'><h4 style='color:#ff0000; font-weight:bold;'>"._US_OLDDELETED."</h4>";
		echo "<img src='".XOOPS_URL."/images/avatar/".$oldavatar."' /></div>";
	}
	$pixels_label  = new XoopsFormLabel(_US_MAXPIXEL, $xoopsConfig['avatar_width']." x ".$xoopsConfig['avatar_height']);
	$size_label    = new XoopsFormLabel(_US_MAXIMGSZ, $xoopsConfig['avatar_maxsize']);
	$file_form     = new XoopsFormFile(_US_SELFILE, 'avatarfile', $xoopsConfig['avatar_maxsize']);
	$op_hidden     = new XoopsFormHidden('op', 'avatarupload');
	$submit_button = new XoopsFormButton('', 'submit', _SUBMIT, 'submit');
	$form          = new XoopsThemeForm(_US_UPLOADMYAVATAR, 'uploadavatar', 'edituser.php');
	$form->setExtra("enctype='multipart/form-data'");
	$form->setRequired('avatarfile');
	$form->addElement($pixels_label);
	$form->addElement($size_label);
	$form->addElement($file_form);
	$form->addElement($op_hidden);
	$form->addElement($submit_button);
	$form->display();
	CloseTable();
	include_once('footer.php');
}

if ( ($op == 'avatarupload') && ($xoopsConfig['avatar_allow_upload'] == 1) ) {
	include_once(XOOPS_ROOT_PATH . '/class/fileupload.php');
	$upload = new fileupload();
	$upload->set_upload_dir(XOOPS_ROOT_PATH . '/images/avatar/users', 'avatarfile');
	$upload->set_basename($xoopsUser->uid(), 'avatarfile');
	$upload->set_accepted('gif|jpg|png', 'avatarfile');
	$upload->set_overwrite(2, 'avatarfile');
	$upload->set_max_image_height($xoopsConfig['avatar_height'], 'avatarfile');
	$upload->set_max_image_width($xoopsConfig['avatar_width']  , 'avatarfile');

	$result = $upload->upload();
	if ($result['avatarfile']['filename']) {
		$db->query("UPDATE ".$db->prefix('users')." SET user_avatar='".avatarExists($xoopsUser->getVar('uid'))."' WHERE uid=".$xoopsUser->getVar("uid")."");
		redirect_header('user.php', 0);
		} else {
			include_once('header.php');
			OpenTable();
			echo $upload->errors();
			CloseTable();
			include_once('footer.php');
			exit();
		}
}
?>
