package xor.main;

import java.net.*;
import java.util.*;
import java.lang.*;

public class AddPair implements Cloneable{
    private InetAddress m_oInetAdd;
    private int m_nPort;
    private String m_sType;
    private boolean m_isRefreshed;
    private Set<InetAddress> m_aoProxyIgnoringAddresses;
    
    AddPair(String _sType,Set<InetAddress> _aoPIA,InetAddress _oInetAdd,int _nPort){
	init(_sType,_aoPIA,_oInetAdd,_nPort);
    }
    AddPair(String _sType,Set<InetAddress> _aoPIA,InetAddress _oInetAdd){
	init(_sType,_aoPIA,_oInetAdd,-1);
    }
    AddPair(String _sType,Set<InetAddress> _aoPIA){
	init(_sType,_aoPIA,null,-1);
    }
    private void init(String _sType,Set<InetAddress> _aoPIA,InetAddress _oInetAdd,int _nPort){
	m_oInetAdd = _oInetAdd;
	m_nPort = _nPort;
	m_sType = _sType;
	m_aoProxyIgnoringAddresses = _aoPIA;
	m_isRefreshed = false;
    }
    public void refresh(){
	if(!m_isRefreshed && m_oInetAdd != null){
	    System.setProperty(m_sType+".proxyPort",new Integer(m_nPort).toString());
	    System.setProperty(m_sType+".proxyHost",m_oInetAdd.getCanonicalHostName());
	    m_isRefreshed = true;
	}
    }
    public AddPair clone(){
	return new AddPair(m_sType,m_aoProxyIgnoringAddresses,m_oInetAdd,m_nPort);
    }
    public String getType(){
	return m_sType;
    }
    public int getPort(){
	return m_nPort;
    }
    public String getInetAdd(){
	if(m_oInetAdd != null){
	    return m_oInetAdd.getHostName();
	}
	return new String();
    }
    public void setType(String _sType){
	m_sType = _sType;
	m_isRefreshed = false; 
    }
    public void setInetAdd(InetAddress _oIA){
	m_oInetAdd = _oIA;
	m_isRefreshed = false; 
    }
    public void setInetAdd(String _sIA){
	try{
	    m_oInetAdd = InetAddress.getByName(_sIA);
	}catch(UnknownHostException e){
	    e.printStackTrace();
	}
	m_isRefreshed = false; 
    }
    public void setPort(int _nPort){
	m_nPort = _nPort;
	m_isRefreshed = false; 
    }
    public void setPort(String _sPort){
	m_nPort = Integer.parseInt(_sPort);
	m_isRefreshed = false; 
    }
    public boolean isSet(){
	return (m_nPort != -1);
    }
}
