package xor.main;

import java.util.*;
import xor.sche.*;

public class DB extends Node{
    protected DBSet m_oDBSet;
    protected DBBuffer m_oCanvas,m_oPalette;
    protected Map<Sche,Thread> m_oAutoLoaderMap;
    private Kernel m_oKernel;

    public DB(DBSet _oDBSet,Kernel _oKernel){
	m_oKernel = _oKernel;
	m_oDBSet = _oDBSet;
	m_oCanvas = new DBBuffer();
	m_oPalette = new DBBuffer();
	addNode("canvas",m_oCanvas);
	addNode("palette",m_oPalette);
	m_oAutoLoaderMap = new HashMap<Sche,Thread>();
    }
    public void addNewSche(Sche _oSche,String _sType){
	addNewSche(_oSche,_sType,true);
    }
    synchronized public boolean addNewSche(Sche _oSche,String _sType,boolean _isCallingBack){
	boolean _isAdded = false;
	DBBuffer _oUsingDBBuffer = null;
	DBBuffer _oOtherDBBuffer = null;
	if(_sType.equals("canvas")){
	    _oUsingDBBuffer = m_oCanvas;	
	    _oOtherDBBuffer = m_oPalette;
	}else if(_sType.equals("palette")){
	    _oUsingDBBuffer = m_oPalette;
	    _oOtherDBBuffer = m_oCanvas;
	}
	_isAdded = (_oUsingDBBuffer.addNewSche(_oSche) &&
		    !_oOtherDBBuffer.containsSche(_oSche));
	if(_isAdded){
	    m_oKernel.getLogger().config("Loaded Sche at "+_sType+": ID = "+_oSche.ID()); 
	    ScheAutoLoader _oSAL = new ScheAutoLoader(_oSche);
	    Thread _oT = new Thread(_oSAL);
	    _oSAL.setThread(_oT);
	    _oT.start();
	    m_oAutoLoaderMap.put(_oSche,_oT);
	    if(_isCallingBack){
		m_oDBSet.callbackNodeComplete(_oSche,_sType);
	    }
	}else{
	    Sche _oOriginalSche = _oUsingDBBuffer.getScheWith(_oSche.ID());
	    boolean _isUpdated = _oOriginalSche.updateTo(_oSche);
	    if(_isUpdated){
		m_oKernel.getLogger().config("Updated Sche at "+_sType+": ID = "+_oSche.ID());
		m_oDBSet.update(_oOriginalSche);
	    }else{
		m_oKernel.getLogger().config("Loaded existing Sche but didn't update at "+_sType+": ID = "+_oSche.ID()); 
	    }
	}
	return _isAdded;
    }
    public void removeSche(Sche _oSche){
	m_oCanvas.removeSche(_oSche);
	m_oPalette.removeSche(_oSche);
    }
    public void moveSche(Sche _oSche,PaletteEnum _sType){
	removeSche(_oSche);
	if(_sType == PaletteEnum.CANVAS){
	    m_oCanvas.addNewSche(_oSche);
	}else{
	    m_oPalette.addNewSche(_oSche);
	}
    }
    public String typeOf(String _sID){
	if(m_oCanvas.containsID(_sID)){
	    return "canvas";
	}else if(m_oPalette.containsID(_sID)){
	    return "palette";
	}
	return null;
    }
    public String type(){
	return "db";
    }
    public DBBuffer getCanvas(){
	return m_oCanvas;
    }
    public DBBuffer getPalette(){
	return m_oPalette;
    }
    class ScheAutoLoader implements Runnable{
	private Sche m_oS;
	private Thread m_oT;
	private int m_nReloadMilliSecs;
	
	ScheAutoLoader(Sche _oS){
	    m_oS = _oS;
	    m_nReloadMilliSecs = 10000; // 10 minutes
	}
	public void setThread(Thread _oT){
	    m_oT = _oT;
	}
	public void resetReloadMilliSecs(int _nNew){
	    reload();
	    m_nReloadMilliSecs = _nNew;
	}
	public void run(){
	    if(m_oT == null){
		return;
	    }
	    while(true){
		try{
		    m_oT.sleep(m_nReloadMilliSecs);
		}catch(InterruptedException e){
		    e.printStackTrace();
		}
		if(!m_oDBSet.isBusy()){
		    reload();
		}
	    }
	}
	synchronized public void reload(){
	    m_oKernel.getImporter().reloadSche(m_oS);
	}
    }
}
