package xor.main;

import java.io.*;
import java.util.*;
import java.util.logging.*;
import xor.sche.*;

final public class DBSet extends Node{
    private Kernel m_oKernel;
    private DB m_oDB;
    private boolean m_hasChanges;
    private Logger m_oLogger;
    private String m_sConfigFileDir;
    private boolean m_isStoppedToSave;

    DBSet(Kernel _oKernel,String _sConfigFileDir){
	super();
	m_oKernel = _oKernel;
	m_sConfigFileDir = _sConfigFileDir;
	m_oDB = new DB(this,m_oKernel);
	super.addNode("buffer",m_oDB);
	m_hasChanges = false;
	m_isStoppedToSave = false;
	loadDB();
    }
    public void callbackNodeComplete(Sche _oSche,String _sType){
	String _sID = _oSche.ID();
	boolean _isImported = m_oDB.addNewSche(_oSche,_sType,false);
	if(_isImported){
	    DBSetEvent _oEv = new DBSetEvent(this,DBSetEnum.ADD,_oSche);
	    m_oKernel.getInterface().sendDBSetListener(_oEv);
	}
    }
    public void save(){
	makeDBSettingWaiterThread();
	alertIfCannotSave();
    }
    public void update(Sche _oS){
	DBSetEvent _oEv = new DBSetEvent(this,DBSetEnum.UPDATE,_oS);
	m_oKernel.getInterface().sendDBSetListener(_oEv);
	m_hasChanges = true;
    }
    public void alertIfCannotSave(){
	if(!isSavable()){
	    int _nWantToSetDB = m_oKernel.getInterface().makeDecision("Database to save is not set. Do you want to set now?");
	    if(_nWantToSetDB == 0){
		if(m_oKernel.getInterface().type().equals("MDI")){
		    ((xor.main.swing.MDIInterface)m_oKernel.getInterface()).showWindow("Setting");
		}
	    }
	}
    }
    private void beginRealTaskToSave(){
	Iterator _i = keySet().iterator();
	while(_i.hasNext()){
	    String _sR = (String)_i.next();
	    Node _oN = (Node)get(_sR);
	    if(_oN != null && _oN.type().equals("dbloader")){
		((xor.main.dbloader.Abstract)_oN).save(m_oDB);
	    }
	}
	m_hasChanges = false;
    }
    private void makeDBSettingWaiterThread(){
	DBSettingWaiter _oDBW = new DBSettingWaiter();
	Thread _oT = new Thread(_oDBW);
	_oDBW.setThread(_oT);
	_oT.start();
    }
    class DBSettingWaiter implements Runnable{
	private Thread m_oT;

	DBSettingWaiter(){
	    m_oT = null;
	}
	public void setThread(Thread _oT){
	    m_oT = _oT;
	}
	public void run(){
	    try{
		while(!isSavable()){
		    m_oT.sleep(500);
		}
	    }catch(java.lang.InterruptedException e){
		e.printStackTrace();
	    }
	    beginRealTaskToSave();
	}
    }
    synchronized public boolean isBusy(){
	Iterator _i = keySet().iterator();
	while(_i.hasNext()){
	    String _sR = (String)_i.next();
	    Node _oN = (Node)get(_sR);
	    if(_oN != null && _oN.type().equals("dbloader")){
		xor.main.dbloader.Abstract _oDB = (xor.main.dbloader.Abstract)_oN;
		String _sProfile = "["+_oDB.profile()+"]";
		if(_oDB.isBusy()){
		    m_oKernel.getLogger().finest(_sProfile+" is busy.");
		    return true;
		}else{
		    m_oKernel.getLogger().finest(_sProfile+" is not busy.");
		}
	    }
	}
	return false;
    }
    synchronized public boolean isSavable(){
	if(onlyContains("buffer")){
	    return false;
	}
	Iterator _i = keySet().iterator();
	while(_i.hasNext()){
	    String _sR = (String)_i.next();
	    Node _oN = (Node)get(_sR);
	    if(_oN != null && _oN.type().equals("dbloader")){
		if(((xor.main.dbloader.Abstract)_oN).isSavable()){
		}else{
		    return false;
		}
	    }
	}
	return true;
    }
    public boolean hasChanges(){
	return m_hasChanges;
    }
    public void loadDB(){
	File _oDatDir = new File(m_sConfigFileDir);
	String[] _asFiles = _oDatDir.list();
	if(_asFiles != null){
	    int i;
	    for(i=0;i<_asFiles.length;i++){
		String _sName = _asFiles[i];
		if(_sName.substring(0,1).equals(".")){
		    continue;
		}
		addDB(_sName,new TextConfigFileLoader(m_oKernel,m_sConfigFileDir+"/"+_sName));
	    }
	}
    }
    public xor.main.dbloader.Abstract addDB(String _sName,String _sType){
	TextConfigFileLoader _oTCFL = new TextConfigFileLoader(m_oKernel,m_sConfigFileDir+"/"+_sName);
	xor.main.dbloader.Factory _oDBF = new xor.main.dbloader.Factory(this,_oTCFL,_sType,m_oKernel);
	m_hasChanges = true;
	return addDBWithFactory(_sName,_oDBF);
    }
    public xor.main.dbloader.Abstract addDB(String _sName,TextConfigFileLoader _oTCFL){	
	xor.main.dbloader.Factory _oDBF = new xor.main.dbloader.Factory(this,_oTCFL,m_oKernel);
	return addDBWithFactory(_sName,_oDBF);
    }
    private xor.main.dbloader.Abstract addDBWithFactory(String _sName,xor.main.dbloader.Factory _oDBF){
	xor.main.dbloader.Abstract _oDB = _oDBF.get(_sName);
	if(_oDB != null){
	    addNode(_sName,_oDB);
	}
	return _oDB;
    }
    public void removeDB(String _sName){
	if(_sName.equals("buffer")){
	    return;
	}
	dumpChildren();
	xor.main.dbloader.Abstract _oDB = (xor.main.dbloader.Abstract)get(_sName);
	if(_oDB != null){
	    _oDB.suicide();
	}
	deleteNode(_sName);
    }
    public Map<String,xor.main.dbloader.Abstract> getDBs(){
	Map<String,xor.main.dbloader.Abstract> _aoS = new HashMap<String,xor.main.dbloader.Abstract>();
	Iterator _i = getKeys().iterator();
	while(_i.hasNext()){
	    String _sKey = (String)_i.next();
	    if(_sKey.equals("buffer")){
		continue;
	    }
	    _aoS.put(_sKey,(xor.main.dbloader.Abstract)get(_sKey));
	}
	return _aoS;
    }
    public void move(Sche _oSche,PaletteEnum _sType){
	m_oDB.moveSche(_oSche,_sType);
	m_hasChanges = true;
    }
    public void remove(Sche _oSche){
	m_oDB.removeSche(_oSche);
    }
    public String type(){
	return "dbset";
    }
    public String typeOf(String _sID){
	return m_oDB.typeOf(_sID);
    }
    public String typeOf(Sche _oS){
	return m_oDB.typeOf(_oS.ID());
    }
    public String pathOf(Sche _oS){
	return "dat::buffer::"+typeOf(_oS)+"::"+_oS.ID();
    }
    public String pathOf(String _sS){
	return "dat::buffer::"+typeOf(_sS)+"::"+_sS;
    }
}
