package xor.main;

import gnu.getopt.Getopt;
import java.io.*;
import java.util.*;
import java.lang.*;
import java.util.logging.*;
import xor.sche.*;

public class Kernel extends Node implements Runnable{
    private AbstractInterface m_oInterface;
    private Thread m_tInterface;
    private AbstractQueryParser m_oQueryParser;
    private Set<String> m_aoSelectedSet;
    private String[] m_asArgv;
    private Importer m_oImporter;
    private ScheAdderSocket m_oSAS;
    private Logger m_oLogger;
    private ELogger m_oELogger;
    private DBSet m_oDBSet;
    private Set<Sche> m_aoSelectionEventSet;
    private String m_sSelectionType;
    static public String s_sVersion = "0.5";
    static private String s_sConfigFileDir = "./.sche.swing.conf";

    public Kernel(String[] _sArgv){
	m_asArgv = _sArgv;
	m_oLogger = Logger.getLogger("sche.swing");
	try{
	    FileHandler _oFH = new FileHandler("out.log");
	    _oFH.setFormatter(new SimpleFormatter());
	    m_oLogger.addHandler(_oFH);
	    m_oELogger = new ELogger();
	    m_oLogger.addHandler(m_oELogger);
	    m_oLogger.setLevel(Level.ALL);
	}catch(IOException e){
	    e.printStackTrace();
	}
    }
    public void run(){
	m_oLogger.config("Starting Kernel.");
	Getopt _oG = new Getopt("ScheSwing",m_asArgv,"i:");
	int _nI;
	InterfaceFactory _oIF = new InterfaceFactory(this);
	m_oSAS = new ScheAdderSocket(this);
	Thread _oSASThread = new Thread(m_oSAS);
	_oSASThread.start();
	m_oQueryParser = new SCHEDULParser(this);
	m_aoSelectedSet = new HashSet<String>();
	m_oInterface = _oIF.get("console");
	while((_nI=_oG.getopt()) != -1){
	    switch (_nI){
	    case 'i':
		m_oInterface = _oIF.get(_oG.getOptarg());
	    default:
		break;
	    }
	}
	m_oDBSet = new DBSet(this,s_sConfigFileDir+"/dat");
	addNode("dat",m_oDBSet);
	m_oDBSet.alertIfCannotSave();
	m_oImporter = new Importer(this,s_sConfigFileDir+"/network",m_oDBSet);
	addNode("importer",m_oImporter);
    }
    synchronized public void execQuery(String _sQuery){
	execQuery(_sQuery,(SelectionMap)null);
    }
    synchronized public void execQuery(String _sQuery,QueryCaller _oQC){
	SelectionMap _oSM = new SelectionMap();
	execQuery(_sQuery,_oSM,_oQC);
    }
    synchronized public void execQuery(String _sQuery,SelectionMap _oSM,QueryCaller _oQC){
	if(_oSM == null){
	    _oSM = new SelectionMap();
	}
	_oSM.changed(_oQC);
	execQuery(_sQuery,_oSM);
    }
    synchronized public void execQuery(String _sQuery,SelectionMap _oSM){
	m_oQueryParser.parse(_sQuery,_oSM);
    }
    public void exit(){
	m_oLogger.config("Going to exit.");
	if(m_oDBSet.hasChanges()){
	    m_oLogger.fine("DB has changes.");
	    int _nWantToSave = m_oInterface.makeDecision("Schedules are changed. Do you want to save?");
	    if(_nWantToSave == 2){
		return;
	    }else if(_nWantToSave == 0){
		m_oDBSet.save();
		runHaltWaiter();
		return;
	    }else{
		halt();
		return;
	    }
	}
	halt();
    }
    private void runHaltWaiter(){
	HaltWaiterForSave _oHWFS = new HaltWaiterForSave();
	Thread _oT = new Thread(_oHWFS);
	_oHWFS.setThread(_oT);
	_oT.start();
    }
    class HaltWaiterForSave implements Runnable{
	private Thread m_oT;
	
	HaltWaiterForSave(){
	    m_oT = null;
	}
	public void setThread(Thread _oT){
	    m_oT = _oT;
	}
	public void run(){
	    if(m_oT == null){
		return;
	    }
	    try{
		while(m_oDBSet.isBusy()){
		    m_oT.sleep(200);
		    m_oLogger.finest("DB is busy. Sleeping...");
		}
	    }catch(java.lang.InterruptedException e){
		e.printStackTrace();
	    }
	    halt();
	}
    }
    public void halt(){
	getLogger().config("Kernel HALTED.");
	System.exit(0);
    }
    public void doWith(String _sType,AbstractList<String> _asValues){
	if(_sType.equals("printKernelVersion")){
	    m_oInterface.println(s_sVersion);
	}else if(_sType.equals("type")){
	    m_oInterface.println(type());
	}
    }
    public AbstractInterface getInterface(){
	return m_oInterface;
    }
    public Importer getImporter(){
	return m_oImporter;
    }
    public Logger getLogger(){
	return m_oLogger;
    }
    public ELogger getELogger(){
	return m_oELogger;
    }
    public DBSet getDBSet(){
	return m_oDBSet;
    }
    synchronized public void resetChanges(){
	m_aoSelectionEventSet = new HashSet<Sche>();
	clearAllSelectedWithoutEvent();
    }
    synchronized public void addSelectedPath(String _sPath){
	Sche _oSche = (Sche)iteratePath(this,_sPath);
	m_aoSelectionEventSet.add(_oSche);
	m_aoSelectedSet.add(_sPath);
    }
    synchronized public void setSelectionType(String _sType){
	m_sSelectionType = _sType;
    }
    synchronized public void applyChangesForSelectedSet(SelectionMap _oSM){
	sendSelectionEvent(_oSM);
	sendSelectionResultString();
    }
    private void sendSelectionEvent(SelectionMap _oSM){
	if(_oSM == null){_oSM = new SelectionMap();}
	Iterator _i = m_aoSelectionEventSet.iterator();
	while(_i.hasNext()){
	    Sche _oS = (Sche)_i.next();
	    _oSM.addScheFor(_oS);
	}
	DBSetEvent _oEv = new DBSetEvent(this,DBSetEnum.SELECT,_oSM);
	getInterface().sendDBSetListener(_oEv);
    }
    public Set<Sche> getSelectionSet(){
	return m_aoSelectionEventSet;
    }
    private void sendSelectionResultString(){
	m_oInterface.print("# Selected : ");
	Iterator _i = m_aoSelectedSet.iterator();
	while(_i.hasNext()){
	    m_oInterface.print(_i.next()+",");
	}
	m_oInterface.println("");
    }
    synchronized public void clearAllSelected(){
	clearAllSelectedWithoutEvent();
	sendUnselectionEvent();
    }
    private void clearAllSelectedWithoutEvent(){
	m_aoSelectedSet.clear();
	m_aoSelectionEventSet.clear();
    }
    private void sendUnselectionEvent(){
	DBSetEvent _oEv = new DBSetEvent(this,DBSetEnum.UNSELECT);
	getInterface().sendDBSetListener(_oEv);
    }
    public Iterator getSelectedPathIterator(){
	return m_aoSelectedSet.iterator();
    }
    public String type(){
	return "kernel";
    }
    public String version(){
	return s_sVersion;
    }
    public String getConfigFileDir(){
	return s_sConfigFileDir;
    }
}
