package xor.main;

import java.util.*;

abstract public class Node{
    private AbstractMap<String,Node> m_oNodes;

    public Node(){
	m_oNodes = new HashMap<String,Node>();
    }
    public void addNode(String _sKey,Node _oNode){
	m_oNodes.put(_sKey,_oNode);
    }
    public Set<String> getKeys(){
	return m_oNodes.keySet();
    }
    public boolean isEmpty(){
	return m_oNodes.isEmpty();
    }
    public boolean onlyContains(String _sKey){
	return (m_oNodes.containsKey(_sKey)&&
	    m_oNodes.size() == 1);
    }
    public boolean exists(String _sKey){
	return m_oNodes.containsKey(_sKey);
    }
    public void deleteNode(String _sKey){
	m_oNodes.remove(_sKey);
    }
    public Node get(String _sKey){
	return m_oNodes.get(_sKey);
    }
    public void doWith(String _sType,AbstractList<String> _asValues){}
    public Node iteratePath(Kernel _oRoot,String _sPath){
	return iteratePath(_oRoot,_sPath,-1);
    }
    public Set<String> keySet(){
	return m_oNodes.keySet();
    }
    public Node iteratePath(Kernel _oRoot,String _sPath,int _nLeftHops){
	StringTokenizer _oST = new StringTokenizer(_sPath,"::");
	Node _oN = _oRoot;
	while(_oST.hasMoreTokens() && _oN != null){
	    String _sPathFrag = _oST.nextToken();
	    _oN = _oN.get(_sPathFrag);
	    if(_nLeftHops > 0){
		_nLeftHops--;
		if(_nLeftHops == 0){
		    break;
		}
	    }
	}
	if(_oN == null){
	    _oRoot.getLogger().warning("The path was null : "+_sPath);
	}
	return _oN;
    }
    abstract public String type();
    public void dumpChildren(){
	Iterator _i = m_oNodes.keySet().iterator();
	while(_i.hasNext()){
	    String _sKey = (String)_i.next();
	    System.out.println(_sKey);
	}
    }
}
