package xor.main.dbloader;

import xor.main.*;
import xor.sche.*;

final public class Factory{
    private TextConfigFileLoader m_oTCFL;
    private DBSet m_oDBSet;
    private Kernel m_oKernel;
    private String m_sType;

    public Factory(DBSet _oDBSet,TextConfigFileLoader _oTCFL,Kernel _oKernel){
	m_oDBSet = _oDBSet;
	m_oTCFL = _oTCFL;
	m_oKernel = _oKernel;
	m_sType = (String)m_oTCFL.getOne("TYPE");
    }
    public Factory(DBSet _oDBSet,TextConfigFileLoader _oTCFL,String _sType,Kernel _oKernel){
	m_oDBSet = _oDBSet;
	m_oTCFL = _oTCFL;
	m_oKernel = _oKernel;
	m_sType = _sType;
    }
    public Abstract get(String _sName){
	if(m_sType != null){
	    if(m_sType.equals("plaintext")){
		return new XML(m_oDBSet,m_oTCFL,m_oKernel);
	    }
	}
	return null;
    }
}
