package xor.main.dbloader;

import java.lang.*;
import java.io.*;
import java.util.*;
import xor.sche.*;
import xor.main.*;
import xor.main.dbloader.xml.*;

public class XMLFileLoader extends Abstract implements Runnable{
    private File m_oFile;
    private String m_sType;
    private Kernel m_oKernel;
    private Sche m_oWritingSche;
    private boolean m_isTemporaryFile;
    private boolean m_isBusy;
    
    public XMLFileLoader(DBSet _oDBSet,File _oFile,String _sType,Kernel _oKernel){
	super(_oDBSet);
	init();
	m_oFile = _oFile;
	m_sType = _sType;
	m_oKernel = _oKernel;
    }
    public XMLFileLoader(DBSet _oDBSet,String _sXML,String _sType,Kernel _oKernel){
	super(_oDBSet);
	init();
	m_sType = _sType;
	m_oKernel = _oKernel;
	setFile(_sXML);
    }
    public XMLFileLoader(DBSet _oDBSet,File _oFile,String _sType,Kernel _oKernel,Sche _oWritingSche){
	super(_oDBSet);
	init();
	m_sType = _sType;
	m_oKernel = _oKernel;
	m_oFile = _oFile;
	m_oWritingSche = _oWritingSche;
    }
    private void init(){
	m_isBusy = false;
	m_isTemporaryFile = false;
    }
    synchronized private void setFile(String _sXML){
	File _oF = new File(".tmp"+hashCode());
	m_isTemporaryFile = true;
	BufferedWriter _oBW = null;
	try{
	    _oBW = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(_oF),"UTF-8"));
	    _oBW.write(_sXML);
	    _oBW.close();
	}catch(IOException e){
	    e.printStackTrace();
	}
	m_oFile = _oF;
    }
    synchronized public void run(){
	m_isBusy = true;
	if(m_oWritingSche == null){
	    parseSche();
	}else{
	    writeSche();
	}
	m_isBusy = false;
    }
    private void parseSche(){
	Sche2 _oS2 = new Sche2();
	m_oKernel.getLogger().config("Going to load file "+m_oFile.getAbsolutePath());
	try{
	    m_oKernel.getLogger().finest("This may be a Xor.Sche..."+m_oFile.getAbsolutePath());
	    Sche _oS = (Sche)_oS2.objFromFile(m_oFile);
	    if(_oS.isValid()){
		m_oKernel.getLogger().fine("This is a Sche! ID : "+_oS.ID());
		addNewSche(_oS,m_sType);
		deleteFile();
	    }else{
		parseFeed();
	    }
	}catch(ParseErrorException e){
	    parseFeed();
	}catch(Exception e){
	    e.printStackTrace();
	}
    }
    private void parseFeed(){
	xor.main.dbloader.xml.Feed _oF2 = new xor.main.dbloader.xml.Feed();
	try{
	    m_oKernel.getLogger().finest("This may be a Feed..."+m_oFile.getAbsolutePath());
	    xor.sche.Feed _oF = (xor.sche.Feed)_oF2.objFromFile(m_oFile);
	    Iterator _i = _oF.sches().iterator();
	    while(_i.hasNext()){
		xor.sche.Sche _o = (xor.sche.Sche)_i.next();
		if(_o.isValid()){
		    m_oKernel.getLogger().fine("Sche inside feed! ID : "+_o.ID());
		    addNewSche(_o,m_sType);
		    deleteFile();
		}
	    }
	}catch(ParseErrorException e){
	    m_oKernel.getLogger().severe("This XML is invalid. "+m_oFile.getAbsolutePath());
	}catch(Exception e){
	    e.printStackTrace();
	}
    }
    private void deleteFile(){
	if(m_isTemporaryFile){	
	    m_oKernel.getLogger().fine("Deleted "+m_oFile.getAbsolutePath());
	    m_oFile.delete();
	}
    }
    private void writeSche(){
	m_isBusy = true;
	m_oKernel.getLogger().fine("Writing Sche ID : "+m_oWritingSche.ID());
	Sche2 _oS2 = new Sche2();
	_oS2.writeFileFromObj(m_oFile,m_oWritingSche);
	m_oKernel.getLogger().fine("Wrote Sche ID : "+m_oWritingSche.ID());
	m_isBusy = false;
    }
    public void save(DB _oDB){}
    public void suicide(){}
    public String dbtype(){
	return "";
    }
    public void update(){}
    public boolean isBusy(){
	return m_isBusy;
    }
    public boolean isSavable(){
	return true;
    }
    public String profile(){
	return "xmlfileloader";
    }
}
