package xor.main.swing;

import javax.swing.*;
import java.awt.BorderLayout;
import java.awt.event.*;
import xor.main.*;

public class Console extends Inside{
    private JSplitPane m_oSP;
    private JTextArea m_oTAM,m_oTAQ;
    private String m_sM,m_sQ;
    private int m_nMinSize;

    Console(SwingInterface _oI,Kernel _oKernel,MDI _oMDI){
	super(_oKernel,_oI,_oMDI);
	OutputChecker _oOC = new OutputChecker(this);
	m_oI.addConsoleListener(_oOC);
	m_oSP = new JSplitPane();
	m_oSP.addComponentListener(new ResizeChecker());

	m_oTAM = new JTextArea();
	m_oTAQ = new JTextArea();
    }
    public void set(){
	m_oSP.setOrientation(JSplitPane.VERTICAL_SPLIT);
	m_oSP.setOneTouchExpandable(true);
	m_oSP.setDividerSize(3);
	
	m_oTAM.setLineWrap(true);
	m_oTAM.setEditable(false);
	JScrollPane _oSPM = new JScrollPane(); // M = Message
	_oSPM.setViewportView(m_oTAM);
	m_oSP.setTopComponent(_oSPM);

	m_oTAQ.setLineWrap(true);
	JScrollPane _oSPQ = new JScrollPane(); // Q = Query
	_oSPQ.setViewportView(m_oTAQ);
	m_oSP.setBottomComponent(_oSPQ);
	m_nMinSize = _oSPQ.getMinimumSize().height;

	m_sM = m_sQ = "";
	flush();

	m_oTAQ.addKeyListener(new KeyChecker());
	m_oSP.setVisible(true);
    }
    synchronized public void refresh(){
	super.refresh();
	m_oSP.setDividerLocation(m_oSP.getSize().height-m_nMinSize);
	flush();
    }
    public void refreshForce(){}
    public JSplitPane panel(){
	return m_oSP;
    }
    public String type(){
	return "Console";
    }
    synchronized public void println(String _sMessage){
	m_sM = m_sM+_sMessage+"\n";
	flush();
    }
    synchronized public void print(String _sMessage){
	m_sM = m_sM+_sMessage;
	flush();
    }
    synchronized private void flush(){
	m_oTAM.setText(m_sM);
	m_oTAQ.setText(m_sQ);
    }
    private void getCommandLine(){
	m_sQ = m_oTAQ.getText();
	m_sQ = m_sQ.substring(0,m_sQ.length()-1);
	m_oI.callCommandWith(m_sQ);
    }
    protected void hasQuery(String _sQuery){
	m_sQ = _sQuery;
	flush();
    }
    protected void hasNoQuery(){
	m_sQ = "";
    }
    protected void executedQuery(String _sQuery){
	m_sM = m_sM+"#"+_sQuery+"\n";
	flush();
    }
    synchronized public void clear(){
	m_sM = "";
	flush();
    }
    class ResizeChecker extends ComponentAdapter{
	public void componentResized(ComponentEvent e){
	    refresh();
	}
    }
    class KeyChecker implements KeyListener{
	public void keyTyped(KeyEvent e){
	    if(e.getKeyChar() == 0xa){
		getCommandLine();
	    }
	}
	public void keyPressed(KeyEvent e){}
	public void keyReleased(KeyEvent e){}
    }
    class OutputChecker extends ConsoleAdapter{
	private Console m_oThis;
	
	OutputChecker(Console _oThis){
	    m_oThis = _oThis;
	}
	public void println(ConsoleEvent _oEv){
	    m_oThis.println(_oEv.getMessage());
	}
	public void print(ConsoleEvent _oEv){
	    m_oThis.print(_oEv.getMessage());
	}
	public void clear(ConsoleEvent _oEv){
	    m_oThis.clear();
	}
	public void hasQuery(ConsoleEvent _oEv){
	    m_oThis.hasQuery(_oEv.getMessage());
	}
	public void hasNoQuery(ConsoleEvent _oEv){
	    m_oThis.hasNoQuery();
	}
	public void executedQuery(ConsoleEvent _oEv){
	    m_oThis.executedQuery(_oEv.getMessage());
	}
    }
}
