package xor.main.swing;

import java.util.*;
import xor.sche.*;

class DisplayBounds{
    private Date m_oBegin,m_oEnd;

    DisplayBounds(){
	m_oBegin = m_oEnd = null;
    }
    DisplayBounds(Date _oBegin,Date _oEnd){
	m_oBegin = _oBegin;
	m_oEnd = _oEnd;
    }
    DisplayBounds(Sche _oSche){
	xor.sche.Time _oT = _oSche.changeables().get(0).time();
	m_oBegin = _oT.begin();
	m_oEnd = _oT.end();
    }
    public void setBegin(Date _oBegin){
	m_oBegin = _oBegin;
    }
    public void setEnd(Date _oEnd){
	m_oEnd = _oEnd;
    }
    public Date getBegin(){
	return m_oBegin;
    }
    public Date getEnd(){
	return m_oEnd;
    }
    public void optimize(){
	if(m_oBegin != null && m_oEnd != null && m_oBegin.getTime() > m_oEnd.getTime()){
	    Date _oT = m_oBegin;
	    m_oBegin = m_oEnd;
	    m_oEnd = _oT;
	}
    }
    public Date getCenter(){
	if(m_oBegin != null && m_oEnd != null){
	    long _lBegin = m_oBegin.getTime();
	    long _lEnd = m_oEnd.getTime();
	    return new Date((_lBegin+_lEnd)/2);
	}else if(m_oBegin == null){
	    return m_oEnd;
	}else{
	    return m_oBegin;
	}
    }
    public long getMinRateToDisplay(){
	if(m_oBegin != null && m_oEnd != null){
	    return m_oEnd.getTime()-m_oBegin.getTime();
	}else{
	    return 0;
	}
    }
    synchronized public void makeUnionFor(DisplayBounds _oDB){
	_oDB.optimize();
	if(m_oBegin != null && m_oEnd != null){
	    if(_oDB.getBegin() != null && _oDB.getBegin().getTime() < m_oBegin.getTime()){
		m_oBegin = _oDB.getBegin();
	    }
	    if(_oDB.getEnd() != null && _oDB.getEnd().getTime() > m_oEnd.getTime()){
		m_oEnd = _oDB.getEnd();
	    }
	}else if(!(m_oBegin == null && m_oEnd == null)){
	    Date _oMyTime;
	    if(m_oBegin == null){
		_oMyTime = m_oEnd;
	    }else{
		_oMyTime = m_oBegin;
	    }
	    if(_oDB.getBegin().getTime() < m_oBegin.getTime()){
		if(_oDB.getEnd().getTime() < _oMyTime.getTime()){
		    m_oEnd = _oMyTime;
		}else{
		    m_oEnd = _oDB.getEnd();
		}
		m_oBegin = _oDB.getBegin();
	    }else{
		m_oEnd = _oDB.getEnd();
	    }
	}else{
	    m_oBegin = _oDB.getBegin();
	    m_oEnd = _oDB.getEnd();
	}
    }
}
