package xor.main.swing;

import javax.swing.*;
import java.awt.Frame;
import java.awt.BorderLayout;
import java.awt.event.*;
import java.util.*;

public class MDIFrame extends ConsoleFrame{
    private MDI m_oMDI;
    private AnnouncementPanel m_oAP;

    public MDIFrame(SwingInterface _oI){
	super(_oI);
	m_oMDI = new MDI(_oI);

	setTitle("Sche::SWING MDI");
	setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
	setSize(800,600);
	//	setExtendedState(Frame.MAXIMIZED_BOTH);
	setLocationRelativeTo(null);
	setLayout(new BorderLayout());
	setJMenuBar(new MenuBar());
	add(new MDIToolBar(m_oI),BorderLayout.NORTH);
	JPanel _oJM = new JPanel(new BorderLayout());
	_oJM.add(m_oMDI.panel(),BorderLayout.CENTER);
	refreshContentPane();
	addWindowListener(new WindowEventChecker());
	m_oAP = new AnnouncementPanel();
	_oJM.add(m_oAP,BorderLayout.NORTH);
	add(_oJM,BorderLayout.CENTER);
	m_oI.addAnnouncementListener(new AnnouncementChecker());
	setVisible(true);
    }
    public int makeDecision(String _sMessage){
	return m_oMDI.makeDecision(_sMessage);
    }
    private void refreshContentPane(){
    }
    class WindowEventChecker extends WindowAdapter{
	public void windowClosing(WindowEvent e){
	    m_oI.callCommandWith("exit;");
	}
    }
    class MenuBar extends JMenuBar{
	public MenuBar(){
	    add(new FileMenuBar());
	    add(new WindowMenuBar());
	    add(new HelpMenuBar());
	}
    }
    class FileMenuBar extends JMenu{
	FileMenuBar(){
	    super("File");
	    add(new ActionLoadScript(m_oI));
	    add(new Import());
	    addSeparator();
	    add(new ActionSave(m_oI));
	    addSeparator();
	    add(new ActionExit(m_oI));
	}
	class Import extends JMenu{
	    Import(){
		super("Import");
		add(new ActionImportFile(m_oI));
		add(new ActionImportURI(m_oI));
	    }
	}
    }
    class WindowMenuBar extends JMenu{
	public WindowMenuBar(){
	    super("Window");
	    add(new ActionWindowShow(m_oI,"Picker"));
	    add(new ActionWindowShow(m_oI,"Calendar"));
	    add(new ActionWindowShow(m_oI,"ScheList"));
	    addSeparator();
	    add(new ActionWindowShow(m_oI,"Detail"));
	    add(new ActionWindowShow(m_oI,"Updated"));
	    addSeparator();
	    add(new ActionWindowShow(m_oI,"Console"));
	    add(new ActionWindowShow(m_oI,"Log"));
	    addSeparator();
	    add(new ActionWindowShow(m_oI,"Setting"));
	    add(new ActionWindowShow(m_oI,"About"));
	}
    }
    class HelpMenuBar extends JMenu{
	public HelpMenuBar(){
	    super("Help");
	    JMenuItem _oAbout = new JMenuItem("About");
	}
    }
    class AnnouncementPanel extends JPanel{
	private JComponent m_oComponent;
	private String m_sWindow;
	private BlinkThread m_oBT;

	AnnouncementPanel(){
	    super(new BorderLayout());
	    m_oComponent = noAnnouncement();
	    add(m_oComponent,BorderLayout.CENTER);
	    m_oBT = null;
	}
	public void addAnnouncement(AnnouncementEnum _oStatus,String _sMessage,String _sWindow){
	    m_sWindow = _sWindow;
	    remove(m_oComponent);
	    if(_oStatus == null || _oStatus == AnnouncementEnum.NONE){
		m_oComponent = noAnnouncement();
	    }else if(_oStatus == AnnouncementEnum.DEFAULT){
		m_oComponent = new JButton(_sMessage);
		((JButton)m_oComponent).setHorizontalAlignment(SwingConstants.LEFT);
		((JButton)m_oComponent).addMouseListener(new ButtonClickedChecker());
		startBlinkThread();
	    }else{
	    }
	    m_oComponent.setVisible(false);
	    add(m_oComponent,BorderLayout.CENTER);
	    m_oComponent.setVisible(true);
	    repaint();
	}
	private JComponent noAnnouncement(){
	    return new JLabel("No updated sches.");
	}
	private void resetAnnouncement(){
	    addAnnouncement(null,null,null);
	}
	private void sendWindowShowEvent(){
	    if(m_oBT != null){
		m_oBT.kill();
	    }
	    m_oI.sendWindowShowListener(new WindowShowEvent(this,m_sWindow));
	    resetAnnouncement();
	}
	class ButtonClickedChecker extends MouseAdapter{
	    public void mouseClicked(MouseEvent e){
		sendWindowShowEvent();
	    }
	}
	private void startBlinkThread(){
	    m_oBT = new BlinkThread();
	    Thread _oT = new Thread(m_oBT);
	    m_oBT.setThread(_oT);
	    _oT.start();
	}
	class BlinkThread implements Runnable{
	    private Thread m_oT;
	    private boolean m_isGoing;

	    BlinkThread(){
		m_isGoing = false;
	    }
	    public void setThread(Thread _oT){
		m_oT = _oT;
	    }
	    public void run(){
		m_isGoing = true;
		setToYellow();
		try{m_oT.sleep(100);}catch(InterruptedException e){e.printStackTrace();}
		if(!m_isGoing){return;}
		setToWhite();
		try{m_oT.sleep(100);}catch(InterruptedException e){e.printStackTrace();}
		if(!m_isGoing){return;}
		setToYellow();
		try{m_oT.sleep(100);}catch(InterruptedException e){e.printStackTrace();}
		if(!m_isGoing){return;}
		setToWhite();
		try{m_oT.sleep(100);}catch(InterruptedException e){e.printStackTrace();}
		if(!m_isGoing){return;}
		setToYellow();
		try{m_oT.sleep(100);}catch(InterruptedException e){e.printStackTrace();}
		if(!m_isGoing){return;}
	    }
	    public void kill(){
		m_isGoing = false;
	    }
	    public void setToYellow(){
		m_oComponent.setBackground(java.awt.Color.YELLOW);
		m_oComponent.setForeground(java.awt.Color.BLACK);
	    }
	    public void setToWhite(){
		m_oComponent.setBackground(java.awt.Color.WHITE);
		m_oComponent.setForeground(java.awt.Color.BLACK);
	    }
	}
    }
    class AnnouncementChecker extends AnnouncementAdapter{
	public void set(AnnouncementEvent _oEv){
	    String _sWindowType = _oEv.getWindowType();
	    m_oAP.addAnnouncement(_oEv.getType(),
				  _oEv.getShowing(),
				  _sWindowType);
	}
    }
}
