package xor.main.swing;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.text.*;
import xor.main.*;
import xor.sche.*;

class PickerFrame extends Inside{
    private JPanel m_oRoot;
    private SwingInterface m_oI;
    private JSplitPane m_oSP;
    private SchePanel m_oPalette,m_oCanvas;
    private TimeLineGrid m_oGrid;
    private ScrollBar m_oScrollBar;
    private String m_sDefaultRatio;
    private Long m_lNowRatio;
    private JToolBar m_oRatioToolBar,m_oProcedureBar;
    private Date m_oCenterDate;
    private RatioChangerButton m_oRCB;
    private static final Map<String,Long> s_oHorizontalRatio = new HashMap<String,Long>();
    private static final java.util.List<String> s_oOrderedListRatio = new ArrayList<String>();
    private PaletteEnum m_oMouseMovingPalette;
    
    PickerFrame(SwingInterface _oI,String _sDefaultRatio,Kernel _oKernel,MDI _oMDI){
	super(_oKernel,_oI,_oMDI);
	m_oCenterDate = new Date();
	m_oRoot = new JPanel();
	m_oPalette = new SchePanel(PaletteEnum.PALETTE);
	m_oCanvas = new SchePanel(PaletteEnum.CANVAS);
	m_oGrid = new TimeLineGrid();
	m_oRoot.addComponentListener(new ResizeChecker());
	m_sDefaultRatio = _sDefaultRatio;
	m_oRoot.addKeyListener(new KeyChecker());
    }
    public void set(){
	m_lNowRatio = s_oHorizontalRatio.get(m_sDefaultRatio);
	m_oSP = new JSplitPane();
	m_oSP.setOrientation(JSplitPane.VERTICAL_SPLIT);
	m_oSP.setDividerSize(2);
	m_oSP.setContinuousLayout(false);
	m_oSP.setTopComponent(m_oPalette);
	m_oSP.setBottomComponent(m_oCanvas);
	JPanel _oMain = new JPanel();
	_oMain.setLayout(new BorderLayout());
	_oMain.add(m_oSP,BorderLayout.CENTER);
	_oMain.add(m_oGrid,BorderLayout.NORTH);
	m_oRoot.setLayout(new BorderLayout());
	m_oRoot.add(_oMain,BorderLayout.CENTER);
	m_oScrollBar = new ScrollBar();
	m_oScrollBar.setOrientation(JScrollBar.HORIZONTAL);
	JPanel _oRatioNav = new JPanel();
	_oRatioNav.setLayout(new BorderLayout());
	_oRatioNav.add(m_oScrollBar,BorderLayout.CENTER);
	m_oRCB = new RatioChangerButton();
	m_oRCB.setSelectedItem(m_sDefaultRatio);
	_oRatioNav.add(m_oRCB,BorderLayout.EAST);
	m_oRoot.add(_oRatioNav,BorderLayout.SOUTH);
	refresh();
    }
    public JPanel panel(){
	return m_oRoot;
    }
    public SchePanel palette(PaletteEnum _oPE){
	if(_oPE == PaletteEnum.CANVAS){return m_oCanvas;}
	return m_oPalette;
    }
    public void refresh(){
	super.refresh();
	m_oSP.setDividerLocation(m_oSP.getSize().height/2);
	m_oPalette.getPanel().refresh();
	m_oCanvas.getPanel().refresh();
	m_oGrid.refresh();
	m_oRoot.repaint();
    }
    public void refreshForce(){}
    public void addSche(Sche _oSche){
	String _sType = m_oKernel.getDBSet().typeOf(_oSche.ID());
	if(_sType.equals("palette")){
	    m_oPalette.getPanel().addSche(_oSche);
	}else if(_sType.equals("canvas")){
	    m_oCanvas.getPanel().addSche(_oSche);
	}
    }
    public void removeSelected(){
	m_oPalette.getPanel().removeSelected();
	m_oCanvas.getPanel().removeSelected();
    }
    public void setCenterAndLength(Date _oCenter,long _lRate){
	m_oRCB.setSelectedItem(bestRatioForLength(_lRate));
	m_oCenterDate = _oCenter;
	m_oScrollBar.setBaseDateForced();
	refresh();
    }
    public void removeSche(Sche _oSche){
	m_oPalette.getPanel().removeSche(_oSche);
	m_oCanvas.getPanel().removeSche(_oSche);
    }
    synchronized public void selectSche(Sche _oS,SelectionMap _oC){
	m_oPalette.getPanel().selectSche(_oS,_oC);
	m_oCanvas.getPanel().selectSche(_oS,_oC);
    }
    synchronized public void unselectSche(){
	m_oPalette.getPanel().unselectSche();
	m_oCanvas.getPanel().unselectSche();
    }
    public void moveScheTo(PaletteEnum _sType){
	m_oPalette.getPanel().moveScheTo(_sType);
	m_oCanvas.getPanel().moveScheTo(_sType);
    }
    public PickerFrame oThis(){
	return this;
    }
    public String type(){
	return "pickerframe";
    }
    private Date beginDate(){
	return new Date(m_oCenterDate.getTime()-m_lNowRatio/2);
    }
    private Date endDate(){
	return new Date(m_oCenterDate.getTime()+m_lNowRatio/2);
    }
    class ResizeChecker extends ComponentAdapter{
	public void componentResized(ComponentEvent e){
	    refresh();
	}
	public void componentShown(ComponentEvent e){
	    refresh();
	}
	public void componentMoved(ComponentEvent e){
	    refresh();
	}
    }
    class TimeLineGrid extends JPanel{
	private Edge m_oBegin,m_oEnd;
	
	TimeLineGrid(){
	    super(new BorderLayout());
	    m_oBegin = new Edge();
	    m_oEnd = new Edge();
	    add(m_oBegin,BorderLayout.WEST);
	    add(m_oEnd,BorderLayout.EAST);
	}
	public void refresh(){
	    m_oBegin.refresh(beginDate());
	    m_oEnd.refresh(endDate());
	}
	class Edge extends JButton{
	    private SimpleDateFormat m_oSDF;
	    
	    Edge(){
		m_oSDF = new SimpleDateFormat("yy/MM/dd HH:mm");
	    }
	    public void refresh(Date _oD){
		setText(m_oSDF.format(_oD));
	    }
	}
    }
    class RatioChangerButton extends JComboBox{
	RatioChangerButton(){
	    Iterator _i = s_oOrderedListRatio.iterator();
	    while(_i.hasNext()){
		addItem((String)_i.next());
	    }
	    addItemListener(new ChangeListener());
	}
	public void changeTo(String _s){
	    m_lNowRatio = s_oHorizontalRatio.get(_s).longValue();
	    refresh();
	}
	class ChangeListener implements ItemListener{
	    public void itemStateChanged(ItemEvent e){
		if(e.getStateChange() == ItemEvent.SELECTED){
		    changeTo(e.getItem().toString());
		}
	    }
	}
    }
    class ScrollBar extends JScrollBar{
	private boolean m_isResettedByMouse,m_isBaseDateSet;
	private Date m_oBaseDate;

	ScrollBar(){
	    setMaximum(Integer.MAX_VALUE);
	    setMinimum(0);
	    setVisibleAmount(Integer.MAX_VALUE/3);
	    resetPos();
	    addAdjustmentListener(new ScrollBarChangeListener());
	    addMouseListener(new MouseChangeListener());
	    m_isResettedByMouse = m_isBaseDateSet = false;
	    setBaseDateForced();
	}
	public void setBaseDateForced(){
	    m_oBaseDate = m_oCenterDate;
	}
	private void resetPos(){
	    setBaseDateForced();
	    setValue(Integer.MAX_VALUE/3);
	}
	private void setPos(){
	    if(!m_isResettedByMouse){
		if(!m_isBaseDateSet){
		    setBaseDateForced();
		    m_isBaseDateSet = true;
		}
		double _dX = new Integer(getFinalValue()).doubleValue();
		_dX /= Integer.MAX_VALUE/2;
		_dX -= 1;
		long _lT = new Long(new Double(m_lNowRatio.doubleValue()*_dX).longValue());
		m_oCenterDate = new Date(m_oBaseDate.getTime()+_lT);
		refresh();
	    }else{
		m_isResettedByMouse = false;
		m_isBaseDateSet = false;
	    }
	}
	private int getFinalValue(){
	    return getValue()/2*3;
	}
	class ScrollBarChangeListener implements AdjustmentListener{
	    public void adjustmentValueChanged(AdjustmentEvent e){
		setPos();
	    }
	}
	class MouseChangeListener extends MouseAdapter{
	    public void mouseReleased(MouseEvent e){
		m_isResettedByMouse = true;
		resetPos();
	    }
	}
    }
    class SchePanel extends JScrollPane{
	private ScheMainPanel m_oSMP;
	
	SchePanel(PaletteEnum _oPE){
	    m_oSMP = new ScheMainPanel(_oPE);
	    getViewport().setView(m_oSMP);
	    addMouseListener(new PanelMouseChecker(_oPE));
	    setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
	}
	public ScheMainPanel getPanel(){
	    return m_oSMP;
	}
    }
    class PanelMouseChecker extends MouseAdapter{
	private PaletteEnum m_oPE;
	
	PanelMouseChecker(PaletteEnum _oPE){
	    setIsMouseInCanvas(_oPE);
	}
	public void setIsMouseInCanvas(PaletteEnum _oPE){
	    m_oPE = _oPE;
	}
	public void mouseEntered(MouseEvent _oE){
	    m_oMouseMovingPalette = m_oPE;
	}
    }
    class ScheMainPanel extends JPanel{
	private Map<Sche,ScheBar> m_oSB;
	private AbstractList<Row> m_aoRows;
	private Set<Sche> m_aoNotShownSches;
	private PaletteEnum m_sPaletteType;
	private JLabel m_oExplainPanel;

	ScheMainPanel(PaletteEnum _sPaletteType){
	    setLayout(null);
	    m_sPaletteType = _sPaletteType;
	    m_oSB = new HashMap<Sche,ScheBar>();
	    m_aoRows = new LinkedList<Row>();
	    m_aoNotShownSches = new HashSet<Sche>();
	    m_oExplainPanel = null;
	}
	synchronized public void refresh(){
	    refreshUnshownObjs();
	    refreshRows();
	}
	private void refreshUnshownObjs(){
	    int _nBegin,_nEnd;
	    Set<Sche> _oRemoving = new HashSet<Sche>();
	    Set<Sche> _oShowing = new HashSet<Sche>();
	    Iterator _i = m_aoNotShownSches.iterator();
	    synchronized(m_aoNotShownSches){
		while(_i.hasNext()){
		    Sche _oS = (Sche)_i.next();
		    ScheBar _oSB = m_oSB.get(_oS);
		    if(_oSB == null){
			_oRemoving.add(_oS);
			continue;
		    }
		    _nBegin = getBeginPixel(_oSB.beginDate());
		    _nEnd = getEndPixel(_oSB.endDate());
		    if(isVisible(_oSB,_nBegin,_nEnd)){
			_oShowing.add(_oS);
		    }
		}
	    }
	    _i = _oRemoving.iterator();
	    while(_i.hasNext()){
		m_oSB.remove((Sche)_i.next());
	    }
	    _i = _oShowing.iterator();
	    while(_i.hasNext()){
		showSche((Sche)_i.next());
	    }
	    if(m_oSB.size() == 0){
		makeExplainPanel();
	    }
	}
	private void makeExplainPanel(){
	    if(m_oExplainPanel == null){
		String _sText = "";
		if(m_sPaletteType == PaletteEnum.PALETTE){
		    _sText = "PALETTE - Downloaded sches comes here.";
		}else{
		    _sText = "CANVAS - This is your timeline. Drag & Drop schedules in PALETTE to here.";
		}
		m_oExplainPanel = new JLabel(_sText);
		setLayout(new BorderLayout());
		add(m_oExplainPanel,BorderLayout.CENTER);
	    }
	}
	private void removeExplainPanel(){
	    if(m_oExplainPanel != null){
		m_oExplainPanel = null;
		removeAll();
		setLayout(null);
	    }
	}
	synchronized private void refreshRows(){
	    int _n = 0;
	    double _dH = new Integer(mySize().height).doubleValue()/m_aoRows.size();
	    int _nHeight = new Double(_dH).intValue();
	    Iterator _i = m_aoRows.iterator();
	    Set<Row> _aoDeletingRows = new HashSet<Row>();
	    
	    while(_i.hasNext()){
		Row _oR = (Row)_i.next();
		boolean _isNeeded = _oR.refreshAtPosIfCan(_n,_nHeight);
		if(!_isNeeded){
		    _aoDeletingRows.add(_oR);
		}
		_n++;
	    }
	    _i = _aoDeletingRows.iterator();
	    while(_i.hasNext()){
		Row _oRTarget = (Row)_i.next();
		int _nDelPos = m_aoRows.indexOf(_oRTarget);
		m_aoRows.remove(_nDelPos);
		Iterator _i2 = _oRTarget.sches().iterator();
		while(_i2.hasNext()){
		    Sche _oS = (Sche)_i2.next();
		    hideSche(_oS);
		}
	    }
	}
	private void hideSche(Sche _oS){
	    m_aoNotShownSches.add(_oS);
	}
	private void showSche(Sche _oS){
	    removeExplainPanel();
	    boolean _isAdded = false;
	    Iterator _i = m_aoRows.iterator();
	    while(_i.hasNext()){
		Row _oR = (Row)_i.next();
		if(_oR.canAdd(_oS)){
		    _oR.addSche(_oS);
		    _isAdded = true;
		    break;
		}
	    }
	    if(!_isAdded){
		Row _oR = new Row();
		_oR.addSche(_oS);
		m_aoRows.add(_oR);
	    }
	    m_aoNotShownSches.remove(_oS);
	}
	public Dimension mySize(){
	    return getSize();
	}
	public void addSche(Sche _oS){
	    ScheBar _oSB = new ScheBar(_oS,m_sPaletteType);
	    m_aoNotShownSches.add(_oS);
	    m_oSB.put(_oS,_oSB);
	    showSche(_oS);
	    add(_oSB);
	    makeChangesForSche();
	}
	public void removeSche(Sche _oS){
	    ScheBar _oSB = m_oSB.get(_oS);
	    if(_oSB == null){return;}
	    _oSB.setVisible(false);
	    m_oSB.remove(_oS);
	    Iterator _i = m_aoRows.iterator();
	    while(_i.hasNext()){
		Row _oR = (Row)_i.next();
		_oR.removeSche(_oS);
	    }
	    makeChangesForSche();
	}
	public void removeSelected(){
	    Set<Sche> _aoRemoving = new HashSet<Sche>();
	    Iterator _i = m_oSB.keySet().iterator();
	    while(_i.hasNext()){
		Sche _oS = (Sche)_i.next();
		ScheBar _oSB = m_oSB.get(_oS);
		if(_oSB.isSelected()){
		    _aoRemoving.add(_oS);
		}
	    }
	    _i = _aoRemoving.iterator();
	    while(_i.hasNext()){
		removeSche((Sche)_i.next());
	    }
	}
	synchronized private void makeChangesForSche(){
	    oThis().refresh();
	    repaint();
	}
	public void selectSche(Sche _oS,SelectionMap _oC){
	    Iterator _i = m_oSB.keySet().iterator();
	    while(_i.hasNext()){
		Sche _oSelS = (Sche)_i.next();
		selectScheEx(_oSelS,_oC);
	    }
	    selectScheEx(_oS,_oC);
	}
	private void selectScheEx(Sche _oS,SelectionMap _oC){
	    if(_oC == null || m_oSB.get(_oS) == null){return;}
	    if(_oC.includes(_oS)){
		((ScheBar)m_oSB.get(_oS)).select(_oC,true);
	    }else{
		((ScheBar)m_oSB.get(_oS)).unselect();
	    }
	}
	public void unselectSche(){
	    Iterator _i = m_oSB.keySet().iterator();
	    while(_i.hasNext()){
		Sche _oS = (Sche)_i.next();
		((ScheBar)m_oSB.get(_oS)).unselect();
	    }
	}
	public void moveScheTo(PaletteEnum _oPE){
	    Set<Sche> _aoS = selectedSches();
	    Iterator _i = _aoS.iterator();
	    while(_i.hasNext()){
		Sche _oS = (Sche)_i.next();
		oThis().removeSche(_oS);
		oThis().palette(_oPE).getPanel().addSche(_oS);
	    }
	}
	synchronized public Set<Sche> selectedSches(){
	    Set<Sche> _aoS = new HashSet<Sche>();
	    Iterator _i = m_oSB.keySet().iterator();
	    while(_i.hasNext()){
		Sche _oS = (Sche)_i.next();
		ScheBar _oSB = (ScheBar)m_oSB.get(_oS);
		if(_oSB.isSelected()){
		    _aoS.add(_oS);
		}
	    }
	    return _aoS;
	}
	public int getBeginPixel(Date _oD){
	    if(_oD == null){
		return Integer.MIN_VALUE;
	    }else if(_oD.after(endDate())){
		return Integer.MAX_VALUE;
	    }
	    return getPixel(_oD);
	}
	public int getEndPixel(Date _oD){
	    if(_oD == null){
		return Integer.MAX_VALUE;
	    }else if(_oD.before(beginDate())){
		return Integer.MIN_VALUE;
	    }
	    return getPixel(_oD);
	}
	private int getPixel(Date _oD){
	    double _dRate = getRate(_oD);
	    return new Double(getSize().width*_dRate).intValue();
	}
	private double getRate(Date _oD){
	    long _oNumerator = _oD.getTime()-beginDate().getTime();
	    return new Long(_oNumerator).doubleValue()/new Long(m_lNowRatio).doubleValue();
	}
	public boolean isVisible(ScheBar _oSB,int _nBegin,int _nEnd){
	    if(_nBegin == Integer.MAX_VALUE || _nEnd == Integer.MIN_VALUE){
		return false;
	    }
	    return true;
	}
	class Row{
	    private Set<Sche> m_oIncludedSches;

	    Row(){
		m_oIncludedSches = new HashSet<Sche>();
	    }
	    public boolean canAdd(Sche _oS){
		Iterator _i = m_oIncludedSches.iterator();
		while(_i.hasNext()){
		    Sche _oIncSche = (Sche)_i.next();
		    if(_oS.changeables().get(0).time().overlaps(_oIncSche.changeables().get(0).time())){
			return false;
		    }
		}
		return true;
	    }
	    public void addSche(Sche _oS){
		m_oIncludedSches.add(_oS);
	    }
	    public void removeSche(Sche _oS){
		m_oIncludedSches.remove(_oS);
	    }
	    public Set<Sche> sches(){
		return m_oIncludedSches;
	    }
	    public boolean refreshAtPosIfCan(int _nMyLine,int _nYSize){
		int _nBegin,_nEnd;
		boolean _isThisRowNeeded = false;
		Iterator _i = m_oIncludedSches.iterator();
		while(_i.hasNext()){
		    Sche _oSche = (Sche)_i.next();
		    ScheBar _oSB = (ScheBar)m_oSB.get(_oSche);
		    _nBegin = getBeginPixel(_oSB.beginDate());
		    _nEnd = getEndPixel(_oSB.endDate());
		    if(!isVisible(_oSB,_nBegin,_nEnd)){
			_oSB.setVisible(false);
			continue;
		    }else{
			_oSB.setVisible(true);
		    }
		    int _nWidth = mySize().width;
		    if(_nBegin < 0){_nBegin = 0;}
		    if(_nEnd > _nWidth){_nEnd = _nWidth;}
		    _oSB.setBounds(_nBegin,_nMyLine*_nYSize,_nEnd-_nBegin,_nYSize);
		    _isThisRowNeeded = true;
		}
		return _isThisRowNeeded;
	    }
	}
    }
    class ScheBar extends JButton{
	private Sche m_oSche;
	private boolean m_isSelected;
	private PaletteEnum m_oPaletteType,m_oPaletteTypeOfSelected;
	private SimpleDateFormat m_oSDF;
	
	ScheBar(Sche _oSche,PaletteEnum _oPaletteType){
	    super(_oSche.changeables().get(0).title());
	    m_oSDF = new SimpleDateFormat("HH:mm");
	    m_oPaletteType = _oPaletteType;
	    m_oSche = _oSche;
	    updateScheInfo();
	    addMouseListener(new PressCheck());
	    addMouseListener(new PanelMouseChecker(m_oPaletteType));
	    addMouseMotionListener(new DragCheck());
	    m_isSelected = true;
	    unselect();
	}
	public void updateScheInfo(){
	    updateScheInfo(m_oSche);
	}
	public void updateScheInfo(Sche _oS){
	    setToolTipText(toolTipText(_oS));
	}
	private String toolTipText(Sche _oS){
	    String _sBegin,_sEnd;
	    _sBegin = "";
	    _sEnd = "";
	    if(beginDate() != null){
		_sBegin = m_oSDF.format(beginDate());
	    }
	    if(endDate() != null){
		_sEnd = m_oSDF.format(endDate());
	    }
	    return _sBegin+"-"+_sEnd+" "+_oS.changeables().get(0).title();
	}
	public Date beginDate(){
	    return m_oSche.changeables().get(0).time().begin();
	}
	public Date endDate(){
	    return m_oSche.changeables().get(0).time().end();
	}
	synchronized public void select(SelectionMap _oC){
	    select(_oC,false);
	}
	synchronized public void select(SelectionMap _oC,boolean _isAdding){
	    if(_oC != null && _oC.isAlreadyChanged(oThis())){return;}
	    if(!_isAdding){
		unselectSche();
	    }
	    m_isSelected = true;
	    changeToSelectedColor();
	}
	synchronized public void selectFromMe(SelectionMap _oC,boolean _isAdding){
	    select(_oC,_isAdding);
	    String _sPath = m_oKernel.getDBSet().pathOf(m_oSche);
	    String _sQuery = "select ";
	    if(_isAdding){_sQuery = _sQuery+"-a ";}
	    _sQuery = _sQuery+_sPath;
	    m_oKernel.execQuery(_sQuery,_oC,oThis());
	}
	synchronized public void unselect(){
	    changeToUnselectedColor();
	    m_isSelected = false;
	}
	public boolean isSelected(){
	    return m_isSelected;
	}
	private void changeToSelectedColor(){	
	    setForeground(Color.RED);
	    setBackground(Color.GRAY);
	}
	private void changeToUnselectedColor(){
	    setForeground(Color.BLACK);
	    setBackground(Color.WHITE);
	}
	class PressCheck extends MouseAdapter{
	    private boolean m_isClicked,m_isDragging,m_hasGotOutComponent;
	    
	    PressCheck(){
		m_isClicked = m_isDragging = m_hasGotOutComponent = false;
	    }
	    public void mouseEntered(MouseEvent e){
		m_oMouseMovingPalette = m_oPaletteType;
	    }
	    public void mouseExited(MouseEvent e){
		if(m_isDragging){
		    m_hasGotOutComponent = true;
		}
	    }
	    public void mousePressed(MouseEvent e){
		m_isClicked = true;
		m_hasGotOutComponent = false;
		if(!m_isSelected){
		    selectWithModifier(null);
		}
		if(!m_isDragging){
		    m_isDragging = true;
		    m_oPaletteTypeOfSelected = m_oPaletteType;
		}
	    }
	    public void mouseReleased(MouseEvent e){
		m_isClicked = false;
		if(m_isDragging){
		    m_isDragging = false;
		    refresh();
		    if(!m_hasGotOutComponent){
			selectWithModifier(null); // Select only this sche.
			// If this sche was clicked for selecting, not for moving(dragging to different palette).
			// When you move sches, the mouse gets out the component after clicking it, at least once.
			// So, that means, if mouse was released while never getting out the component after press, it can be said that it was clicked for selecting.
		    }
		}
		m_hasGotOutComponent = false;
	    }
	    private void selectWithModifier(SelectionMap _oSM){
		selectFromMe(null,false);
	    }
	}
	class DragCheck extends MouseMotionAdapter{
	    public void mouseDragged(MouseEvent e){
		if(m_oPaletteTypeOfSelected != m_oMouseMovingPalette){
		    m_oPaletteTypeOfSelected = m_oMouseMovingPalette;
		    String _sQuery = "mv -"+(m_oPaletteTypeOfSelected==PaletteEnum.PALETTE?"p":"c");
		    m_oKernel.execQuery(_sQuery,oThis());
		}
	    }
	}
    }
    static{
	s_oOrderedListRatio.add("1 Year");
	s_oHorizontalRatio.put("1 Year",     new Long("31536000000"));
	s_oOrderedListRatio.add("6 Months");
	s_oHorizontalRatio.put("6 Months",   new Long("15768000000"));
	s_oOrderedListRatio.add("3 Months");
	s_oHorizontalRatio.put("3 Months",   new Long( "7884000000"));
	s_oOrderedListRatio.add("1 Month");
	s_oHorizontalRatio.put("1 Month",    new Long( "3942000000"));
	s_oOrderedListRatio.add("2 Weeks");
	s_oHorizontalRatio.put("2 Weeks",    new Long( "1209600000"));
	s_oOrderedListRatio.add("1 Week");
	s_oHorizontalRatio.put("1 Week",     new Long(  "604800000"));
	s_oOrderedListRatio.add("4 Days");
	s_oHorizontalRatio.put("4 Days",     new Long(  "345600000"));
	s_oOrderedListRatio.add("2 Days");
	s_oHorizontalRatio.put("2 Days",     new Long(  "172800000"));
	s_oOrderedListRatio.add("1 Day");
	s_oHorizontalRatio.put("1 Day",      new Long(   "86400000"));
	s_oOrderedListRatio.add("12 Hours");
	s_oHorizontalRatio.put("12 Hours",   new Long(   "43200000"));
	s_oOrderedListRatio.add("6 Hours");
	s_oHorizontalRatio.put("6 Hours",    new Long(   "21600000"));
	s_oOrderedListRatio.add("3 Hours");
	s_oHorizontalRatio.put("3 Hours",    new Long(   "10800000"));
	s_oOrderedListRatio.add("1 Hour");
	s_oHorizontalRatio.put("1 Hour",     new Long(    "3600000"));
	s_oOrderedListRatio.add("30 Minutes");
	s_oHorizontalRatio.put("30 Minutes", new Long(    "1800000"));
	s_oOrderedListRatio.add("15 Minutes");
	s_oHorizontalRatio.put("15 Minutes", new Long(     "900000"));
	s_oOrderedListRatio.add("5 Minutes");
	s_oHorizontalRatio.put("5 Minutes",  new Long(     "300000"));
	s_oOrderedListRatio.add("2 Minutes");
	s_oHorizontalRatio.put("2 Minutes",  new Long(     "120000"));
	s_oOrderedListRatio.add("1 Minute");
	s_oHorizontalRatio.put("1 Minute",   new Long(      "60000"));
	s_oOrderedListRatio.add("30 Seconds");
	s_oHorizontalRatio.put("30 Seconds", new Long(      "30000"));
    }
    private String bestRatioForLength(long _l){
	_l *= 1.2;
	if(_l > 15768000000L){
	    return "1 Year";
	}else if(_l > 7884000000L){
	    return "6 Months";
	}else if(_l > 3942000000L){
	    return "3 Months";
	}else if(_l > 1209600000L){
	    return "1 Month";
	}else if(_l > 604800000L){
	    return "2 Weeks";
	}else if(_l > 345600000L){
	    return "1 Week";
	}else if(_l > 172800000L){
	    return "4 Days";
	}else if(_l > 86400000L){
	    return "2 Days";
	}else if(_l > 43200000L){
	    return "1 Day";
	}else if(_l > 21600000L){
	    return "12 Hours";
	}else if(_l > 10800000L){
	    return "6 Hours";
	}else if(_l > 3600000L){
	    return "3 Hours";
	}else if(_l > 1800000L){
	    return "1 Hour";
	}
	return "30 Minutes";
    }
    private SimpleDateFormat bestTimeFormat(){
	return new SimpleDateFormat("");
    }
    class KeyChecker extends KeyAdapter{
	public void keyPressed(KeyEvent e){
	    System.out.println("PRESSED");
	}
    }
}
