package xor.main.swing;

import javax.swing.*;
import java.awt.BorderLayout;

class RootDesktopPane extends RootPane{
    public RootDesktopPane(SwingInterface _oI){
	super(_oI);
	m_oPanel = new JDesktopPane();
	m_oPanel.setVisible(true);
	((JDesktopPane)m_oPanel).setDesktopManager(new MagneticDesktopManager());
    }
    public void addInside(Inside _oIn,String _sName){
	InternalWindow _oIW = new InternalWindow(m_oI,_oIn);
	_oIW.setTitle(_sName);
	m_oPanel.add(_oIW);
    }
    class MagneticDesktopManager extends DefaultDesktopManager{
	public void dragFrame(JComponent _oJCF,int x,int y){
	    int e = x;
	    int n = y;
	    int w = m_oPanel.getSize().width-_oJCF.getSize().width-e;
	    int s = m_oPanel.getSize().height-_oJCF.getSize().height-n;
	    if(isNear(e) || isNear(n) | isNear(w) || isNear(s)){
		x = (e<w)?(isNear(e)?0:e):(isNear(w)?w+e:e);
		y = (n<s)?(isNear(n)?0:n):(isNear(s)?s+n:n);
	    }
	    super.dragFrame(_oJCF,x,y);
	}
	private boolean isNear(int c){
	    return (Math.abs(c)<10);
	}
    }
    public void removeInside(String _sIn){
    }
    public void bringToTop(String _sName){}
    public boolean exists(String _sName){
	return true;
    }
    public int makeDecision(String _sName){return 0;}
}
