package xor.main.swing;

import java.util.*;
import javax.swing.*;

abstract class RootPane extends JComponent{
    protected JComponent m_oPanel;
    protected SwingInterface m_oI;
    protected Map<String,Inside> m_oMap;

    public RootPane(SwingInterface _oI){
	m_oI = _oI;
	m_oMap = new HashMap<String,Inside>();
    }
    public JComponent panel(){
	return m_oPanel;
    }
    public void addInsides(Map<String,Inside> _aoM){
	Iterator _oIt = _aoM.keySet().iterator();
	while(_oIt.hasNext()){
	    String _sName = (String)_oIt.next();
	    Inside _oIn = _aoM.get(_sName);
	    m_oI.oKernel().getLogger().config("Added "+_sName+" in root panel.");
	    addInside(_oIn,_sName);
	}
    }
    protected void setInside(String _sName,Inside _oI){
	m_oMap.put(_sName,_oI);
    }
    protected Inside getInside(String _sName){
	return m_oMap.get(_sName);
    }
    abstract void addInside(Inside _oI,String _sName);
    abstract void removeInside(String _sName);
    abstract public void bringToTop(String _sName);
    abstract public boolean exists(String _sName);
    abstract public int makeDecision(String _sMessage);
}
