package xor.main.swing;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.text.*;
import java.util.*;
import java.util.regex.*;
import xor.main.*;
import xor.sche.*;

public class ScheList extends Inside{
    private Table m_oTable;
    private TableModel m_oTableModel;
    private JPanel m_oMainPanel;
    private SimpleDateFormat m_oSDF;
    private AbstractMap<String,Object[]> m_aoDisplayed;
    private AbstractMap<String,Sche> m_aoScheMap;
    static private Object[] s_oHeader = {"Status","Title","Content","Location","Begin","End","ID"};
    private boolean m_isCalledFromOuter;
    private int m_nProgressExistingRow;
    private Thread m_oFilterThreadT;
    private FilterThread m_oFilterThread;
    private AbstractList<Sche> m_aoListBuffer;
    private ToolBar m_oToolBar;

    ScheList(SwingInterface _oI,Kernel _oKernel,MDI _oMDI){
	super(_oKernel,_oI,_oMDI);
	m_oMainPanel = new JPanel(new BorderLayout());
	m_isCalledFromOuter = false;
    }
    public void set(){
	m_oTable = new Table(this);
	JScrollPane _oJSP = new JScrollPane();
	_oJSP.getViewport().setView(m_oTable);
	m_oSDF = new SimpleDateFormat("yy/MM/dd HH:mm");
	m_aoDisplayed = new HashMap<String,Object[]>();
	m_aoScheMap = new HashMap<String,Sche>();
	m_oTableModel = new TableModel();
	m_oTable.setModel(m_oTableModel);
	m_oTable.setCellRenderer();
	DBSetChecker _oDBSC = new DBSetChecker(m_oTable,this);
	m_oI.addDBSetListener(_oDBSC);
	m_oMainPanel.add(_oJSP,BorderLayout.CENTER);
	m_oToolBar = new ToolBar();
	m_oMainPanel.add(m_oToolBar,BorderLayout.NORTH);
	m_nProgressExistingRow = 0;
	m_oFilterThread = null;
	m_aoListBuffer = new Vector<Sche>();
	m_oMainPanel.setVisible(false);
    }
    public void refreshForce(){
	runFilterThread();
    }
    class ToolBar extends JToolBar{
	private JCheckBox m_oShowPalette;
	private JCheckBox m_oShowDoneAndHalt;
	private SearchBox m_oSearchQuery;

	ToolBar(){
	    m_oShowPalette = new JCheckBox("Show palette",true);
	    m_oShowDoneAndHalt = new JCheckBox("Show done/halted");
	    m_oSearchQuery = new SearchBox();
	    m_oShowPalette.addItemListener(new CheckBoxChecker(m_oShowPalette));
	    m_oShowDoneAndHalt.addItemListener(new CheckBoxChecker(m_oShowDoneAndHalt));
	    add(m_oShowPalette);
	    add(m_oShowDoneAndHalt);
	    add(m_oSearchQuery);
	}
	public boolean isShowingPalette(){
	    return m_oShowPalette.isSelected();
	}
	public boolean isShowingDoneAndHalt(){
	    return m_oShowDoneAndHalt.isSelected();
	}
	public String searchingQuery(){
	    return m_oSearchQuery.getText();
	}
	class CheckBoxChecker implements ItemListener{
	    private JCheckBox m_oParent;
	    
	    CheckBoxChecker(JCheckBox _oParent){
		m_oParent = _oParent;
	    }
	    public void itemStateChanged(ItemEvent e){
		if(m_oParent == e.getSource()){
		    runFilterThread();
		}
	    }
	}
    }
    class SearchBox extends JTextField{
	SearchBox(){
	    addKeyListener(new KeyChecker());
	}
	private void search(){
	    runFilterThreadWith(getText());
	}
	class KeyChecker extends KeyAdapter{
	    public void keyTyped(KeyEvent e){
		if(e.getKeyChar() == 0xa){
		    search();
		}
	    }
	}
    }
    private void runFilterThreadWith(String _sKey){
	if(m_oFilterThread != null && _sKey.equals(m_oFilterThread.isSearching())){
	    return;
	}
	if(m_oFilterThreadT != null){
	    m_oFilterThread.kill();
	}
	runFilterThread(_sKey);
    }
    private void runFilterThread(){
	runFilterThread(null);
    }
    private void runFilterThread(String _sKey){
	//	m_oTable.setVisible(false);
	if(_sKey == null && m_oFilterThread != null){
	    _sKey = m_oFilterThread.isSearching();
	}
	m_oFilterThread = new FilterThread(_sKey);
	m_oFilterThreadT = new Thread(m_oFilterThread);
	m_oFilterThread.setThread(m_oFilterThreadT);
	m_oFilterThreadT.start();
    }
    class FilterThread implements Runnable{
	private String m_sKey;
	private boolean m_isAlive;
	private Thread m_oT;
	private Filter m_oFilter;
	
	FilterThread(String _sKey){
	    m_sKey = _sKey;
	    m_isAlive = true;
	    m_oFilter = new Filter();
	}
	public void setThread(Thread _oT){
	    m_oT = _oT;
	}
	public void run(){
	    clearTable();
	    int _i = 0;
	    int _nRows = m_aoListBuffer.size();
	    while(true){
		if(!m_isAlive){
		    break;
		}
		try{
		    m_oT.sleep(10);
		}catch(InterruptedException e){
		    e.printStackTrace();
		}
		while(_i < _nRows){
		    Sche _oS = m_aoListBuffer.get(_i);
		    if(m_oFilter.passes(_oS)){
			addToTable(_oS);
		    }
		    _i++;
		    if(_i % 10 == 0){
			break;
		    }
		}
		if(_i == _nRows){
		    return;
		}
	    }
	}
	public void kill(){
	    m_isAlive = false;
	}
	public String isSearching(){
	    return m_sKey;
	}
	public boolean isAlive(){
	    return m_isAlive;
	}
    }
    class Filter{
	public boolean passes(Sche _oS){
	    if(!m_oToolBar.isShowingPalette()){
		if(m_oKernel.getDBSet().typeOf(_oS).equals("palette")){
		    return false;
		}
	    }
	    if(!m_oToolBar.isShowingDoneAndHalt()){
		xor.sche.Time _oT = _oS.changeables().get(0).time();
		if(_oT.status().equals("done") || _oT.status().equals("halt")){
		    return false;
		}
	    }
	    String _sSQ = m_oToolBar.searchingQuery();
	    if(_sSQ.equals("")){
		return true;
	    }else{
		Set _oSet = new HashSet<String>();
		_oSet.add(_oS.ID());
		_oSet.add(_oS.changeables().get(0).title());
		Pattern _oP = Pattern.compile(".*"+_sSQ+".*");
		Iterator _i = _oSet.iterator();
		while(_i.hasNext()){
		    Matcher _oM = _oP.matcher((String)_i.next());
		    boolean _isMatch = _oM.matches();
		    if(_isMatch){
			return true;
		    }
		}
		return false;
	    }
	}
    }
    public JComponent panel(){
	m_oMainPanel.repaint();
	return m_oMainPanel;
    }
    public String type(){
	return "ScheList";
    }
    synchronized public void addLine(xor.sche.Sche _oS){
	if(m_aoScheMap.containsValue(_oS)){return;}
	int _nPos = rowToAdd(_oS);
	if(_nPos == -1){
	    addLineToLast(_oS);
	}else{
	    addLineToLine(_oS,_nPos);
	}
    }
    synchronized private void addLineToLast(Sche _oS){
	addLineToLastBuffer(_oS);
	addToTable(_oS);
    }
    synchronized private void addLineToLine(Sche _oS,int _nPos){
	addLineToLineBuffer(_oS,_nPos);
	addToTable(_oS);
    }
    synchronized private void addLineToLastBuffer(Sche _oS){
	m_aoListBuffer.add(_oS);
    }
    synchronized private void addLineToLineBuffer(Sche _oS,int _nPos){
	m_aoListBuffer.add(_nPos,_oS);
    }
    synchronized private void clearTable(){
	int _nRows = m_oTable.getRowCount();
	int _nIt;
	for(_nIt=0;_nIt<_nRows;_nIt++){
	    m_oTableModel.removeRow(0);
	}
    }
    synchronized private void addToTable(Sche _oS){
	Object[] _oRow = newRow(_oS);
	m_aoDisplayed.put(_oS.ID(),_oRow);
	m_aoScheMap.put(_oS.ID(),_oS);
	m_oTableModel.addRow(_oRow);
    }
    synchronized private int rowToAdd(Sche _oS){
	xor.sche.Time _oTime = _oS.changeables().get(0).time();
	Date _oDImp = _oTime.mostImportantTime();
	if(_oDImp == null){
	    if(_oTime.status().equals("progress")){
		m_nProgressExistingRow++;
		return 0;
	    }else{
		return -1;
	    }
	}
	int _nRC = m_oTable.getRowCount();
	int _nI = m_nProgressExistingRow;
	Date _oDMIT = _oS.changeables().get(0).time().mostImportantTime();
	long _lMIT = _oDMIT.getTime();
	for(;_nI<_nRC;_nI++){
	    xor.sche.Sche _oST = m_aoListBuffer.get(_nI);
	    xor.sche.Time _oTT = _oST.changeables().get(0).time();
	    if(_oTT.status().equals("done") ||
	       _oTT.status().equals("halt")){
		return _nI;
	    }
	    Date _oDTmp = _oTT.mostImportantTime();
	    if(_oDTmp == null){
		continue;
	    }
	    if(_lMIT < _oDTmp.getTime()){
		return _nI;
	    }
	}
	return -1;
    }
    private Object[] newRow(Sche _oS){
	xor.sche.Changeable _oC = _oS.changeables().get(0);
	String _sBegin = "";
	String _sEnd = "";
	xor.sche.Time _oT = _oS.changeables().get(0).time();
	Date _d = _oT.begin();
	_sBegin = _d!=null?m_oSDF.format(_d):"-";
	_d = _oT.end();
	_sEnd = _d!=null?m_oSDF.format(_d):"-";
	String _sLocation = _oC.location()==null?" - ":_oC.location().name();
	String _sContent = _oC.content()==null?" - ":_oC.content().toString();
	Object[] _oRow = {_oT.status(),
			  _oC.title(),
			  _sContent,
			  _sLocation,
			  _sBegin,
			  _sEnd,
			  _oS.ID(),
	};
	return _oRow;
    }
    synchronized public void removeLine(){	
	int _nRowCount = m_oTable.getRowCount();
	int i;
	Iterator _i = m_oI.oKernel().getSelectionSet().iterator();
	while(_i.hasNext()){
	    String _sID = ((Sche)_i.next()).ID();
	    for(i=0;i<_nRowCount;i++){
		if(_sID.equals((String)m_oTable.getValueAt(i,6))){
		    m_oTableModel.removeRow(i);
		    break;
		}
	    }
	    m_aoScheMap.remove(_sID);
	    m_aoDisplayed.remove(_sID);
	}
    }
    synchronized public void updateLine(xor.sche.Sche _oS){
	if(m_oFilterThread == null || m_oFilterThread.isAlive()){
	    return;
	}
	/*
	int _nLength = m_oTable.getRowCount();
	int i;
	String _sID = _oS.ID();
	for(i=0;i<_nLength;i++){
	    String _sIDTmp = "";
	    _sIDTmp = (String)m_oTable.getValueAt(i,6);
	    if(_sID.equals(_sIDTmp)){
		int[] _an = m_oTable.getSelectedRows();
		boolean _isSelected = false;
		int _i2 = 0;
		for(;_i2<_an.length;_i2++){
		    if(_an[_i2] == i){
			_isSelected = true;
			break;
		    }
		}
		m_oTableModel.removeRow(i);
		Object[] _oRow = newRow(_oS);
		m_oTableModel.insertRow(i,_oRow);
		if(_isSelected){
		    m_oTable.addRowSelectionInterval(i,i);
		}
		m_oTable.repaint();
		break;
	    }
	    }*/
    }
    synchronized public void selected(int[] _anV){
	if(_anV.length == 0){return;}
	int i;
	StringBuffer _sCMD = new StringBuffer("select");
	for(i=0;i<_anV.length;i++){
	    if(_anV[i] == -1){return;}
	    String _sID = (String)m_oTable.getValueAt(_anV[i],6);
	    String _sPath = m_oI.oKernel().getDBSet().pathOf(_sID);
	    _sCMD.append(" "+_sPath);
	}
	m_oI.oKernel().execQuery(new String(_sCMD),this);
    }
    class Table extends JTable{
	private ScheList m_oThis;
	
	Table(ScheList _oThis){
	    m_oThis = _oThis;
	}
	public void setCellRenderer(){
	    DefaultTableCellRenderer _oDTCR = new RowRenderer();
	    DefaultTableColumnModel _oCModel = (DefaultTableColumnModel)getColumnModel();
	    for(int _i=0;_i<7;_i++){
		_oCModel.getColumn(_i).setCellRenderer(_oDTCR);
	    }
	}
	public void valueChanged(ListSelectionEvent _oLSE){
	    super.valueChanged(_oLSE);
	    if(_oLSE.getValueIsAdjusting()){
		return;
	    }
	    if(!m_isCalledFromOuter){
		selected(getSelectedRows());
	    }
	}
	synchronized public void selectSche(Sche _oS,SelectionMap _oSM){
	    if(_oSM.isAlreadyChanged(m_oThis)){return;}
	    m_isCalledFromOuter = true;
	    String _sID = _oS.ID();
	    int _nRowNum = 0;
	    for(;_nRowNum < getRowCount();_nRowNum++){
		String _sTID = (String)getValueAt(_nRowNum,6);
		if(isRowSelected(_nRowNum)){
		    continue;
		}
		if(_sID.equals(_sTID)){
		    break;
		}
	    }
	    Sche _oST = m_aoScheMap.get(_sID);
	    if(_nRowNum < getRowCount()){
		addRowSelectionInterval(_nRowNum,_nRowNum);
	    }
	    m_isCalledFromOuter = false;
	}
	synchronized public void unselectAll(){
	    if(getSelectedRowCount() > 0){
		clearSelection();
	    }
	}
    }
    class RowRenderer extends DefaultTableCellRenderer{
	public Component getTableCellRendererComponent(JTable _oTable,
						     Object _oValue,
						     boolean _isSelected,
						     boolean _hasFocus,
						     int _nRow,
						     int _nCol){
	    String _sContent = (String)m_oTableModel.getValueAt(_nRow,_nCol);
	    String _sID = (String)m_oTableModel.getValueAt(_nRow,6);
	    Sche _oS = m_aoScheMap.get(_sID);
	    Time _oT = _oS.changeables().get(0).time();
	    if(!_isSelected){
		if(_nCol == 6){
		    setText("");
		    setSize(0,getSize().height);
		}else{
		    setForeground(java.awt.Color.BLACK);
		    setText(_sContent);
		    if(_nCol == 0){
			if(_oT.status().equals("progress")){
			    setBackground(new java.awt.Color(0xffcccc));
			}else if(_oT.status().equals("coming")){
			    setBackground(new java.awt.Color(0xccffcc));
			}else if(_oT.status().equals("done")){
			    setBackground(new java.awt.Color(0xccccff));
			}else if(_oT.status().equals("halt")){
			    setBackground(new java.awt.Color(0xcccccc));
			}
		    }else{
			if(_oT.status().equals("progress")){
			    setBackground(new java.awt.Color(0xffeeee));
			}else if(_oT.status().equals("coming")){
			    setBackground(new java.awt.Color(0xeeffee));
			}else if(_oT.status().equals("done")){
			    setBackground(new java.awt.Color(0xeeeeff));
			}else if(_oT.status().equals("halt")){
			    setBackground(new java.awt.Color(0xeeeeee));
			}
			if(m_oKernel.getDBSet().typeOf(_oS).equals("palette")){
			    setForeground(java.awt.Color.GRAY);
			}
		    }
		}
	    }else{
		setText(_sContent);
		setBackground(Color.BLACK);
		if(_oT.status().equals("progress")){
		    setForeground(Color.RED);
		}else if(_oT.status().equals("coming")){
		    setForeground(Color.GREEN);	
		}else if(_oT.status().equals("done")){
		    setForeground(Color.CYAN);
		}else if(_oT.status().equals("halt")){
		    setForeground(Color.GRAY);	
		}
	    }
	    return this;
	}
    }
    class TableModel extends DefaultTableModel{
	TableModel(){
	    super(s_oHeader,0);
	}
	public boolean isCellEditable(int row,int column){
	    return false;
	}
    }
    class DBSetChecker extends DBSetAdapter{
	private Table m_oTable;
	private ScheList m_oThis;

	DBSetChecker(Table _oTable,ScheList _oScheList){
	    m_oTable = _oTable;
	    m_oThis = _oScheList;
	}
	synchronized public void add(DBSetEvent _oEv){
	    Iterator _i = _oEv.getSelectionMap().sches().iterator();
	    while(_i.hasNext()){
		addLine((Sche)_i.next());
	    }
	}
	public void remove(DBSetEvent _oEv){
	    removeLine();
	}
	synchronized public void select(DBSetEvent _oEv){
	    if(_oEv == null || _oEv.getSelectionMap() == null){return;}
	    if(!_oEv.getSelectionMap().isAlreadyChanged(m_oThis)){
		m_oTable.unselectAll();
	    }
	    Iterator _i = _oEv.getSelectionMap().sches().iterator();
	    while(_i.hasNext()){
		m_oTable.selectSche((Sche)_i.next(),_oEv.getSelectionMap());
	    }
	}
	public void unselect(DBSetEvent _oEv){
	    if(_oEv == null){return;}
	    m_oTable.unselectAll();
	}
	synchronized public void update(DBSetEvent _oEv){
	    Iterator _i = _oEv.getSelectionMap().sches().iterator();
	    while(_i.hasNext()){
		updateLine((Sche)_i.next());
	    }
	    runFilterThread();
	}
	public void move(DBSetEvent _oEv){
	    runFilterThread();
	}
    }
}
