package xor.main.swing;

import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.table.*;
import javax.swing.event.*;
import xor.main.*;
import java.io.*;
import java.util.*;
import java.lang.*;
import java.awt.*;
import java.awt.event.*;

public class Setting extends Inside{
    private JPanel m_oRoot;
    private JSplitPane m_oSP;
    private SettingRootTree m_oTree;
    private SettingWindowSocket m_oWin;
    private Set<SettingWindow> m_oUpdateNeeded;

    Setting(SwingInterface _oI,Kernel _oKernel,MDI _oMDI){
	super(_oKernel,_oI,_oMDI);
	m_oRoot = new JPanel(new BorderLayout());
	m_oSP = new JSplitPane();
	m_oWin = new SettingWindowSocket();
	m_oUpdateNeeded = new HashSet<SettingWindow>();
    }
    public void set(){
	m_oSP.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
	m_oTree = new SettingRootTree();
	m_oSP.setLeftComponent(m_oTree);
	m_oSP.setRightComponent(m_oWin);
	m_oRoot.add(m_oSP,BorderLayout.CENTER);
	JButton _oOK = new JButton("Update");
	_oOK.setVisible(true);
	_oOK.addMouseListener(new UpdateMouseChecker());
	JPanel _oOKP = new JPanel(new BorderLayout());
	_oOKP.add(_oOK,BorderLayout.EAST);
	m_oRoot.add(_oOKP,BorderLayout.SOUTH);
    }
    public void refresh(){
	super.refresh();
	m_oTree.repaint();
	m_oWin.repaint();
	m_oWin.refresh();
    }
    public void refreshForce(){}
    public void update(){
	Iterator _i = m_oUpdateNeeded.iterator();
	while(_i.hasNext()){
	    SettingWindow _oSW = (SettingWindow)_i.next();
	    _oSW.update();
	}
	m_oUpdateNeeded.clear();
    }
    public JComponent panel(){
	return m_oRoot;
    }
    public String type(){
	return "Setting";
    }
    public Setting oThis(){
	return this;
    }
    public void updateTree(){
	m_oTree.updateTree();
    }
    class UpdateMouseChecker extends MouseAdapter{
	public void mouseClicked(MouseEvent e){
	    update();
	}
    }
    class SettingWindowSocket extends JPanel{
	private SettingWindow m_oInside;
	
	SettingWindowSocket(){
	    super(new BorderLayout());
	    m_oInside = new NothingSettingWindow();
	    add(m_oInside,BorderLayout.CENTER);
	}
	public void changeMainWindowTo(SettingWindow _oSW){
	    if(m_oInside != null){
		remove(m_oInside);
	    }
	    m_oInside = _oSW;
	    m_oUpdateNeeded.add(_oSW);
	    add(m_oInside,BorderLayout.CENTER);
	    int _nSPLocation = m_oSP.getDividerLocation();
	    // Setting divider location for Main window rendering bug.
	    m_oSP.setDividerLocation(_nSPLocation+1);
	    m_oSP.setDividerLocation(_nSPLocation);
	    m_oInside.generate();
	    oThis().refresh();
	}
	public void refresh(){
	    repaint();
	    m_oInside.refresh();
	}
    }
    class SettingRootTree extends JPanel{
	private JTree m_oTree;
	private DefaultTreeModel m_oTreeModel;

	SettingRootTree(){
	    super(new BorderLayout());
	    DefaultMutableTreeNode _oRoot = new DefaultMutableTreeNode("Setting");
	    m_oTreeModel = new DefaultTreeModel(_oRoot);
	    m_oTree = new JTree(m_oTreeModel);
	    _oRoot.add(new DBNode());
	    _oRoot.add(new NetworkNode());
	    m_oTree.setRootVisible(true);
	    m_oTree.setVisible(true);
	    JScrollPane _oJSP = new JScrollPane(m_oTree);
	    add(_oJSP,BorderLayout.CENTER);
	    setVisible(true);
	    m_oTree.expandRow(0);
	}
	public void updateTree(){
	    m_oTreeModel.reload();
	}
	abstract class SettingIncludingTreeNode extends DefaultMutableTreeNode{
	    protected SettingWindow m_oSW;
	    
	    SettingIncludingTreeNode(String _sName){
		super(_sName);
		m_oTree.addTreeSelectionListener(new SelChecker(this));
	    }
	    public void setSettingWindow(SettingWindow _oSW){
		m_oSW = _oSW;
	    }
	    public void switchToThis(){
		m_oWin.changeMainWindowTo(m_oSW);
	    }
	    class SelChecker implements TreeSelectionListener{
		private SettingIncludingTreeNode m_oSITN;
		
		SelChecker(SettingIncludingTreeNode _oSITN){
		    super();
		    m_oSITN = _oSITN;
		}
		public void valueChanged(TreeSelectionEvent e){
		    if(m_oSITN.hashCode() == e.getPath().getLastPathComponent().hashCode()){
			switchToThis();
		    }
		}
	    }
	}
	class NetworkNode extends DefaultMutableTreeNode{
	    NetworkNode(){
		super("Network");
		NetworkSettingWaiter _oNSW = new NetworkSettingWaiter();
		Thread _oT = new Thread(_oNSW);
		_oNSW.setThread(_oT);
		_oT.start();
	    }
	    class Proxy extends SettingIncludingTreeNode{
		Proxy(SettingNetworkProxy _oSNP){
		    super("Proxy");
		    SettingWindow _oPSW = new ProxySettingWindow(_oSNP);
		    setSettingWindow(_oPSW);
		    updateTree();
		}
	    }
	    class NetworkSettingWaiter implements Runnable{
		private Thread m_oT;

		public void run(){
		    try{
			while(m_oKernel.getImporter() == null){
			    m_oT.sleep(1000);
			}
		    }catch(InterruptedException e){
			e.printStackTrace();
		    }
		    add(new Proxy(m_oKernel.getImporter().getSNP()));
		}
		public void setThread(Thread _oT){
		    m_oT = _oT;
		}
	    }
	}
	class DBNode extends SettingIncludingTreeNode{
	    private Map<String,DB> m_oRegDBs;
	    private DBAllAnalysisWindow m_oDBSW;
	    private DBSet m_oDBSet;

	    DBNode(){
		super("Database");
		DBSettingWaiter _oNSW = new DBSettingWaiter();
		Thread _oT = new Thread(_oNSW);
		_oNSW.setThread(_oT);
		_oT.start();
		m_oRegDBs = new HashMap<String,DB>();
		setDBAnalysisWindow();
	    }
	    public void addDBData(String _sName,String _sType){
		addDBData(_sName,_sType,false);
	    }
	    public void addDBData(String _sName,String _sType,boolean _isSelectionNeeded){
		DBFactory _oDBF = new DBFactory();
		DB _oDB = _oDBF.generate(_sName,_sType);
		addDBData(_sName,_oDB,_isSelectionNeeded);
	    }
	    public void addDBData(String _sName,DB _oDB){
		addDBData(_sName,_oDB,false);
	    }
	    public void addDBData(String _sName,DB _oDB,boolean _isSelectionNeeded){
		if(_oDB == null){
		    return;
		}
		setDBAnalysisWindow();
		add(_oDB);
		m_oRegDBs.put(_sName,_oDB);
		m_oDBSW.addDBSet(_sName,_oDB.type());
		updateTree();
		m_oTree.expandRow(1);
		if(_isSelectionNeeded){
		    selectNode(_oDB);
		}
	    }
	    private void selectNode(DB _oDB){
		TreeNode[] _aoNodes = _oDB.getPath();
		TreePath _oPath = new TreePath(_aoNodes);
		m_oTree.setSelectionPath(_oPath);
	    }
	    public void removeDBData(String _sName){
		DB _oDB = m_oRegDBs.get(_sName);
		remove(_oDB);
		m_oRegDBs.remove(_sName);
		m_oDBSW.removeDBSet(_sName);
		m_oDBSet.removeDB(_sName);
		updateTree();
		m_oTree.expandRow(1);
	    }
	    private void setDBAnalysisWindow(){
		if(m_oDBSW == null){
		    m_oDBSW = new DBAllAnalysisWindow();
		    setSettingWindow(m_oDBSW);
		    m_oDBSW.addDBListener(new DBSettingChangeChecker());
		}
	    }
	    abstract class DB extends SettingIncludingTreeNode{
		DB(String _sName){
		    super(_sName);
		}
		abstract public String type();
	    }
	    class DBPlainText extends DB{
		DBPlainText(String _sName,xor.main.dbloader.XML _oDB){
		    super(_sName);
		    DBPlainTextSettingWindow _oDBW = new DBPlainTextSettingWindow(_oDB);
		    setSettingWindow(_oDBW);
		}
		public String type(){return "plaintext";}
	    }
	    class DBMySQL extends DB{
		DBMySQL(String _sName){
		    super(_sName);
		}
		public String type(){return "mysql";}
	    }
	    class DBFactory{
		public DB generate(String _sKey,String _sType){
		    return generate(_sKey,_sType,m_oDBSet.addDB(_sKey,_sType));
		}
		public DB generate(String _sKey,String _sType,xor.main.dbloader.Abstract _oDB){
		    DB _oNew = null;
		    if(_sType.equals("plaintext")){
			_oNew = new DBPlainText(_sKey,(xor.main.dbloader.XML) _oDB);
		    }else if(_sType.equals("mysql")){
		    }
		    return _oNew;
		}
	    }
	    class DBSettingWaiter implements Runnable{
		private Thread m_oT;

		public void run(){
		    try{
			while(m_oKernel.getDBSet() == null){
			    m_oT.sleep(2000);
			}
		    }catch(InterruptedException e){
			e.printStackTrace();
		    }
		    m_oDBSet = m_oKernel.getDBSet();
		    Map<String,xor.main.dbloader.Abstract> _oA = m_oDBSet.getDBs();
		    Iterator _i = _oA.keySet().iterator();
		    DBFactory _oDBF = new DBFactory();
		    while(_i.hasNext()){
			String _sKey = (String)_i.next();
			xor.main.dbloader.Abstract _oDB = _oA.get(_sKey);
			if(_oDB == null){
			    continue;
			}
			if(_oDB.dbtype().equals("plaintext")){
			    addDBData(_sKey,_oDBF.generate(_sKey,"plaintext",_oDB));
			}
		    }
		}
		public void setThread(Thread _oT){
		    m_oT = _oT;
		}
	    }
	    class DBSettingChangeChecker extends DBAdapter{
		public void add(DBEvent e){
		    addDBData(e.getName(),e.getType(),true);
		}
		public void remove(DBEvent e){
		    if(e.getName() != null){
			removeDBData(e.getName());
		    }
		}
	    }
	}
    }
    abstract class SettingWindow extends JPanel{
	private boolean m_isGenerated;

	SettingWindow(){
	    super(new BorderLayout());
	    m_isGenerated = false;
	}
	final public void generate(){
	    if(!m_isGenerated){
		tryToGenerate();
		m_isGenerated = true;
	    }
	}
	abstract public void tryToGenerate();
	public boolean isRefreshed(){
	    return m_isGenerated;
	}
	public void refresh(){
	    repaint();
	}
	abstract public void update();
	public void addUpdateButton(JComponent _oC){
	    add(_oC,BorderLayout.SOUTH);
	}
    }
    class NothingSettingWindow extends SettingWindow{
	NothingSettingWindow(){
	    super();
	}
	public void tryToGenerate(){
	    JLabel _oL = new JLabel("<html><p>Choose setting content from left.</p><p>Double-click to open Setting file.");
	    add(_oL,BorderLayout.CENTER);
	}
	public void update(){}
    }
    class ProxySettingWindow extends SettingWindow{
	private SettingNetworkProxy m_oSNP;
	private SingleProxySetting m_oHTTP,m_oHTTPS,m_oFTP,m_oSOCKS;
	private JPanel m_oJP;
	
	ProxySettingWindow(SettingNetworkProxy _oSNP){
	    super();
	    m_oSNP = _oSNP;
	    m_oJP = new JPanel(new GridLayout(0,1));
	}
	public void tryToGenerate(){
	    m_oHTTP = new SingleProxySetting("http");
	    m_oHTTPS = new SingleProxySetting("https");
	    m_oFTP = new SingleProxySetting("ftp");
	    m_oSOCKS = new SingleProxySetting("socks");
	    m_oJP.add(m_oHTTP);
	    m_oJP.add(m_oHTTPS);
	    m_oJP.add(m_oFTP);
	    m_oJP.add(m_oSOCKS);
	    add(m_oJP,BorderLayout.NORTH);
	    refresh();
	}
	private AddPair getAddressPair(String _sType){
	    return m_oSNP.getPairFor(_sType);
	}
	public void refresh(){
	    m_oJP.repaint();
	    m_oHTTP.refresh();
	    m_oHTTPS.refresh();
	    m_oFTP.refresh();
	    m_oSOCKS.refresh();
	    super.refresh();
	}
	public void update(){
	    m_oHTTP.update();
	    m_oHTTPS.update();
	    m_oFTP.update();
	    m_oSOCKS.update();
	    m_oSNP.update();
	}
	class SingleProxySetting extends JPanel{
	    private JLabel m_oName;
	    private JTextField m_oHost,m_oPort;
	    private String m_sType;
	    
	    SingleProxySetting(String _sType){
		super(new GridLayout(1,3));
		m_oName = new JLabel();
		m_oHost = new JTextField();
		m_oPort = new JTextField();
		add(m_oName);
		add(m_oHost);
		add(m_oPort);
		m_oName.setHorizontalAlignment(SwingConstants.RIGHT);
		m_sType = _sType;
		m_oName.setText(m_sType);
	    }
	    public void refresh(){
		AddPair _oAP = getAddressPair(m_sType);
		if(_oAP != null){
		    m_oHost.setText(_oAP.getInetAdd());
		    int _nPort = _oAP.getPort();
		    if(_nPort != -1){
			m_oPort.setText(new Integer(_nPort).toString());
		    }
		}
	    }
	    public void update(){
		AddPair _oAP = getAddressPair(m_sType);
		if(_oAP != null){
		    _oAP.setInetAdd(m_oHost.getText());
		    _oAP.setPort(m_oPort.getText());
		    _oAP.refresh();
		}
	    }
	}
    }
    abstract class DBSettingWindow extends SettingWindow{
	abstract public boolean isSet();
    }
    class DBPlainTextSettingWindow extends DBSettingWindow{
	private JTextField m_oFilePath;
	private JButton m_oFileBrowser;
	private xor.main.dbloader.XML m_oDB;
	private JLabel m_oStatus;
	
	DBPlainTextSettingWindow(xor.main.dbloader.XML _oDB){
	    m_oDB = _oDB;
	}
	public void tryToGenerate(){
	    JPanel _oRow = new JPanel(new BorderLayout());
	    m_oFilePath = new JTextField(m_oDB.getPath());
	    _oRow.add(m_oFilePath,BorderLayout.CENTER);
	    m_oFileBrowser = new JButton("Browse");
	    _oRow.add(m_oFileBrowser,BorderLayout.EAST);
	    JLabel _oL = new JLabel("Directory Path:");
	    _oRow.add(_oL,BorderLayout.WEST);
	    add(_oRow,BorderLayout.NORTH);
	    m_oFileBrowser.addMouseListener(new MouseChecker());
	    m_oFilePath.addKeyListener(new InputChecker());
	    m_oStatus = new JLabel();
	    setLabel();
	    _oRow.add(m_oStatus,BorderLayout.SOUTH);
	}
	private void setLabel(){
	    if(m_oFilePath.getText().equals("")){
		m_oStatus.setText("Please set directory to save datas.");
		m_oStatus.setForeground(java.awt.Color.RED);
	    }else{
		m_oStatus.setText("Click \"Update\" below to save datas.");
		m_oStatus.setForeground(java.awt.Color.BLACK);
	    }
	}
	private void updatePath(String _sFilePath){
	    m_oFilePath.setText(_sFilePath);
	    setLabel();
	}
	public void refresh(){}
	public void update(){
	    m_oDB.setPath(m_oFilePath.getText());
	    m_oDB.update();
	}
	public boolean isSet(){
	    return !m_oFilePath.getText().equals("");
	}
	class MouseChecker extends MouseAdapter{
	    public void mouseClicked(MouseEvent e){
		JFileChooser _oFC = new JFileChooser(m_oFilePath.getText());
		_oFC.setFileSelectionMode( JFileChooser.DIRECTORIES_ONLY);
		
		int _nAppr = _oFC.showOpenDialog( null ); 		
		if(_nAppr != JFileChooser.APPROVE_OPTION){
		    return;
		}
		File _oFile = _oFC.getSelectedFile();
		updatePath(_oFile.getAbsolutePath());
	    }
	}
	class InputChecker extends KeyAdapter{
	    public void keyReleased(KeyEvent e){
		setLabel();
	    }
	}
    }
    class DBMySQLSettingWindow extends DBSettingWindow{ 
	public void tryToGenerate(){}
	public void refresh(){}
	public void update(){}
	public boolean isSet(){
	    return true;
	}
    }
    class DBSettingWindowFactory{
	public DBSettingWindow getEmptyOneFor(String _sType,xor.main.dbloader.Abstract _oDB){
	    if(_sType.equals("plaintext")){
		return new DBPlainTextSettingWindow((xor.main.dbloader.XML)_oDB);
	    }else if(_sType.equals("mysql")){
		return new DBMySQLSettingWindow();
	    }
	    return null;
	}
    }
    class DBAllAnalysisWindow extends SettingWindow{
	private ListWindow m_oLW;
	private Editor m_oEditor;
	private Map<String,String> m_oBuffer;
	
	DBAllAnalysisWindow(){
	    m_oBuffer = new HashMap<String,String>();
	}
	public void tryToGenerate(){
	    m_oLW = new ListWindow();
	    add(m_oLW,BorderLayout.CENTER);
	    m_oEditor = new Editor();
	    add(m_oEditor,BorderLayout.NORTH);
	    addDBSetInsideBuffer();
	}
	public void addDBSet(String _sName,String _sType){
	    if(m_oLW == null){
		m_oBuffer.put(_sName,_sType);
	    }else{
		m_oLW.addRow(_sName,_sType);
	    }
	}
	private void addDBSetInsideBuffer(){
	    if(m_oLW != null){
		if(!m_oBuffer.isEmpty()){
		    Iterator _i = m_oBuffer.keySet().iterator();
		    while(_i.hasNext()){
			String _sNameTmp = (String)_i.next();
			m_oLW.addRow(_sNameTmp,m_oBuffer.get(_sNameTmp));
		    }
		    m_oBuffer.clear();
		}
	    }
	}
	public void removeDBSet(String _sName){
	    m_oLW.removeRowNamed(_sName);
	}
	public void refresh(){}
	public void update(){}
	class ListWindow extends JPanel{
	    private TableModel m_oTableModel;
	    private Table m_oTable;
	    
	    ListWindow(){
		super(new BorderLayout());
		m_oTableModel = new TableModel();
		m_oTable = new Table();
		m_oTable.setModel(m_oTableModel);
		JScrollPane _oJSP = new JScrollPane(m_oTable);
		add(_oJSP,BorderLayout.CENTER);
		JLabel _oTitle = new JLabel("Registered DBs");
		add(_oTitle,BorderLayout.NORTH);
	    }
	    public void addRow(String _sName,String _sType){
		Object[] _oRow = {_sName,_sType};
		m_oTableModel.addRow(_oRow);
	    }
	    public void removeRowNamed(String _sName){
		int _nMaxRow = m_oTable.getRowCount();
		int _nIt = 0;
		for(;_nIt<_nMaxRow;_nIt++){
		    String _sItName = m_oTable.getNameAtRow(_nIt);
		    if(_sItName.equals(_sName)){
			m_oTableModel.removeRow(_nIt);
			break;
		    }
		}
	    }
	    public String getNameAtSelectedRow(){
		return m_oTable.getNameAtSelectedRow();
	    }
	    class Table extends JTable{
		Table(){
		    super();
		    setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		    setVisible(true);
		}
		public void valueChanged(ListSelectionEvent _oLSE){
		    super.valueChanged(_oLSE);
		    if(_oLSE.getValueIsAdjusting()){
			return;
		    }
		}
		public String getNameAtSelectedRow(){
		    int _nPos = getSelectedRow();
		    if(_nPos != -1){
			return getNameAtRow(_nPos);
		    }
		    return null;
		}
		public String getNameAtRow(int _n){
		    return (String)getValueAt(_n,0);
		}
	    }
	    class TableModel extends DefaultTableModel{
		TableModel(){
		    super();
		    addColumn("Name");
		    addColumn("Type");
		}
		public boolean isCellEditable(int row,int column){
		    return false;
		}
	    }
	}
	class Editor extends JTabbedPane{
	    AbstractEditor m_oAdd,m_oRemove;

	    Editor(){
		super();
		m_oAdd = new EditorAdd();
		m_oRemove = new EditorRemove();
		addTab("Add",m_oAdd);
		addTab("Remove",m_oRemove);
	    }
	    class AbstractEditor extends JPanel{
		AbstractEditor(){
		    super();
		}
		AbstractEditor(LayoutManager _oJ){
		    super(_oJ);
		}
	    }
	    class EditorAdd extends AbstractEditor{
		private JTextField m_oName;
		private JComboBox m_oType;
		private JButton m_oAdd;
		
		EditorAdd(){
		    super(new GridLayout(2,3));
		    JLabel _oName = new JLabel("Name");
		    add(_oName);
		    JLabel _oType = new JLabel("Type");
		    add(_oType);
		    JLabel _oAddT = new JLabel("");
		    add(_oAddT);
		    m_oName = new JTextField();
		    m_oName.addKeyListener(new InputChecker());
		    m_oType = new JComboBox();
		    m_oType.addItem("plaintext");
		    //		    m_oType.addItem("mysql");
		    add(m_oName);
		    add(m_oType);
		    m_oAdd = new JButton("Add");
		    m_oAdd.addMouseListener(new AddButtonChecker());
		    add(m_oAdd);
		    m_oAdd.setEnabled(false);
		}
		public void setIsAbleToAdd(){
		    m_oAdd.setEnabled(isAddable(m_oName.getText()));
		}
		private boolean isAddable(String _sNewName){
		    if(_sNewName.equals("") ||
		       _sNewName.equals("buffer")){
			return false;
		    }
		    return true;
		}
		class InputChecker extends KeyAdapter{
		    public void keyReleased(KeyEvent e){
			setIsAbleToAdd();
		    }
		}
		class AddButtonChecker extends MouseAdapter{
		    public void mouseClicked(MouseEvent e){
			sendDBListener(new DBEvent(this,
						   DBEventEnum.ADD,
						   m_oName.getText(),
						   (String)m_oType.getSelectedItem()));
		    }
		}
	    }
	    class EditorRemove extends AbstractEditor{
		private JButton m_oRemove;
		
		EditorRemove(){
		    super(new BorderLayout());
		    m_oRemove = new JButton("Remove");
		    m_oRemove.addMouseListener(new AddButtonChecker());
		    add(m_oRemove,BorderLayout.SOUTH);
		    JLabel _oInst = new JLabel("Press the button below to remove selected DB.");
		    add(_oInst,BorderLayout.CENTER);
		}
		class AddButtonChecker extends MouseAdapter{
		    public void mouseClicked(MouseEvent e){
			String _sDBName = m_oLW.getNameAtSelectedRow();
			int _nAnswer = JOptionPane.showConfirmDialog(new JPanel(),
								     "Do you really want to remove DB \""+_sDBName+"\"?",
								     "Yes No",
								     JOptionPane.YES_NO_OPTION);
			if(_nAnswer == 0){
			    sendDBListener(new DBEvent(this,
						       DBEventEnum.REMOVE,
						       _sDBName,
						       null));
			}
		    }
		}
	    }
	}
	private Vector<DBListener> m_aoDBListeners = new Vector<DBListener>();
	public void addDBListener(DBListener _oL){
	    m_aoDBListeners.addElement(_oL);
	}
	public void removeDBListener(DBListener _oL){
	    m_aoDBListeners.removeElement(_oL);
		}
	public void sendDBListener(DBEvent _oEv){
	    DBEventEnum _sMethod = _oEv.getMethod();
	    Vector<DBListener> _aoL = (Vector<DBListener>)m_aoDBListeners.clone();
	    Enumeration _oENum = _aoL.elements();
	    if(_sMethod == DBEventEnum.ADD){
		while(_oENum.hasMoreElements()){
		    DBListener _oL = (DBListener)_oENum.nextElement();
		    _oL.add(_oEv);
		}
	    }else if(_sMethod == DBEventEnum.REMOVE){
		while(_oENum.hasMoreElements()){
		    DBListener _oL = (DBListener)_oENum.nextElement();
		    _oL.remove(_oEv);
		}
	    }
	}
    }
    enum DBEventEnum{
	ADD,
	REMOVE
    }
    class DBEvent extends EventObject{
	private DBEventEnum m_sMethod;
	private String m_sDBName;
	private String m_sDBType;

	DBEvent(Object _oS,DBEventEnum _sMethod,String _sDBName,String _sDBType){
	    super(_oS);
	    m_sMethod = _sMethod;
	    m_sDBName = _sDBName;
	    m_sDBType = _sDBType;
	}
	public DBEventEnum getMethod(){
	    return m_sMethod;
	}
	public String getName(){
	    return m_sDBName;
	}
	public String getType(){
	    return m_sDBType;
	}
    }
    interface DBListener extends EventListener{
	public void add(DBEvent e);
	public void remove(DBEvent e);
    }
    class DBAdapter implements DBListener{
	public void add(DBEvent e){}
	public void remove(DBEvent e){}
    }
}
