package xor.main.swing;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.text.*;
import xor.main.*;
import xor.sche.*;

public class Updated extends Inside{
    private JPanel m_oPanel;
    private Table m_oTable;
    private TableModel m_oTableModel;
    private AbstractList<Sche> m_aoUpdatedSches;
    static private Object[] s_oHeader = {"Updated","Title",""};
    static private SimpleDateFormat s_oSDF = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.S");
    
    Updated(SwingInterface _oI,Kernel _oKernel,MDI _oMDI){
	super(_oKernel,_oI,_oMDI);
	m_oPanel = new JPanel(new BorderLayout());
	m_aoUpdatedSches = new Vector<Sche>();
    }
    public void set(){
	m_oTable = new Table();
	m_oTableModel = new TableModel();
	m_oTable.setModel(m_oTableModel);
	JScrollPane _oJSP = new JScrollPane(m_oTable);
	m_oPanel.add(_oJSP,BorderLayout.CENTER);
	ToolBar _oTB = new ToolBar();
	m_oPanel.add(_oTB,BorderLayout.NORTH);
	DBSetChecker _oDBSC = new DBSetChecker();
	m_oI.addDBSetListener(_oDBSC);
	m_oPanel.setVisible(false);
    }
    public void refreshForce(){}
    public JComponent panel(){
	return m_oPanel;
    }
    public String type(){
	return "Updated";
    }
    public void addUpdatedSche(Sche _oS){
	if(m_aoUpdatedSches.contains(_oS)){
	    return;
	}
	setAnnouncement(_oS);
	addRow(_oS);
    }
    private void setAnnouncement(Sche _oS){
	m_aoUpdatedSches.add(_oS);
	String _sMessage = "";
	if(m_aoUpdatedSches.size() == 1){
	    _sMessage = "Sche named \""+_oS.changeables().get(0).title()+"\" is updated.";
	}else{
	    _sMessage = m_aoUpdatedSches.size()+" sches were updated.";
	}
	m_oI.sendAnnouncementListener(new AnnouncementEvent(this,AnnouncementEnum.DEFAULT,"Updated",_sMessage));
    }
    private void addRow(Sche _oS){
	Date _oD = new Date();
	String _sDate = s_oSDF.format(_oD);
	Object[] _oRow = {
	    _sDate,
	    _oS.changeables().get(0).title(),
	    _oS.ID()
	};
	m_oTableModel.insertRow(0,_oRow);
    }
    synchronized private void clearTable(){
	int _nRows = m_oTable.getRowCount();
	int _nIt;
	for(_nIt=0;_nIt<_nRows;_nIt++){
	    m_oTableModel.removeRow(0);
	}
    }
    synchronized private void selected(int[] _anV){
	if(_anV.length == 0){
	    return;
	}
	int i;
	Set<String> _aoIDs = new HashSet<String>();
	StringBuffer _sCMD = new StringBuffer("select");
	for(i=0;i<_anV.length;i++){
	    if(_anV[i] == -1){
		return;
	    }
	    String _sID = (String)m_oTable.getValueAt(_anV[i],2);
	    if(!_aoIDs.contains(_sID)){
		String _sPath = m_oI.oKernel().getDBSet().pathOf(_sID);
		_sCMD.append(" "+_sPath);
		_aoIDs.add(_sID);
	    }
	}
	m_oI.oKernel().execQuery(new String(_sCMD),this);
    }
    class Table extends JTable{
	public void valueChanged(ListSelectionEvent _oLSE){
	    super.valueChanged(_oLSE);
	    if(_oLSE.getValueIsAdjusting()){
		return;
	    }
	    selected(getSelectedRows());
	}
    }
    class TableModel extends DefaultTableModel{
	TableModel(){
	    super(s_oHeader,0);
	}
	public boolean isCellEditable(int row,int column){
	    return false;
	}
    }
    class ToolBar extends JToolBar{
	ToolBar(){
	    JButton _oB = new DeleteButton();
	    add(_oB);
	}
    }
    class DeleteButton extends JButton{
	DeleteButton(){
	    super("Delete updated");
	    addMouseListener(new ButtonClickChecker());
	}
	class ButtonClickChecker extends MouseAdapter{
	    public void mouseClicked(MouseEvent e){
		clearTable();
	    }
	}
    }
    class DBSetChecker extends DBSetAdapter{
	public void update(DBSetEvent _oEv){
	    Iterator _i = _oEv.getSelectionMap().sches().iterator();
	    while(_i.hasNext()){
		addUpdatedSche((Sche)_i.next());
	    }
	}
    }
}
