package xor.sche;

import java.util.*;
import java.net.*;
import java.text.*;

final public class Sche extends ScheObj{
    private String m_sID;
    private AbstractList<URI> m_aoURIs;
    private AbstractList<Changeable> m_aoChangeables;
    private Generator m_oGenerator;

    public Sche(){
	m_aoURIs = new LinkedList<URI>();
	m_aoChangeables = new LinkedList<Changeable>();
	m_oGenerator = new Generator();
    }
    public void setGenerator(Generator _oG){   m_oGenerator = _oG;}
    public void setID(String _sID){            m_sID = _sID;}
    public void addURI(URI _oURI){             m_aoURIs.add(_oURI);}
    public void addChangeable(Changeable _oC){ m_aoChangeables.add(_oC);}

    public String ID(){	             return m_sID;}
    public AbstractList<URI> URIs(){ return m_aoURIs;}
    public AbstractList<Changeable> changeables(){return m_aoChangeables;}
    public Generator generator(){    return m_oGenerator;}

    public String type(){
	return "sche-sche";
    }
    public boolean isValid(){
	return !m_aoChangeables.isEmpty();
    }
    public boolean updateTo(Sche _oS){
	Changeable _oC = _oS.changeables().get(0);
	SimpleDateFormat _oSDF = new SimpleDateFormat("yyyy/MM/d HH:mm:ss");
	if(m_aoChangeables.get(0).modified().getTime() < _oC.modified().getTime()){
	    m_aoURIs = _oS.URIs();
	    m_aoChangeables = _oS.changeables();
	    m_oGenerator = _oS.generator();
	    return true;
	}
	return false;
    }
}
