
#include <QtGui>

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "fudaselectdlg.h"
#include "optiondialog.h"
#include "ankijikan_dialog.h"

#include "textrsc.h" // kamiku text resource

int RandomNumber(int min, int max)
{
    return min + (int)(qrand() * (max - min + 1.0) / (1.0 + RAND_MAX));
}

int GenerateRandomNumbers(int *data, int len)
{
    int i, j, rnd;
    int tmp;

    QTime midnight(0,0,0);
    qsrand(midnight.secsTo(QTime::currentTime()));

    j = len - 1;
    for (i = 0; i < (len - 1); i++, j--) {
        rnd = RandomNumber(0, j);
        tmp = data[j];
        data[j] = data[rnd];
        data[rnd] = tmp;
    }
    return i;
}

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

//    QTextCodec::setCodecForTr(QTextCodec::codecForLocale());
    QTextCodec::setCodecForTr(QTextCodec::codecForName("UTF-8")); // source codec is UTF-8

    QCoreApplication::setApplicationName("QtKarutaEishow");
    QCoreApplication::setApplicationVersion("1.0");
    this->setWindowTitle(QCoreApplication::applicationName());
    IniFilePath = QCoreApplication::applicationDirPath() + QDir::separator() + QCoreApplication::applicationName() + ".ini";

//    ui->Btn_Start->setIcon(QIcon(QPixmap(":/images/Play.png")));
//    ui->Btn_Stop->setIcon(QIcon(QPixmap(":/images/Stop.png")));


    // Initialize FudaList
    FList = new QList<int>;
    FList->clear();

    // Load Setting
    LoadSaveSetting(IniFilePath, false);

    // Play setting

    // Check Music Files
    QString CheckFilepath1 = QCoreApplication::applicationDirPath() + QDir::separator() + tr("Music") + QDir::separator() + tr("yamajun_000_2.ogg");
    QFileInfo CheckFile1(CheckFilepath1);
    if (CheckFile1.exists()) {
        ui->Btn_Start->setEnabled(true);
        ui->statusBar->showMessage(QString(tr("再生ボタンを押してください")));
    } else {
        ui->Btn_Start->setEnabled(false);
        ui->statusBar->showMessage(QString(tr("音声ファイルが見つからないので再生できません(!_!)")));
    }
    // Check Music2 Files
    QString CheckFilepath2 = QCoreApplication::applicationDirPath() + QDir::separator() + tr("Music2") + QDir::separator() + tr("inaba_000_2.ogg");
    QFileInfo CheckFile2(CheckFilepath2);
    if (CheckFile2.exists()) {
        EnableOptMusic = true;
    } else { // Music2 file Not Exist
        EnableOptMusic = false;
        SelectVoice = 0;
    }
    //    chk_joka = true;
//    Wait1Time = 10;
//    Wait2Time = 3;
    ui->checkBox->setChecked(chk_joka);
    ui->spinBox_1->setValue(Wait1Time);
    ui->spinBox_2->setValue(Wait2Time);

    // Initialize PlayFudaList
    PlayFudaList = new QList<int>();
    PlayFudaList->clear();
    flag_playseqstate = false;
    flag_pause = false;
    PlayCounter = 0;
    PlayListCount = 0;

    // Init PlaySequenceThread
    PlaySeqTh = new PlaySequenceThread(this->winId());

    // GetSoundVolume to Slider Value
    ui->Slider_Volume->setValue((int)(PlaySeqTh->GetSoundVolume() * 100));

    //    signals:
    //        void SequencStartded();
    //        void Music1Starteded(int fudaNum);
    //        void Music1Ended();
    //        void Music2Starteded(int fudaNum);
    //        void Music2Ended();
    //        void SequenceEnded(int status); // status 0 is success, !0 is Fail
    connect(PlaySeqTh, SIGNAL(SequencStartded()),
            this, SLOT(SequencStartded()));
    connect(PlaySeqTh, SIGNAL(Music1Starteded(int)),
            this, SLOT(Music1Starteded(int)));
    connect(PlaySeqTh, SIGNAL(Music1Ended()),
            this, SLOT(Music1Ended()));
    connect(PlaySeqTh, SIGNAL(Music2Starteded(int)),
            this, SLOT(Music2Starteded(int)));
    connect(PlaySeqTh, SIGNAL(Music2Ended()),
            this, SLOT(Music2Ended()));
    connect(PlaySeqTh, SIGNAL(SequenceEnded(int)),
            this, SLOT(SequenceEnded(int)));

    // Start PlaySequeceThread
    PlaySeqTh->start();
}

MainWindow::~MainWindow()
{
    // Save Setting
    LoadSaveSetting(IniFilePath, true);

    // Finalize PlaySequenceThread
    PlaySeqTh->stop();
    PlaySeqTh->wait();
    delete PlaySeqTh;

    // Finalize mytask
    FList->clear();
    delete FList;

    PlayFudaList->clear();
    delete PlayFudaList;

    delete ui;
}

void MainWindow::on_actionQuit_triggered()
{
    close();
}

void MainWindow::on_actionAbout_triggered()
{
    QString AppName = QCoreApplication::applicationName();
    QString Version = QCoreApplication::applicationVersion();
    QString Year = "2011";
    QString Author = "alucky4416@users.sourceforge.ne.jp";
    QString msg;
    msg = QString("<h2>%1 %2</h2>" \
                  "<p>use Qt4 (32bit)" \
                  "<p>use BASS audio library" \
                  "<p>" \
                  "<p>Copyright &copy; %3 %4.").arg(AppName).arg(Version).arg(Year).arg(Author);
    QMessageBox::about(this, "About", msg);
}

void MainWindow::on_actionAboutQt_triggered()
{
    QApplication::aboutQt();
}

void MainWindow::on_Btn_Start_clicked()
{
    if (!flag_playseqstate) {
        // WaitTime, CheckBox disable
        ui->spinBox_1->setEnabled(false);
        ui->spinBox_2->setEnabled(false);
        ui->checkBox->setEnabled(false);

        // Generate Play FudaList
        PlayCounter = 0;
        PlayListCount = FList->count();

        int fudaList[PlayListCount];
        // Copy FList to fudalist[]
        for (int i = 0; i < PlayListCount;i++) {
            fudaList[i] = FList->at(i);
        }
        GenerateRandomNumbers(&fudaList[0], PlayListCount);
        // Copy fudalist[](shuffule) to PlayFudaList;
        PlayFudaList->clear();
        for (int i = 0; i < PlayListCount; i++) {
            PlayFudaList->append(fudaList[i]);
        }
        // Add Joka
        if (chk_joka) {
            PlayFudaList->insert(0, 0); // fudaN=0 insert to top
        }
        // Set Play Setting
        PlaySeqTh->SetPlaySetting(SelectVoice, Wait1Time, Wait2Time);
        // Set Play Music Folder
        ;
        // Set Play list
        PlaySeqTh->SetPlayNumList(PlayFudaList);
    }

    if (!flag_pause) {
        // Play Start
        PlaySeqTh->Start();

        ui->Btn_Start->setIcon(QIcon(QPixmap(":/images/Pause.png")));
        flag_pause = true;
    } else {
        // Pause
        PlaySeqTh->Pause();

        ui->Btn_Start->setIcon(QIcon(QPixmap(":/images/Play.png")));
        flag_pause = false;
    }
    flag_playseqstate = true;
}

void MainWindow::on_Btn_Stop_clicked()
{
#if 1
    if (!flag_playseqstate) return; // Disable for Debugging
#endif

    // if Dialog("Play Exit OK?")
    QMessageBox::StandardButton reply = QMessageBox::question(
                this,
                tr("確認"),
                tr("終了しますか?"),
                QMessageBox::Ok | QMessageBox::Cancel);
    if (reply == QMessageBox::Ok) {
        PlaySeqTh->Abort();
    } else if (reply == QMessageBox::Cancel) {
        ;   //...
    }
}

// SLOT
void MainWindow::SequencStartded()
{
    ;
}
// SLOT
void MainWindow::Music1Starteded(int fudaNum)
{
    PlayCounter++;
    QString kamiku = tr(kaminoku[fudaNum-1]);
    ui->statusBar->showMessage(QString(tr("%1 / %2 再生中: 第%3首 : %4")).arg(PlayCounter).arg(PlayListCount).arg(fudaNum).arg(kamiku));

//    qDebug() << QString("Music1Starteded, FudaN = %1").arg(fudaNum);
}
// SLOT
void MainWindow::Music1Ended()
{
    ;
//    qDebug() << "Music1Ended";
}
// SLOT
void MainWindow::Music2Starteded(int fudaNum)
{
    ;
//    qDebug() << QString("Music2Starteded, FudaN = %1").arg(fudaNum);
}
// SLOT
void MainWindow::Music2Ended()
{
//    ui->statusBar->clearMessage();

//    qDebug() << "Music2Ended";
}
// SLOT
void MainWindow::SequenceEnded(int status)
{
    ui->statusBar->clearMessage();
    // status 0 is success, !0 is Fail

    flag_playseqstate = false;
    flag_pause = false;

    // WaitTime, CheckBox enable
    ui->spinBox_1->setEnabled(true);
    ui->spinBox_2->setEnabled(true);
    ui->checkBox->setEnabled(true);

    ui->Btn_Start->setIcon(QIcon(QPixmap(":/images/Play.png")));

//    qDebug() << "SequenceEnd";
}


void MainWindow::on_spinBox_1_valueChanged(int arg1)
{
    Wait1Time = arg1;
}

void MainWindow::on_spinBox_2_valueChanged(int arg1)
{
    Wait2Time = arg1;
}

void MainWindow::on_checkBox_toggled(bool checked)
{
    chk_joka = checked;
}


void MainWindow::on_actionFuda_triggered()
{
    on_Btn_FudaSelect_clicked();
}


void MainWindow::on_actionOption_triggered()
{
    if (flag_playseqstate) return; // disable when Playing

    OptionDialog *dlg = new OptionDialog(this, SelectVoice, EnableOptMusic, PlaySeqTh);

//    dlg->Set_Opt_voice_select(SelectVoice);

    int i = dlg->exec();
    if (i == QDialog::Accepted) {
        //        qDebug() << "Ok";
        SelectVoice = dlg->Get_Opt_voice_select();
//        qDebug() << QString("Select %1").arg(SelectVoice);
    } else if (i == QDialog::Rejected) {
//        qDebug() << "Cancel";
    } else {
//        qDebug() << "Unkown";
    }

    delete dlg;
}

QString FudaList_ToCSVString(QList<int> *list)
{
    QString csvstr;
    int len = list->count();
    for (int i = 0; i < len; i++) {
        csvstr += QString("%1").arg(list->at(i));
        if ((i + 1) != len) {
            csvstr += ",";
        }
    }
    return csvstr;
}

void MainWindow::LoadSaveSetting(QString filepath, bool store = false)
{
    QSettings settings(filepath, QSettings::IniFormat);
    if (store) {
        // Save
        QString FudaListStr = FudaList_ToCSVString(FList);
        // qDebug() << "FudaListStr is " << FudaListStr;

        settings.setValue("SETTING/chk_joka", chk_joka);
        settings.setValue("SETTING/Wait1Time", Wait1Time);
        settings.setValue("SETTING/Wait2Time", Wait2Time);
        settings.setValue("SETTING/SelectVoice", SelectVoice);
        settings.setValue("SETTING/FudaList", FudaListStr);

    } else {
        // Load
        chk_joka    = settings.value("SETTING/chk_joka",   true).toBool();
        Wait1Time   = settings.value("SETTING/Wait1Time",  10).toInt();
        Wait2Time   = settings.value("SETTING/Wait2Time",  3).toInt();
        SelectVoice = settings.value("SETTING/SelectVoice", 0).toInt();

        QString FudaListStr(settings.value("SETTING/FudaList", QString("")).toString());
        // qDebug() << "FudaListStr is " << FudaListStr;

        FList->clear();
        if (FudaListStr.isEmpty()) {
            // Set All (1 to 100)
            for (int i = 0; i < 100; i++) {
                FList->append(i+1);
            }
        } else {
            QStringList FudaStrList = FudaListStr.split(",");
            int x;
            for (int i = 0; i < FudaStrList.count(); i++) {
                x = FudaStrList.at(i).toInt();
                if (1 <= x && x <= 100) {
                    FList->append(x);
                    // qDebug() << QString("FList [%1] is %2").arg(i).arg(FList->last());
                }
            }
        }
    }
}

void MainWindow::on_Btn_FudaSelect_clicked()
{
    if (flag_playseqstate) return; // disable when Playing

    FudaSelectDlg *dlg = new FudaSelectDlg(this);
    dlg->SetFList(FList);

    int i = dlg->exec();
    if (i == QDialog::Accepted) {
//        qDebug() << "Ok";
    } else if (i == QDialog::Rejected) {
//        qDebug() << "Cancel";
    } else {
//        qDebug() << "Unkown";
    }

    delete dlg;
}

void MainWindow::on_Slider_Volume_valueChanged(int value)
{
    PlaySeqTh->SetSoundVolume((float)value / 100.0);
}

void MainWindow::on_Btn_AnkiJikan_clicked()
{
    if (flag_playseqstate) return; // disable when Playing

    AnkiJikan_Dialog *dlg = new AnkiJikan_Dialog(this);

    dlg->exec();

    delete dlg;
}
