#include "ankijikan_dialog.h"
#include "ui_ankijikan_dialog.h"

#include <QDebug>
#include <QDateTime>
#include <QMessageBox>

AnkiJikan_Dialog::AnkiJikan_Dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::AnkiJikan_Dialog)
{
    ui->setupUi(this);
    flag_exec = false;
    Minute_Count = 0;
    AnkiTimer = new QTimer(this);

    connect(AnkiTimer, SIGNAL(timeout()),
            this, SLOT(TimeOutDone()));

}

AnkiJikan_Dialog::~AnkiJikan_Dialog()
{
    delete AnkiTimer;
    delete ui;
}

void AnkiJikan_Dialog::on_StartStopBtn_clicked()
{
    if (flag_exec) {
        AnkiTimer->stop();
        ui->StartStopBtn->setText(tr("開始"));
        ui->MsgLabel->setText("");
        ui->progressBar->setValue(0);
        ui->MsgLabel_2->setText(tr("終了時刻 : "));
        flag_exec = false;
        this->close(); // StopBtn then Close thisDialog
    } else {
        ui->StartStopBtn->setText(tr("終了"));
        QString msg = tr("残り時間 : 15 分");
        ui->MsgLabel->setText(msg);
        ui->progressBar->setValue(0);
        QDateTime starttime(QDateTime::currentDateTime());
        QDateTime endtime = starttime.addSecs(15 * 60);
        msg = tr("終了時刻 : ") + endtime.toString("hh:mm");
        ui->MsgLabel_2->setText(msg);

        Minute_Count = 0;
        AnkiTimer->start(60000); // 1 minute
        flag_exec = true;

//        QDateTime now(QDateTime::currentDateTime());
//        qDebug() << "StartTime : " << now;
    }
}

void  AnkiJikan_Dialog::TimeOutDone()
{
    Minute_Count++;
    if (Minute_Count >= 15) {
        // Timeup! 15 minute
        AnkiTimer->stop();
        ui->StartStopBtn->setText(tr("開始"));
        ui->MsgLabel->setText(tr("暗記時間終了"));
        ui->progressBar->setValue(100);
        QMessageBox::information(this, tr("暗記時間"), tr("暗記時間終了"), QMessageBox::Ok);
        flag_exec = false;
        this->close(); // StopBtn then Close thisDialog

//        QDateTime now(QDateTime::currentDateTime());
//        qDebug() << "  EndTime : " << now;
    } else {
        int LeastTime = (15 - Minute_Count);
        QString msg = QString(tr("残り時間 : %１分")).arg(LeastTime);
        ui->MsgLabel->setText(msg);
        ui->progressBar->setValue((int)(Minute_Count / 15.0 * 100.0));

        if (LeastTime == 2) {
            QApplication::beep();
//            qDebug() << tr("least at 2 minute");
            ;
        }
//        QDateTime now(QDateTime::currentDateTime());
//        qDebug() << "  NowTime : " << now;
    }

}

