#include "optiondialog.h"
#include "ui_optiondialog.h"

#include <QDebug>

//void OptionDialog::Set_Opt_voice_select(int select)
//{
//    opt_voice_select = select;
//}

int OptionDialog::Get_Opt_voice_select()
{
    return opt_voice_select;
}

void OptionDialog::TimeoutDone()
{
    if (PlaySeqTh) {
        if (PlaySeqTh->GetPlayStatus() == 0) {
            ui->Btn_TestPlay->setEnabled(true);
            interval_timer->stop(); // TimerStop
//            qDebug() << "TestPlay Ended.";
        }
    }
}

OptionDialog::OptionDialog(QWidget *parent, int select, bool enableOptMusic, PlaySequenceThread *pTh) :
    QDialog(parent),
    ui(new Ui::OptionDialog)
{
    ui->setupUi(this);
    interval_timer = new QTimer(this);
    connect(interval_timer, SIGNAL(timeout()), this, SLOT(TimeoutDone()));

    if (enableOptMusic) {
        ui->radioButton_2->setEnabled(true);
    } else {
        ui->radioButton_2->setEnabled(false);
    }

    if (pTh) {
        PlaySeqTh = pTh;
        ui->Btn_TestPlay->setEnabled(true);
    } else {
        PlaySeqTh = NULL;
        ui->Btn_TestPlay->setEnabled(false);
    }

    opt_voice_select = select;
    if (opt_voice_select == 0) {
        ui->radioButton_1->setChecked(true);
        ui->radioButton_2->setChecked(false);
    } else {
        ui->radioButton_1->setChecked(false);
        ui->radioButton_2->setChecked(true);
    }
}

OptionDialog::~OptionDialog()
{
    if (PlaySeqTh) {
        PlaySeqTh->Abort();
    }

    interval_timer->stop();
    delete interval_timer;

    delete ui;
}

void OptionDialog::on_buttonBox_accepted()
{
    if (ui->radioButton_1->isChecked()) {
        opt_voice_select = 0;
    } else {
        opt_voice_select = 1;
    }
}

void OptionDialog::on_buttonBox_rejected()
{
    ;
}

void OptionDialog::on_Btn_TestPlay_clicked()
{
    // Test Playing
    QList<int> *PlayFudaList;
    PlayFudaList = new QList<int>;
    PlayFudaList->clear();
    PlayFudaList->insert(0, 0); // fudaN=0 insert to top

    int select = 0;
    if (ui->radioButton_1->isChecked()) {
        select = 0;
    } else {
        select = 1;
    }
    // Set Play Setting
    PlaySeqTh->SetPlaySetting(select, 1, 1);

    // Set Play list
    PlaySeqTh->SetPlayNumList(PlayFudaList);

    ui->Btn_TestPlay->setEnabled(false);
    interval_timer->setInterval(1000);
    interval_timer->start(); // TimerStart
    PlaySeqTh->Start();
}
